/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.resourcemanager.internal.http;

import com.google.common.base.Function;
import com.google.common.base.Optional;
import com.oracle.bmc.http.internal.HeaderUtils;
import com.oracle.bmc.http.internal.ResponseConversionFunctionFactory;
import com.oracle.bmc.http.internal.ResponseHelper;
import com.oracle.bmc.http.internal.RestClient;
import com.oracle.bmc.http.internal.WithHeaders;
import com.oracle.bmc.http.internal.WrappedInvocationBuilder;
import com.oracle.bmc.http.internal.WrappedWebTarget;
import com.oracle.bmc.resourcemanager.model.StackResourceDriftCollection;
import com.oracle.bmc.resourcemanager.requests.ListStackResourceDriftDetailsRequest;
import com.oracle.bmc.resourcemanager.responses.ListStackResourceDriftDetailsResponse;
import com.oracle.bmc.util.internal.CollectionFormatType;
import com.oracle.bmc.util.internal.HttpUtils;
import java.util.List;
import javax.ws.rs.core.MultivaluedMap;
import javax.ws.rs.core.Response;
import org.apache.commons.lang3.Validate;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ListStackResourceDriftDetailsConverter {
    private static final Logger LOG = LoggerFactory.getLogger(ListStackResourceDriftDetailsConverter.class);
    private static final ResponseConversionFunctionFactory RESPONSE_CONVERSION_FACTORY = new ResponseConversionFunctionFactory();

    public static ListStackResourceDriftDetailsRequest interceptRequest(ListStackResourceDriftDetailsRequest request) {
        return request;
    }

    public static WrappedInvocationBuilder fromRequest(RestClient client, ListStackResourceDriftDetailsRequest request) {
        Validate.notNull((Object)((Object)request), (String)"request instance is required", (Object[])new Object[0]);
        Validate.notBlank((CharSequence)request.getStackId(), (String)"stackId must not be blank", (Object[])new Object[0]);
        WrappedWebTarget target = client.getBaseTarget().path("/20180917").path("stacks").path(HttpUtils.encodePathSegment((String)request.getStackId())).path("actions").path("listResourceDriftDetails");
        if (request.getWorkRequestId() != null) {
            target = target.queryParam("workRequestId", new Object[]{HttpUtils.attemptEncodeQueryParam((Object)request.getWorkRequestId())});
        }
        if (request.getResourceDriftStatus() != null) {
            target = HttpUtils.encodeCollectionFormatQueryParam((WrappedWebTarget)target, (String)"resourceDriftStatus", request.getResourceDriftStatus(), (CollectionFormatType)CollectionFormatType.Multi);
        }
        if (request.getLimit() != null) {
            target = target.queryParam("limit", new Object[]{HttpUtils.attemptEncodeQueryParam((Object)request.getLimit())});
        }
        if (request.getPage() != null) {
            target = target.queryParam("page", new Object[]{HttpUtils.attemptEncodeQueryParam((Object)request.getPage())});
        }
        WrappedInvocationBuilder ib = target.request();
        ib.accept(new String[]{"application/json"});
        if (request.getOpcRequestId() != null) {
            ib.header("opc-request-id", (Object)request.getOpcRequestId());
        }
        return ib;
    }

    public static Function<Response, ListStackResourceDriftDetailsResponse> fromResponse() {
        Function<Response, ListStackResourceDriftDetailsResponse> transformer = new Function<Response, ListStackResourceDriftDetailsResponse>(){

            public ListStackResourceDriftDetailsResponse apply(Response rawResponse) {
                Optional opcNextPageHeader;
                LOG.trace("Transform function invoked for com.oracle.bmc.resourcemanager.responses.ListStackResourceDriftDetailsResponse");
                Function responseFn = RESPONSE_CONVERSION_FACTORY.create(StackResourceDriftCollection.class);
                WithHeaders response = (WithHeaders)responseFn.apply((Object)rawResponse);
                MultivaluedMap headers = response.getHeaders();
                ListStackResourceDriftDetailsResponse.Builder builder = ListStackResourceDriftDetailsResponse.builder().__httpStatusCode__(rawResponse.getStatus());
                builder.stackResourceDriftCollection((StackResourceDriftCollection)response.getItem());
                Optional opcRequestIdHeader = HeaderUtils.get((MultivaluedMap)headers, (String)"opc-request-id");
                if (opcRequestIdHeader.isPresent()) {
                    builder.opcRequestId((String)HeaderUtils.toValue((String)"opc-request-id", (String)((String)((List)opcRequestIdHeader.get()).get(0)), String.class));
                }
                if ((opcNextPageHeader = HeaderUtils.get((MultivaluedMap)headers, (String)"opc-next-page")).isPresent()) {
                    builder.opcNextPage((String)HeaderUtils.toValue((String)"opc-next-page", (String)((String)((List)opcNextPageHeader.get()).get(0)), String.class));
                }
                ListStackResourceDriftDetailsResponse responseWrapper = builder.build();
                ResponseHelper.closeResponseSilentlyIfNotBuffered((Response)rawResponse);
                return responseWrapper;
            }
        };
        return transformer;
    }
}

