/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.resourcemanager.internal.http;

import com.google.common.base.Function;
import com.google.common.base.Optional;
import com.oracle.bmc.http.internal.HeaderUtils;
import com.oracle.bmc.http.internal.ResponseConversionFunctionFactory;
import com.oracle.bmc.http.internal.ResponseHelper;
import com.oracle.bmc.http.internal.RestClient;
import com.oracle.bmc.http.internal.WithHeaders;
import com.oracle.bmc.http.internal.WrappedInvocationBuilder;
import com.oracle.bmc.http.internal.WrappedWebTarget;
import com.oracle.bmc.resourcemanager.model.TemplateCategorySummaryCollection;
import com.oracle.bmc.resourcemanager.requests.ListTemplateCategoriesRequest;
import com.oracle.bmc.resourcemanager.responses.ListTemplateCategoriesResponse;
import java.util.List;
import javax.ws.rs.core.MultivaluedMap;
import javax.ws.rs.core.Response;
import org.apache.commons.lang3.Validate;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ListTemplateCategoriesConverter {
    private static final Logger LOG = LoggerFactory.getLogger(ListTemplateCategoriesConverter.class);
    private static final ResponseConversionFunctionFactory RESPONSE_CONVERSION_FACTORY = new ResponseConversionFunctionFactory();

    public static ListTemplateCategoriesRequest interceptRequest(ListTemplateCategoriesRequest request) {
        return request;
    }

    public static WrappedInvocationBuilder fromRequest(RestClient client, ListTemplateCategoriesRequest request) {
        Validate.notNull((Object)((Object)request), (String)"request instance is required", (Object[])new Object[0]);
        WrappedWebTarget target = client.getBaseTarget().path("/20180917").path("templateCategories");
        WrappedInvocationBuilder ib = target.request();
        ib.accept(new String[]{"application/json"});
        if (request.getOpcRequestId() != null) {
            ib.header("opc-request-id", (Object)request.getOpcRequestId());
        }
        return ib;
    }

    public static Function<Response, ListTemplateCategoriesResponse> fromResponse() {
        Function<Response, ListTemplateCategoriesResponse> transformer = new Function<Response, ListTemplateCategoriesResponse>(){

            public ListTemplateCategoriesResponse apply(Response rawResponse) {
                LOG.trace("Transform function invoked for com.oracle.bmc.resourcemanager.responses.ListTemplateCategoriesResponse");
                Function responseFn = RESPONSE_CONVERSION_FACTORY.create(TemplateCategorySummaryCollection.class);
                WithHeaders response = (WithHeaders)responseFn.apply((Object)rawResponse);
                MultivaluedMap headers = response.getHeaders();
                ListTemplateCategoriesResponse.Builder builder = ListTemplateCategoriesResponse.builder().__httpStatusCode__(rawResponse.getStatus());
                builder.templateCategorySummaryCollection((TemplateCategorySummaryCollection)response.getItem());
                Optional opcRequestIdHeader = HeaderUtils.get((MultivaluedMap)headers, (String)"opc-request-id");
                if (opcRequestIdHeader.isPresent()) {
                    builder.opcRequestId((String)HeaderUtils.toValue((String)"opc-request-id", (String)((String)((List)opcRequestIdHeader.get()).get(0)), String.class));
                }
                ListTemplateCategoriesResponse responseWrapper = builder.build();
                ResponseHelper.closeResponseSilentlyIfNotBuffered((Response)rawResponse);
                return responseWrapper;
            }
        };
        return transformer;
    }
}

