/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.resourcemanager.model;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonFilter;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonSubTypes;
import com.fasterxml.jackson.annotation.JsonTypeInfo;
import com.fasterxml.jackson.annotation.JsonValue;
import com.oracle.bmc.resourcemanager.model.CompartmentConfigSource;
import com.oracle.bmc.resourcemanager.model.GitConfigSource;
import com.oracle.bmc.resourcemanager.model.ZipUploadConfigSource;
import java.beans.ConstructorProperties;
import java.util.HashMap;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@JsonTypeInfo(use=JsonTypeInfo.Id.NAME, include=JsonTypeInfo.As.PROPERTY, property="configSourceType", defaultImpl=ConfigSource.class)
@JsonSubTypes(value={@JsonSubTypes.Type(value=GitConfigSource.class, name="GIT_CONFIG_SOURCE"), @JsonSubTypes.Type(value=CompartmentConfigSource.class, name="COMPARTMENT_CONFIG_SOURCE"), @JsonSubTypes.Type(value=ZipUploadConfigSource.class, name="ZIP_UPLOAD")})
@JsonFilter(value="explicitlySetFilter")
public class ConfigSource {
    @JsonProperty(value="workingDirectory")
    private final String workingDirectory;

    public String getWorkingDirectory() {
        return this.workingDirectory;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof ConfigSource)) {
            return false;
        }
        ConfigSource other = (ConfigSource)o;
        if (!other.canEqual(this)) {
            return false;
        }
        String this$workingDirectory = this.getWorkingDirectory();
        String other$workingDirectory = other.getWorkingDirectory();
        return !(this$workingDirectory == null ? other$workingDirectory != null : !this$workingDirectory.equals(other$workingDirectory));
    }

    protected boolean canEqual(Object other) {
        return other instanceof ConfigSource;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        String $workingDirectory = this.getWorkingDirectory();
        result = result * 59 + ($workingDirectory == null ? 43 : $workingDirectory.hashCode());
        return result;
    }

    public String toString() {
        return "ConfigSource(workingDirectory=" + this.getWorkingDirectory() + ")";
    }

    @ConstructorProperties(value={"workingDirectory"})
    @Deprecated
    protected ConfigSource(String workingDirectory) {
        this.workingDirectory = workingDirectory;
    }

    public static enum ConfigSourceType {
        ZipUpload("ZIP_UPLOAD"),
        GitConfigSource("GIT_CONFIG_SOURCE"),
        CompartmentConfigSource("COMPARTMENT_CONFIG_SOURCE"),
        UnknownEnumValue(null);

        private static final Logger LOG;
        private final String value;
        private static Map<String, ConfigSourceType> map;

        private ConfigSourceType(String value) {
            this.value = value;
        }

        @JsonValue
        public String getValue() {
            return this.value;
        }

        @JsonCreator
        public static ConfigSourceType create(String key) {
            if (map.containsKey(key)) {
                return map.get(key);
            }
            LOG.warn("Received unknown value '{}' for enum 'ConfigSourceType', returning UnknownEnumValue", (Object)key);
            return UnknownEnumValue;
        }

        static {
            LOG = LoggerFactory.getLogger(ConfigSourceType.class);
            map = new HashMap<String, ConfigSourceType>();
            for (ConfigSourceType v : ConfigSourceType.values()) {
                if (v == UnknownEnumValue) continue;
                map.put(v.getValue(), v);
            }
        }
    }
}

