/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.resourcemanager.requests;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonValue;
import com.oracle.bmc.requests.BmcRequest;
import com.oracle.bmc.resourcemanager.model.LogEntry;
import com.oracle.bmc.retrier.RetryConfiguration;
import com.oracle.bmc.util.internal.Consumer;
import java.beans.ConstructorProperties;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.ws.rs.client.Invocation;

public class GetJobLogsRequest
extends BmcRequest<Void> {
    private String jobId;
    private String opcRequestId;
    private List<LogEntry.Type> type;
    private LogEntry.Level levelGreaterThanOrEqualTo;
    private SortOrder sortOrder;
    private Integer limit;
    private String page;
    private Date timestampGreaterThanOrEqualTo;
    private Date timestampLessThanOrEqualTo;

    @ConstructorProperties(value={"jobId", "opcRequestId", "type", "levelGreaterThanOrEqualTo", "sortOrder", "limit", "page", "timestampGreaterThanOrEqualTo", "timestampLessThanOrEqualTo"})
    GetJobLogsRequest(String jobId, String opcRequestId, List<LogEntry.Type> type, LogEntry.Level levelGreaterThanOrEqualTo, SortOrder sortOrder, Integer limit, String page, Date timestampGreaterThanOrEqualTo, Date timestampLessThanOrEqualTo) {
        this.jobId = jobId;
        this.opcRequestId = opcRequestId;
        this.type = type;
        this.levelGreaterThanOrEqualTo = levelGreaterThanOrEqualTo;
        this.sortOrder = sortOrder;
        this.limit = limit;
        this.page = page;
        this.timestampGreaterThanOrEqualTo = timestampGreaterThanOrEqualTo;
        this.timestampLessThanOrEqualTo = timestampLessThanOrEqualTo;
    }

    public static Builder builder() {
        return new Builder();
    }

    public String getJobId() {
        return this.jobId;
    }

    public String getOpcRequestId() {
        return this.opcRequestId;
    }

    public List<LogEntry.Type> getType() {
        return this.type;
    }

    public LogEntry.Level getLevelGreaterThanOrEqualTo() {
        return this.levelGreaterThanOrEqualTo;
    }

    public SortOrder getSortOrder() {
        return this.sortOrder;
    }

    public Integer getLimit() {
        return this.limit;
    }

    public String getPage() {
        return this.page;
    }

    public Date getTimestampGreaterThanOrEqualTo() {
        return this.timestampGreaterThanOrEqualTo;
    }

    public Date getTimestampLessThanOrEqualTo() {
        return this.timestampLessThanOrEqualTo;
    }

    public static class Builder
    implements BmcRequest.Builder<GetJobLogsRequest, Void> {
        private String jobId;
        private String opcRequestId;
        private List<LogEntry.Type> type;
        private LogEntry.Level levelGreaterThanOrEqualTo;
        private SortOrder sortOrder;
        private Integer limit;
        private String page;
        private Date timestampGreaterThanOrEqualTo;
        private Date timestampLessThanOrEqualTo;
        private Consumer<Invocation.Builder> invocationCallback = null;
        private RetryConfiguration retryConfiguration = null;

        public Builder invocationCallback(Consumer<Invocation.Builder> invocationCallback) {
            this.invocationCallback = invocationCallback;
            return this;
        }

        public Builder retryConfiguration(RetryConfiguration retryConfiguration) {
            this.retryConfiguration = retryConfiguration;
            return this;
        }

        public Builder copy(GetJobLogsRequest o) {
            this.jobId(o.getJobId());
            this.opcRequestId(o.getOpcRequestId());
            this.type(o.getType());
            this.levelGreaterThanOrEqualTo(o.getLevelGreaterThanOrEqualTo());
            this.sortOrder(o.getSortOrder());
            this.limit(o.getLimit());
            this.page(o.getPage());
            this.timestampGreaterThanOrEqualTo(o.getTimestampGreaterThanOrEqualTo());
            this.timestampLessThanOrEqualTo(o.getTimestampLessThanOrEqualTo());
            this.invocationCallback((Consumer<Invocation.Builder>)o.getInvocationCallback());
            this.retryConfiguration(o.getRetryConfiguration());
            return this;
        }

        public GetJobLogsRequest build() {
            GetJobLogsRequest request = this.buildWithoutInvocationCallback();
            request.setInvocationCallback(this.invocationCallback);
            request.setRetryConfiguration(this.retryConfiguration);
            return request;
        }

        Builder() {
        }

        public Builder jobId(String jobId) {
            this.jobId = jobId;
            return this;
        }

        public Builder opcRequestId(String opcRequestId) {
            this.opcRequestId = opcRequestId;
            return this;
        }

        public Builder type(List<LogEntry.Type> type) {
            this.type = type;
            return this;
        }

        public Builder levelGreaterThanOrEqualTo(LogEntry.Level levelGreaterThanOrEqualTo) {
            this.levelGreaterThanOrEqualTo = levelGreaterThanOrEqualTo;
            return this;
        }

        public Builder sortOrder(SortOrder sortOrder) {
            this.sortOrder = sortOrder;
            return this;
        }

        public Builder limit(Integer limit) {
            this.limit = limit;
            return this;
        }

        public Builder page(String page) {
            this.page = page;
            return this;
        }

        public Builder timestampGreaterThanOrEqualTo(Date timestampGreaterThanOrEqualTo) {
            this.timestampGreaterThanOrEqualTo = timestampGreaterThanOrEqualTo;
            return this;
        }

        public Builder timestampLessThanOrEqualTo(Date timestampLessThanOrEqualTo) {
            this.timestampLessThanOrEqualTo = timestampLessThanOrEqualTo;
            return this;
        }

        public GetJobLogsRequest buildWithoutInvocationCallback() {
            return new GetJobLogsRequest(this.jobId, this.opcRequestId, this.type, this.levelGreaterThanOrEqualTo, this.sortOrder, this.limit, this.page, this.timestampGreaterThanOrEqualTo, this.timestampLessThanOrEqualTo);
        }

        public String toString() {
            return "GetJobLogsRequest.Builder(jobId=" + this.jobId + ", opcRequestId=" + this.opcRequestId + ", type=" + this.type + ", levelGreaterThanOrEqualTo=" + (Object)((Object)this.levelGreaterThanOrEqualTo) + ", sortOrder=" + (Object)((Object)this.sortOrder) + ", limit=" + this.limit + ", page=" + this.page + ", timestampGreaterThanOrEqualTo=" + this.timestampGreaterThanOrEqualTo + ", timestampLessThanOrEqualTo=" + this.timestampLessThanOrEqualTo + ")";
        }
    }

    public static enum SortOrder {
        Asc("ASC"),
        Desc("DESC");

        private final String value;
        private static Map<String, SortOrder> map;

        private SortOrder(String value) {
            this.value = value;
        }

        @JsonValue
        public String getValue() {
            return this.value;
        }

        @JsonCreator
        public static SortOrder create(String key) {
            if (map.containsKey(key)) {
                return map.get(key);
            }
            throw new IllegalArgumentException("Invalid SortOrder: " + key);
        }

        static {
            map = new HashMap<String, SortOrder>();
            for (SortOrder v : SortOrder.values()) {
                map.put(v.getValue(), v);
            }
        }
    }
}

