/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.resourcemanager.model;

import com.fasterxml.jackson.annotation.JsonFilter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonTypeInfo;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonPOJOBuilder;
import com.oracle.bmc.resourcemanager.model.CreateConfigSourceDetails;
import java.util.HashSet;
import java.util.Objects;
import java.util.Set;

@JsonDeserialize(builder=Builder.class)
@JsonTypeInfo(use=JsonTypeInfo.Id.NAME, include=JsonTypeInfo.As.PROPERTY, property="configSourceType")
@JsonFilter(value="explicitlySetFilter")
public final class CreateObjectStorageConfigSourceDetails
extends CreateConfigSourceDetails {
    @JsonProperty(value="region")
    private final String region;
    @JsonProperty(value="namespace")
    private final String namespace;
    @JsonProperty(value="bucketName")
    private final String bucketName;

    public static Builder builder() {
        return new Builder();
    }

    public Builder toBuilder() {
        return new Builder().copy(this);
    }

    @Deprecated
    public CreateObjectStorageConfigSourceDetails(String workingDirectory, String region, String namespace, String bucketName) {
        super(workingDirectory);
        this.region = region;
        this.namespace = namespace;
        this.bucketName = bucketName;
    }

    public String getRegion() {
        return this.region;
    }

    public String getNamespace() {
        return this.namespace;
    }

    public String getBucketName() {
        return this.bucketName;
    }

    @Override
    public String toString() {
        return this.toString(true);
    }

    @Override
    public String toString(boolean includeByteArrayContents) {
        StringBuilder sb = new StringBuilder();
        sb.append("CreateObjectStorageConfigSourceDetails(");
        sb.append("super=").append(super.toString(includeByteArrayContents));
        sb.append(", region=").append(String.valueOf(this.region));
        sb.append(", namespace=").append(String.valueOf(this.namespace));
        sb.append(", bucketName=").append(String.valueOf(this.bucketName));
        sb.append(")");
        return sb.toString();
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof CreateObjectStorageConfigSourceDetails)) {
            return false;
        }
        CreateObjectStorageConfigSourceDetails other = (CreateObjectStorageConfigSourceDetails)((Object)o);
        return Objects.equals(this.region, other.region) && Objects.equals(this.namespace, other.namespace) && Objects.equals(this.bucketName, other.bucketName) && super.equals((Object)other);
    }

    @Override
    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        result = result * 59 + (this.region == null ? 43 : this.region.hashCode());
        result = result * 59 + (this.namespace == null ? 43 : this.namespace.hashCode());
        result = result * 59 + (this.bucketName == null ? 43 : this.bucketName.hashCode());
        return result;
    }

    @JsonPOJOBuilder(withPrefix="")
    public static class Builder {
        @JsonProperty(value="workingDirectory")
        private String workingDirectory;
        @JsonProperty(value="region")
        private String region;
        @JsonProperty(value="namespace")
        private String namespace;
        @JsonProperty(value="bucketName")
        private String bucketName;
        @JsonIgnore
        private final Set<String> __explicitlySet__ = new HashSet<String>();

        public Builder workingDirectory(String workingDirectory) {
            this.workingDirectory = workingDirectory;
            this.__explicitlySet__.add("workingDirectory");
            return this;
        }

        public Builder region(String region) {
            this.region = region;
            this.__explicitlySet__.add("region");
            return this;
        }

        public Builder namespace(String namespace) {
            this.namespace = namespace;
            this.__explicitlySet__.add("namespace");
            return this;
        }

        public Builder bucketName(String bucketName) {
            this.bucketName = bucketName;
            this.__explicitlySet__.add("bucketName");
            return this;
        }

        public CreateObjectStorageConfigSourceDetails build() {
            CreateObjectStorageConfigSourceDetails model = new CreateObjectStorageConfigSourceDetails(this.workingDirectory, this.region, this.namespace, this.bucketName);
            for (String explicitlySetProperty : this.__explicitlySet__) {
                model.markPropertyAsExplicitlySet(explicitlySetProperty);
            }
            return model;
        }

        @JsonIgnore
        public Builder copy(CreateObjectStorageConfigSourceDetails model) {
            if (model.wasPropertyExplicitlySet("workingDirectory")) {
                this.workingDirectory(model.getWorkingDirectory());
            }
            if (model.wasPropertyExplicitlySet("region")) {
                this.region(model.getRegion());
            }
            if (model.wasPropertyExplicitlySet("namespace")) {
                this.namespace(model.getNamespace());
            }
            if (model.wasPropertyExplicitlySet("bucketName")) {
                this.bucketName(model.getBucketName());
            }
            return this;
        }
    }
}

