/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.resourcemanager.model;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonFilter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonValue;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonPOJOBuilder;
import com.oracle.bmc.http.client.internal.ExplicitlySetBmcModel;
import com.oracle.bmc.http.internal.BmcEnum;
import java.beans.ConstructorProperties;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@JsonDeserialize(builder=Builder.class)
@JsonFilter(value="explicitlySetFilter")
public final class ResourceDiscoveryServiceSummary
extends ExplicitlySetBmcModel {
    @JsonProperty(value="name")
    private final String name;
    @JsonProperty(value="discoveryScope")
    private final DiscoveryScope discoveryScope;

    @Deprecated
    @ConstructorProperties(value={"name", "discoveryScope"})
    public ResourceDiscoveryServiceSummary(String name, DiscoveryScope discoveryScope) {
        this.name = name;
        this.discoveryScope = discoveryScope;
    }

    public static Builder builder() {
        return new Builder();
    }

    public Builder toBuilder() {
        return new Builder().copy(this);
    }

    public String getName() {
        return this.name;
    }

    public DiscoveryScope getDiscoveryScope() {
        return this.discoveryScope;
    }

    public String toString() {
        return this.toString(true);
    }

    public String toString(boolean includeByteArrayContents) {
        StringBuilder sb = new StringBuilder();
        sb.append("ResourceDiscoveryServiceSummary(");
        sb.append("super=").append(super.toString());
        sb.append("name=").append(String.valueOf(this.name));
        sb.append(", discoveryScope=").append(String.valueOf((Object)this.discoveryScope));
        sb.append(")");
        return sb.toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof ResourceDiscoveryServiceSummary)) {
            return false;
        }
        ResourceDiscoveryServiceSummary other = (ResourceDiscoveryServiceSummary)((Object)o);
        return Objects.equals(this.name, other.name) && Objects.equals((Object)this.discoveryScope, (Object)other.discoveryScope) && super.equals((Object)other);
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + (this.name == null ? 43 : this.name.hashCode());
        result = result * 59 + (this.discoveryScope == null ? 43 : this.discoveryScope.hashCode());
        result = result * 59 + super.hashCode();
        return result;
    }

    public static enum DiscoveryScope implements BmcEnum
    {
        Tenancy("TENANCY"),
        Compartment("COMPARTMENT"),
        UnknownEnumValue(null);

        private static final Logger LOG;
        private final String value;
        private static Map<String, DiscoveryScope> map;

        private DiscoveryScope(String value) {
            this.value = value;
        }

        @JsonValue
        public String getValue() {
            return this.value;
        }

        @JsonCreator
        public static DiscoveryScope create(String key) {
            if (map.containsKey(key)) {
                return map.get(key);
            }
            LOG.warn("Received unknown value '{}' for enum 'DiscoveryScope', returning UnknownEnumValue", (Object)key);
            return UnknownEnumValue;
        }

        static {
            LOG = LoggerFactory.getLogger(DiscoveryScope.class);
            map = new HashMap<String, DiscoveryScope>();
            for (DiscoveryScope v : DiscoveryScope.values()) {
                if (v == UnknownEnumValue) continue;
                map.put(v.getValue(), v);
            }
        }
    }

    @JsonPOJOBuilder(withPrefix="")
    public static class Builder {
        @JsonProperty(value="name")
        private String name;
        @JsonProperty(value="discoveryScope")
        private DiscoveryScope discoveryScope;
        @JsonIgnore
        private final Set<String> __explicitlySet__ = new HashSet<String>();

        public Builder name(String name) {
            this.name = name;
            this.__explicitlySet__.add("name");
            return this;
        }

        public Builder discoveryScope(DiscoveryScope discoveryScope) {
            this.discoveryScope = discoveryScope;
            this.__explicitlySet__.add("discoveryScope");
            return this;
        }

        public ResourceDiscoveryServiceSummary build() {
            ResourceDiscoveryServiceSummary model = new ResourceDiscoveryServiceSummary(this.name, this.discoveryScope);
            for (String explicitlySetProperty : this.__explicitlySet__) {
                model.markPropertyAsExplicitlySet(explicitlySetProperty);
            }
            return model;
        }

        @JsonIgnore
        public Builder copy(ResourceDiscoveryServiceSummary model) {
            if (model.wasPropertyExplicitlySet("name")) {
                this.name(model.getName());
            }
            if (model.wasPropertyExplicitlySet("discoveryScope")) {
                this.discoveryScope(model.getDiscoveryScope());
            }
            return this;
        }
    }
}

