/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.resourcemanager.requests;

import com.oracle.bmc.http.client.RequestInterceptor;
import com.oracle.bmc.requests.BmcRequest;
import com.oracle.bmc.retrier.RetryConfiguration;
import java.util.Objects;

public class GetConfigurationSourceProviderRequest
extends BmcRequest<Void> {
    private String configurationSourceProviderId;
    private String opcRequestId;

    public String getConfigurationSourceProviderId() {
        return this.configurationSourceProviderId;
    }

    public String getOpcRequestId() {
        return this.opcRequestId;
    }

    public Builder toBuilder() {
        return new Builder().configurationSourceProviderId(this.configurationSourceProviderId).opcRequestId(this.opcRequestId);
    }

    public static Builder builder() {
        return new Builder();
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("(");
        sb.append("super=").append(super.toString());
        sb.append(",configurationSourceProviderId=").append(String.valueOf(this.configurationSourceProviderId));
        sb.append(",opcRequestId=").append(String.valueOf(this.opcRequestId));
        sb.append(")");
        return sb.toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof GetConfigurationSourceProviderRequest)) {
            return false;
        }
        GetConfigurationSourceProviderRequest other = (GetConfigurationSourceProviderRequest)((Object)o);
        return super.equals(o) && Objects.equals(this.configurationSourceProviderId, other.configurationSourceProviderId) && Objects.equals(this.opcRequestId, other.opcRequestId);
    }

    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        result = result * 59 + (this.configurationSourceProviderId == null ? 43 : this.configurationSourceProviderId.hashCode());
        result = result * 59 + (this.opcRequestId == null ? 43 : this.opcRequestId.hashCode());
        return result;
    }

    public static class Builder
    implements BmcRequest.Builder<GetConfigurationSourceProviderRequest, Void> {
        private RequestInterceptor invocationCallback = null;
        private RetryConfiguration retryConfiguration = null;
        private String configurationSourceProviderId = null;
        private String opcRequestId = null;

        public Builder configurationSourceProviderId(String configurationSourceProviderId) {
            this.configurationSourceProviderId = configurationSourceProviderId;
            return this;
        }

        public Builder opcRequestId(String opcRequestId) {
            this.opcRequestId = opcRequestId;
            return this;
        }

        public Builder invocationCallback(RequestInterceptor invocationCallback) {
            this.invocationCallback = invocationCallback;
            return this;
        }

        public Builder retryConfiguration(RetryConfiguration retryConfiguration) {
            this.retryConfiguration = retryConfiguration;
            return this;
        }

        public Builder copy(GetConfigurationSourceProviderRequest o) {
            this.configurationSourceProviderId(o.getConfigurationSourceProviderId());
            this.opcRequestId(o.getOpcRequestId());
            this.invocationCallback(o.getInvocationCallback());
            this.retryConfiguration(o.getRetryConfiguration());
            return this;
        }

        public GetConfigurationSourceProviderRequest build() {
            GetConfigurationSourceProviderRequest request = this.buildWithoutInvocationCallback();
            request.setInvocationCallback(this.invocationCallback);
            request.setRetryConfiguration(this.retryConfiguration);
            return request;
        }

        public GetConfigurationSourceProviderRequest buildWithoutInvocationCallback() {
            GetConfigurationSourceProviderRequest request = new GetConfigurationSourceProviderRequest();
            request.configurationSourceProviderId = this.configurationSourceProviderId;
            request.opcRequestId = this.opcRequestId;
            return request;
        }
    }
}

