/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.resourcemanager;

import com.oracle.bmc.ClientConfiguration;
import com.oracle.bmc.Region;
import com.oracle.bmc.Service;
import com.oracle.bmc.Services;
import com.oracle.bmc.auth.AbstractAuthenticationDetailsProvider;
import com.oracle.bmc.auth.BasicAuthenticationDetailsProvider;
import com.oracle.bmc.common.ClientBuilderBase;
import com.oracle.bmc.common.RegionalClientBuilder;
import com.oracle.bmc.http.ClientConfigurator;
import com.oracle.bmc.http.client.Method;
import com.oracle.bmc.http.internal.BaseSyncClient;
import com.oracle.bmc.http.internal.BmcEnum;
import com.oracle.bmc.http.signing.RequestSignerFactory;
import com.oracle.bmc.http.signing.SigningStrategy;
import com.oracle.bmc.http.signing.internal.DefaultRequestSignerFactory;
import com.oracle.bmc.internal.Alloy;
import com.oracle.bmc.internal.ClientThreadFactory;
import com.oracle.bmc.resourcemanager.ResourceManager;
import com.oracle.bmc.resourcemanager.ResourceManagerPaginators;
import com.oracle.bmc.resourcemanager.ResourceManagerWaiters;
import com.oracle.bmc.resourcemanager.model.AssociatedResourcesCollection;
import com.oracle.bmc.resourcemanager.model.ConfigurationSourceProvider;
import com.oracle.bmc.resourcemanager.model.ConfigurationSourceProviderCollection;
import com.oracle.bmc.resourcemanager.model.Job;
import com.oracle.bmc.resourcemanager.model.JobOutputsCollection;
import com.oracle.bmc.resourcemanager.model.JobSummary;
import com.oracle.bmc.resourcemanager.model.LogEntry;
import com.oracle.bmc.resourcemanager.model.PrivateEndpoint;
import com.oracle.bmc.resourcemanager.model.PrivateEndpointCollection;
import com.oracle.bmc.resourcemanager.model.ReachableIp;
import com.oracle.bmc.resourcemanager.model.ResourceDiscoveryServiceCollection;
import com.oracle.bmc.resourcemanager.model.Stack;
import com.oracle.bmc.resourcemanager.model.StackResourceDriftCollection;
import com.oracle.bmc.resourcemanager.model.StackSummary;
import com.oracle.bmc.resourcemanager.model.Template;
import com.oracle.bmc.resourcemanager.model.TemplateCategorySummaryCollection;
import com.oracle.bmc.resourcemanager.model.TemplateSummaryCollection;
import com.oracle.bmc.resourcemanager.model.TerraformVersionCollection;
import com.oracle.bmc.resourcemanager.model.WorkRequest;
import com.oracle.bmc.resourcemanager.model.WorkRequestError;
import com.oracle.bmc.resourcemanager.model.WorkRequestLogEntry;
import com.oracle.bmc.resourcemanager.model.WorkRequestSummary;
import com.oracle.bmc.resourcemanager.requests.CancelJobRequest;
import com.oracle.bmc.resourcemanager.requests.ChangeConfigurationSourceProviderCompartmentRequest;
import com.oracle.bmc.resourcemanager.requests.ChangePrivateEndpointCompartmentRequest;
import com.oracle.bmc.resourcemanager.requests.ChangeStackCompartmentRequest;
import com.oracle.bmc.resourcemanager.requests.ChangeTemplateCompartmentRequest;
import com.oracle.bmc.resourcemanager.requests.CreateConfigurationSourceProviderRequest;
import com.oracle.bmc.resourcemanager.requests.CreateJobRequest;
import com.oracle.bmc.resourcemanager.requests.CreatePrivateEndpointRequest;
import com.oracle.bmc.resourcemanager.requests.CreateStackRequest;
import com.oracle.bmc.resourcemanager.requests.CreateTemplateRequest;
import com.oracle.bmc.resourcemanager.requests.DeleteConfigurationSourceProviderRequest;
import com.oracle.bmc.resourcemanager.requests.DeletePrivateEndpointRequest;
import com.oracle.bmc.resourcemanager.requests.DeleteStackRequest;
import com.oracle.bmc.resourcemanager.requests.DeleteTemplateRequest;
import com.oracle.bmc.resourcemanager.requests.DetectStackDriftRequest;
import com.oracle.bmc.resourcemanager.requests.GetConfigurationSourceProviderRequest;
import com.oracle.bmc.resourcemanager.requests.GetJobDetailedLogContentRequest;
import com.oracle.bmc.resourcemanager.requests.GetJobLogsContentRequest;
import com.oracle.bmc.resourcemanager.requests.GetJobLogsRequest;
import com.oracle.bmc.resourcemanager.requests.GetJobRequest;
import com.oracle.bmc.resourcemanager.requests.GetJobTfConfigRequest;
import com.oracle.bmc.resourcemanager.requests.GetJobTfPlanRequest;
import com.oracle.bmc.resourcemanager.requests.GetJobTfStateRequest;
import com.oracle.bmc.resourcemanager.requests.GetPrivateEndpointRequest;
import com.oracle.bmc.resourcemanager.requests.GetReachableIpRequest;
import com.oracle.bmc.resourcemanager.requests.GetStackRequest;
import com.oracle.bmc.resourcemanager.requests.GetStackTfConfigRequest;
import com.oracle.bmc.resourcemanager.requests.GetStackTfStateRequest;
import com.oracle.bmc.resourcemanager.requests.GetTemplateLogoRequest;
import com.oracle.bmc.resourcemanager.requests.GetTemplateRequest;
import com.oracle.bmc.resourcemanager.requests.GetTemplateTfConfigRequest;
import com.oracle.bmc.resourcemanager.requests.GetWorkRequestRequest;
import com.oracle.bmc.resourcemanager.requests.ListConfigurationSourceProvidersRequest;
import com.oracle.bmc.resourcemanager.requests.ListJobAssociatedResourcesRequest;
import com.oracle.bmc.resourcemanager.requests.ListJobOutputsRequest;
import com.oracle.bmc.resourcemanager.requests.ListJobsRequest;
import com.oracle.bmc.resourcemanager.requests.ListPrivateEndpointsRequest;
import com.oracle.bmc.resourcemanager.requests.ListResourceDiscoveryServicesRequest;
import com.oracle.bmc.resourcemanager.requests.ListStackAssociatedResourcesRequest;
import com.oracle.bmc.resourcemanager.requests.ListStackResourceDriftDetailsRequest;
import com.oracle.bmc.resourcemanager.requests.ListStacksRequest;
import com.oracle.bmc.resourcemanager.requests.ListTemplateCategoriesRequest;
import com.oracle.bmc.resourcemanager.requests.ListTemplatesRequest;
import com.oracle.bmc.resourcemanager.requests.ListTerraformVersionsRequest;
import com.oracle.bmc.resourcemanager.requests.ListWorkRequestErrorsRequest;
import com.oracle.bmc.resourcemanager.requests.ListWorkRequestLogsRequest;
import com.oracle.bmc.resourcemanager.requests.ListWorkRequestsRequest;
import com.oracle.bmc.resourcemanager.requests.UpdateConfigurationSourceProviderRequest;
import com.oracle.bmc.resourcemanager.requests.UpdateJobRequest;
import com.oracle.bmc.resourcemanager.requests.UpdatePrivateEndpointRequest;
import com.oracle.bmc.resourcemanager.requests.UpdateStackRequest;
import com.oracle.bmc.resourcemanager.requests.UpdateTemplateRequest;
import com.oracle.bmc.resourcemanager.responses.CancelJobResponse;
import com.oracle.bmc.resourcemanager.responses.ChangeConfigurationSourceProviderCompartmentResponse;
import com.oracle.bmc.resourcemanager.responses.ChangePrivateEndpointCompartmentResponse;
import com.oracle.bmc.resourcemanager.responses.ChangeStackCompartmentResponse;
import com.oracle.bmc.resourcemanager.responses.ChangeTemplateCompartmentResponse;
import com.oracle.bmc.resourcemanager.responses.CreateConfigurationSourceProviderResponse;
import com.oracle.bmc.resourcemanager.responses.CreateJobResponse;
import com.oracle.bmc.resourcemanager.responses.CreatePrivateEndpointResponse;
import com.oracle.bmc.resourcemanager.responses.CreateStackResponse;
import com.oracle.bmc.resourcemanager.responses.CreateTemplateResponse;
import com.oracle.bmc.resourcemanager.responses.DeleteConfigurationSourceProviderResponse;
import com.oracle.bmc.resourcemanager.responses.DeletePrivateEndpointResponse;
import com.oracle.bmc.resourcemanager.responses.DeleteStackResponse;
import com.oracle.bmc.resourcemanager.responses.DeleteTemplateResponse;
import com.oracle.bmc.resourcemanager.responses.DetectStackDriftResponse;
import com.oracle.bmc.resourcemanager.responses.GetConfigurationSourceProviderResponse;
import com.oracle.bmc.resourcemanager.responses.GetJobDetailedLogContentResponse;
import com.oracle.bmc.resourcemanager.responses.GetJobLogsContentResponse;
import com.oracle.bmc.resourcemanager.responses.GetJobLogsResponse;
import com.oracle.bmc.resourcemanager.responses.GetJobResponse;
import com.oracle.bmc.resourcemanager.responses.GetJobTfConfigResponse;
import com.oracle.bmc.resourcemanager.responses.GetJobTfPlanResponse;
import com.oracle.bmc.resourcemanager.responses.GetJobTfStateResponse;
import com.oracle.bmc.resourcemanager.responses.GetPrivateEndpointResponse;
import com.oracle.bmc.resourcemanager.responses.GetReachableIpResponse;
import com.oracle.bmc.resourcemanager.responses.GetStackResponse;
import com.oracle.bmc.resourcemanager.responses.GetStackTfConfigResponse;
import com.oracle.bmc.resourcemanager.responses.GetStackTfStateResponse;
import com.oracle.bmc.resourcemanager.responses.GetTemplateLogoResponse;
import com.oracle.bmc.resourcemanager.responses.GetTemplateResponse;
import com.oracle.bmc.resourcemanager.responses.GetTemplateTfConfigResponse;
import com.oracle.bmc.resourcemanager.responses.GetWorkRequestResponse;
import com.oracle.bmc.resourcemanager.responses.ListConfigurationSourceProvidersResponse;
import com.oracle.bmc.resourcemanager.responses.ListJobAssociatedResourcesResponse;
import com.oracle.bmc.resourcemanager.responses.ListJobOutputsResponse;
import com.oracle.bmc.resourcemanager.responses.ListJobsResponse;
import com.oracle.bmc.resourcemanager.responses.ListPrivateEndpointsResponse;
import com.oracle.bmc.resourcemanager.responses.ListResourceDiscoveryServicesResponse;
import com.oracle.bmc.resourcemanager.responses.ListStackAssociatedResourcesResponse;
import com.oracle.bmc.resourcemanager.responses.ListStackResourceDriftDetailsResponse;
import com.oracle.bmc.resourcemanager.responses.ListStacksResponse;
import com.oracle.bmc.resourcemanager.responses.ListTemplateCategoriesResponse;
import com.oracle.bmc.resourcemanager.responses.ListTemplatesResponse;
import com.oracle.bmc.resourcemanager.responses.ListTerraformVersionsResponse;
import com.oracle.bmc.resourcemanager.responses.ListWorkRequestErrorsResponse;
import com.oracle.bmc.resourcemanager.responses.ListWorkRequestLogsResponse;
import com.oracle.bmc.resourcemanager.responses.ListWorkRequestsResponse;
import com.oracle.bmc.resourcemanager.responses.UpdateConfigurationSourceProviderResponse;
import com.oracle.bmc.resourcemanager.responses.UpdateJobResponse;
import com.oracle.bmc.resourcemanager.responses.UpdatePrivateEndpointResponse;
import com.oracle.bmc.resourcemanager.responses.UpdateStackResponse;
import com.oracle.bmc.resourcemanager.responses.UpdateTemplateResponse;
import com.oracle.bmc.util.CircuitBreakerUtils;
import com.oracle.bmc.util.StreamUtils;
import com.oracle.bmc.util.internal.CollectionFormatType;
import com.oracle.bmc.util.internal.Validate;
import jakarta.annotation.Nonnull;
import java.io.InputStream;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ResourceManagerClient
extends BaseSyncClient
implements ResourceManager {
    public static final Service SERVICE = Services.serviceBuilder().serviceName("RESOURCEMANAGER").serviceEndpointPrefix("resourcemanager").serviceEndpointTemplate("https://resourcemanager.{region}.{secondLevelDomain}").build();
    private static final Logger LOG = LoggerFactory.getLogger(ResourceManagerClient.class);
    private final ResourceManagerWaiters waiters;
    private final ResourceManagerPaginators paginators;

    ResourceManagerClient(ClientBuilderBase<?, ?> builder, AbstractAuthenticationDetailsProvider authenticationDetailsProvider, ExecutorService executorService) {
        this(builder, authenticationDetailsProvider, executorService, true);
    }

    ResourceManagerClient(ClientBuilderBase<?, ?> builder, AbstractAuthenticationDetailsProvider authenticationDetailsProvider, ExecutorService executorService, boolean isStreamWarningEnabled) {
        super(builder, authenticationDetailsProvider, CircuitBreakerUtils.DEFAULT_CIRCUIT_BREAKER_CONFIGURATION);
        if (executorService == null) {
            ThreadPoolExecutor threadPoolExecutor = new ThreadPoolExecutor(50, 50, 60L, TimeUnit.SECONDS, new LinkedBlockingQueue<Runnable>(), (ThreadFactory)ClientThreadFactory.builder().isDaemon(true).nameFormat("ResourceManager-waiters-%d").build());
            threadPoolExecutor.allowCoreThreadTimeOut(true);
            executorService = threadPoolExecutor;
        }
        this.waiters = new ResourceManagerWaiters(executorService, this);
        this.paginators = new ResourceManagerPaginators(this);
        if (isStreamWarningEnabled && StreamUtils.isExtraStreamLogsEnabled()) {
            LOG.warn(StreamUtils.getStreamWarningMessage((String)"ResourceManagerClient", (String)"getJobTfConfig,getJobTfPlan,getJobTfState,getStackTfConfig,getStackTfState,getTemplateLogo,getTemplateTfConfig"));
        }
    }

    public static Builder builder() {
        return new Builder(SERVICE);
    }

    @Override
    public void setRegion(Region region) {
        super.setRegion(region);
    }

    @Override
    public void setRegion(String regionId) {
        super.setRegion(regionId);
    }

    @Override
    public CancelJobResponse cancelJob(CancelJobRequest request) {
        Validate.notBlank((String)request.getJobId(), (String)"jobId must not be blank", (Object[])new Object[0]);
        return (CancelJobResponse)this.clientCall(request, CancelJobResponse::builder).logger(LOG, "cancelJob").serviceDetails("ResourceManager", "CancelJob", "https://docs.oracle.com/iaas/api/#/en/resourcemanager/20180917/Job/CancelJob").method(Method.DELETE).requestBuilder(CancelJobRequest::builder).basePath("/20180917").appendPathParam("jobs").appendPathParam(request.getJobId()).appendQueryParam("isForced", (Object)request.getIsForced()).accept(new String[]{"application/json"}).appendHeader("opc-request-id", request.getOpcRequestId()).appendHeader("if-match", request.getIfMatch()).handleResponseHeaderString("opc-request-id", CancelJobResponse.Builder::opcRequestId).operationUsesDefaultRetries().callSync();
    }

    @Override
    public ChangeConfigurationSourceProviderCompartmentResponse changeConfigurationSourceProviderCompartment(ChangeConfigurationSourceProviderCompartmentRequest request) {
        Validate.notBlank((String)request.getConfigurationSourceProviderId(), (String)"configurationSourceProviderId must not be blank", (Object[])new Object[0]);
        Objects.requireNonNull(request.getChangeConfigurationSourceProviderCompartmentDetails(), "changeConfigurationSourceProviderCompartmentDetails is required");
        return (ChangeConfigurationSourceProviderCompartmentResponse)this.clientCall(request, ChangeConfigurationSourceProviderCompartmentResponse::builder).logger(LOG, "changeConfigurationSourceProviderCompartment").serviceDetails("ResourceManager", "ChangeConfigurationSourceProviderCompartment", "https://docs.oracle.com/iaas/api/#/en/resourcemanager/20180917/ConfigurationSourceProvider/ChangeConfigurationSourceProviderCompartment").method(Method.POST).requestBuilder(ChangeConfigurationSourceProviderCompartmentRequest::builder).basePath("/20180917").appendPathParam("configurationSourceProviders").appendPathParam(request.getConfigurationSourceProviderId()).appendPathParam("actions").appendPathParam("changeCompartment").accept(new String[]{"application/json"}).appendHeader("if-match", request.getIfMatch()).appendHeader("opc-request-id", request.getOpcRequestId()).appendHeader("opc-retry-token", request.getOpcRetryToken()).hasBody().handleResponseHeaderString("opc-request-id", ChangeConfigurationSourceProviderCompartmentResponse.Builder::opcRequestId).operationUsesDefaultRetries().callSync();
    }

    @Override
    public ChangePrivateEndpointCompartmentResponse changePrivateEndpointCompartment(ChangePrivateEndpointCompartmentRequest request) {
        Validate.notBlank((String)request.getPrivateEndpointId(), (String)"privateEndpointId must not be blank", (Object[])new Object[0]);
        Objects.requireNonNull(request.getChangePrivateEndpointCompartmentDetails(), "changePrivateEndpointCompartmentDetails is required");
        return (ChangePrivateEndpointCompartmentResponse)this.clientCall(request, ChangePrivateEndpointCompartmentResponse::builder).logger(LOG, "changePrivateEndpointCompartment").serviceDetails("ResourceManager", "ChangePrivateEndpointCompartment", "https://docs.oracle.com/iaas/api/#/en/resourcemanager/20180917/PrivateEndpoint/ChangePrivateEndpointCompartment").method(Method.POST).requestBuilder(ChangePrivateEndpointCompartmentRequest::builder).basePath("/20180917").appendPathParam("privateEndpoints").appendPathParam(request.getPrivateEndpointId()).appendPathParam("actions").appendPathParam("changeCompartment").accept(new String[]{"application/json"}).appendHeader("if-match", request.getIfMatch()).appendHeader("opc-request-id", request.getOpcRequestId()).appendHeader("opc-retry-token", request.getOpcRetryToken()).hasBody().handleResponseHeaderString("opc-request-id", ChangePrivateEndpointCompartmentResponse.Builder::opcRequestId).operationUsesDefaultRetries().callSync();
    }

    @Override
    public ChangeStackCompartmentResponse changeStackCompartment(ChangeStackCompartmentRequest request) {
        Validate.notBlank((String)request.getStackId(), (String)"stackId must not be blank", (Object[])new Object[0]);
        Objects.requireNonNull(request.getChangeStackCompartmentDetails(), "changeStackCompartmentDetails is required");
        return (ChangeStackCompartmentResponse)this.clientCall(request, ChangeStackCompartmentResponse::builder).logger(LOG, "changeStackCompartment").serviceDetails("ResourceManager", "ChangeStackCompartment", "https://docs.oracle.com/iaas/api/#/en/resourcemanager/20180917/Stack/ChangeStackCompartment").method(Method.POST).requestBuilder(ChangeStackCompartmentRequest::builder).basePath("/20180917").appendPathParam("stacks").appendPathParam(request.getStackId()).appendPathParam("actions").appendPathParam("changeCompartment").accept(new String[]{"application/json"}).appendHeader("if-match", request.getIfMatch()).appendHeader("opc-request-id", request.getOpcRequestId()).appendHeader("opc-retry-token", request.getOpcRetryToken()).hasBody().handleResponseHeaderString("opc-request-id", ChangeStackCompartmentResponse.Builder::opcRequestId).handleResponseHeaderString("opc-work-request-id", ChangeStackCompartmentResponse.Builder::opcWorkRequestId).operationUsesDefaultRetries().callSync();
    }

    @Override
    public ChangeTemplateCompartmentResponse changeTemplateCompartment(ChangeTemplateCompartmentRequest request) {
        Validate.notBlank((String)request.getTemplateId(), (String)"templateId must not be blank", (Object[])new Object[0]);
        Objects.requireNonNull(request.getChangeTemplateCompartmentDetails(), "changeTemplateCompartmentDetails is required");
        return (ChangeTemplateCompartmentResponse)this.clientCall(request, ChangeTemplateCompartmentResponse::builder).logger(LOG, "changeTemplateCompartment").serviceDetails("ResourceManager", "ChangeTemplateCompartment", "https://docs.oracle.com/iaas/api/#/en/resourcemanager/20180917/Template/ChangeTemplateCompartment").method(Method.POST).requestBuilder(ChangeTemplateCompartmentRequest::builder).basePath("/20180917").appendPathParam("templates").appendPathParam(request.getTemplateId()).appendPathParam("actions").appendPathParam("changeCompartment").accept(new String[]{"application/json"}).appendHeader("if-match", request.getIfMatch()).appendHeader("opc-request-id", request.getOpcRequestId()).appendHeader("opc-retry-token", request.getOpcRetryToken()).hasBody().handleResponseHeaderString("opc-request-id", ChangeTemplateCompartmentResponse.Builder::opcRequestId).operationUsesDefaultRetries().callSync();
    }

    @Override
    public CreateConfigurationSourceProviderResponse createConfigurationSourceProvider(CreateConfigurationSourceProviderRequest request) {
        Objects.requireNonNull(request.getCreateConfigurationSourceProviderDetails(), "createConfigurationSourceProviderDetails is required");
        return (CreateConfigurationSourceProviderResponse)this.clientCall(request, CreateConfigurationSourceProviderResponse::builder).logger(LOG, "createConfigurationSourceProvider").serviceDetails("ResourceManager", "CreateConfigurationSourceProvider", "https://docs.oracle.com/iaas/api/#/en/resourcemanager/20180917/ConfigurationSourceProvider/CreateConfigurationSourceProvider").method(Method.POST).requestBuilder(CreateConfigurationSourceProviderRequest::builder).basePath("/20180917").appendPathParam("configurationSourceProviders").accept(new String[]{"application/json"}).appendHeader("opc-request-id", request.getOpcRequestId()).appendHeader("opc-retry-token", request.getOpcRetryToken()).hasBody().handleBody(ConfigurationSourceProvider.class, CreateConfigurationSourceProviderResponse.Builder::configurationSourceProvider).handleResponseHeaderString("opc-request-id", CreateConfigurationSourceProviderResponse.Builder::opcRequestId).handleResponseHeaderString("etag", CreateConfigurationSourceProviderResponse.Builder::etag).operationUsesDefaultRetries().callSync();
    }

    @Override
    public CreateJobResponse createJob(CreateJobRequest request) {
        Objects.requireNonNull(request.getCreateJobDetails(), "createJobDetails is required");
        return (CreateJobResponse)this.clientCall(request, CreateJobResponse::builder).logger(LOG, "createJob").serviceDetails("ResourceManager", "CreateJob", "https://docs.oracle.com/iaas/api/#/en/resourcemanager/20180917/Job/CreateJob").method(Method.POST).requestBuilder(CreateJobRequest::builder).basePath("/20180917").appendPathParam("jobs").accept(new String[]{"application/json"}).appendHeader("opc-request-id", request.getOpcRequestId()).appendHeader("opc-retry-token", request.getOpcRetryToken()).hasBody().handleBody(Job.class, CreateJobResponse.Builder::job).handleResponseHeaderString("opc-request-id", CreateJobResponse.Builder::opcRequestId).handleResponseHeaderString("etag", CreateJobResponse.Builder::etag).operationUsesDefaultRetries().callSync();
    }

    @Override
    public CreatePrivateEndpointResponse createPrivateEndpoint(CreatePrivateEndpointRequest request) {
        Objects.requireNonNull(request.getCreatePrivateEndpointDetails(), "createPrivateEndpointDetails is required");
        return (CreatePrivateEndpointResponse)this.clientCall(request, CreatePrivateEndpointResponse::builder).logger(LOG, "createPrivateEndpoint").serviceDetails("ResourceManager", "CreatePrivateEndpoint", "https://docs.oracle.com/iaas/api/#/en/resourcemanager/20180917/PrivateEndpoint/CreatePrivateEndpoint").method(Method.POST).requestBuilder(CreatePrivateEndpointRequest::builder).basePath("/20180917").appendPathParam("privateEndpoints").accept(new String[]{"application/json"}).appendHeader("opc-request-id", request.getOpcRequestId()).appendHeader("opc-retry-token", request.getOpcRetryToken()).hasBody().handleBody(PrivateEndpoint.class, CreatePrivateEndpointResponse.Builder::privateEndpoint).handleResponseHeaderString("opc-request-id", CreatePrivateEndpointResponse.Builder::opcRequestId).handleResponseHeaderString("etag", CreatePrivateEndpointResponse.Builder::etag).operationUsesDefaultRetries().callSync();
    }

    @Override
    public CreateStackResponse createStack(CreateStackRequest request) {
        Objects.requireNonNull(request.getCreateStackDetails(), "createStackDetails is required");
        return (CreateStackResponse)this.clientCall(request, CreateStackResponse::builder).logger(LOG, "createStack").serviceDetails("ResourceManager", "CreateStack", "https://docs.oracle.com/iaas/api/#/en/resourcemanager/20180917/Stack/CreateStack").method(Method.POST).requestBuilder(CreateStackRequest::builder).basePath("/20180917").appendPathParam("stacks").accept(new String[]{"application/json"}).appendHeader("opc-request-id", request.getOpcRequestId()).appendHeader("opc-retry-token", request.getOpcRetryToken()).hasBody().handleBody(Stack.class, CreateStackResponse.Builder::stack).handleResponseHeaderString("opc-request-id", CreateStackResponse.Builder::opcRequestId).handleResponseHeaderString("opc-work-request-id", CreateStackResponse.Builder::opcWorkRequestId).handleResponseHeaderString("etag", CreateStackResponse.Builder::etag).operationUsesDefaultRetries().callSync();
    }

    @Override
    public CreateTemplateResponse createTemplate(CreateTemplateRequest request) {
        Objects.requireNonNull(request.getCreateTemplateDetails(), "createTemplateDetails is required");
        return (CreateTemplateResponse)this.clientCall(request, CreateTemplateResponse::builder).logger(LOG, "createTemplate").serviceDetails("ResourceManager", "CreateTemplate", "https://docs.oracle.com/iaas/api/#/en/resourcemanager/20180917/Template/CreateTemplate").method(Method.POST).requestBuilder(CreateTemplateRequest::builder).basePath("/20180917").appendPathParam("templates").accept(new String[]{"application/json"}).appendHeader("opc-request-id", request.getOpcRequestId()).appendHeader("opc-retry-token", request.getOpcRetryToken()).hasBody().handleBody(Template.class, CreateTemplateResponse.Builder::template).handleResponseHeaderString("opc-request-id", CreateTemplateResponse.Builder::opcRequestId).handleResponseHeaderString("etag", CreateTemplateResponse.Builder::etag).operationUsesDefaultRetries().callSync();
    }

    @Override
    public DeleteConfigurationSourceProviderResponse deleteConfigurationSourceProvider(DeleteConfigurationSourceProviderRequest request) {
        Validate.notBlank((String)request.getConfigurationSourceProviderId(), (String)"configurationSourceProviderId must not be blank", (Object[])new Object[0]);
        return (DeleteConfigurationSourceProviderResponse)this.clientCall(request, DeleteConfigurationSourceProviderResponse::builder).logger(LOG, "deleteConfigurationSourceProvider").serviceDetails("ResourceManager", "DeleteConfigurationSourceProvider", "https://docs.oracle.com/iaas/api/#/en/resourcemanager/20180917/ConfigurationSourceProvider/DeleteConfigurationSourceProvider").method(Method.DELETE).requestBuilder(DeleteConfigurationSourceProviderRequest::builder).basePath("/20180917").appendPathParam("configurationSourceProviders").appendPathParam(request.getConfigurationSourceProviderId()).accept(new String[]{"application/json"}).appendHeader("opc-request-id", request.getOpcRequestId()).appendHeader("if-match", request.getIfMatch()).handleResponseHeaderString("opc-request-id", DeleteConfigurationSourceProviderResponse.Builder::opcRequestId).operationUsesDefaultRetries().callSync();
    }

    @Override
    public DeletePrivateEndpointResponse deletePrivateEndpoint(DeletePrivateEndpointRequest request) {
        Validate.notBlank((String)request.getPrivateEndpointId(), (String)"privateEndpointId must not be blank", (Object[])new Object[0]);
        return (DeletePrivateEndpointResponse)this.clientCall(request, DeletePrivateEndpointResponse::builder).logger(LOG, "deletePrivateEndpoint").serviceDetails("ResourceManager", "DeletePrivateEndpoint", "https://docs.oracle.com/iaas/api/#/en/resourcemanager/20180917/PrivateEndpoint/DeletePrivateEndpoint").method(Method.DELETE).requestBuilder(DeletePrivateEndpointRequest::builder).basePath("/20180917").appendPathParam("privateEndpoints").appendPathParam(request.getPrivateEndpointId()).accept(new String[]{"application/json"}).appendHeader("opc-request-id", request.getOpcRequestId()).appendHeader("if-match", request.getIfMatch()).handleResponseHeaderString("opc-request-id", DeletePrivateEndpointResponse.Builder::opcRequestId).operationUsesDefaultRetries().callSync();
    }

    @Override
    public DeleteStackResponse deleteStack(DeleteStackRequest request) {
        Validate.notBlank((String)request.getStackId(), (String)"stackId must not be blank", (Object[])new Object[0]);
        return (DeleteStackResponse)this.clientCall(request, DeleteStackResponse::builder).logger(LOG, "deleteStack").serviceDetails("ResourceManager", "DeleteStack", "https://docs.oracle.com/iaas/api/#/en/resourcemanager/20180917/Stack/DeleteStack").method(Method.DELETE).requestBuilder(DeleteStackRequest::builder).basePath("/20180917").appendPathParam("stacks").appendPathParam(request.getStackId()).accept(new String[]{"application/json"}).appendHeader("opc-request-id", request.getOpcRequestId()).appendHeader("if-match", request.getIfMatch()).handleResponseHeaderString("opc-request-id", DeleteStackResponse.Builder::opcRequestId).operationUsesDefaultRetries().callSync();
    }

    @Override
    public DeleteTemplateResponse deleteTemplate(DeleteTemplateRequest request) {
        Validate.notBlank((String)request.getTemplateId(), (String)"templateId must not be blank", (Object[])new Object[0]);
        return (DeleteTemplateResponse)this.clientCall(request, DeleteTemplateResponse::builder).logger(LOG, "deleteTemplate").serviceDetails("ResourceManager", "DeleteTemplate", "https://docs.oracle.com/iaas/api/#/en/resourcemanager/20180917/Template/DeleteTemplate").method(Method.DELETE).requestBuilder(DeleteTemplateRequest::builder).basePath("/20180917").appendPathParam("templates").appendPathParam(request.getTemplateId()).accept(new String[]{"application/json"}).appendHeader("opc-request-id", request.getOpcRequestId()).appendHeader("if-match", request.getIfMatch()).handleResponseHeaderString("opc-request-id", DeleteTemplateResponse.Builder::opcRequestId).operationUsesDefaultRetries().callSync();
    }

    @Override
    public DetectStackDriftResponse detectStackDrift(DetectStackDriftRequest request) {
        Validate.notBlank((String)request.getStackId(), (String)"stackId must not be blank", (Object[])new Object[0]);
        return (DetectStackDriftResponse)this.clientCall(request, DetectStackDriftResponse::builder).logger(LOG, "detectStackDrift").serviceDetails("ResourceManager", "DetectStackDrift", "https://docs.oracle.com/iaas/api/#/en/resourcemanager/20180917/Stack/DetectStackDrift").method(Method.POST).requestBuilder(DetectStackDriftRequest::builder).basePath("/20180917").appendPathParam("stacks").appendPathParam(request.getStackId()).appendPathParam("actions").appendPathParam("detectDrift").accept(new String[]{"application/json"}).appendHeader("if-match", request.getIfMatch()).appendHeader("opc-request-id", request.getOpcRequestId()).appendHeader("opc-retry-token", request.getOpcRetryToken()).hasBody().handleResponseHeaderString("opc-request-id", DetectStackDriftResponse.Builder::opcRequestId).handleResponseHeaderString("opc-work-request-id", DetectStackDriftResponse.Builder::opcWorkRequestId).operationUsesDefaultRetries().callSync();
    }

    @Override
    public GetConfigurationSourceProviderResponse getConfigurationSourceProvider(GetConfigurationSourceProviderRequest request) {
        Validate.notBlank((String)request.getConfigurationSourceProviderId(), (String)"configurationSourceProviderId must not be blank", (Object[])new Object[0]);
        return (GetConfigurationSourceProviderResponse)this.clientCall(request, GetConfigurationSourceProviderResponse::builder).logger(LOG, "getConfigurationSourceProvider").serviceDetails("ResourceManager", "GetConfigurationSourceProvider", "https://docs.oracle.com/iaas/api/#/en/resourcemanager/20180917/ConfigurationSourceProvider/GetConfigurationSourceProvider").method(Method.GET).requestBuilder(GetConfigurationSourceProviderRequest::builder).basePath("/20180917").appendPathParam("configurationSourceProviders").appendPathParam(request.getConfigurationSourceProviderId()).accept(new String[]{"application/json"}).appendHeader("opc-request-id", request.getOpcRequestId()).handleBody(ConfigurationSourceProvider.class, GetConfigurationSourceProviderResponse.Builder::configurationSourceProvider).handleResponseHeaderString("opc-request-id", GetConfigurationSourceProviderResponse.Builder::opcRequestId).handleResponseHeaderString("etag", GetConfigurationSourceProviderResponse.Builder::etag).operationUsesDefaultRetries().callSync();
    }

    @Override
    public GetJobResponse getJob(GetJobRequest request) {
        Validate.notBlank((String)request.getJobId(), (String)"jobId must not be blank", (Object[])new Object[0]);
        return (GetJobResponse)this.clientCall(request, GetJobResponse::builder).logger(LOG, "getJob").serviceDetails("ResourceManager", "GetJob", "https://docs.oracle.com/iaas/api/#/en/resourcemanager/20180917/Job/GetJob").method(Method.GET).requestBuilder(GetJobRequest::builder).basePath("/20180917").appendPathParam("jobs").appendPathParam(request.getJobId()).accept(new String[]{"application/json"}).appendHeader("opc-request-id", request.getOpcRequestId()).handleBody(Job.class, GetJobResponse.Builder::job).handleResponseHeaderString("opc-request-id", GetJobResponse.Builder::opcRequestId).handleResponseHeaderString("etag", GetJobResponse.Builder::etag).operationUsesDefaultRetries().callSync();
    }

    @Override
    public GetJobDetailedLogContentResponse getJobDetailedLogContent(GetJobDetailedLogContentRequest request) {
        Validate.notBlank((String)request.getJobId(), (String)"jobId must not be blank", (Object[])new Object[0]);
        return (GetJobDetailedLogContentResponse)this.clientCall(request, GetJobDetailedLogContentResponse::builder).logger(LOG, "getJobDetailedLogContent").serviceDetails("ResourceManager", "GetJobDetailedLogContent", "https://docs.oracle.com/iaas/api/#/en/resourcemanager/20180917/Job/GetJobDetailedLogContent").method(Method.GET).requestBuilder(GetJobDetailedLogContentRequest::builder).basePath("/20180917").appendPathParam("jobs").appendPathParam(request.getJobId()).appendPathParam("detailedLogContent").accept(new String[]{"text/plain; charset=utf-8"}).appendHeader("opc-request-id", request.getOpcRequestId()).handleBody(String.class, GetJobDetailedLogContentResponse.Builder::value).handleResponseHeaderString("opc-request-id", GetJobDetailedLogContentResponse.Builder::opcRequestId).operationUsesDefaultRetries().callSync();
    }

    @Override
    public GetJobLogsResponse getJobLogs(GetJobLogsRequest request) {
        Validate.notBlank((String)request.getJobId(), (String)"jobId must not be blank", (Object[])new Object[0]);
        return (GetJobLogsResponse)this.clientCall(request, GetJobLogsResponse::builder).logger(LOG, "getJobLogs").serviceDetails("ResourceManager", "GetJobLogs", "https://docs.oracle.com/iaas/api/#/en/resourcemanager/20180917/Job/GetJobLogs").method(Method.GET).requestBuilder(GetJobLogsRequest::builder).basePath("/20180917").appendPathParam("jobs").appendPathParam(request.getJobId()).appendPathParam("logs").appendListQueryParam("type", request.getType(), CollectionFormatType.Multi).appendEnumQueryParam("levelGreaterThanOrEqualTo", (BmcEnum)request.getLevelGreaterThanOrEqualTo()).appendEnumQueryParam("sortOrder", (BmcEnum)request.getSortOrder()).appendQueryParam("limit", (Object)request.getLimit()).appendQueryParam("page", (Object)request.getPage()).appendQueryParam("timestampGreaterThanOrEqualTo", (Object)request.getTimestampGreaterThanOrEqualTo()).appendQueryParam("timestampLessThanOrEqualTo", (Object)request.getTimestampLessThanOrEqualTo()).accept(new String[]{"application/json"}).appendHeader("opc-request-id", request.getOpcRequestId()).handleBodyList(LogEntry.class, GetJobLogsResponse.Builder::items).handleResponseHeaderString("opc-request-id", GetJobLogsResponse.Builder::opcRequestId).handleResponseHeaderString("opc-next-page", GetJobLogsResponse.Builder::opcNextPage).operationUsesDefaultRetries().callSync();
    }

    @Override
    public GetJobLogsContentResponse getJobLogsContent(GetJobLogsContentRequest request) {
        Validate.notBlank((String)request.getJobId(), (String)"jobId must not be blank", (Object[])new Object[0]);
        return (GetJobLogsContentResponse)this.clientCall(request, GetJobLogsContentResponse::builder).logger(LOG, "getJobLogsContent").serviceDetails("ResourceManager", "GetJobLogsContent", "https://docs.oracle.com/iaas/api/#/en/resourcemanager/20180917/Job/GetJobLogsContent").method(Method.GET).requestBuilder(GetJobLogsContentRequest::builder).basePath("/20180917").appendPathParam("jobs").appendPathParam(request.getJobId()).appendPathParam("logs").appendPathParam("content").accept(new String[]{"text/plain; charset=utf-8"}).appendHeader("opc-request-id", request.getOpcRequestId()).handleBody(String.class, GetJobLogsContentResponse.Builder::value).handleResponseHeaderString("opc-request-id", GetJobLogsContentResponse.Builder::opcRequestId).operationUsesDefaultRetries().callSync();
    }

    @Override
    public GetJobTfConfigResponse getJobTfConfig(GetJobTfConfigRequest request) {
        Validate.notBlank((String)request.getJobId(), (String)"jobId must not be blank", (Object[])new Object[0]);
        return (GetJobTfConfigResponse)this.clientCall(request, GetJobTfConfigResponse::builder).logger(LOG, "getJobTfConfig").serviceDetails("ResourceManager", "GetJobTfConfig", "https://docs.oracle.com/iaas/api/#/en/resourcemanager/20180917/Job/GetJobTfConfig").method(Method.GET).requestBuilder(GetJobTfConfigRequest::builder).basePath("/20180917").appendPathParam("jobs").appendPathParam(request.getJobId()).appendPathParam("tfConfig").accept(new String[]{"application/zip"}).appendHeader("opc-request-id", request.getOpcRequestId()).handleBody(InputStream.class, GetJobTfConfigResponse.Builder::inputStream).handleResponseHeaderString("opc-request-id", GetJobTfConfigResponse.Builder::opcRequestId).operationUsesDefaultRetries().callSync();
    }

    @Override
    public GetJobTfPlanResponse getJobTfPlan(GetJobTfPlanRequest request) {
        Validate.notBlank((String)request.getJobId(), (String)"jobId must not be blank", (Object[])new Object[0]);
        return (GetJobTfPlanResponse)this.clientCall(request, GetJobTfPlanResponse::builder).logger(LOG, "getJobTfPlan").serviceDetails("ResourceManager", "GetJobTfPlan", "https://docs.oracle.com/iaas/api/#/en/resourcemanager/20180917/Job/GetJobTfPlan").method(Method.GET).requestBuilder(GetJobTfPlanRequest::builder).basePath("/20180917").appendPathParam("jobs").appendPathParam(request.getJobId()).appendPathParam("tfPlan").appendEnumQueryParam("tfPlanFormat", (BmcEnum)request.getTfPlanFormat()).accept(new String[]{"application/octet-stream"}).appendHeader("opc-request-id", request.getOpcRequestId()).handleBody(InputStream.class, GetJobTfPlanResponse.Builder::inputStream).handleResponseHeaderString("opc-request-id", GetJobTfPlanResponse.Builder::opcRequestId).operationUsesDefaultRetries().callSync();
    }

    @Override
    public GetJobTfStateResponse getJobTfState(GetJobTfStateRequest request) {
        Validate.notBlank((String)request.getJobId(), (String)"jobId must not be blank", (Object[])new Object[0]);
        return (GetJobTfStateResponse)this.clientCall(request, GetJobTfStateResponse::builder).logger(LOG, "getJobTfState").serviceDetails("ResourceManager", "GetJobTfState", "https://docs.oracle.com/iaas/api/#/en/resourcemanager/20180917/Job/GetJobTfState").method(Method.GET).requestBuilder(GetJobTfStateRequest::builder).basePath("/20180917").appendPathParam("jobs").appendPathParam(request.getJobId()).appendPathParam("tfState").accept(new String[]{"application/octet-stream"}).appendHeader("opc-request-id", request.getOpcRequestId()).handleBody(InputStream.class, GetJobTfStateResponse.Builder::inputStream).handleResponseHeaderString("opc-request-id", GetJobTfStateResponse.Builder::opcRequestId).operationUsesDefaultRetries().callSync();
    }

    @Override
    public GetPrivateEndpointResponse getPrivateEndpoint(GetPrivateEndpointRequest request) {
        Validate.notBlank((String)request.getPrivateEndpointId(), (String)"privateEndpointId must not be blank", (Object[])new Object[0]);
        return (GetPrivateEndpointResponse)this.clientCall(request, GetPrivateEndpointResponse::builder).logger(LOG, "getPrivateEndpoint").serviceDetails("ResourceManager", "GetPrivateEndpoint", "https://docs.oracle.com/iaas/api/#/en/resourcemanager/20180917/PrivateEndpoint/GetPrivateEndpoint").method(Method.GET).requestBuilder(GetPrivateEndpointRequest::builder).basePath("/20180917").appendPathParam("privateEndpoints").appendPathParam(request.getPrivateEndpointId()).accept(new String[]{"application/json"}).appendHeader("opc-request-id", request.getOpcRequestId()).handleBody(PrivateEndpoint.class, GetPrivateEndpointResponse.Builder::privateEndpoint).handleResponseHeaderString("opc-request-id", GetPrivateEndpointResponse.Builder::opcRequestId).handleResponseHeaderString("etag", GetPrivateEndpointResponse.Builder::etag).operationUsesDefaultRetries().callSync();
    }

    @Override
    public GetReachableIpResponse getReachableIp(GetReachableIpRequest request) {
        Objects.requireNonNull(request.getPrivateIp(), "privateIp is required");
        Validate.notBlank((String)request.getPrivateEndpointId(), (String)"privateEndpointId must not be blank", (Object[])new Object[0]);
        return (GetReachableIpResponse)this.clientCall(request, GetReachableIpResponse::builder).logger(LOG, "getReachableIp").serviceDetails("ResourceManager", "GetReachableIp", "https://docs.oracle.com/iaas/api/#/en/resourcemanager/20180917/ReachableIp/GetReachableIp").method(Method.GET).requestBuilder(GetReachableIpRequest::builder).basePath("/20180917").appendPathParam("privateEndpoints").appendPathParam(request.getPrivateEndpointId()).appendPathParam("reachableIp").appendQueryParam("privateIp", (Object)request.getPrivateIp()).accept(new String[]{"application/json"}).appendHeader("opc-request-id", request.getOpcRequestId()).appendHeader("opc-retry-token", request.getOpcRetryToken()).handleBody(ReachableIp.class, GetReachableIpResponse.Builder::reachableIp).handleResponseHeaderString("opc-request-id", GetReachableIpResponse.Builder::opcRequestId).operationUsesDefaultRetries().callSync();
    }

    @Override
    public GetStackResponse getStack(GetStackRequest request) {
        Validate.notBlank((String)request.getStackId(), (String)"stackId must not be blank", (Object[])new Object[0]);
        return (GetStackResponse)this.clientCall(request, GetStackResponse::builder).logger(LOG, "getStack").serviceDetails("ResourceManager", "GetStack", "https://docs.oracle.com/iaas/api/#/en/resourcemanager/20180917/Stack/GetStack").method(Method.GET).requestBuilder(GetStackRequest::builder).basePath("/20180917").appendPathParam("stacks").appendPathParam(request.getStackId()).accept(new String[]{"application/json"}).appendHeader("opc-request-id", request.getOpcRequestId()).handleBody(Stack.class, GetStackResponse.Builder::stack).handleResponseHeaderString("opc-request-id", GetStackResponse.Builder::opcRequestId).handleResponseHeaderString("etag", GetStackResponse.Builder::etag).operationUsesDefaultRetries().callSync();
    }

    @Override
    public GetStackTfConfigResponse getStackTfConfig(GetStackTfConfigRequest request) {
        Validate.notBlank((String)request.getStackId(), (String)"stackId must not be blank", (Object[])new Object[0]);
        return (GetStackTfConfigResponse)this.clientCall(request, GetStackTfConfigResponse::builder).logger(LOG, "getStackTfConfig").serviceDetails("ResourceManager", "GetStackTfConfig", "https://docs.oracle.com/iaas/api/#/en/resourcemanager/20180917/Stack/GetStackTfConfig").method(Method.GET).requestBuilder(GetStackTfConfigRequest::builder).basePath("/20180917").appendPathParam("stacks").appendPathParam(request.getStackId()).appendPathParam("tfConfig").accept(new String[]{"application/zip"}).appendHeader("opc-request-id", request.getOpcRequestId()).handleBody(InputStream.class, GetStackTfConfigResponse.Builder::inputStream).handleResponseHeaderString("opc-request-id", GetStackTfConfigResponse.Builder::opcRequestId).operationUsesDefaultRetries().callSync();
    }

    @Override
    public GetStackTfStateResponse getStackTfState(GetStackTfStateRequest request) {
        Validate.notBlank((String)request.getStackId(), (String)"stackId must not be blank", (Object[])new Object[0]);
        return (GetStackTfStateResponse)this.clientCall(request, GetStackTfStateResponse::builder).logger(LOG, "getStackTfState").serviceDetails("ResourceManager", "GetStackTfState", "https://docs.oracle.com/iaas/api/#/en/resourcemanager/20180917/Stack/GetStackTfState").method(Method.GET).requestBuilder(GetStackTfStateRequest::builder).basePath("/20180917").appendPathParam("stacks").appendPathParam(request.getStackId()).appendPathParam("tfState").accept(new String[]{"application/octet-stream"}).appendHeader("opc-request-id", request.getOpcRequestId()).handleBody(InputStream.class, GetStackTfStateResponse.Builder::inputStream).handleResponseHeaderString("opc-request-id", GetStackTfStateResponse.Builder::opcRequestId).operationUsesDefaultRetries().callSync();
    }

    @Override
    public GetTemplateResponse getTemplate(GetTemplateRequest request) {
        Validate.notBlank((String)request.getTemplateId(), (String)"templateId must not be blank", (Object[])new Object[0]);
        return (GetTemplateResponse)this.clientCall(request, GetTemplateResponse::builder).logger(LOG, "getTemplate").serviceDetails("ResourceManager", "GetTemplate", "https://docs.oracle.com/iaas/api/#/en/resourcemanager/20180917/Template/GetTemplate").method(Method.GET).requestBuilder(GetTemplateRequest::builder).basePath("/20180917").appendPathParam("templates").appendPathParam(request.getTemplateId()).accept(new String[]{"application/json"}).appendHeader("opc-request-id", request.getOpcRequestId()).handleBody(Template.class, GetTemplateResponse.Builder::template).handleResponseHeaderString("opc-request-id", GetTemplateResponse.Builder::opcRequestId).handleResponseHeaderString("etag", GetTemplateResponse.Builder::etag).operationUsesDefaultRetries().callSync();
    }

    @Override
    public GetTemplateLogoResponse getTemplateLogo(GetTemplateLogoRequest request) {
        Validate.notBlank((String)request.getTemplateId(), (String)"templateId must not be blank", (Object[])new Object[0]);
        return (GetTemplateLogoResponse)this.clientCall(request, GetTemplateLogoResponse::builder).logger(LOG, "getTemplateLogo").serviceDetails("ResourceManager", "GetTemplateLogo", "https://docs.oracle.com/iaas/api/#/en/resourcemanager/20180917/Template/GetTemplateLogo").method(Method.GET).requestBuilder(GetTemplateLogoRequest::builder).basePath("/20180917").appendPathParam("templates").appendPathParam(request.getTemplateId()).appendPathParam("logo").accept(new String[]{"image/png"}).appendHeader("opc-request-id", request.getOpcRequestId()).handleBody(InputStream.class, GetTemplateLogoResponse.Builder::inputStream).handleResponseHeaderString("opc-request-id", GetTemplateLogoResponse.Builder::opcRequestId).operationUsesDefaultRetries().callSync();
    }

    @Override
    public GetTemplateTfConfigResponse getTemplateTfConfig(GetTemplateTfConfigRequest request) {
        Validate.notBlank((String)request.getTemplateId(), (String)"templateId must not be blank", (Object[])new Object[0]);
        return (GetTemplateTfConfigResponse)this.clientCall(request, GetTemplateTfConfigResponse::builder).logger(LOG, "getTemplateTfConfig").serviceDetails("ResourceManager", "GetTemplateTfConfig", "https://docs.oracle.com/iaas/api/#/en/resourcemanager/20180917/Template/GetTemplateTfConfig").method(Method.GET).requestBuilder(GetTemplateTfConfigRequest::builder).basePath("/20180917").appendPathParam("templates").appendPathParam(request.getTemplateId()).appendPathParam("tfConfig").accept(new String[]{"application/zip"}).appendHeader("opc-request-id", request.getOpcRequestId()).handleBody(InputStream.class, GetTemplateTfConfigResponse.Builder::inputStream).handleResponseHeaderString("opc-request-id", GetTemplateTfConfigResponse.Builder::opcRequestId).operationUsesDefaultRetries().callSync();
    }

    @Override
    public GetWorkRequestResponse getWorkRequest(GetWorkRequestRequest request) {
        Validate.notBlank((String)request.getWorkRequestId(), (String)"workRequestId must not be blank", (Object[])new Object[0]);
        return (GetWorkRequestResponse)this.clientCall(request, GetWorkRequestResponse::builder).logger(LOG, "getWorkRequest").serviceDetails("ResourceManager", "GetWorkRequest", "https://docs.oracle.com/iaas/api/#/en/resourcemanager/20180917/WorkRequest/GetWorkRequest").method(Method.GET).requestBuilder(GetWorkRequestRequest::builder).basePath("/20180917").appendPathParam("workRequests").appendPathParam(request.getWorkRequestId()).accept(new String[]{"application/json"}).appendHeader("opc-request-id", request.getOpcRequestId()).handleBody(WorkRequest.class, GetWorkRequestResponse.Builder::workRequest).handleResponseHeaderString("opc-request-id", GetWorkRequestResponse.Builder::opcRequestId).operationUsesDefaultRetries().callSync();
    }

    @Override
    public ListConfigurationSourceProvidersResponse listConfigurationSourceProviders(ListConfigurationSourceProvidersRequest request) {
        return (ListConfigurationSourceProvidersResponse)this.clientCall(request, ListConfigurationSourceProvidersResponse::builder).logger(LOG, "listConfigurationSourceProviders").serviceDetails("ResourceManager", "ListConfigurationSourceProviders", "https://docs.oracle.com/iaas/api/#/en/resourcemanager/20180917/ConfigurationSourceProviderSummary/ListConfigurationSourceProviders").method(Method.GET).requestBuilder(ListConfigurationSourceProvidersRequest::builder).basePath("/20180917").appendPathParam("configurationSourceProviders").appendQueryParam("compartmentId", (Object)request.getCompartmentId()).appendQueryParam("configurationSourceProviderId", (Object)request.getConfigurationSourceProviderId()).appendQueryParam("displayName", (Object)request.getDisplayName()).appendEnumQueryParam("sortBy", (BmcEnum)request.getSortBy()).appendEnumQueryParam("sortOrder", (BmcEnum)request.getSortOrder()).appendQueryParam("limit", (Object)request.getLimit()).appendQueryParam("page", (Object)request.getPage()).appendQueryParam("configSourceProviderType", (Object)request.getConfigSourceProviderType()).accept(new String[]{"application/json"}).appendHeader("opc-request-id", request.getOpcRequestId()).handleBody(ConfigurationSourceProviderCollection.class, ListConfigurationSourceProvidersResponse.Builder::configurationSourceProviderCollection).handleResponseHeaderString("opc-request-id", ListConfigurationSourceProvidersResponse.Builder::opcRequestId).handleResponseHeaderString("opc-next-page", ListConfigurationSourceProvidersResponse.Builder::opcNextPage).operationUsesDefaultRetries().callSync();
    }

    @Override
    public ListJobAssociatedResourcesResponse listJobAssociatedResources(ListJobAssociatedResourcesRequest request) {
        Validate.notBlank((String)request.getJobId(), (String)"jobId must not be blank", (Object[])new Object[0]);
        return (ListJobAssociatedResourcesResponse)this.clientCall(request, ListJobAssociatedResourcesResponse::builder).logger(LOG, "listJobAssociatedResources").serviceDetails("ResourceManager", "ListJobAssociatedResources", "https://docs.oracle.com/iaas/api/#/en/resourcemanager/20180917/AssociatedResourceSummary/ListJobAssociatedResources").method(Method.GET).requestBuilder(ListJobAssociatedResourcesRequest::builder).basePath("/20180917").appendPathParam("jobs").appendPathParam(request.getJobId()).appendPathParam("associatedResources").appendQueryParam("compartmentId", (Object)request.getCompartmentId()).appendQueryParam("terraformResourceType", (Object)request.getTerraformResourceType()).appendQueryParam("limit", (Object)request.getLimit()).appendQueryParam("page", (Object)request.getPage()).accept(new String[]{"application/json"}).appendHeader("opc-request-id", request.getOpcRequestId()).handleBody(AssociatedResourcesCollection.class, ListJobAssociatedResourcesResponse.Builder::associatedResourcesCollection).handleResponseHeaderString("opc-request-id", ListJobAssociatedResourcesResponse.Builder::opcRequestId).handleResponseHeaderString("opc-next-page", ListJobAssociatedResourcesResponse.Builder::opcNextPage).operationUsesDefaultRetries().callSync();
    }

    @Override
    public ListJobOutputsResponse listJobOutputs(ListJobOutputsRequest request) {
        Validate.notBlank((String)request.getJobId(), (String)"jobId must not be blank", (Object[])new Object[0]);
        return (ListJobOutputsResponse)this.clientCall(request, ListJobOutputsResponse::builder).logger(LOG, "listJobOutputs").serviceDetails("ResourceManager", "ListJobOutputs", "https://docs.oracle.com/iaas/api/#/en/resourcemanager/20180917/JobOutputSummary/ListJobOutputs").method(Method.GET).requestBuilder(ListJobOutputsRequest::builder).basePath("/20180917").appendPathParam("jobs").appendPathParam(request.getJobId()).appendPathParam("outputs").appendQueryParam("compartmentId", (Object)request.getCompartmentId()).appendQueryParam("limit", (Object)request.getLimit()).appendQueryParam("page", (Object)request.getPage()).accept(new String[]{"application/json"}).appendHeader("opc-request-id", request.getOpcRequestId()).handleBody(JobOutputsCollection.class, ListJobOutputsResponse.Builder::jobOutputsCollection).handleResponseHeaderString("opc-request-id", ListJobOutputsResponse.Builder::opcRequestId).handleResponseHeaderString("opc-next-page", ListJobOutputsResponse.Builder::opcNextPage).operationUsesDefaultRetries().callSync();
    }

    @Override
    public ListJobsResponse listJobs(ListJobsRequest request) {
        return (ListJobsResponse)this.clientCall(request, ListJobsResponse::builder).logger(LOG, "listJobs").serviceDetails("ResourceManager", "ListJobs", "https://docs.oracle.com/iaas/api/#/en/resourcemanager/20180917/JobSummary/ListJobs").method(Method.GET).requestBuilder(ListJobsRequest::builder).basePath("/20180917").appendPathParam("jobs").appendQueryParam("compartmentId", (Object)request.getCompartmentId()).appendQueryParam("stackId", (Object)request.getStackId()).appendQueryParam("id", (Object)request.getId()).appendEnumQueryParam("lifecycleState", (BmcEnum)request.getLifecycleState()).appendQueryParam("displayName", (Object)request.getDisplayName()).appendEnumQueryParam("sortBy", (BmcEnum)request.getSortBy()).appendEnumQueryParam("sortOrder", (BmcEnum)request.getSortOrder()).appendQueryParam("limit", (Object)request.getLimit()).appendQueryParam("page", (Object)request.getPage()).accept(new String[]{"application/json"}).appendHeader("opc-request-id", request.getOpcRequestId()).handleBodyList(JobSummary.class, ListJobsResponse.Builder::items).handleResponseHeaderString("opc-request-id", ListJobsResponse.Builder::opcRequestId).handleResponseHeaderString("opc-next-page", ListJobsResponse.Builder::opcNextPage).operationUsesDefaultRetries().callSync();
    }

    @Override
    public ListPrivateEndpointsResponse listPrivateEndpoints(ListPrivateEndpointsRequest request) {
        return (ListPrivateEndpointsResponse)this.clientCall(request, ListPrivateEndpointsResponse::builder).logger(LOG, "listPrivateEndpoints").serviceDetails("ResourceManager", "ListPrivateEndpoints", "https://docs.oracle.com/iaas/api/#/en/resourcemanager/20180917/PrivateEndpointSummary/ListPrivateEndpoints").method(Method.GET).requestBuilder(ListPrivateEndpointsRequest::builder).basePath("/20180917").appendPathParam("privateEndpoints").appendQueryParam("compartmentId", (Object)request.getCompartmentId()).appendQueryParam("privateEndpointId", (Object)request.getPrivateEndpointId()).appendQueryParam("displayName", (Object)request.getDisplayName()).appendQueryParam("vcnId", (Object)request.getVcnId()).appendEnumQueryParam("sortBy", (BmcEnum)request.getSortBy()).appendEnumQueryParam("sortOrder", (BmcEnum)request.getSortOrder()).appendQueryParam("limit", (Object)request.getLimit()).appendQueryParam("page", (Object)request.getPage()).accept(new String[]{"application/json"}).appendHeader("opc-request-id", request.getOpcRequestId()).handleBody(PrivateEndpointCollection.class, ListPrivateEndpointsResponse.Builder::privateEndpointCollection).handleResponseHeaderString("opc-request-id", ListPrivateEndpointsResponse.Builder::opcRequestId).handleResponseHeaderString("opc-next-page", ListPrivateEndpointsResponse.Builder::opcNextPage).operationUsesDefaultRetries().callSync();
    }

    @Override
    public ListResourceDiscoveryServicesResponse listResourceDiscoveryServices(ListResourceDiscoveryServicesRequest request) {
        return (ListResourceDiscoveryServicesResponse)this.clientCall(request, ListResourceDiscoveryServicesResponse::builder).logger(LOG, "listResourceDiscoveryServices").serviceDetails("ResourceManager", "ListResourceDiscoveryServices", "https://docs.oracle.com/iaas/api/#/en/resourcemanager/20180917/Stack/ListResourceDiscoveryServices").method(Method.GET).requestBuilder(ListResourceDiscoveryServicesRequest::builder).basePath("/20180917").appendPathParam("resourceDiscoveryServices").appendQueryParam("compartmentId", (Object)request.getCompartmentId()).accept(new String[]{"application/json"}).appendHeader("opc-request-id", request.getOpcRequestId()).handleBody(ResourceDiscoveryServiceCollection.class, ListResourceDiscoveryServicesResponse.Builder::resourceDiscoveryServiceCollection).handleResponseHeaderString("opc-request-id", ListResourceDiscoveryServicesResponse.Builder::opcRequestId).operationUsesDefaultRetries().callSync();
    }

    @Override
    public ListStackAssociatedResourcesResponse listStackAssociatedResources(ListStackAssociatedResourcesRequest request) {
        Validate.notBlank((String)request.getStackId(), (String)"stackId must not be blank", (Object[])new Object[0]);
        return (ListStackAssociatedResourcesResponse)this.clientCall(request, ListStackAssociatedResourcesResponse::builder).logger(LOG, "listStackAssociatedResources").serviceDetails("ResourceManager", "ListStackAssociatedResources", "https://docs.oracle.com/iaas/api/#/en/resourcemanager/20180917/AssociatedResourceSummary/ListStackAssociatedResources").method(Method.GET).requestBuilder(ListStackAssociatedResourcesRequest::builder).basePath("/20180917").appendPathParam("stacks").appendPathParam(request.getStackId()).appendPathParam("associatedResources").appendQueryParam("terraformResourceType", (Object)request.getTerraformResourceType()).appendQueryParam("compartmentId", (Object)request.getCompartmentId()).appendQueryParam("limit", (Object)request.getLimit()).appendQueryParam("page", (Object)request.getPage()).accept(new String[]{"application/json"}).appendHeader("opc-request-id", request.getOpcRequestId()).handleBody(AssociatedResourcesCollection.class, ListStackAssociatedResourcesResponse.Builder::associatedResourcesCollection).handleResponseHeaderString("opc-request-id", ListStackAssociatedResourcesResponse.Builder::opcRequestId).handleResponseHeaderString("opc-next-page", ListStackAssociatedResourcesResponse.Builder::opcNextPage).operationUsesDefaultRetries().callSync();
    }

    @Override
    public ListStackResourceDriftDetailsResponse listStackResourceDriftDetails(ListStackResourceDriftDetailsRequest request) {
        Validate.notBlank((String)request.getStackId(), (String)"stackId must not be blank", (Object[])new Object[0]);
        return (ListStackResourceDriftDetailsResponse)this.clientCall(request, ListStackResourceDriftDetailsResponse::builder).logger(LOG, "listStackResourceDriftDetails").serviceDetails("ResourceManager", "ListStackResourceDriftDetails", "https://docs.oracle.com/iaas/api/#/en/resourcemanager/20180917/StackResourceDriftSummary/ListStackResourceDriftDetails").method(Method.POST).requestBuilder(ListStackResourceDriftDetailsRequest::builder).basePath("/20180917").appendPathParam("stacks").appendPathParam(request.getStackId()).appendPathParam("actions").appendPathParam("listResourceDriftDetails").appendQueryParam("workRequestId", (Object)request.getWorkRequestId()).appendListQueryParam("resourceDriftStatus", request.getResourceDriftStatus(), CollectionFormatType.Multi).appendQueryParam("limit", (Object)request.getLimit()).appendQueryParam("page", (Object)request.getPage()).accept(new String[]{"application/json"}).appendHeader("opc-request-id", request.getOpcRequestId()).handleBody(StackResourceDriftCollection.class, ListStackResourceDriftDetailsResponse.Builder::stackResourceDriftCollection).handleResponseHeaderString("opc-request-id", ListStackResourceDriftDetailsResponse.Builder::opcRequestId).handleResponseHeaderString("opc-next-page", ListStackResourceDriftDetailsResponse.Builder::opcNextPage).operationUsesDefaultRetries().callSync();
    }

    @Override
    public ListStacksResponse listStacks(ListStacksRequest request) {
        return (ListStacksResponse)this.clientCall(request, ListStacksResponse::builder).logger(LOG, "listStacks").serviceDetails("ResourceManager", "ListStacks", "https://docs.oracle.com/iaas/api/#/en/resourcemanager/20180917/StackSummary/ListStacks").method(Method.GET).requestBuilder(ListStacksRequest::builder).basePath("/20180917").appendPathParam("stacks").appendQueryParam("compartmentId", (Object)request.getCompartmentId()).appendQueryParam("id", (Object)request.getId()).appendEnumQueryParam("lifecycleState", (BmcEnum)request.getLifecycleState()).appendQueryParam("displayName", (Object)request.getDisplayName()).appendEnumQueryParam("sortBy", (BmcEnum)request.getSortBy()).appendEnumQueryParam("sortOrder", (BmcEnum)request.getSortOrder()).appendQueryParam("limit", (Object)request.getLimit()).appendQueryParam("page", (Object)request.getPage()).accept(new String[]{"application/json"}).appendHeader("opc-request-id", request.getOpcRequestId()).handleBodyList(StackSummary.class, ListStacksResponse.Builder::items).handleResponseHeaderString("opc-request-id", ListStacksResponse.Builder::opcRequestId).handleResponseHeaderString("opc-next-page", ListStacksResponse.Builder::opcNextPage).operationUsesDefaultRetries().callSync();
    }

    @Override
    public ListTemplateCategoriesResponse listTemplateCategories(ListTemplateCategoriesRequest request) {
        return (ListTemplateCategoriesResponse)this.clientCall(request, ListTemplateCategoriesResponse::builder).logger(LOG, "listTemplateCategories").serviceDetails("ResourceManager", "ListTemplateCategories", "https://docs.oracle.com/iaas/api/#/en/resourcemanager/20180917/TemplateCategorySummary/ListTemplateCategories").method(Method.GET).requestBuilder(ListTemplateCategoriesRequest::builder).basePath("/20180917").appendPathParam("templateCategories").accept(new String[]{"application/json"}).appendHeader("opc-request-id", request.getOpcRequestId()).handleBody(TemplateCategorySummaryCollection.class, ListTemplateCategoriesResponse.Builder::templateCategorySummaryCollection).handleResponseHeaderString("opc-request-id", ListTemplateCategoriesResponse.Builder::opcRequestId).operationUsesDefaultRetries().callSync();
    }

    @Override
    public ListTemplatesResponse listTemplates(ListTemplatesRequest request) {
        return (ListTemplatesResponse)this.clientCall(request, ListTemplatesResponse::builder).logger(LOG, "listTemplates").serviceDetails("ResourceManager", "ListTemplates", "https://docs.oracle.com/iaas/api/#/en/resourcemanager/20180917/Template/ListTemplates").method(Method.GET).requestBuilder(ListTemplatesRequest::builder).basePath("/20180917").appendPathParam("templates").appendQueryParam("compartmentId", (Object)request.getCompartmentId()).appendQueryParam("templateCategoryId", (Object)request.getTemplateCategoryId()).appendQueryParam("templateId", (Object)request.getTemplateId()).appendQueryParam("displayName", (Object)request.getDisplayName()).appendEnumQueryParam("sortBy", (BmcEnum)request.getSortBy()).appendEnumQueryParam("sortOrder", (BmcEnum)request.getSortOrder()).appendQueryParam("limit", (Object)request.getLimit()).appendQueryParam("page", (Object)request.getPage()).accept(new String[]{"application/json"}).appendHeader("opc-request-id", request.getOpcRequestId()).handleBody(TemplateSummaryCollection.class, ListTemplatesResponse.Builder::templateSummaryCollection).handleResponseHeaderString("opc-request-id", ListTemplatesResponse.Builder::opcRequestId).handleResponseHeaderString("opc-next-page", ListTemplatesResponse.Builder::opcNextPage).operationUsesDefaultRetries().callSync();
    }

    @Override
    public ListTerraformVersionsResponse listTerraformVersions(ListTerraformVersionsRequest request) {
        return (ListTerraformVersionsResponse)this.clientCall(request, ListTerraformVersionsResponse::builder).logger(LOG, "listTerraformVersions").serviceDetails("ResourceManager", "ListTerraformVersions", "https://docs.oracle.com/iaas/api/#/en/resourcemanager/20180917/Stack/ListTerraformVersions").method(Method.GET).requestBuilder(ListTerraformVersionsRequest::builder).basePath("/20180917").appendPathParam("terraformVersions").appendQueryParam("compartmentId", (Object)request.getCompartmentId()).accept(new String[]{"application/json"}).appendHeader("opc-request-id", request.getOpcRequestId()).handleBody(TerraformVersionCollection.class, ListTerraformVersionsResponse.Builder::terraformVersionCollection).handleResponseHeaderString("opc-request-id", ListTerraformVersionsResponse.Builder::opcRequestId).operationUsesDefaultRetries().callSync();
    }

    @Override
    public ListWorkRequestErrorsResponse listWorkRequestErrors(ListWorkRequestErrorsRequest request) {
        Validate.notBlank((String)request.getWorkRequestId(), (String)"workRequestId must not be blank", (Object[])new Object[0]);
        return (ListWorkRequestErrorsResponse)this.clientCall(request, ListWorkRequestErrorsResponse::builder).logger(LOG, "listWorkRequestErrors").serviceDetails("ResourceManager", "ListWorkRequestErrors", "https://docs.oracle.com/iaas/api/#/en/resourcemanager/20180917/WorkRequest/ListWorkRequestErrors").method(Method.GET).requestBuilder(ListWorkRequestErrorsRequest::builder).basePath("/20180917").appendPathParam("workRequests").appendPathParam(request.getWorkRequestId()).appendPathParam("errors").appendQueryParam("compartmentId", (Object)request.getCompartmentId()).appendQueryParam("limit", (Object)request.getLimit()).appendQueryParam("page", (Object)request.getPage()).appendEnumQueryParam("sortOrder", (BmcEnum)request.getSortOrder()).accept(new String[]{"application/json"}).appendHeader("opc-request-id", request.getOpcRequestId()).handleBodyList(WorkRequestError.class, ListWorkRequestErrorsResponse.Builder::items).handleResponseHeaderString("opc-next-page", ListWorkRequestErrorsResponse.Builder::opcNextPage).handleResponseHeaderString("opc-request-id", ListWorkRequestErrorsResponse.Builder::opcRequestId).operationUsesDefaultRetries().callSync();
    }

    @Override
    public ListWorkRequestLogsResponse listWorkRequestLogs(ListWorkRequestLogsRequest request) {
        Validate.notBlank((String)request.getWorkRequestId(), (String)"workRequestId must not be blank", (Object[])new Object[0]);
        return (ListWorkRequestLogsResponse)this.clientCall(request, ListWorkRequestLogsResponse::builder).logger(LOG, "listWorkRequestLogs").serviceDetails("ResourceManager", "ListWorkRequestLogs", "https://docs.oracle.com/iaas/api/#/en/resourcemanager/20180917/WorkRequest/ListWorkRequestLogs").method(Method.GET).requestBuilder(ListWorkRequestLogsRequest::builder).basePath("/20180917").appendPathParam("workRequests").appendPathParam(request.getWorkRequestId()).appendPathParam("logs").appendQueryParam("compartmentId", (Object)request.getCompartmentId()).appendQueryParam("limit", (Object)request.getLimit()).appendQueryParam("page", (Object)request.getPage()).appendEnumQueryParam("sortOrder", (BmcEnum)request.getSortOrder()).accept(new String[]{"application/json"}).appendHeader("opc-request-id", request.getOpcRequestId()).handleBodyList(WorkRequestLogEntry.class, ListWorkRequestLogsResponse.Builder::items).handleResponseHeaderString("opc-next-page", ListWorkRequestLogsResponse.Builder::opcNextPage).handleResponseHeaderString("opc-request-id", ListWorkRequestLogsResponse.Builder::opcRequestId).operationUsesDefaultRetries().callSync();
    }

    @Override
    public ListWorkRequestsResponse listWorkRequests(ListWorkRequestsRequest request) {
        Objects.requireNonNull(request.getCompartmentId(), "compartmentId is required");
        return (ListWorkRequestsResponse)this.clientCall(request, ListWorkRequestsResponse::builder).logger(LOG, "listWorkRequests").serviceDetails("ResourceManager", "ListWorkRequests", "https://docs.oracle.com/iaas/api/#/en/resourcemanager/20180917/WorkRequest/ListWorkRequests").method(Method.GET).requestBuilder(ListWorkRequestsRequest::builder).basePath("/20180917").appendPathParam("workRequests").appendQueryParam("compartmentId", (Object)request.getCompartmentId()).appendQueryParam("resourceId", (Object)request.getResourceId()).appendQueryParam("limit", (Object)request.getLimit()).appendQueryParam("page", (Object)request.getPage()).accept(new String[]{"application/json"}).appendHeader("opc-request-id", request.getOpcRequestId()).handleBodyList(WorkRequestSummary.class, ListWorkRequestsResponse.Builder::items).handleResponseHeaderString("opc-next-page", ListWorkRequestsResponse.Builder::opcNextPage).handleResponseHeaderString("opc-request-id", ListWorkRequestsResponse.Builder::opcRequestId).operationUsesDefaultRetries().callSync();
    }

    @Override
    public UpdateConfigurationSourceProviderResponse updateConfigurationSourceProvider(UpdateConfigurationSourceProviderRequest request) {
        Validate.notBlank((String)request.getConfigurationSourceProviderId(), (String)"configurationSourceProviderId must not be blank", (Object[])new Object[0]);
        Objects.requireNonNull(request.getUpdateConfigurationSourceProviderDetails(), "updateConfigurationSourceProviderDetails is required");
        return (UpdateConfigurationSourceProviderResponse)this.clientCall(request, UpdateConfigurationSourceProviderResponse::builder).logger(LOG, "updateConfigurationSourceProvider").serviceDetails("ResourceManager", "UpdateConfigurationSourceProvider", "https://docs.oracle.com/iaas/api/#/en/resourcemanager/20180917/ConfigurationSourceProvider/UpdateConfigurationSourceProvider").method(Method.PUT).requestBuilder(UpdateConfigurationSourceProviderRequest::builder).basePath("/20180917").appendPathParam("configurationSourceProviders").appendPathParam(request.getConfigurationSourceProviderId()).accept(new String[]{"application/json"}).appendHeader("opc-request-id", request.getOpcRequestId()).appendHeader("if-match", request.getIfMatch()).hasBody().handleBody(ConfigurationSourceProvider.class, UpdateConfigurationSourceProviderResponse.Builder::configurationSourceProvider).handleResponseHeaderString("opc-request-id", UpdateConfigurationSourceProviderResponse.Builder::opcRequestId).handleResponseHeaderString("etag", UpdateConfigurationSourceProviderResponse.Builder::etag).operationUsesDefaultRetries().callSync();
    }

    @Override
    public UpdateJobResponse updateJob(UpdateJobRequest request) {
        Validate.notBlank((String)request.getJobId(), (String)"jobId must not be blank", (Object[])new Object[0]);
        Objects.requireNonNull(request.getUpdateJobDetails(), "updateJobDetails is required");
        return (UpdateJobResponse)this.clientCall(request, UpdateJobResponse::builder).logger(LOG, "updateJob").serviceDetails("ResourceManager", "UpdateJob", "https://docs.oracle.com/iaas/api/#/en/resourcemanager/20180917/Job/UpdateJob").method(Method.PUT).requestBuilder(UpdateJobRequest::builder).basePath("/20180917").appendPathParam("jobs").appendPathParam(request.getJobId()).accept(new String[]{"application/json"}).appendHeader("opc-request-id", request.getOpcRequestId()).appendHeader("if-match", request.getIfMatch()).hasBody().handleBody(Job.class, UpdateJobResponse.Builder::job).handleResponseHeaderString("opc-request-id", UpdateJobResponse.Builder::opcRequestId).handleResponseHeaderString("etag", UpdateJobResponse.Builder::etag).operationUsesDefaultRetries().callSync();
    }

    @Override
    public UpdatePrivateEndpointResponse updatePrivateEndpoint(UpdatePrivateEndpointRequest request) {
        Validate.notBlank((String)request.getPrivateEndpointId(), (String)"privateEndpointId must not be blank", (Object[])new Object[0]);
        Objects.requireNonNull(request.getUpdatePrivateEndpointDetails(), "updatePrivateEndpointDetails is required");
        return (UpdatePrivateEndpointResponse)this.clientCall(request, UpdatePrivateEndpointResponse::builder).logger(LOG, "updatePrivateEndpoint").serviceDetails("ResourceManager", "UpdatePrivateEndpoint", "https://docs.oracle.com/iaas/api/#/en/resourcemanager/20180917/PrivateEndpoint/UpdatePrivateEndpoint").method(Method.PUT).requestBuilder(UpdatePrivateEndpointRequest::builder).basePath("/20180917").appendPathParam("privateEndpoints").appendPathParam(request.getPrivateEndpointId()).accept(new String[]{"application/json"}).appendHeader("opc-request-id", request.getOpcRequestId()).appendHeader("if-match", request.getIfMatch()).hasBody().handleBody(PrivateEndpoint.class, UpdatePrivateEndpointResponse.Builder::privateEndpoint).handleResponseHeaderString("opc-request-id", UpdatePrivateEndpointResponse.Builder::opcRequestId).handleResponseHeaderString("etag", UpdatePrivateEndpointResponse.Builder::etag).operationUsesDefaultRetries().callSync();
    }

    @Override
    public UpdateStackResponse updateStack(UpdateStackRequest request) {
        Validate.notBlank((String)request.getStackId(), (String)"stackId must not be blank", (Object[])new Object[0]);
        Objects.requireNonNull(request.getUpdateStackDetails(), "updateStackDetails is required");
        return (UpdateStackResponse)this.clientCall(request, UpdateStackResponse::builder).logger(LOG, "updateStack").serviceDetails("ResourceManager", "UpdateStack", "https://docs.oracle.com/iaas/api/#/en/resourcemanager/20180917/Stack/UpdateStack").method(Method.PUT).requestBuilder(UpdateStackRequest::builder).basePath("/20180917").appendPathParam("stacks").appendPathParam(request.getStackId()).accept(new String[]{"application/json"}).appendHeader("opc-request-id", request.getOpcRequestId()).appendHeader("if-match", request.getIfMatch()).hasBody().handleBody(Stack.class, UpdateStackResponse.Builder::stack).handleResponseHeaderString("opc-request-id", UpdateStackResponse.Builder::opcRequestId).handleResponseHeaderString("etag", UpdateStackResponse.Builder::etag).operationUsesDefaultRetries().callSync();
    }

    @Override
    public UpdateTemplateResponse updateTemplate(UpdateTemplateRequest request) {
        Validate.notBlank((String)request.getTemplateId(), (String)"templateId must not be blank", (Object[])new Object[0]);
        Objects.requireNonNull(request.getUpdateTemplateDetails(), "updateTemplateDetails is required");
        return (UpdateTemplateResponse)this.clientCall(request, UpdateTemplateResponse::builder).logger(LOG, "updateTemplate").serviceDetails("ResourceManager", "UpdateTemplate", "https://docs.oracle.com/iaas/api/#/en/resourcemanager/20180917/Template/UpdateTemplate").method(Method.PUT).requestBuilder(UpdateTemplateRequest::builder).basePath("/20180917").appendPathParam("templates").appendPathParam(request.getTemplateId()).accept(new String[]{"application/json"}).appendHeader("opc-request-id", request.getOpcRequestId()).appendHeader("if-match", request.getIfMatch()).hasBody().handleBody(Template.class, UpdateTemplateResponse.Builder::template).handleResponseHeaderString("opc-request-id", UpdateTemplateResponse.Builder::opcRequestId).handleResponseHeaderString("etag", UpdateTemplateResponse.Builder::etag).operationUsesDefaultRetries().callSync();
    }

    @Override
    public ResourceManagerWaiters getWaiters() {
        return this.waiters;
    }

    @Override
    public ResourceManagerPaginators getPaginators() {
        return this.paginators;
    }

    @Deprecated
    public ResourceManagerClient(BasicAuthenticationDetailsProvider authenticationDetailsProvider) {
        this((ClientBuilderBase<?, ?>)ResourceManagerClient.builder(), (AbstractAuthenticationDetailsProvider)authenticationDetailsProvider, null);
    }

    @Deprecated
    public ResourceManagerClient(BasicAuthenticationDetailsProvider authenticationDetailsProvider, ClientConfiguration configuration) {
        this(ResourceManagerClient.builder().configuration(configuration), (AbstractAuthenticationDetailsProvider)authenticationDetailsProvider, null);
    }

    @Deprecated
    public ResourceManagerClient(BasicAuthenticationDetailsProvider authenticationDetailsProvider, ClientConfiguration configuration, ClientConfigurator clientConfigurator) {
        this(((Builder)ResourceManagerClient.builder().configuration(configuration)).clientConfigurator(clientConfigurator), (AbstractAuthenticationDetailsProvider)authenticationDetailsProvider, null);
    }

    @Deprecated
    public ResourceManagerClient(AbstractAuthenticationDetailsProvider authenticationDetailsProvider, ClientConfiguration configuration, ClientConfigurator clientConfigurator, RequestSignerFactory defaultRequestSignerFactory) {
        this(((Builder)((Builder)ResourceManagerClient.builder().configuration(configuration)).clientConfigurator(clientConfigurator)).requestSignerFactory(defaultRequestSignerFactory), authenticationDetailsProvider, null);
    }

    @Deprecated
    public ResourceManagerClient(AbstractAuthenticationDetailsProvider authenticationDetailsProvider, ClientConfiguration configuration, ClientConfigurator clientConfigurator, RequestSignerFactory defaultRequestSignerFactory, List<ClientConfigurator> additionalClientConfigurators) {
        this(((Builder)((Builder)((Builder)ResourceManagerClient.builder().configuration(configuration)).clientConfigurator(clientConfigurator)).requestSignerFactory(defaultRequestSignerFactory)).additionalClientConfigurators(additionalClientConfigurators), authenticationDetailsProvider, null);
    }

    @Deprecated
    public ResourceManagerClient(AbstractAuthenticationDetailsProvider authenticationDetailsProvider, ClientConfiguration configuration, ClientConfigurator clientConfigurator, RequestSignerFactory defaultRequestSignerFactory, List<ClientConfigurator> additionalClientConfigurators, String endpoint) {
        this(((Builder)((Builder)((Builder)((Builder)ResourceManagerClient.builder().configuration(configuration)).clientConfigurator(clientConfigurator)).requestSignerFactory(defaultRequestSignerFactory)).additionalClientConfigurators(additionalClientConfigurators)).endpoint(endpoint), authenticationDetailsProvider, null);
    }

    @Deprecated
    public ResourceManagerClient(AbstractAuthenticationDetailsProvider authenticationDetailsProvider, ClientConfiguration configuration, ClientConfigurator clientConfigurator, RequestSignerFactory defaultRequestSignerFactory, Map<SigningStrategy, RequestSignerFactory> signingStrategyRequestSignerFactories, List<ClientConfigurator> additionalClientConfigurators, String endpoint) {
        this(((Builder)((Builder)((Builder)((Builder)((Builder)ResourceManagerClient.builder().configuration(configuration)).clientConfigurator(clientConfigurator)).requestSignerFactory(defaultRequestSignerFactory)).additionalClientConfigurators(additionalClientConfigurators)).endpoint(endpoint)).signingStrategyRequestSignerFactories(signingStrategyRequestSignerFactories), authenticationDetailsProvider, null);
    }

    @Deprecated
    public ResourceManagerClient(AbstractAuthenticationDetailsProvider authenticationDetailsProvider, ClientConfiguration configuration, ClientConfigurator clientConfigurator, RequestSignerFactory defaultRequestSignerFactory, Map<SigningStrategy, RequestSignerFactory> signingStrategyRequestSignerFactories, List<ClientConfigurator> additionalClientConfigurators, String endpoint, ExecutorService executorService) {
        this(((Builder)((Builder)((Builder)((Builder)((Builder)ResourceManagerClient.builder().configuration(configuration)).clientConfigurator(clientConfigurator)).requestSignerFactory(defaultRequestSignerFactory)).additionalClientConfigurators(additionalClientConfigurators)).endpoint(endpoint)).signingStrategyRequestSignerFactories(signingStrategyRequestSignerFactories), authenticationDetailsProvider, executorService);
    }

    public static class Builder
    extends RegionalClientBuilder<Builder, ResourceManagerClient> {
        private boolean isStreamWarningEnabled = true;
        private ExecutorService executorService;

        private Builder(Service service) {
            super(service);
            String packageName = "resourcemanager";
            Alloy.throwDisabledServiceExceptionIfAppropriate((String)"resourcemanager");
            this.requestSignerFactory = new DefaultRequestSignerFactory(SigningStrategy.STANDARD);
        }

        public Builder executorService(ExecutorService executorService) {
            this.executorService = executorService;
            return this;
        }

        public Builder isStreamWarningEnabled(boolean isStreamWarningEnabled) {
            this.isStreamWarningEnabled = isStreamWarningEnabled;
            return this;
        }

        public ResourceManagerClient build(@Nonnull AbstractAuthenticationDetailsProvider authenticationDetailsProvider) {
            return new ResourceManagerClient((ClientBuilderBase<?, ?>)this, authenticationDetailsProvider, this.executorService, this.isStreamWarningEnabled);
        }
    }
}

