/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.resourcemanager.model;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonFilter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonValue;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonPOJOBuilder;
import com.oracle.bmc.http.client.internal.ExplicitlySetBmcModel;
import com.oracle.bmc.http.internal.BmcEnum;
import java.beans.ConstructorProperties;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@JsonDeserialize(builder=Builder.class)
@JsonFilter(value="explicitlySetFilter")
public final class StackResourceDriftSummary
extends ExplicitlySetBmcModel {
    @JsonProperty(value="stackId")
    private final String stackId;
    @JsonProperty(value="compartmentId")
    private final String compartmentId;
    @JsonProperty(value="resourceName")
    private final String resourceName;
    @JsonProperty(value="resourceId")
    private final String resourceId;
    @JsonProperty(value="resourceType")
    private final String resourceType;
    @JsonProperty(value="resourceDriftStatus")
    private final ResourceDriftStatus resourceDriftStatus;
    @JsonProperty(value="actualProperties")
    private final Map<String, String> actualProperties;
    @JsonProperty(value="expectedProperties")
    private final Map<String, String> expectedProperties;
    @JsonProperty(value="timeDriftChecked")
    private final Date timeDriftChecked;

    @Deprecated
    @ConstructorProperties(value={"stackId", "compartmentId", "resourceName", "resourceId", "resourceType", "resourceDriftStatus", "actualProperties", "expectedProperties", "timeDriftChecked"})
    public StackResourceDriftSummary(String stackId, String compartmentId, String resourceName, String resourceId, String resourceType, ResourceDriftStatus resourceDriftStatus, Map<String, String> actualProperties, Map<String, String> expectedProperties, Date timeDriftChecked) {
        this.stackId = stackId;
        this.compartmentId = compartmentId;
        this.resourceName = resourceName;
        this.resourceId = resourceId;
        this.resourceType = resourceType;
        this.resourceDriftStatus = resourceDriftStatus;
        this.actualProperties = actualProperties;
        this.expectedProperties = expectedProperties;
        this.timeDriftChecked = timeDriftChecked;
    }

    public static Builder builder() {
        return new Builder();
    }

    public Builder toBuilder() {
        return new Builder().copy(this);
    }

    public String getStackId() {
        return this.stackId;
    }

    public String getCompartmentId() {
        return this.compartmentId;
    }

    public String getResourceName() {
        return this.resourceName;
    }

    public String getResourceId() {
        return this.resourceId;
    }

    public String getResourceType() {
        return this.resourceType;
    }

    public ResourceDriftStatus getResourceDriftStatus() {
        return this.resourceDriftStatus;
    }

    public Map<String, String> getActualProperties() {
        return this.actualProperties;
    }

    public Map<String, String> getExpectedProperties() {
        return this.expectedProperties;
    }

    public Date getTimeDriftChecked() {
        return this.timeDriftChecked;
    }

    public String toString() {
        return this.toString(true);
    }

    public String toString(boolean includeByteArrayContents) {
        StringBuilder sb = new StringBuilder();
        sb.append("StackResourceDriftSummary(");
        sb.append("super=").append(super.toString());
        sb.append("stackId=").append(String.valueOf(this.stackId));
        sb.append(", compartmentId=").append(String.valueOf(this.compartmentId));
        sb.append(", resourceName=").append(String.valueOf(this.resourceName));
        sb.append(", resourceId=").append(String.valueOf(this.resourceId));
        sb.append(", resourceType=").append(String.valueOf(this.resourceType));
        sb.append(", resourceDriftStatus=").append(String.valueOf((Object)this.resourceDriftStatus));
        sb.append(", actualProperties=").append(String.valueOf(this.actualProperties));
        sb.append(", expectedProperties=").append(String.valueOf(this.expectedProperties));
        sb.append(", timeDriftChecked=").append(String.valueOf(this.timeDriftChecked));
        sb.append(")");
        return sb.toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof StackResourceDriftSummary)) {
            return false;
        }
        StackResourceDriftSummary other = (StackResourceDriftSummary)((Object)o);
        return Objects.equals(this.stackId, other.stackId) && Objects.equals(this.compartmentId, other.compartmentId) && Objects.equals(this.resourceName, other.resourceName) && Objects.equals(this.resourceId, other.resourceId) && Objects.equals(this.resourceType, other.resourceType) && Objects.equals((Object)this.resourceDriftStatus, (Object)other.resourceDriftStatus) && Objects.equals(this.actualProperties, other.actualProperties) && Objects.equals(this.expectedProperties, other.expectedProperties) && Objects.equals(this.timeDriftChecked, other.timeDriftChecked) && super.equals((Object)other);
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + (this.stackId == null ? 43 : this.stackId.hashCode());
        result = result * 59 + (this.compartmentId == null ? 43 : this.compartmentId.hashCode());
        result = result * 59 + (this.resourceName == null ? 43 : this.resourceName.hashCode());
        result = result * 59 + (this.resourceId == null ? 43 : this.resourceId.hashCode());
        result = result * 59 + (this.resourceType == null ? 43 : this.resourceType.hashCode());
        result = result * 59 + (this.resourceDriftStatus == null ? 43 : this.resourceDriftStatus.hashCode());
        result = result * 59 + (this.actualProperties == null ? 43 : this.actualProperties.hashCode());
        result = result * 59 + (this.expectedProperties == null ? 43 : this.expectedProperties.hashCode());
        result = result * 59 + (this.timeDriftChecked == null ? 43 : this.timeDriftChecked.hashCode());
        result = result * 59 + super.hashCode();
        return result;
    }

    public static enum ResourceDriftStatus implements BmcEnum
    {
        NotChecked("NOT_CHECKED"),
        InSync("IN_SYNC"),
        Modified("MODIFIED"),
        Deleted("DELETED"),
        UnknownEnumValue(null);

        private static final Logger LOG;
        private final String value;
        private static Map<String, ResourceDriftStatus> map;

        private ResourceDriftStatus(String value) {
            this.value = value;
        }

        @JsonValue
        public String getValue() {
            return this.value;
        }

        @JsonCreator
        public static ResourceDriftStatus create(String key) {
            if (map.containsKey(key)) {
                return map.get(key);
            }
            LOG.warn("Received unknown value '{}' for enum 'ResourceDriftStatus', returning UnknownEnumValue", (Object)key);
            return UnknownEnumValue;
        }

        static {
            LOG = LoggerFactory.getLogger(ResourceDriftStatus.class);
            map = new HashMap<String, ResourceDriftStatus>();
            for (ResourceDriftStatus v : ResourceDriftStatus.values()) {
                if (v == UnknownEnumValue) continue;
                map.put(v.getValue(), v);
            }
        }
    }

    @JsonPOJOBuilder(withPrefix="")
    public static class Builder {
        @JsonProperty(value="stackId")
        private String stackId;
        @JsonProperty(value="compartmentId")
        private String compartmentId;
        @JsonProperty(value="resourceName")
        private String resourceName;
        @JsonProperty(value="resourceId")
        private String resourceId;
        @JsonProperty(value="resourceType")
        private String resourceType;
        @JsonProperty(value="resourceDriftStatus")
        private ResourceDriftStatus resourceDriftStatus;
        @JsonProperty(value="actualProperties")
        private Map<String, String> actualProperties;
        @JsonProperty(value="expectedProperties")
        private Map<String, String> expectedProperties;
        @JsonProperty(value="timeDriftChecked")
        private Date timeDriftChecked;
        @JsonIgnore
        private final Set<String> __explicitlySet__ = new HashSet<String>();

        public Builder stackId(String stackId) {
            this.stackId = stackId;
            this.__explicitlySet__.add("stackId");
            return this;
        }

        public Builder compartmentId(String compartmentId) {
            this.compartmentId = compartmentId;
            this.__explicitlySet__.add("compartmentId");
            return this;
        }

        public Builder resourceName(String resourceName) {
            this.resourceName = resourceName;
            this.__explicitlySet__.add("resourceName");
            return this;
        }

        public Builder resourceId(String resourceId) {
            this.resourceId = resourceId;
            this.__explicitlySet__.add("resourceId");
            return this;
        }

        public Builder resourceType(String resourceType) {
            this.resourceType = resourceType;
            this.__explicitlySet__.add("resourceType");
            return this;
        }

        public Builder resourceDriftStatus(ResourceDriftStatus resourceDriftStatus) {
            this.resourceDriftStatus = resourceDriftStatus;
            this.__explicitlySet__.add("resourceDriftStatus");
            return this;
        }

        public Builder actualProperties(Map<String, String> actualProperties) {
            this.actualProperties = actualProperties;
            this.__explicitlySet__.add("actualProperties");
            return this;
        }

        public Builder expectedProperties(Map<String, String> expectedProperties) {
            this.expectedProperties = expectedProperties;
            this.__explicitlySet__.add("expectedProperties");
            return this;
        }

        public Builder timeDriftChecked(Date timeDriftChecked) {
            this.timeDriftChecked = timeDriftChecked;
            this.__explicitlySet__.add("timeDriftChecked");
            return this;
        }

        public StackResourceDriftSummary build() {
            StackResourceDriftSummary model = new StackResourceDriftSummary(this.stackId, this.compartmentId, this.resourceName, this.resourceId, this.resourceType, this.resourceDriftStatus, this.actualProperties, this.expectedProperties, this.timeDriftChecked);
            for (String explicitlySetProperty : this.__explicitlySet__) {
                model.markPropertyAsExplicitlySet(explicitlySetProperty);
            }
            return model;
        }

        @JsonIgnore
        public Builder copy(StackResourceDriftSummary model) {
            if (model.wasPropertyExplicitlySet("stackId")) {
                this.stackId(model.getStackId());
            }
            if (model.wasPropertyExplicitlySet("compartmentId")) {
                this.compartmentId(model.getCompartmentId());
            }
            if (model.wasPropertyExplicitlySet("resourceName")) {
                this.resourceName(model.getResourceName());
            }
            if (model.wasPropertyExplicitlySet("resourceId")) {
                this.resourceId(model.getResourceId());
            }
            if (model.wasPropertyExplicitlySet("resourceType")) {
                this.resourceType(model.getResourceType());
            }
            if (model.wasPropertyExplicitlySet("resourceDriftStatus")) {
                this.resourceDriftStatus(model.getResourceDriftStatus());
            }
            if (model.wasPropertyExplicitlySet("actualProperties")) {
                this.actualProperties(model.getActualProperties());
            }
            if (model.wasPropertyExplicitlySet("expectedProperties")) {
                this.expectedProperties(model.getExpectedProperties());
            }
            if (model.wasPropertyExplicitlySet("timeDriftChecked")) {
                this.timeDriftChecked(model.getTimeDriftChecked());
            }
            return this;
        }
    }
}

