/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.resourcemanager.model;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonFilter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonValue;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonPOJOBuilder;
import com.oracle.bmc.http.client.internal.ExplicitlySetBmcModel;
import com.oracle.bmc.http.internal.BmcEnum;
import java.beans.ConstructorProperties;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@JsonDeserialize(builder=Builder.class)
@JsonFilter(value="explicitlySetFilter")
public final class TerraformAdvancedOptions
extends ExplicitlySetBmcModel {
    @JsonProperty(value="isRefreshRequired")
    private final Boolean isRefreshRequired;
    @JsonProperty(value="parallelism")
    private final Integer parallelism;
    @JsonProperty(value="detailedLogLevel")
    private final DetailedLogLevel detailedLogLevel;

    @Deprecated
    @ConstructorProperties(value={"isRefreshRequired", "parallelism", "detailedLogLevel"})
    public TerraformAdvancedOptions(Boolean isRefreshRequired, Integer parallelism, DetailedLogLevel detailedLogLevel) {
        this.isRefreshRequired = isRefreshRequired;
        this.parallelism = parallelism;
        this.detailedLogLevel = detailedLogLevel;
    }

    public static Builder builder() {
        return new Builder();
    }

    public Builder toBuilder() {
        return new Builder().copy(this);
    }

    public Boolean getIsRefreshRequired() {
        return this.isRefreshRequired;
    }

    public Integer getParallelism() {
        return this.parallelism;
    }

    public DetailedLogLevel getDetailedLogLevel() {
        return this.detailedLogLevel;
    }

    public String toString() {
        return this.toString(true);
    }

    public String toString(boolean includeByteArrayContents) {
        StringBuilder sb = new StringBuilder();
        sb.append("TerraformAdvancedOptions(");
        sb.append("super=").append(super.toString());
        sb.append("isRefreshRequired=").append(String.valueOf(this.isRefreshRequired));
        sb.append(", parallelism=").append(String.valueOf(this.parallelism));
        sb.append(", detailedLogLevel=").append(String.valueOf((Object)this.detailedLogLevel));
        sb.append(")");
        return sb.toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof TerraformAdvancedOptions)) {
            return false;
        }
        TerraformAdvancedOptions other = (TerraformAdvancedOptions)((Object)o);
        return Objects.equals(this.isRefreshRequired, other.isRefreshRequired) && Objects.equals(this.parallelism, other.parallelism) && Objects.equals((Object)this.detailedLogLevel, (Object)other.detailedLogLevel) && super.equals((Object)other);
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + (this.isRefreshRequired == null ? 43 : this.isRefreshRequired.hashCode());
        result = result * 59 + (this.parallelism == null ? 43 : this.parallelism.hashCode());
        result = result * 59 + (this.detailedLogLevel == null ? 43 : this.detailedLogLevel.hashCode());
        result = result * 59 + super.hashCode();
        return result;
    }

    public static enum DetailedLogLevel implements BmcEnum
    {
        Error("ERROR"),
        Warn("WARN"),
        Info("INFO"),
        Debug("DEBUG"),
        Trace("TRACE"),
        UnknownEnumValue(null);

        private static final Logger LOG;
        private final String value;
        private static Map<String, DetailedLogLevel> map;

        private DetailedLogLevel(String value) {
            this.value = value;
        }

        @JsonValue
        public String getValue() {
            return this.value;
        }

        @JsonCreator
        public static DetailedLogLevel create(String key) {
            if (map.containsKey(key)) {
                return map.get(key);
            }
            LOG.warn("Received unknown value '{}' for enum 'DetailedLogLevel', returning UnknownEnumValue", (Object)key);
            return UnknownEnumValue;
        }

        static {
            LOG = LoggerFactory.getLogger(DetailedLogLevel.class);
            map = new HashMap<String, DetailedLogLevel>();
            for (DetailedLogLevel v : DetailedLogLevel.values()) {
                if (v == UnknownEnumValue) continue;
                map.put(v.getValue(), v);
            }
        }
    }

    @JsonPOJOBuilder(withPrefix="")
    public static class Builder {
        @JsonProperty(value="isRefreshRequired")
        private Boolean isRefreshRequired;
        @JsonProperty(value="parallelism")
        private Integer parallelism;
        @JsonProperty(value="detailedLogLevel")
        private DetailedLogLevel detailedLogLevel;
        @JsonIgnore
        private final Set<String> __explicitlySet__ = new HashSet<String>();

        public Builder isRefreshRequired(Boolean isRefreshRequired) {
            this.isRefreshRequired = isRefreshRequired;
            this.__explicitlySet__.add("isRefreshRequired");
            return this;
        }

        public Builder parallelism(Integer parallelism) {
            this.parallelism = parallelism;
            this.__explicitlySet__.add("parallelism");
            return this;
        }

        public Builder detailedLogLevel(DetailedLogLevel detailedLogLevel) {
            this.detailedLogLevel = detailedLogLevel;
            this.__explicitlySet__.add("detailedLogLevel");
            return this;
        }

        public TerraformAdvancedOptions build() {
            TerraformAdvancedOptions model = new TerraformAdvancedOptions(this.isRefreshRequired, this.parallelism, this.detailedLogLevel);
            for (String explicitlySetProperty : this.__explicitlySet__) {
                model.markPropertyAsExplicitlySet(explicitlySetProperty);
            }
            return model;
        }

        @JsonIgnore
        public Builder copy(TerraformAdvancedOptions model) {
            if (model.wasPropertyExplicitlySet("isRefreshRequired")) {
                this.isRefreshRequired(model.getIsRefreshRequired());
            }
            if (model.wasPropertyExplicitlySet("parallelism")) {
                this.parallelism(model.getParallelism());
            }
            if (model.wasPropertyExplicitlySet("detailedLogLevel")) {
                this.detailedLogLevel(model.getDetailedLogLevel());
            }
            return this;
        }
    }
}

