/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.resourcemanager.requests;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonValue;
import com.oracle.bmc.http.client.RequestInterceptor;
import com.oracle.bmc.http.internal.BmcEnum;
import com.oracle.bmc.requests.BmcRequest;
import com.oracle.bmc.retrier.RetryConfiguration;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;

public class GetJobTfPlanRequest
extends BmcRequest<Void> {
    private String jobId;
    private String opcRequestId;
    private TfPlanFormat tfPlanFormat;

    public String getJobId() {
        return this.jobId;
    }

    public String getOpcRequestId() {
        return this.opcRequestId;
    }

    public TfPlanFormat getTfPlanFormat() {
        return this.tfPlanFormat;
    }

    public Builder toBuilder() {
        return new Builder().jobId(this.jobId).opcRequestId(this.opcRequestId).tfPlanFormat(this.tfPlanFormat);
    }

    public static Builder builder() {
        return new Builder();
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("(");
        sb.append("super=").append(super.toString());
        sb.append(",jobId=").append(String.valueOf(this.jobId));
        sb.append(",opcRequestId=").append(String.valueOf(this.opcRequestId));
        sb.append(",tfPlanFormat=").append(String.valueOf((Object)this.tfPlanFormat));
        sb.append(")");
        return sb.toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof GetJobTfPlanRequest)) {
            return false;
        }
        GetJobTfPlanRequest other = (GetJobTfPlanRequest)((Object)o);
        return super.equals(o) && Objects.equals(this.jobId, other.jobId) && Objects.equals(this.opcRequestId, other.opcRequestId) && Objects.equals((Object)this.tfPlanFormat, (Object)other.tfPlanFormat);
    }

    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        result = result * 59 + (this.jobId == null ? 43 : this.jobId.hashCode());
        result = result * 59 + (this.opcRequestId == null ? 43 : this.opcRequestId.hashCode());
        result = result * 59 + (this.tfPlanFormat == null ? 43 : this.tfPlanFormat.hashCode());
        return result;
    }

    public static class Builder
    implements BmcRequest.Builder<GetJobTfPlanRequest, Void> {
        private RequestInterceptor invocationCallback = null;
        private RetryConfiguration retryConfiguration = null;
        private String jobId = null;
        private String opcRequestId = null;
        private TfPlanFormat tfPlanFormat = null;

        public Builder jobId(String jobId) {
            this.jobId = jobId;
            return this;
        }

        public Builder opcRequestId(String opcRequestId) {
            this.opcRequestId = opcRequestId;
            return this;
        }

        public Builder tfPlanFormat(TfPlanFormat tfPlanFormat) {
            this.tfPlanFormat = tfPlanFormat;
            return this;
        }

        public Builder invocationCallback(RequestInterceptor invocationCallback) {
            this.invocationCallback = invocationCallback;
            return this;
        }

        public Builder retryConfiguration(RetryConfiguration retryConfiguration) {
            this.retryConfiguration = retryConfiguration;
            return this;
        }

        public Builder copy(GetJobTfPlanRequest o) {
            this.jobId(o.getJobId());
            this.opcRequestId(o.getOpcRequestId());
            this.tfPlanFormat(o.getTfPlanFormat());
            this.invocationCallback(o.getInvocationCallback());
            this.retryConfiguration(o.getRetryConfiguration());
            return this;
        }

        public GetJobTfPlanRequest build() {
            GetJobTfPlanRequest request = this.buildWithoutInvocationCallback();
            request.setInvocationCallback(this.invocationCallback);
            request.setRetryConfiguration(this.retryConfiguration);
            return request;
        }

        public GetJobTfPlanRequest buildWithoutInvocationCallback() {
            GetJobTfPlanRequest request = new GetJobTfPlanRequest();
            request.jobId = this.jobId;
            request.opcRequestId = this.opcRequestId;
            request.tfPlanFormat = this.tfPlanFormat;
            return request;
        }
    }

    public static enum TfPlanFormat implements BmcEnum
    {
        Binary("BINARY"),
        Json("JSON");

        private final String value;
        private static Map<String, TfPlanFormat> map;

        private TfPlanFormat(String value) {
            this.value = value;
        }

        @JsonValue
        public String getValue() {
            return this.value;
        }

        @JsonCreator
        public static TfPlanFormat create(String key) {
            if (map.containsKey(key)) {
                return map.get(key);
            }
            throw new IllegalArgumentException("Invalid TfPlanFormat: " + key);
        }

        static {
            map = new HashMap<String, TfPlanFormat>();
            for (TfPlanFormat v : TfPlanFormat.values()) {
                map.put(v.getValue(), v);
            }
        }
    }
}

