/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.resourcemanager.model;

import com.fasterxml.jackson.annotation.JsonFilter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonTypeInfo;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonPOJOBuilder;
import com.oracle.bmc.resourcemanager.model.ConfigSource;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import java.util.Set;

@JsonDeserialize(builder=Builder.class)
@JsonTypeInfo(use=JsonTypeInfo.Id.NAME, include=JsonTypeInfo.As.PROPERTY, property="configSourceType")
@JsonFilter(value="explicitlySetFilter")
public final class CompartmentConfigSource
extends ConfigSource {
    @JsonProperty(value="compartmentId")
    private final String compartmentId;
    @JsonProperty(value="region")
    private final String region;
    @JsonProperty(value="servicesToDiscover")
    private final List<String> servicesToDiscover;

    public static Builder builder() {
        return new Builder();
    }

    public Builder toBuilder() {
        return new Builder().copy(this);
    }

    @Deprecated
    public CompartmentConfigSource(String workingDirectory, String compartmentId, String region, List<String> servicesToDiscover) {
        super(workingDirectory);
        this.compartmentId = compartmentId;
        this.region = region;
        this.servicesToDiscover = servicesToDiscover;
    }

    public String getCompartmentId() {
        return this.compartmentId;
    }

    public String getRegion() {
        return this.region;
    }

    public List<String> getServicesToDiscover() {
        return this.servicesToDiscover;
    }

    @Override
    public String toString() {
        return this.toString(true);
    }

    @Override
    public String toString(boolean includeByteArrayContents) {
        StringBuilder sb = new StringBuilder();
        sb.append("CompartmentConfigSource(");
        sb.append("super=").append(super.toString(includeByteArrayContents));
        sb.append(", compartmentId=").append(String.valueOf(this.compartmentId));
        sb.append(", region=").append(String.valueOf(this.region));
        sb.append(", servicesToDiscover=").append(String.valueOf(this.servicesToDiscover));
        sb.append(")");
        return sb.toString();
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof CompartmentConfigSource)) {
            return false;
        }
        CompartmentConfigSource other = (CompartmentConfigSource)((Object)o);
        return Objects.equals(this.compartmentId, other.compartmentId) && Objects.equals(this.region, other.region) && Objects.equals(this.servicesToDiscover, other.servicesToDiscover) && super.equals((Object)other);
    }

    @Override
    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        result = result * 59 + (this.compartmentId == null ? 43 : this.compartmentId.hashCode());
        result = result * 59 + (this.region == null ? 43 : this.region.hashCode());
        result = result * 59 + (this.servicesToDiscover == null ? 43 : this.servicesToDiscover.hashCode());
        return result;
    }

    @JsonPOJOBuilder(withPrefix="")
    public static class Builder {
        @JsonProperty(value="workingDirectory")
        private String workingDirectory;
        @JsonProperty(value="compartmentId")
        private String compartmentId;
        @JsonProperty(value="region")
        private String region;
        @JsonProperty(value="servicesToDiscover")
        private List<String> servicesToDiscover;
        @JsonIgnore
        private final Set<String> __explicitlySet__ = new HashSet<String>();

        public Builder workingDirectory(String workingDirectory) {
            this.workingDirectory = workingDirectory;
            this.__explicitlySet__.add("workingDirectory");
            return this;
        }

        public Builder compartmentId(String compartmentId) {
            this.compartmentId = compartmentId;
            this.__explicitlySet__.add("compartmentId");
            return this;
        }

        public Builder region(String region) {
            this.region = region;
            this.__explicitlySet__.add("region");
            return this;
        }

        public Builder servicesToDiscover(List<String> servicesToDiscover) {
            this.servicesToDiscover = servicesToDiscover;
            this.__explicitlySet__.add("servicesToDiscover");
            return this;
        }

        public CompartmentConfigSource build() {
            CompartmentConfigSource model = new CompartmentConfigSource(this.workingDirectory, this.compartmentId, this.region, this.servicesToDiscover);
            for (String explicitlySetProperty : this.__explicitlySet__) {
                model.markPropertyAsExplicitlySet(explicitlySetProperty);
            }
            return model;
        }

        @JsonIgnore
        public Builder copy(CompartmentConfigSource model) {
            if (model.wasPropertyExplicitlySet("workingDirectory")) {
                this.workingDirectory(model.getWorkingDirectory());
            }
            if (model.wasPropertyExplicitlySet("compartmentId")) {
                this.compartmentId(model.getCompartmentId());
            }
            if (model.wasPropertyExplicitlySet("region")) {
                this.region(model.getRegion());
            }
            if (model.wasPropertyExplicitlySet("servicesToDiscover")) {
                this.servicesToDiscover(model.getServicesToDiscover());
            }
            return this;
        }
    }
}

