/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.resourcemanager.requests;

import com.oracle.bmc.http.client.RequestInterceptor;
import com.oracle.bmc.requests.BmcRequest;
import com.oracle.bmc.resourcemanager.model.StackResourceDriftSummary;
import com.oracle.bmc.retrier.RetryConfiguration;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;

public class ListStackResourceDriftDetailsRequest
extends BmcRequest<Void> {
    private String stackId;
    private String opcRequestId;
    private String workRequestId;
    private List<StackResourceDriftSummary.ResourceDriftStatus> resourceDriftStatus;
    private Integer limit;
    private String page;

    public String getStackId() {
        return this.stackId;
    }

    public String getOpcRequestId() {
        return this.opcRequestId;
    }

    public String getWorkRequestId() {
        return this.workRequestId;
    }

    public List<StackResourceDriftSummary.ResourceDriftStatus> getResourceDriftStatus() {
        return this.resourceDriftStatus;
    }

    public Integer getLimit() {
        return this.limit;
    }

    public String getPage() {
        return this.page;
    }

    public Builder toBuilder() {
        return new Builder().stackId(this.stackId).opcRequestId(this.opcRequestId).workRequestId(this.workRequestId).resourceDriftStatus(this.resourceDriftStatus).limit(this.limit).page(this.page);
    }

    public static Builder builder() {
        return new Builder();
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("(");
        sb.append("super=").append(super.toString());
        sb.append(",stackId=").append(String.valueOf(this.stackId));
        sb.append(",opcRequestId=").append(String.valueOf(this.opcRequestId));
        sb.append(",workRequestId=").append(String.valueOf(this.workRequestId));
        sb.append(",resourceDriftStatus=").append(String.valueOf(this.resourceDriftStatus));
        sb.append(",limit=").append(String.valueOf(this.limit));
        sb.append(",page=").append(String.valueOf(this.page));
        sb.append(")");
        return sb.toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof ListStackResourceDriftDetailsRequest)) {
            return false;
        }
        ListStackResourceDriftDetailsRequest other = (ListStackResourceDriftDetailsRequest)((Object)o);
        return super.equals(o) && Objects.equals(this.stackId, other.stackId) && Objects.equals(this.opcRequestId, other.opcRequestId) && Objects.equals(this.workRequestId, other.workRequestId) && Objects.equals(this.resourceDriftStatus, other.resourceDriftStatus) && Objects.equals(this.limit, other.limit) && Objects.equals(this.page, other.page);
    }

    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        result = result * 59 + (this.stackId == null ? 43 : this.stackId.hashCode());
        result = result * 59 + (this.opcRequestId == null ? 43 : this.opcRequestId.hashCode());
        result = result * 59 + (this.workRequestId == null ? 43 : this.workRequestId.hashCode());
        result = result * 59 + (this.resourceDriftStatus == null ? 43 : this.resourceDriftStatus.hashCode());
        result = result * 59 + (this.limit == null ? 43 : this.limit.hashCode());
        result = result * 59 + (this.page == null ? 43 : this.page.hashCode());
        return result;
    }

    public static class Builder
    implements BmcRequest.Builder<ListStackResourceDriftDetailsRequest, Void> {
        private RequestInterceptor invocationCallback = null;
        private RetryConfiguration retryConfiguration = null;
        private String stackId = null;
        private String opcRequestId = null;
        private String workRequestId = null;
        private List<StackResourceDriftSummary.ResourceDriftStatus> resourceDriftStatus = null;
        private Integer limit = null;
        private String page = null;

        public Builder stackId(String stackId) {
            this.stackId = stackId;
            return this;
        }

        public Builder opcRequestId(String opcRequestId) {
            this.opcRequestId = opcRequestId;
            return this;
        }

        public Builder workRequestId(String workRequestId) {
            this.workRequestId = workRequestId;
            return this;
        }

        public Builder resourceDriftStatus(List<StackResourceDriftSummary.ResourceDriftStatus> resourceDriftStatus) {
            this.resourceDriftStatus = resourceDriftStatus;
            return this;
        }

        public Builder resourceDriftStatus(StackResourceDriftSummary.ResourceDriftStatus singularValue) {
            return this.resourceDriftStatus(Arrays.asList(singularValue));
        }

        public Builder limit(Integer limit) {
            this.limit = limit;
            return this;
        }

        public Builder page(String page) {
            this.page = page;
            return this;
        }

        public Builder invocationCallback(RequestInterceptor invocationCallback) {
            this.invocationCallback = invocationCallback;
            return this;
        }

        public Builder retryConfiguration(RetryConfiguration retryConfiguration) {
            this.retryConfiguration = retryConfiguration;
            return this;
        }

        public Builder copy(ListStackResourceDriftDetailsRequest o) {
            this.stackId(o.getStackId());
            this.opcRequestId(o.getOpcRequestId());
            this.workRequestId(o.getWorkRequestId());
            this.resourceDriftStatus(o.getResourceDriftStatus());
            this.limit(o.getLimit());
            this.page(o.getPage());
            this.invocationCallback(o.getInvocationCallback());
            this.retryConfiguration(o.getRetryConfiguration());
            return this;
        }

        public ListStackResourceDriftDetailsRequest build() {
            ListStackResourceDriftDetailsRequest request = this.buildWithoutInvocationCallback();
            request.setInvocationCallback(this.invocationCallback);
            request.setRetryConfiguration(this.retryConfiguration);
            return request;
        }

        public ListStackResourceDriftDetailsRequest buildWithoutInvocationCallback() {
            ListStackResourceDriftDetailsRequest request = new ListStackResourceDriftDetailsRequest();
            request.stackId = this.stackId;
            request.opcRequestId = this.opcRequestId;
            request.workRequestId = this.workRequestId;
            request.resourceDriftStatus = this.resourceDriftStatus;
            request.limit = this.limit;
            request.page = this.page;
            return request;
        }
    }
}

