/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.resourcescheduler;

import com.oracle.bmc.ClientConfiguration;
import com.oracle.bmc.Region;
import com.oracle.bmc.Service;
import com.oracle.bmc.Services;
import com.oracle.bmc.auth.AbstractAuthenticationDetailsProvider;
import com.oracle.bmc.auth.BasicAuthenticationDetailsProvider;
import com.oracle.bmc.common.ClientBuilderBase;
import com.oracle.bmc.common.RegionalClientBuilder;
import com.oracle.bmc.http.ClientConfigurator;
import com.oracle.bmc.http.client.Method;
import com.oracle.bmc.http.internal.BaseSyncClient;
import com.oracle.bmc.http.internal.BmcEnum;
import com.oracle.bmc.http.signing.RequestSignerFactory;
import com.oracle.bmc.http.signing.SigningStrategy;
import com.oracle.bmc.http.signing.internal.DefaultRequestSignerFactory;
import com.oracle.bmc.internal.Alloy;
import com.oracle.bmc.internal.ClientThreadFactory;
import com.oracle.bmc.resourcescheduler.Schedule;
import com.oracle.bmc.resourcescheduler.SchedulePaginators;
import com.oracle.bmc.resourcescheduler.ScheduleWaiters;
import com.oracle.bmc.resourcescheduler.model.ResourceTypeCollection;
import com.oracle.bmc.resourcescheduler.model.ScheduleCollection;
import com.oracle.bmc.resourcescheduler.model.WorkRequest;
import com.oracle.bmc.resourcescheduler.model.WorkRequestErrorCollection;
import com.oracle.bmc.resourcescheduler.model.WorkRequestLogEntryCollection;
import com.oracle.bmc.resourcescheduler.model.WorkRequestSummaryCollection;
import com.oracle.bmc.resourcescheduler.requests.ActivateScheduleRequest;
import com.oracle.bmc.resourcescheduler.requests.CancelWorkRequestRequest;
import com.oracle.bmc.resourcescheduler.requests.CreateScheduleRequest;
import com.oracle.bmc.resourcescheduler.requests.DeactivateScheduleRequest;
import com.oracle.bmc.resourcescheduler.requests.DeleteScheduleRequest;
import com.oracle.bmc.resourcescheduler.requests.GetScheduleRequest;
import com.oracle.bmc.resourcescheduler.requests.GetWorkRequestRequest;
import com.oracle.bmc.resourcescheduler.requests.ListResourceTypesRequest;
import com.oracle.bmc.resourcescheduler.requests.ListSchedulesRequest;
import com.oracle.bmc.resourcescheduler.requests.ListWorkRequestErrorsRequest;
import com.oracle.bmc.resourcescheduler.requests.ListWorkRequestLogsRequest;
import com.oracle.bmc.resourcescheduler.requests.ListWorkRequestsRequest;
import com.oracle.bmc.resourcescheduler.requests.UpdateScheduleRequest;
import com.oracle.bmc.resourcescheduler.responses.ActivateScheduleResponse;
import com.oracle.bmc.resourcescheduler.responses.CancelWorkRequestResponse;
import com.oracle.bmc.resourcescheduler.responses.CreateScheduleResponse;
import com.oracle.bmc.resourcescheduler.responses.DeactivateScheduleResponse;
import com.oracle.bmc.resourcescheduler.responses.DeleteScheduleResponse;
import com.oracle.bmc.resourcescheduler.responses.GetScheduleResponse;
import com.oracle.bmc.resourcescheduler.responses.GetWorkRequestResponse;
import com.oracle.bmc.resourcescheduler.responses.ListResourceTypesResponse;
import com.oracle.bmc.resourcescheduler.responses.ListSchedulesResponse;
import com.oracle.bmc.resourcescheduler.responses.ListWorkRequestErrorsResponse;
import com.oracle.bmc.resourcescheduler.responses.ListWorkRequestLogsResponse;
import com.oracle.bmc.resourcescheduler.responses.ListWorkRequestsResponse;
import com.oracle.bmc.resourcescheduler.responses.UpdateScheduleResponse;
import com.oracle.bmc.util.CircuitBreakerUtils;
import com.oracle.bmc.util.internal.Validate;
import jakarta.annotation.Nonnull;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ScheduleClient
extends BaseSyncClient
implements Schedule {
    public static final Service SERVICE = Services.serviceBuilder().serviceName("SCHEDULE").serviceEndpointPrefix("").serviceEndpointTemplate("https://resource-scheduler.{region}.oci.{secondLevelDomain}").build();
    private static final Logger LOG = LoggerFactory.getLogger(ScheduleClient.class);
    private final ScheduleWaiters waiters;
    private final SchedulePaginators paginators;

    ScheduleClient(ClientBuilderBase<?, ?> builder, AbstractAuthenticationDetailsProvider authenticationDetailsProvider, ExecutorService executorService) {
        super(builder, authenticationDetailsProvider, CircuitBreakerUtils.DEFAULT_CIRCUIT_BREAKER_CONFIGURATION);
        if (executorService == null) {
            ThreadPoolExecutor threadPoolExecutor = new ThreadPoolExecutor(50, 50, 60L, TimeUnit.SECONDS, new LinkedBlockingQueue<Runnable>(), (ThreadFactory)ClientThreadFactory.builder().isDaemon(true).nameFormat("Schedule-waiters-%d").build());
            threadPoolExecutor.allowCoreThreadTimeOut(true);
            executorService = threadPoolExecutor;
        }
        this.waiters = new ScheduleWaiters(executorService, this);
        this.paginators = new SchedulePaginators(this);
    }

    public static Builder builder() {
        return new Builder(SERVICE);
    }

    @Override
    public void setRegion(Region region) {
        super.setRegion(region);
    }

    @Override
    public void setRegion(String regionId) {
        super.setRegion(regionId);
    }

    @Override
    public ActivateScheduleResponse activateSchedule(ActivateScheduleRequest request) {
        Validate.notBlank((String)request.getScheduleId(), (String)"scheduleId must not be blank", (Object[])new Object[0]);
        return (ActivateScheduleResponse)this.clientCall(request, ActivateScheduleResponse::builder).logger(LOG, "activateSchedule").serviceDetails("Schedule", "ActivateSchedule", "https://docs.oracle.com/iaas/api/#/en/resource-scheduler/20240430/Schedule/ActivateSchedule").method(Method.POST).requestBuilder(ActivateScheduleRequest::builder).basePath("/20240430").appendPathParam("schedules").appendPathParam(request.getScheduleId()).appendPathParam("actions").appendPathParam("activateSchedule").accept(new String[]{"application/json"}).appendHeader("if-match", request.getIfMatch()).appendHeader("opc-request-id", request.getOpcRequestId()).appendHeader("opc-retry-token", request.getOpcRetryToken()).operationUsesDefaultRetries().handleBody(com.oracle.bmc.resourcescheduler.model.Schedule.class, ActivateScheduleResponse.Builder::schedule).handleResponseHeaderString("opc-request-id", ActivateScheduleResponse.Builder::opcRequestId).handleResponseHeaderString("etag", ActivateScheduleResponse.Builder::etag).callSync();
    }

    @Override
    public CancelWorkRequestResponse cancelWorkRequest(CancelWorkRequestRequest request) {
        Validate.notBlank((String)request.getWorkRequestId(), (String)"workRequestId must not be blank", (Object[])new Object[0]);
        return (CancelWorkRequestResponse)this.clientCall(request, CancelWorkRequestResponse::builder).logger(LOG, "cancelWorkRequest").serviceDetails("Schedule", "CancelWorkRequest", "https://docs.oracle.com/iaas/api/#/en/resource-scheduler/20240430/WorkRequest/CancelWorkRequest").method(Method.DELETE).requestBuilder(CancelWorkRequestRequest::builder).basePath("/20240430").appendPathParam("workRequests").appendPathParam(request.getWorkRequestId()).accept(new String[]{"application/json"}).appendHeader("if-match", request.getIfMatch()).appendHeader("opc-request-id", request.getOpcRequestId()).operationUsesDefaultRetries().handleResponseHeaderString("opc-request-id", CancelWorkRequestResponse.Builder::opcRequestId).callSync();
    }

    @Override
    public CreateScheduleResponse createSchedule(CreateScheduleRequest request) {
        Objects.requireNonNull(request.getCreateScheduleDetails(), "createScheduleDetails is required");
        return (CreateScheduleResponse)this.clientCall(request, CreateScheduleResponse::builder).logger(LOG, "createSchedule").serviceDetails("Schedule", "CreateSchedule", "https://docs.oracle.com/iaas/api/#/en/resource-scheduler/20240430/Schedule/CreateSchedule").method(Method.POST).requestBuilder(CreateScheduleRequest::builder).basePath("/20240430").appendPathParam("schedules").accept(new String[]{"application/json"}).appendHeader("opc-retry-token", request.getOpcRetryToken()).appendHeader("opc-request-id", request.getOpcRequestId()).operationUsesDefaultRetries().hasBody().handleBody(com.oracle.bmc.resourcescheduler.model.Schedule.class, CreateScheduleResponse.Builder::schedule).handleResponseHeaderString("location", CreateScheduleResponse.Builder::location).handleResponseHeaderString("content-location", CreateScheduleResponse.Builder::contentLocation).handleResponseHeaderString("etag", CreateScheduleResponse.Builder::etag).handleResponseHeaderString("opc-work-request-id", CreateScheduleResponse.Builder::opcWorkRequestId).handleResponseHeaderString("opc-request-id", CreateScheduleResponse.Builder::opcRequestId).callSync();
    }

    @Override
    public DeactivateScheduleResponse deactivateSchedule(DeactivateScheduleRequest request) {
        Validate.notBlank((String)request.getScheduleId(), (String)"scheduleId must not be blank", (Object[])new Object[0]);
        return (DeactivateScheduleResponse)this.clientCall(request, DeactivateScheduleResponse::builder).logger(LOG, "deactivateSchedule").serviceDetails("Schedule", "DeactivateSchedule", "https://docs.oracle.com/iaas/api/#/en/resource-scheduler/20240430/Schedule/DeactivateSchedule").method(Method.POST).requestBuilder(DeactivateScheduleRequest::builder).basePath("/20240430").appendPathParam("schedules").appendPathParam(request.getScheduleId()).appendPathParam("actions").appendPathParam("deactivateSchedule").accept(new String[]{"application/json"}).appendHeader("if-match", request.getIfMatch()).appendHeader("opc-request-id", request.getOpcRequestId()).appendHeader("opc-retry-token", request.getOpcRetryToken()).operationUsesDefaultRetries().handleBody(com.oracle.bmc.resourcescheduler.model.Schedule.class, DeactivateScheduleResponse.Builder::schedule).handleResponseHeaderString("opc-request-id", DeactivateScheduleResponse.Builder::opcRequestId).handleResponseHeaderString("etag", DeactivateScheduleResponse.Builder::etag).callSync();
    }

    @Override
    public DeleteScheduleResponse deleteSchedule(DeleteScheduleRequest request) {
        Validate.notBlank((String)request.getScheduleId(), (String)"scheduleId must not be blank", (Object[])new Object[0]);
        return (DeleteScheduleResponse)this.clientCall(request, DeleteScheduleResponse::builder).logger(LOG, "deleteSchedule").serviceDetails("Schedule", "DeleteSchedule", "https://docs.oracle.com/iaas/api/#/en/resource-scheduler/20240430/Schedule/DeleteSchedule").method(Method.DELETE).requestBuilder(DeleteScheduleRequest::builder).basePath("/20240430").appendPathParam("schedules").appendPathParam(request.getScheduleId()).accept(new String[]{"application/json"}).appendHeader("if-match", request.getIfMatch()).appendHeader("opc-request-id", request.getOpcRequestId()).operationUsesDefaultRetries().handleResponseHeaderString("opc-request-id", DeleteScheduleResponse.Builder::opcRequestId).callSync();
    }

    @Override
    public GetScheduleResponse getSchedule(GetScheduleRequest request) {
        Validate.notBlank((String)request.getScheduleId(), (String)"scheduleId must not be blank", (Object[])new Object[0]);
        return (GetScheduleResponse)this.clientCall(request, GetScheduleResponse::builder).logger(LOG, "getSchedule").serviceDetails("Schedule", "GetSchedule", "https://docs.oracle.com/iaas/api/#/en/resource-scheduler/20240430/Schedule/GetSchedule").method(Method.GET).requestBuilder(GetScheduleRequest::builder).basePath("/20240430").appendPathParam("schedules").appendPathParam(request.getScheduleId()).accept(new String[]{"application/json"}).appendHeader("opc-request-id", request.getOpcRequestId()).operationUsesDefaultRetries().handleBody(com.oracle.bmc.resourcescheduler.model.Schedule.class, GetScheduleResponse.Builder::schedule).handleResponseHeaderString("etag", GetScheduleResponse.Builder::etag).handleResponseHeaderString("opc-request-id", GetScheduleResponse.Builder::opcRequestId).callSync();
    }

    @Override
    public GetWorkRequestResponse getWorkRequest(GetWorkRequestRequest request) {
        Validate.notBlank((String)request.getWorkRequestId(), (String)"workRequestId must not be blank", (Object[])new Object[0]);
        return (GetWorkRequestResponse)this.clientCall(request, GetWorkRequestResponse::builder).logger(LOG, "getWorkRequest").serviceDetails("Schedule", "GetWorkRequest", "https://docs.oracle.com/iaas/api/#/en/resource-scheduler/20240430/WorkRequest/GetWorkRequest").method(Method.GET).requestBuilder(GetWorkRequestRequest::builder).basePath("/20240430").appendPathParam("workRequests").appendPathParam(request.getWorkRequestId()).accept(new String[]{"application/json"}).appendHeader("opc-request-id", request.getOpcRequestId()).operationUsesDefaultRetries().handleBody(WorkRequest.class, GetWorkRequestResponse.Builder::workRequest).handleResponseHeaderString("etag", GetWorkRequestResponse.Builder::etag).handleResponseHeaderString("opc-request-id", GetWorkRequestResponse.Builder::opcRequestId).handleResponseHeaderInteger("retry-after", GetWorkRequestResponse.Builder::retryAfter).callSync();
    }

    @Override
    public ListResourceTypesResponse listResourceTypes(ListResourceTypesRequest request) {
        return (ListResourceTypesResponse)this.clientCall(request, ListResourceTypesResponse::builder).logger(LOG, "listResourceTypes").serviceDetails("Schedule", "ListResourceTypes", "https://docs.oracle.com/iaas/api/#/en/resource-scheduler/20240430/ResourceTypeCollection/ListResourceTypes").method(Method.GET).requestBuilder(ListResourceTypesRequest::builder).basePath("/20240430").appendPathParam("schedules").appendPathParam("resourceTypes").appendQueryParam("compartmentId", (Object)request.getCompartmentId()).appendQueryParam("limit", (Object)request.getLimit()).appendQueryParam("page", (Object)request.getPage()).accept(new String[]{"application/json"}).appendHeader("opc-request-id", request.getOpcRequestId()).operationUsesDefaultRetries().handleBody(ResourceTypeCollection.class, ListResourceTypesResponse.Builder::resourceTypeCollection).handleResponseHeaderString("opc-request-id", ListResourceTypesResponse.Builder::opcRequestId).handleResponseHeaderString("opc-next-page", ListResourceTypesResponse.Builder::opcNextPage).callSync();
    }

    @Override
    public ListSchedulesResponse listSchedules(ListSchedulesRequest request) {
        return (ListSchedulesResponse)this.clientCall(request, ListSchedulesResponse::builder).logger(LOG, "listSchedules").serviceDetails("Schedule", "ListSchedules", "https://docs.oracle.com/iaas/api/#/en/resource-scheduler/20240430/Schedule/ListSchedules").method(Method.GET).requestBuilder(ListSchedulesRequest::builder).basePath("/20240430").appendPathParam("schedules").appendQueryParam("compartmentId", (Object)request.getCompartmentId()).appendEnumQueryParam("lifecycleState", (BmcEnum)request.getLifecycleState()).appendQueryParam("displayName", (Object)request.getDisplayName()).appendQueryParam("scheduleId", (Object)request.getScheduleId()).appendQueryParam("limit", (Object)request.getLimit()).appendQueryParam("page", (Object)request.getPage()).appendEnumQueryParam("sortBy", (BmcEnum)request.getSortBy()).appendEnumQueryParam("sortOrder", (BmcEnum)request.getSortOrder()).accept(new String[]{"application/json"}).appendHeader("opc-request-id", request.getOpcRequestId()).operationUsesDefaultRetries().handleBody(ScheduleCollection.class, ListSchedulesResponse.Builder::scheduleCollection).handleResponseHeaderString("opc-request-id", ListSchedulesResponse.Builder::opcRequestId).handleResponseHeaderString("opc-next-page", ListSchedulesResponse.Builder::opcNextPage).callSync();
    }

    @Override
    public ListWorkRequestErrorsResponse listWorkRequestErrors(ListWorkRequestErrorsRequest request) {
        Validate.notBlank((String)request.getWorkRequestId(), (String)"workRequestId must not be blank", (Object[])new Object[0]);
        return (ListWorkRequestErrorsResponse)this.clientCall(request, ListWorkRequestErrorsResponse::builder).logger(LOG, "listWorkRequestErrors").serviceDetails("Schedule", "ListWorkRequestErrors", "https://docs.oracle.com/iaas/api/#/en/resource-scheduler/20240430/WorkRequestError/ListWorkRequestErrors").method(Method.GET).requestBuilder(ListWorkRequestErrorsRequest::builder).basePath("/20240430").appendPathParam("workRequests").appendPathParam(request.getWorkRequestId()).appendPathParam("errors").appendQueryParam("page", (Object)request.getPage()).appendQueryParam("limit", (Object)request.getLimit()).appendEnumQueryParam("sortBy", (BmcEnum)request.getSortBy()).appendEnumQueryParam("sortOrder", (BmcEnum)request.getSortOrder()).accept(new String[]{"application/json"}).appendHeader("opc-request-id", request.getOpcRequestId()).operationUsesDefaultRetries().handleBody(WorkRequestErrorCollection.class, ListWorkRequestErrorsResponse.Builder::workRequestErrorCollection).handleResponseHeaderString("opc-next-page", ListWorkRequestErrorsResponse.Builder::opcNextPage).handleResponseHeaderString("opc-request-id", ListWorkRequestErrorsResponse.Builder::opcRequestId).callSync();
    }

    @Override
    public ListWorkRequestLogsResponse listWorkRequestLogs(ListWorkRequestLogsRequest request) {
        Validate.notBlank((String)request.getWorkRequestId(), (String)"workRequestId must not be blank", (Object[])new Object[0]);
        return (ListWorkRequestLogsResponse)this.clientCall(request, ListWorkRequestLogsResponse::builder).logger(LOG, "listWorkRequestLogs").serviceDetails("Schedule", "ListWorkRequestLogs", "https://docs.oracle.com/iaas/api/#/en/resource-scheduler/20240430/WorkRequestLogEntry/ListWorkRequestLogs").method(Method.GET).requestBuilder(ListWorkRequestLogsRequest::builder).basePath("/20240430").appendPathParam("workRequests").appendPathParam(request.getWorkRequestId()).appendPathParam("logs").appendQueryParam("page", (Object)request.getPage()).appendQueryParam("limit", (Object)request.getLimit()).appendEnumQueryParam("sortBy", (BmcEnum)request.getSortBy()).appendEnumQueryParam("sortOrder", (BmcEnum)request.getSortOrder()).accept(new String[]{"application/json"}).appendHeader("opc-request-id", request.getOpcRequestId()).operationUsesDefaultRetries().handleBody(WorkRequestLogEntryCollection.class, ListWorkRequestLogsResponse.Builder::workRequestLogEntryCollection).handleResponseHeaderString("opc-next-page", ListWorkRequestLogsResponse.Builder::opcNextPage).handleResponseHeaderString("opc-request-id", ListWorkRequestLogsResponse.Builder::opcRequestId).callSync();
    }

    @Override
    public ListWorkRequestsResponse listWorkRequests(ListWorkRequestsRequest request) {
        return (ListWorkRequestsResponse)this.clientCall(request, ListWorkRequestsResponse::builder).logger(LOG, "listWorkRequests").serviceDetails("Schedule", "ListWorkRequests", "https://docs.oracle.com/iaas/api/#/en/resource-scheduler/20240430/WorkRequest/ListWorkRequests").method(Method.GET).requestBuilder(ListWorkRequestsRequest::builder).basePath("/20240430").appendPathParam("workRequests").appendQueryParam("compartmentId", (Object)request.getCompartmentId()).appendQueryParam("workRequestId", (Object)request.getWorkRequestId()).appendEnumQueryParam("status", (BmcEnum)request.getStatus()).appendQueryParam("resourceId", (Object)request.getResourceId()).appendQueryParam("page", (Object)request.getPage()).appendQueryParam("limit", (Object)request.getLimit()).appendEnumQueryParam("sortOrder", (BmcEnum)request.getSortOrder()).appendEnumQueryParam("sortBy", (BmcEnum)request.getSortBy()).appendQueryParam("scheduleId", (Object)request.getScheduleId()).accept(new String[]{"application/json"}).appendHeader("opc-request-id", request.getOpcRequestId()).operationUsesDefaultRetries().handleBody(WorkRequestSummaryCollection.class, ListWorkRequestsResponse.Builder::workRequestSummaryCollection).handleResponseHeaderString("opc-request-id", ListWorkRequestsResponse.Builder::opcRequestId).handleResponseHeaderString("opc-next-page", ListWorkRequestsResponse.Builder::opcNextPage).callSync();
    }

    @Override
    public UpdateScheduleResponse updateSchedule(UpdateScheduleRequest request) {
        Validate.notBlank((String)request.getScheduleId(), (String)"scheduleId must not be blank", (Object[])new Object[0]);
        Objects.requireNonNull(request.getUpdateScheduleDetails(), "updateScheduleDetails is required");
        return (UpdateScheduleResponse)this.clientCall(request, UpdateScheduleResponse::builder).logger(LOG, "updateSchedule").serviceDetails("Schedule", "UpdateSchedule", "https://docs.oracle.com/iaas/api/#/en/resource-scheduler/20240430/Schedule/UpdateSchedule").method(Method.PUT).requestBuilder(UpdateScheduleRequest::builder).basePath("/20240430").appendPathParam("schedules").appendPathParam(request.getScheduleId()).accept(new String[]{"application/json"}).appendHeader("if-match", request.getIfMatch()).appendHeader("opc-request-id", request.getOpcRequestId()).operationUsesDefaultRetries().hasBody().handleResponseHeaderString("opc-work-request-id", UpdateScheduleResponse.Builder::opcWorkRequestId).handleResponseHeaderString("opc-request-id", UpdateScheduleResponse.Builder::opcRequestId).callSync();
    }

    @Override
    public ScheduleWaiters getWaiters() {
        return this.waiters;
    }

    @Override
    public SchedulePaginators getPaginators() {
        return this.paginators;
    }

    @Deprecated
    public ScheduleClient(BasicAuthenticationDetailsProvider authenticationDetailsProvider) {
        this((ClientBuilderBase<?, ?>)ScheduleClient.builder(), (AbstractAuthenticationDetailsProvider)authenticationDetailsProvider, null);
    }

    @Deprecated
    public ScheduleClient(BasicAuthenticationDetailsProvider authenticationDetailsProvider, ClientConfiguration configuration) {
        this(ScheduleClient.builder().configuration(configuration), (AbstractAuthenticationDetailsProvider)authenticationDetailsProvider, null);
    }

    @Deprecated
    public ScheduleClient(BasicAuthenticationDetailsProvider authenticationDetailsProvider, ClientConfiguration configuration, ClientConfigurator clientConfigurator) {
        this(((Builder)ScheduleClient.builder().configuration(configuration)).clientConfigurator(clientConfigurator), (AbstractAuthenticationDetailsProvider)authenticationDetailsProvider, null);
    }

    @Deprecated
    public ScheduleClient(AbstractAuthenticationDetailsProvider authenticationDetailsProvider, ClientConfiguration configuration, ClientConfigurator clientConfigurator, RequestSignerFactory defaultRequestSignerFactory) {
        this(((Builder)((Builder)ScheduleClient.builder().configuration(configuration)).clientConfigurator(clientConfigurator)).requestSignerFactory(defaultRequestSignerFactory), authenticationDetailsProvider, null);
    }

    @Deprecated
    public ScheduleClient(AbstractAuthenticationDetailsProvider authenticationDetailsProvider, ClientConfiguration configuration, ClientConfigurator clientConfigurator, RequestSignerFactory defaultRequestSignerFactory, List<ClientConfigurator> additionalClientConfigurators) {
        this(((Builder)((Builder)((Builder)ScheduleClient.builder().configuration(configuration)).clientConfigurator(clientConfigurator)).requestSignerFactory(defaultRequestSignerFactory)).additionalClientConfigurators(additionalClientConfigurators), authenticationDetailsProvider, null);
    }

    @Deprecated
    public ScheduleClient(AbstractAuthenticationDetailsProvider authenticationDetailsProvider, ClientConfiguration configuration, ClientConfigurator clientConfigurator, RequestSignerFactory defaultRequestSignerFactory, List<ClientConfigurator> additionalClientConfigurators, String endpoint) {
        this(((Builder)((Builder)((Builder)((Builder)ScheduleClient.builder().configuration(configuration)).clientConfigurator(clientConfigurator)).requestSignerFactory(defaultRequestSignerFactory)).additionalClientConfigurators(additionalClientConfigurators)).endpoint(endpoint), authenticationDetailsProvider, null);
    }

    @Deprecated
    public ScheduleClient(AbstractAuthenticationDetailsProvider authenticationDetailsProvider, ClientConfiguration configuration, ClientConfigurator clientConfigurator, RequestSignerFactory defaultRequestSignerFactory, Map<SigningStrategy, RequestSignerFactory> signingStrategyRequestSignerFactories, List<ClientConfigurator> additionalClientConfigurators, String endpoint) {
        this(((Builder)((Builder)((Builder)((Builder)((Builder)ScheduleClient.builder().configuration(configuration)).clientConfigurator(clientConfigurator)).requestSignerFactory(defaultRequestSignerFactory)).additionalClientConfigurators(additionalClientConfigurators)).endpoint(endpoint)).signingStrategyRequestSignerFactories(signingStrategyRequestSignerFactories), authenticationDetailsProvider, null);
    }

    @Deprecated
    public ScheduleClient(AbstractAuthenticationDetailsProvider authenticationDetailsProvider, ClientConfiguration configuration, ClientConfigurator clientConfigurator, RequestSignerFactory defaultRequestSignerFactory, Map<SigningStrategy, RequestSignerFactory> signingStrategyRequestSignerFactories, List<ClientConfigurator> additionalClientConfigurators, String endpoint, ExecutorService executorService) {
        this(((Builder)((Builder)((Builder)((Builder)((Builder)ScheduleClient.builder().configuration(configuration)).clientConfigurator(clientConfigurator)).requestSignerFactory(defaultRequestSignerFactory)).additionalClientConfigurators(additionalClientConfigurators)).endpoint(endpoint)).signingStrategyRequestSignerFactories(signingStrategyRequestSignerFactories), authenticationDetailsProvider, executorService);
    }

    public static class Builder
    extends RegionalClientBuilder<Builder, ScheduleClient> {
        private ExecutorService executorService;

        private Builder(Service service) {
            super(service);
            String packageName = "resourcescheduler";
            Alloy.throwDisabledServiceExceptionIfAppropriate((String)"resourcescheduler");
            this.requestSignerFactory = new DefaultRequestSignerFactory(SigningStrategy.STANDARD);
        }

        public Builder executorService(ExecutorService executorService) {
            this.executorService = executorService;
            return this;
        }

        public ScheduleClient build(@Nonnull AbstractAuthenticationDetailsProvider authenticationDetailsProvider) {
            return new ScheduleClient((ClientBuilderBase<?, ?>)this, authenticationDetailsProvider, this.executorService);
        }
    }
}

