/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.resourcescheduler;

import com.oracle.bmc.resourcescheduler.Schedule;
import com.oracle.bmc.resourcescheduler.model.Schedule;
import com.oracle.bmc.resourcescheduler.requests.GetScheduleRequest;
import com.oracle.bmc.resourcescheduler.requests.GetWorkRequestRequest;
import com.oracle.bmc.resourcescheduler.responses.GetScheduleResponse;
import com.oracle.bmc.resourcescheduler.responses.GetWorkRequestResponse;
import com.oracle.bmc.util.internal.Validate;
import com.oracle.bmc.waiter.BmcGenericWaiter;
import com.oracle.bmc.waiter.DelayStrategy;
import com.oracle.bmc.waiter.TerminationStrategy;
import com.oracle.bmc.waiter.Waiter;
import com.oracle.bmc.waiter.Waiters;
import com.oracle.bmc.waiter.internal.SimpleWaiterImpl;
import java.util.Arrays;
import java.util.HashSet;
import java.util.concurrent.ExecutorService;
import java.util.function.Function;
import java.util.function.Predicate;

public class ScheduleWaiters {
    private final ExecutorService executorService;
    private final Schedule client;

    public ScheduleWaiters(ExecutorService executorService, Schedule client) {
        this.executorService = executorService;
        this.client = client;
    }

    public Waiter<GetScheduleRequest, GetScheduleResponse> forSchedule(GetScheduleRequest request, Schedule.LifecycleState ... targetStates) {
        Validate.notEmpty((Object[])targetStates, (String)"At least one targetState must be provided", (Object[])new Object[0]);
        Validate.noNullElements((Object[])targetStates, (String)"Null targetState values are not permitted", (Object[])new Object[0]);
        return this.forSchedule(Waiters.DEFAULT_POLLING_WAITER, request, targetStates);
    }

    public Waiter<GetScheduleRequest, GetScheduleResponse> forSchedule(GetScheduleRequest request, Schedule.LifecycleState targetState, TerminationStrategy terminationStrategy, DelayStrategy delayStrategy) {
        Validate.notNull((Object)((Object)targetState), (String)"The targetState cannot be null", (Object[])new Object[0]);
        return this.forSchedule(Waiters.newWaiter((TerminationStrategy)terminationStrategy, (DelayStrategy)delayStrategy), request, targetState);
    }

    public Waiter<GetScheduleRequest, GetScheduleResponse> forSchedule(GetScheduleRequest request, TerminationStrategy terminationStrategy, DelayStrategy delayStrategy, Schedule.LifecycleState ... targetStates) {
        Validate.notEmpty((Object[])targetStates, (String)"At least one target state must be provided", (Object[])new Object[0]);
        Validate.noNullElements((Object[])targetStates, (String)"Null target states are not permitted", (Object[])new Object[0]);
        return this.forSchedule(Waiters.newWaiter((TerminationStrategy)terminationStrategy, (DelayStrategy)delayStrategy), request, targetStates);
    }

    private Waiter<GetScheduleRequest, GetScheduleResponse> forSchedule(BmcGenericWaiter waiter, GetScheduleRequest request, Schedule.LifecycleState ... targetStates) {
        final HashSet<Schedule.LifecycleState> targetStatesSet = new HashSet<Schedule.LifecycleState>(Arrays.asList(targetStates));
        return new SimpleWaiterImpl(this.executorService, waiter.toCallable(() -> request, (Function)new Function<GetScheduleRequest, GetScheduleResponse>(){

            @Override
            public GetScheduleResponse apply(GetScheduleRequest request) {
                return ScheduleWaiters.this.client.getSchedule(request);
            }
        }, (Predicate)new Predicate<GetScheduleResponse>(){

            @Override
            public boolean test(GetScheduleResponse response) {
                return targetStatesSet.contains((Object)response.getSchedule().getLifecycleState());
            }
        }, targetStatesSet.contains((Object)Schedule.LifecycleState.Deleted)), (Object)request);
    }

    public Waiter<GetWorkRequestRequest, GetWorkRequestResponse> forWorkRequest(GetWorkRequestRequest request) {
        return this.forWorkRequest(Waiters.DEFAULT_POLLING_WAITER, request);
    }

    public Waiter<GetWorkRequestRequest, GetWorkRequestResponse> forWorkRequest(GetWorkRequestRequest request, TerminationStrategy terminationStrategy, DelayStrategy delayStrategy) {
        return this.forWorkRequest(Waiters.newWaiter((TerminationStrategy)terminationStrategy, (DelayStrategy)delayStrategy), request);
    }

    private Waiter<GetWorkRequestRequest, GetWorkRequestResponse> forWorkRequest(BmcGenericWaiter waiter, GetWorkRequestRequest request) {
        return new SimpleWaiterImpl(this.executorService, waiter.toCallable(() -> request, (Function)new Function<GetWorkRequestRequest, GetWorkRequestResponse>(){

            @Override
            public GetWorkRequestResponse apply(GetWorkRequestRequest request) {
                return ScheduleWaiters.this.client.getWorkRequest(request);
            }
        }, (Predicate)new Predicate<GetWorkRequestResponse>(){

            @Override
            public boolean test(GetWorkRequestResponse response) {
                return response.getWorkRequest().getTimeFinished() != null;
            }
        }, false), (Object)request);
    }
}

