/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.resourcescheduler.model;

import com.fasterxml.jackson.annotation.JsonFilter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonPOJOBuilder;
import com.oracle.bmc.http.client.internal.ExplicitlySetBmcModel;
import java.beans.ConstructorProperties;
import java.util.HashSet;
import java.util.Objects;
import java.util.Set;

@JsonDeserialize(builder=Builder.class)
@JsonFilter(value="explicitlySetFilter")
public final class DefinedTagFilterValue
extends ExplicitlySetBmcModel {
    @JsonProperty(value="namespace")
    private final String namespace;
    @JsonProperty(value="tagKey")
    private final String tagKey;
    @JsonProperty(value="value")
    private final String value;

    @Deprecated
    @ConstructorProperties(value={"namespace", "tagKey", "value"})
    public DefinedTagFilterValue(String namespace, String tagKey, String value) {
        this.namespace = namespace;
        this.tagKey = tagKey;
        this.value = value;
    }

    public static Builder builder() {
        return new Builder();
    }

    public Builder toBuilder() {
        return new Builder().copy(this);
    }

    public String getNamespace() {
        return this.namespace;
    }

    public String getTagKey() {
        return this.tagKey;
    }

    public String getValue() {
        return this.value;
    }

    public String toString() {
        return this.toString(true);
    }

    public String toString(boolean includeByteArrayContents) {
        StringBuilder sb = new StringBuilder();
        sb.append("DefinedTagFilterValue(");
        sb.append("super=").append(super.toString());
        sb.append("namespace=").append(String.valueOf(this.namespace));
        sb.append(", tagKey=").append(String.valueOf(this.tagKey));
        sb.append(", value=").append(String.valueOf(this.value));
        sb.append(")");
        return sb.toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof DefinedTagFilterValue)) {
            return false;
        }
        DefinedTagFilterValue other = (DefinedTagFilterValue)((Object)o);
        return Objects.equals(this.namespace, other.namespace) && Objects.equals(this.tagKey, other.tagKey) && Objects.equals(this.value, other.value) && super.equals((Object)other);
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + (this.namespace == null ? 43 : this.namespace.hashCode());
        result = result * 59 + (this.tagKey == null ? 43 : this.tagKey.hashCode());
        result = result * 59 + (this.value == null ? 43 : this.value.hashCode());
        result = result * 59 + super.hashCode();
        return result;
    }

    @JsonPOJOBuilder(withPrefix="")
    public static class Builder {
        @JsonProperty(value="namespace")
        private String namespace;
        @JsonProperty(value="tagKey")
        private String tagKey;
        @JsonProperty(value="value")
        private String value;
        @JsonIgnore
        private final Set<String> __explicitlySet__ = new HashSet<String>();

        public Builder namespace(String namespace) {
            this.namespace = namespace;
            this.__explicitlySet__.add("namespace");
            return this;
        }

        public Builder tagKey(String tagKey) {
            this.tagKey = tagKey;
            this.__explicitlySet__.add("tagKey");
            return this;
        }

        public Builder value(String value) {
            this.value = value;
            this.__explicitlySet__.add("value");
            return this;
        }

        public DefinedTagFilterValue build() {
            DefinedTagFilterValue model = new DefinedTagFilterValue(this.namespace, this.tagKey, this.value);
            for (String explicitlySetProperty : this.__explicitlySet__) {
                model.markPropertyAsExplicitlySet(explicitlySetProperty);
            }
            return model;
        }

        @JsonIgnore
        public Builder copy(DefinedTagFilterValue model) {
            if (model.wasPropertyExplicitlySet("namespace")) {
                this.namespace(model.getNamespace());
            }
            if (model.wasPropertyExplicitlySet("tagKey")) {
                this.tagKey(model.getTagKey());
            }
            if (model.wasPropertyExplicitlySet("value")) {
                this.value(model.getValue());
            }
            return this;
        }
    }
}

