/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.resourcescheduler.model;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonFilter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonValue;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonPOJOBuilder;
import com.oracle.bmc.http.client.internal.ExplicitlySetBmcModel;
import com.oracle.bmc.http.internal.BmcEnum;
import com.oracle.bmc.resourcescheduler.model.OperationStatus;
import com.oracle.bmc.resourcescheduler.model.Resource;
import com.oracle.bmc.resourcescheduler.model.ResourceFilter;
import com.oracle.bmc.resourcescheduler.model.Schedule;
import java.beans.ConstructorProperties;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@JsonDeserialize(builder=Builder.class)
@JsonFilter(value="explicitlySetFilter")
public final class ScheduleSummary
extends ExplicitlySetBmcModel {
    @JsonProperty(value="id")
    private final String id;
    @JsonProperty(value="compartmentId")
    private final String compartmentId;
    @JsonProperty(value="displayName")
    private final String displayName;
    @JsonProperty(value="action")
    private final Action action;
    @JsonProperty(value="description")
    private final String description;
    @JsonProperty(value="recurrenceDetails")
    private final String recurrenceDetails;
    @JsonProperty(value="recurrenceType")
    private final RecurrenceType recurrenceType;
    @JsonProperty(value="resourceFilters")
    private final List<ResourceFilter> resourceFilters;
    @JsonProperty(value="resources")
    private final List<Resource> resources;
    @JsonProperty(value="timeStarts")
    private final Date timeStarts;
    @JsonProperty(value="timeEnds")
    private final Date timeEnds;
    @JsonProperty(value="timeCreated")
    private final Date timeCreated;
    @JsonProperty(value="timeUpdated")
    private final Date timeUpdated;
    @JsonProperty(value="timeLastRun")
    private final Date timeLastRun;
    @JsonProperty(value="timeNextRun")
    private final Date timeNextRun;
    @JsonProperty(value="lastRunStatus")
    private final OperationStatus lastRunStatus;
    @JsonProperty(value="lifecycleState")
    private final Schedule.LifecycleState lifecycleState;
    @JsonProperty(value="freeformTags")
    private final Map<String, String> freeformTags;
    @JsonProperty(value="definedTags")
    private final Map<String, Map<String, Object>> definedTags;
    @JsonProperty(value="systemTags")
    private final Map<String, Map<String, Object>> systemTags;

    @Deprecated
    @ConstructorProperties(value={"id", "compartmentId", "displayName", "action", "description", "recurrenceDetails", "recurrenceType", "resourceFilters", "resources", "timeStarts", "timeEnds", "timeCreated", "timeUpdated", "timeLastRun", "timeNextRun", "lastRunStatus", "lifecycleState", "freeformTags", "definedTags", "systemTags"})
    public ScheduleSummary(String id, String compartmentId, String displayName, Action action, String description, String recurrenceDetails, RecurrenceType recurrenceType, List<ResourceFilter> resourceFilters, List<Resource> resources, Date timeStarts, Date timeEnds, Date timeCreated, Date timeUpdated, Date timeLastRun, Date timeNextRun, OperationStatus lastRunStatus, Schedule.LifecycleState lifecycleState, Map<String, String> freeformTags, Map<String, Map<String, Object>> definedTags, Map<String, Map<String, Object>> systemTags) {
        this.id = id;
        this.compartmentId = compartmentId;
        this.displayName = displayName;
        this.action = action;
        this.description = description;
        this.recurrenceDetails = recurrenceDetails;
        this.recurrenceType = recurrenceType;
        this.resourceFilters = resourceFilters;
        this.resources = resources;
        this.timeStarts = timeStarts;
        this.timeEnds = timeEnds;
        this.timeCreated = timeCreated;
        this.timeUpdated = timeUpdated;
        this.timeLastRun = timeLastRun;
        this.timeNextRun = timeNextRun;
        this.lastRunStatus = lastRunStatus;
        this.lifecycleState = lifecycleState;
        this.freeformTags = freeformTags;
        this.definedTags = definedTags;
        this.systemTags = systemTags;
    }

    public static Builder builder() {
        return new Builder();
    }

    public Builder toBuilder() {
        return new Builder().copy(this);
    }

    public String getId() {
        return this.id;
    }

    public String getCompartmentId() {
        return this.compartmentId;
    }

    public String getDisplayName() {
        return this.displayName;
    }

    public Action getAction() {
        return this.action;
    }

    public String getDescription() {
        return this.description;
    }

    public String getRecurrenceDetails() {
        return this.recurrenceDetails;
    }

    public RecurrenceType getRecurrenceType() {
        return this.recurrenceType;
    }

    public List<ResourceFilter> getResourceFilters() {
        return this.resourceFilters;
    }

    public List<Resource> getResources() {
        return this.resources;
    }

    public Date getTimeStarts() {
        return this.timeStarts;
    }

    public Date getTimeEnds() {
        return this.timeEnds;
    }

    public Date getTimeCreated() {
        return this.timeCreated;
    }

    public Date getTimeUpdated() {
        return this.timeUpdated;
    }

    public Date getTimeLastRun() {
        return this.timeLastRun;
    }

    public Date getTimeNextRun() {
        return this.timeNextRun;
    }

    public OperationStatus getLastRunStatus() {
        return this.lastRunStatus;
    }

    public Schedule.LifecycleState getLifecycleState() {
        return this.lifecycleState;
    }

    public Map<String, String> getFreeformTags() {
        return this.freeformTags;
    }

    public Map<String, Map<String, Object>> getDefinedTags() {
        return this.definedTags;
    }

    public Map<String, Map<String, Object>> getSystemTags() {
        return this.systemTags;
    }

    public String toString() {
        return this.toString(true);
    }

    public String toString(boolean includeByteArrayContents) {
        StringBuilder sb = new StringBuilder();
        sb.append("ScheduleSummary(");
        sb.append("super=").append(super.toString());
        sb.append("id=").append(String.valueOf(this.id));
        sb.append(", compartmentId=").append(String.valueOf(this.compartmentId));
        sb.append(", displayName=").append(String.valueOf(this.displayName));
        sb.append(", action=").append(String.valueOf((Object)this.action));
        sb.append(", description=").append(String.valueOf(this.description));
        sb.append(", recurrenceDetails=").append(String.valueOf(this.recurrenceDetails));
        sb.append(", recurrenceType=").append(String.valueOf((Object)this.recurrenceType));
        sb.append(", resourceFilters=").append(String.valueOf(this.resourceFilters));
        sb.append(", resources=").append(String.valueOf(this.resources));
        sb.append(", timeStarts=").append(String.valueOf(this.timeStarts));
        sb.append(", timeEnds=").append(String.valueOf(this.timeEnds));
        sb.append(", timeCreated=").append(String.valueOf(this.timeCreated));
        sb.append(", timeUpdated=").append(String.valueOf(this.timeUpdated));
        sb.append(", timeLastRun=").append(String.valueOf(this.timeLastRun));
        sb.append(", timeNextRun=").append(String.valueOf(this.timeNextRun));
        sb.append(", lastRunStatus=").append(String.valueOf((Object)this.lastRunStatus));
        sb.append(", lifecycleState=").append(String.valueOf((Object)this.lifecycleState));
        sb.append(", freeformTags=").append(String.valueOf(this.freeformTags));
        sb.append(", definedTags=").append(String.valueOf(this.definedTags));
        sb.append(", systemTags=").append(String.valueOf(this.systemTags));
        sb.append(")");
        return sb.toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof ScheduleSummary)) {
            return false;
        }
        ScheduleSummary other = (ScheduleSummary)((Object)o);
        return Objects.equals(this.id, other.id) && Objects.equals(this.compartmentId, other.compartmentId) && Objects.equals(this.displayName, other.displayName) && Objects.equals((Object)this.action, (Object)other.action) && Objects.equals(this.description, other.description) && Objects.equals(this.recurrenceDetails, other.recurrenceDetails) && Objects.equals((Object)this.recurrenceType, (Object)other.recurrenceType) && Objects.equals(this.resourceFilters, other.resourceFilters) && Objects.equals(this.resources, other.resources) && Objects.equals(this.timeStarts, other.timeStarts) && Objects.equals(this.timeEnds, other.timeEnds) && Objects.equals(this.timeCreated, other.timeCreated) && Objects.equals(this.timeUpdated, other.timeUpdated) && Objects.equals(this.timeLastRun, other.timeLastRun) && Objects.equals(this.timeNextRun, other.timeNextRun) && Objects.equals((Object)this.lastRunStatus, (Object)other.lastRunStatus) && Objects.equals((Object)this.lifecycleState, (Object)other.lifecycleState) && Objects.equals(this.freeformTags, other.freeformTags) && Objects.equals(this.definedTags, other.definedTags) && Objects.equals(this.systemTags, other.systemTags) && super.equals((Object)other);
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + (this.id == null ? 43 : this.id.hashCode());
        result = result * 59 + (this.compartmentId == null ? 43 : this.compartmentId.hashCode());
        result = result * 59 + (this.displayName == null ? 43 : this.displayName.hashCode());
        result = result * 59 + (this.action == null ? 43 : this.action.hashCode());
        result = result * 59 + (this.description == null ? 43 : this.description.hashCode());
        result = result * 59 + (this.recurrenceDetails == null ? 43 : this.recurrenceDetails.hashCode());
        result = result * 59 + (this.recurrenceType == null ? 43 : this.recurrenceType.hashCode());
        result = result * 59 + (this.resourceFilters == null ? 43 : this.resourceFilters.hashCode());
        result = result * 59 + (this.resources == null ? 43 : this.resources.hashCode());
        result = result * 59 + (this.timeStarts == null ? 43 : this.timeStarts.hashCode());
        result = result * 59 + (this.timeEnds == null ? 43 : this.timeEnds.hashCode());
        result = result * 59 + (this.timeCreated == null ? 43 : this.timeCreated.hashCode());
        result = result * 59 + (this.timeUpdated == null ? 43 : this.timeUpdated.hashCode());
        result = result * 59 + (this.timeLastRun == null ? 43 : this.timeLastRun.hashCode());
        result = result * 59 + (this.timeNextRun == null ? 43 : this.timeNextRun.hashCode());
        result = result * 59 + (this.lastRunStatus == null ? 43 : this.lastRunStatus.hashCode());
        result = result * 59 + (this.lifecycleState == null ? 43 : this.lifecycleState.hashCode());
        result = result * 59 + (this.freeformTags == null ? 43 : this.freeformTags.hashCode());
        result = result * 59 + (this.definedTags == null ? 43 : this.definedTags.hashCode());
        result = result * 59 + (this.systemTags == null ? 43 : this.systemTags.hashCode());
        result = result * 59 + super.hashCode();
        return result;
    }

    public static enum RecurrenceType implements BmcEnum
    {
        Cron("CRON"),
        Ical("ICAL"),
        UnknownEnumValue(null);

        private static final Logger LOG;
        private final String value;
        private static Map<String, RecurrenceType> map;

        private RecurrenceType(String value) {
            this.value = value;
        }

        @JsonValue
        public String getValue() {
            return this.value;
        }

        @JsonCreator
        public static RecurrenceType create(String key) {
            if (map.containsKey(key)) {
                return map.get(key);
            }
            LOG.warn("Received unknown value '{}' for enum 'RecurrenceType', returning UnknownEnumValue", (Object)key);
            return UnknownEnumValue;
        }

        static {
            LOG = LoggerFactory.getLogger(RecurrenceType.class);
            map = new HashMap<String, RecurrenceType>();
            for (RecurrenceType v : RecurrenceType.values()) {
                if (v == UnknownEnumValue) continue;
                map.put(v.getValue(), v);
            }
        }
    }

    public static enum Action implements BmcEnum
    {
        StartResource("START_RESOURCE"),
        StopResource("STOP_RESOURCE"),
        UnknownEnumValue(null);

        private static final Logger LOG;
        private final String value;
        private static Map<String, Action> map;

        private Action(String value) {
            this.value = value;
        }

        @JsonValue
        public String getValue() {
            return this.value;
        }

        @JsonCreator
        public static Action create(String key) {
            if (map.containsKey(key)) {
                return map.get(key);
            }
            LOG.warn("Received unknown value '{}' for enum 'Action', returning UnknownEnumValue", (Object)key);
            return UnknownEnumValue;
        }

        static {
            LOG = LoggerFactory.getLogger(Action.class);
            map = new HashMap<String, Action>();
            for (Action v : Action.values()) {
                if (v == UnknownEnumValue) continue;
                map.put(v.getValue(), v);
            }
        }
    }

    @JsonPOJOBuilder(withPrefix="")
    public static class Builder {
        @JsonProperty(value="id")
        private String id;
        @JsonProperty(value="compartmentId")
        private String compartmentId;
        @JsonProperty(value="displayName")
        private String displayName;
        @JsonProperty(value="action")
        private Action action;
        @JsonProperty(value="description")
        private String description;
        @JsonProperty(value="recurrenceDetails")
        private String recurrenceDetails;
        @JsonProperty(value="recurrenceType")
        private RecurrenceType recurrenceType;
        @JsonProperty(value="resourceFilters")
        private List<ResourceFilter> resourceFilters;
        @JsonProperty(value="resources")
        private List<Resource> resources;
        @JsonProperty(value="timeStarts")
        private Date timeStarts;
        @JsonProperty(value="timeEnds")
        private Date timeEnds;
        @JsonProperty(value="timeCreated")
        private Date timeCreated;
        @JsonProperty(value="timeUpdated")
        private Date timeUpdated;
        @JsonProperty(value="timeLastRun")
        private Date timeLastRun;
        @JsonProperty(value="timeNextRun")
        private Date timeNextRun;
        @JsonProperty(value="lastRunStatus")
        private OperationStatus lastRunStatus;
        @JsonProperty(value="lifecycleState")
        private Schedule.LifecycleState lifecycleState;
        @JsonProperty(value="freeformTags")
        private Map<String, String> freeformTags;
        @JsonProperty(value="definedTags")
        private Map<String, Map<String, Object>> definedTags;
        @JsonProperty(value="systemTags")
        private Map<String, Map<String, Object>> systemTags;
        @JsonIgnore
        private final Set<String> __explicitlySet__ = new HashSet<String>();

        public Builder id(String id) {
            this.id = id;
            this.__explicitlySet__.add("id");
            return this;
        }

        public Builder compartmentId(String compartmentId) {
            this.compartmentId = compartmentId;
            this.__explicitlySet__.add("compartmentId");
            return this;
        }

        public Builder displayName(String displayName) {
            this.displayName = displayName;
            this.__explicitlySet__.add("displayName");
            return this;
        }

        public Builder action(Action action) {
            this.action = action;
            this.__explicitlySet__.add("action");
            return this;
        }

        public Builder description(String description) {
            this.description = description;
            this.__explicitlySet__.add("description");
            return this;
        }

        public Builder recurrenceDetails(String recurrenceDetails) {
            this.recurrenceDetails = recurrenceDetails;
            this.__explicitlySet__.add("recurrenceDetails");
            return this;
        }

        public Builder recurrenceType(RecurrenceType recurrenceType) {
            this.recurrenceType = recurrenceType;
            this.__explicitlySet__.add("recurrenceType");
            return this;
        }

        public Builder resourceFilters(List<ResourceFilter> resourceFilters) {
            this.resourceFilters = resourceFilters;
            this.__explicitlySet__.add("resourceFilters");
            return this;
        }

        public Builder resources(List<Resource> resources) {
            this.resources = resources;
            this.__explicitlySet__.add("resources");
            return this;
        }

        public Builder timeStarts(Date timeStarts) {
            this.timeStarts = timeStarts;
            this.__explicitlySet__.add("timeStarts");
            return this;
        }

        public Builder timeEnds(Date timeEnds) {
            this.timeEnds = timeEnds;
            this.__explicitlySet__.add("timeEnds");
            return this;
        }

        public Builder timeCreated(Date timeCreated) {
            this.timeCreated = timeCreated;
            this.__explicitlySet__.add("timeCreated");
            return this;
        }

        public Builder timeUpdated(Date timeUpdated) {
            this.timeUpdated = timeUpdated;
            this.__explicitlySet__.add("timeUpdated");
            return this;
        }

        public Builder timeLastRun(Date timeLastRun) {
            this.timeLastRun = timeLastRun;
            this.__explicitlySet__.add("timeLastRun");
            return this;
        }

        public Builder timeNextRun(Date timeNextRun) {
            this.timeNextRun = timeNextRun;
            this.__explicitlySet__.add("timeNextRun");
            return this;
        }

        public Builder lastRunStatus(OperationStatus lastRunStatus) {
            this.lastRunStatus = lastRunStatus;
            this.__explicitlySet__.add("lastRunStatus");
            return this;
        }

        public Builder lifecycleState(Schedule.LifecycleState lifecycleState) {
            this.lifecycleState = lifecycleState;
            this.__explicitlySet__.add("lifecycleState");
            return this;
        }

        public Builder freeformTags(Map<String, String> freeformTags) {
            this.freeformTags = freeformTags;
            this.__explicitlySet__.add("freeformTags");
            return this;
        }

        public Builder definedTags(Map<String, Map<String, Object>> definedTags) {
            this.definedTags = definedTags;
            this.__explicitlySet__.add("definedTags");
            return this;
        }

        public Builder systemTags(Map<String, Map<String, Object>> systemTags) {
            this.systemTags = systemTags;
            this.__explicitlySet__.add("systemTags");
            return this;
        }

        public ScheduleSummary build() {
            ScheduleSummary model = new ScheduleSummary(this.id, this.compartmentId, this.displayName, this.action, this.description, this.recurrenceDetails, this.recurrenceType, this.resourceFilters, this.resources, this.timeStarts, this.timeEnds, this.timeCreated, this.timeUpdated, this.timeLastRun, this.timeNextRun, this.lastRunStatus, this.lifecycleState, this.freeformTags, this.definedTags, this.systemTags);
            for (String explicitlySetProperty : this.__explicitlySet__) {
                model.markPropertyAsExplicitlySet(explicitlySetProperty);
            }
            return model;
        }

        @JsonIgnore
        public Builder copy(ScheduleSummary model) {
            if (model.wasPropertyExplicitlySet("id")) {
                this.id(model.getId());
            }
            if (model.wasPropertyExplicitlySet("compartmentId")) {
                this.compartmentId(model.getCompartmentId());
            }
            if (model.wasPropertyExplicitlySet("displayName")) {
                this.displayName(model.getDisplayName());
            }
            if (model.wasPropertyExplicitlySet("action")) {
                this.action(model.getAction());
            }
            if (model.wasPropertyExplicitlySet("description")) {
                this.description(model.getDescription());
            }
            if (model.wasPropertyExplicitlySet("recurrenceDetails")) {
                this.recurrenceDetails(model.getRecurrenceDetails());
            }
            if (model.wasPropertyExplicitlySet("recurrenceType")) {
                this.recurrenceType(model.getRecurrenceType());
            }
            if (model.wasPropertyExplicitlySet("resourceFilters")) {
                this.resourceFilters(model.getResourceFilters());
            }
            if (model.wasPropertyExplicitlySet("resources")) {
                this.resources(model.getResources());
            }
            if (model.wasPropertyExplicitlySet("timeStarts")) {
                this.timeStarts(model.getTimeStarts());
            }
            if (model.wasPropertyExplicitlySet("timeEnds")) {
                this.timeEnds(model.getTimeEnds());
            }
            if (model.wasPropertyExplicitlySet("timeCreated")) {
                this.timeCreated(model.getTimeCreated());
            }
            if (model.wasPropertyExplicitlySet("timeUpdated")) {
                this.timeUpdated(model.getTimeUpdated());
            }
            if (model.wasPropertyExplicitlySet("timeLastRun")) {
                this.timeLastRun(model.getTimeLastRun());
            }
            if (model.wasPropertyExplicitlySet("timeNextRun")) {
                this.timeNextRun(model.getTimeNextRun());
            }
            if (model.wasPropertyExplicitlySet("lastRunStatus")) {
                this.lastRunStatus(model.getLastRunStatus());
            }
            if (model.wasPropertyExplicitlySet("lifecycleState")) {
                this.lifecycleState(model.getLifecycleState());
            }
            if (model.wasPropertyExplicitlySet("freeformTags")) {
                this.freeformTags(model.getFreeformTags());
            }
            if (model.wasPropertyExplicitlySet("definedTags")) {
                this.definedTags(model.getDefinedTags());
            }
            if (model.wasPropertyExplicitlySet("systemTags")) {
                this.systemTags(model.getSystemTags());
            }
            return this;
        }
    }
}

