/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.resourcescheduler.model;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonFilter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonTypeInfo;
import com.fasterxml.jackson.annotation.JsonValue;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonPOJOBuilder;
import com.oracle.bmc.http.internal.BmcEnum;
import com.oracle.bmc.resourcescheduler.model.ResourceFilter;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@JsonDeserialize(builder=Builder.class)
@JsonTypeInfo(use=JsonTypeInfo.Id.NAME, include=JsonTypeInfo.As.PROPERTY, property="attribute")
@JsonFilter(value="explicitlySetFilter")
public final class TimeCreatedResourceFilter
extends ResourceFilter {
    @JsonProperty(value="condition")
    private final Condition condition;
    @JsonProperty(value="value")
    private final String value;

    public static Builder builder() {
        return new Builder();
    }

    public Builder toBuilder() {
        return new Builder().copy(this);
    }

    @Deprecated
    public TimeCreatedResourceFilter(Condition condition, String value) {
        this.condition = condition;
        this.value = value;
    }

    public Condition getCondition() {
        return this.condition;
    }

    public String getValue() {
        return this.value;
    }

    @Override
    public String toString() {
        return this.toString(true);
    }

    @Override
    public String toString(boolean includeByteArrayContents) {
        StringBuilder sb = new StringBuilder();
        sb.append("TimeCreatedResourceFilter(");
        sb.append("super=").append(super.toString(includeByteArrayContents));
        sb.append(", condition=").append(String.valueOf((Object)this.condition));
        sb.append(", value=").append(String.valueOf(this.value));
        sb.append(")");
        return sb.toString();
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof TimeCreatedResourceFilter)) {
            return false;
        }
        TimeCreatedResourceFilter other = (TimeCreatedResourceFilter)((Object)o);
        return Objects.equals((Object)this.condition, (Object)other.condition) && Objects.equals(this.value, other.value) && super.equals((Object)other);
    }

    @Override
    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        result = result * 59 + (this.condition == null ? 43 : this.condition.hashCode());
        result = result * 59 + (this.value == null ? 43 : this.value.hashCode());
        return result;
    }

    public static enum Condition implements BmcEnum
    {
        Equal("EQUAL"),
        Before("BEFORE"),
        After("AFTER"),
        UnknownEnumValue(null);

        private static final Logger LOG;
        private final String value;
        private static Map<String, Condition> map;

        private Condition(String value) {
            this.value = value;
        }

        @JsonValue
        public String getValue() {
            return this.value;
        }

        @JsonCreator
        public static Condition create(String key) {
            if (map.containsKey(key)) {
                return map.get(key);
            }
            LOG.warn("Received unknown value '{}' for enum 'Condition', returning UnknownEnumValue", (Object)key);
            return UnknownEnumValue;
        }

        static {
            LOG = LoggerFactory.getLogger(Condition.class);
            map = new HashMap<String, Condition>();
            for (Condition v : Condition.values()) {
                if (v == UnknownEnumValue) continue;
                map.put(v.getValue(), v);
            }
        }
    }

    @JsonPOJOBuilder(withPrefix="")
    public static class Builder {
        @JsonProperty(value="condition")
        private Condition condition;
        @JsonProperty(value="value")
        private String value;
        @JsonIgnore
        private final Set<String> __explicitlySet__ = new HashSet<String>();

        public Builder condition(Condition condition) {
            this.condition = condition;
            this.__explicitlySet__.add("condition");
            return this;
        }

        public Builder value(String value) {
            this.value = value;
            this.__explicitlySet__.add("value");
            return this;
        }

        public TimeCreatedResourceFilter build() {
            TimeCreatedResourceFilter model = new TimeCreatedResourceFilter(this.condition, this.value);
            for (String explicitlySetProperty : this.__explicitlySet__) {
                model.markPropertyAsExplicitlySet(explicitlySetProperty);
            }
            return model;
        }

        @JsonIgnore
        public Builder copy(TimeCreatedResourceFilter model) {
            if (model.wasPropertyExplicitlySet("condition")) {
                this.condition(model.getCondition());
            }
            if (model.wasPropertyExplicitlySet("value")) {
                this.value(model.getValue());
            }
            return this;
        }
    }
}

