/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.resourcescheduler.responses;

import com.oracle.bmc.resourcescheduler.model.ResourceTypeCollection;
import com.oracle.bmc.responses.BmcResponse;
import java.beans.ConstructorProperties;
import java.util.List;
import java.util.Map;
import java.util.Objects;

public class ListResourceTypesResponse
extends BmcResponse {
    private String opcRequestId;
    private String opcNextPage;
    private ResourceTypeCollection resourceTypeCollection;

    public String getOpcRequestId() {
        return this.opcRequestId;
    }

    public String getOpcNextPage() {
        return this.opcNextPage;
    }

    public ResourceTypeCollection getResourceTypeCollection() {
        return this.resourceTypeCollection;
    }

    @ConstructorProperties(value={"__httpStatusCode__", "headers", "opcRequestId", "opcNextPage", "resourceTypeCollection"})
    private ListResourceTypesResponse(int __httpStatusCode__, Map<String, List<String>> headers, String opcRequestId, String opcNextPage, ResourceTypeCollection resourceTypeCollection) {
        super(__httpStatusCode__, headers);
        this.opcRequestId = opcRequestId;
        this.opcNextPage = opcNextPage;
        this.resourceTypeCollection = resourceTypeCollection;
    }

    public static Builder builder() {
        return new Builder();
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("(");
        sb.append("super=").append(super.toString());
        sb.append(",opcRequestId=").append(String.valueOf(this.opcRequestId));
        sb.append(",opcNextPage=").append(String.valueOf(this.opcNextPage));
        sb.append(",resourceTypeCollection=").append(String.valueOf((Object)this.resourceTypeCollection));
        sb.append(")");
        return sb.toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof ListResourceTypesResponse)) {
            return false;
        }
        ListResourceTypesResponse other = (ListResourceTypesResponse)((Object)o);
        return super.equals(o) && Objects.equals(this.opcRequestId, other.opcRequestId) && Objects.equals(this.opcNextPage, other.opcNextPage) && Objects.equals((Object)this.resourceTypeCollection, (Object)other.resourceTypeCollection);
    }

    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        result = result * 59 + (this.opcRequestId == null ? 43 : this.opcRequestId.hashCode());
        result = result * 59 + (this.opcNextPage == null ? 43 : this.opcNextPage.hashCode());
        result = result * 59 + (this.resourceTypeCollection == null ? 43 : this.resourceTypeCollection.hashCode());
        return result;
    }

    public static class Builder
    implements BmcResponse.Builder<ListResourceTypesResponse> {
        private int __httpStatusCode__;
        private Map<String, List<String>> headers;
        private String opcRequestId;
        private String opcNextPage;
        private ResourceTypeCollection resourceTypeCollection;

        public Builder __httpStatusCode__(int __httpStatusCode__) {
            this.__httpStatusCode__ = __httpStatusCode__;
            return this;
        }

        public Builder headers(Map<String, List<String>> headers) {
            this.headers = headers;
            return this;
        }

        public Builder opcRequestId(String opcRequestId) {
            this.opcRequestId = opcRequestId;
            return this;
        }

        public Builder opcNextPage(String opcNextPage) {
            this.opcNextPage = opcNextPage;
            return this;
        }

        public Builder resourceTypeCollection(ResourceTypeCollection resourceTypeCollection) {
            this.resourceTypeCollection = resourceTypeCollection;
            return this;
        }

        public Builder copy(ListResourceTypesResponse o) {
            this.__httpStatusCode__(o.get__httpStatusCode__());
            this.headers(o.getHeaders());
            this.opcRequestId(o.getOpcRequestId());
            this.opcNextPage(o.getOpcNextPage());
            this.resourceTypeCollection(o.getResourceTypeCollection());
            return this;
        }

        public ListResourceTypesResponse build() {
            return new ListResourceTypesResponse(this.__httpStatusCode__, this.headers, this.opcRequestId, this.opcNextPage, this.resourceTypeCollection);
        }
    }
}

