/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.resourcescheduler;

import com.oracle.bmc.paginator.internal.RequestBuilderAndToken;
import com.oracle.bmc.paginator.internal.ResponseIterable;
import com.oracle.bmc.paginator.internal.ResponseRecordIterable;
import com.oracle.bmc.resourcescheduler.Schedule;
import com.oracle.bmc.resourcescheduler.model.ResourceType;
import com.oracle.bmc.resourcescheduler.model.ScheduleSummary;
import com.oracle.bmc.resourcescheduler.model.WorkRequestError;
import com.oracle.bmc.resourcescheduler.model.WorkRequestLogEntry;
import com.oracle.bmc.resourcescheduler.model.WorkRequestSummary;
import com.oracle.bmc.resourcescheduler.requests.ListResourceTypesRequest;
import com.oracle.bmc.resourcescheduler.requests.ListSchedulesRequest;
import com.oracle.bmc.resourcescheduler.requests.ListWorkRequestErrorsRequest;
import com.oracle.bmc.resourcescheduler.requests.ListWorkRequestLogsRequest;
import com.oracle.bmc.resourcescheduler.requests.ListWorkRequestsRequest;
import com.oracle.bmc.resourcescheduler.responses.ListResourceTypesResponse;
import com.oracle.bmc.resourcescheduler.responses.ListSchedulesResponse;
import com.oracle.bmc.resourcescheduler.responses.ListWorkRequestErrorsResponse;
import com.oracle.bmc.resourcescheduler.responses.ListWorkRequestLogsResponse;
import com.oracle.bmc.resourcescheduler.responses.ListWorkRequestsResponse;
import java.util.List;
import java.util.function.Function;
import java.util.function.Supplier;

public class SchedulePaginators {
    private final Schedule client;

    public SchedulePaginators(Schedule client) {
        this.client = client;
    }

    public Iterable<ListResourceTypesResponse> listResourceTypesResponseIterator(final ListResourceTypesRequest request) {
        return new ResponseIterable((Supplier)new Supplier<ListResourceTypesRequest.Builder>(){

            @Override
            public ListResourceTypesRequest.Builder get() {
                return ListResourceTypesRequest.builder().copy(request);
            }
        }, (Function)new Function<ListResourceTypesResponse, String>(){

            @Override
            public String apply(ListResourceTypesResponse response) {
                return response.getOpcNextPage();
            }
        }, (Function)new Function<RequestBuilderAndToken<ListResourceTypesRequest.Builder>, ListResourceTypesRequest>(){

            @Override
            public ListResourceTypesRequest apply(RequestBuilderAndToken<ListResourceTypesRequest.Builder> input) {
                if (input.getNextPageToken() == null) {
                    return ((ListResourceTypesRequest.Builder)input.getRequestBuilder()).build();
                }
                return ((ListResourceTypesRequest.Builder)input.getRequestBuilder()).page(input.getNextPageToken().orElse(null)).build();
            }
        }, (Function)new Function<ListResourceTypesRequest, ListResourceTypesResponse>(){

            @Override
            public ListResourceTypesResponse apply(ListResourceTypesRequest request) {
                return SchedulePaginators.this.client.listResourceTypes(request);
            }
        });
    }

    public Iterable<ResourceType> listResourceTypesRecordIterator(final ListResourceTypesRequest request) {
        return new ResponseRecordIterable((Supplier)new Supplier<ListResourceTypesRequest.Builder>(){

            @Override
            public ListResourceTypesRequest.Builder get() {
                return ListResourceTypesRequest.builder().copy(request);
            }
        }, (Function)new Function<ListResourceTypesResponse, String>(){

            @Override
            public String apply(ListResourceTypesResponse response) {
                return response.getOpcNextPage();
            }
        }, (Function)new Function<RequestBuilderAndToken<ListResourceTypesRequest.Builder>, ListResourceTypesRequest>(){

            @Override
            public ListResourceTypesRequest apply(RequestBuilderAndToken<ListResourceTypesRequest.Builder> input) {
                if (input.getNextPageToken() == null) {
                    return ((ListResourceTypesRequest.Builder)input.getRequestBuilder()).build();
                }
                return ((ListResourceTypesRequest.Builder)input.getRequestBuilder()).page(input.getNextPageToken().orElse(null)).build();
            }
        }, (Function)new Function<ListResourceTypesRequest, ListResourceTypesResponse>(){

            @Override
            public ListResourceTypesResponse apply(ListResourceTypesRequest request) {
                return SchedulePaginators.this.client.listResourceTypes(request);
            }
        }, (Function)new Function<ListResourceTypesResponse, List<ResourceType>>(){

            @Override
            public List<ResourceType> apply(ListResourceTypesResponse response) {
                return response.getResourceTypeCollection().getItems();
            }
        });
    }

    public Iterable<ListSchedulesResponse> listSchedulesResponseIterator(final ListSchedulesRequest request) {
        return new ResponseIterable((Supplier)new Supplier<ListSchedulesRequest.Builder>(){

            @Override
            public ListSchedulesRequest.Builder get() {
                return ListSchedulesRequest.builder().copy(request);
            }
        }, (Function)new Function<ListSchedulesResponse, String>(){

            @Override
            public String apply(ListSchedulesResponse response) {
                return response.getOpcNextPage();
            }
        }, (Function)new Function<RequestBuilderAndToken<ListSchedulesRequest.Builder>, ListSchedulesRequest>(){

            @Override
            public ListSchedulesRequest apply(RequestBuilderAndToken<ListSchedulesRequest.Builder> input) {
                if (input.getNextPageToken() == null) {
                    return ((ListSchedulesRequest.Builder)input.getRequestBuilder()).build();
                }
                return ((ListSchedulesRequest.Builder)input.getRequestBuilder()).page(input.getNextPageToken().orElse(null)).build();
            }
        }, (Function)new Function<ListSchedulesRequest, ListSchedulesResponse>(){

            @Override
            public ListSchedulesResponse apply(ListSchedulesRequest request) {
                return SchedulePaginators.this.client.listSchedules(request);
            }
        });
    }

    public Iterable<ScheduleSummary> listSchedulesRecordIterator(final ListSchedulesRequest request) {
        return new ResponseRecordIterable((Supplier)new Supplier<ListSchedulesRequest.Builder>(){

            @Override
            public ListSchedulesRequest.Builder get() {
                return ListSchedulesRequest.builder().copy(request);
            }
        }, (Function)new Function<ListSchedulesResponse, String>(){

            @Override
            public String apply(ListSchedulesResponse response) {
                return response.getOpcNextPage();
            }
        }, (Function)new Function<RequestBuilderAndToken<ListSchedulesRequest.Builder>, ListSchedulesRequest>(){

            @Override
            public ListSchedulesRequest apply(RequestBuilderAndToken<ListSchedulesRequest.Builder> input) {
                if (input.getNextPageToken() == null) {
                    return ((ListSchedulesRequest.Builder)input.getRequestBuilder()).build();
                }
                return ((ListSchedulesRequest.Builder)input.getRequestBuilder()).page(input.getNextPageToken().orElse(null)).build();
            }
        }, (Function)new Function<ListSchedulesRequest, ListSchedulesResponse>(){

            @Override
            public ListSchedulesResponse apply(ListSchedulesRequest request) {
                return SchedulePaginators.this.client.listSchedules(request);
            }
        }, (Function)new Function<ListSchedulesResponse, List<ScheduleSummary>>(){

            @Override
            public List<ScheduleSummary> apply(ListSchedulesResponse response) {
                return response.getScheduleCollection().getItems();
            }
        });
    }

    public Iterable<ListWorkRequestErrorsResponse> listWorkRequestErrorsResponseIterator(final ListWorkRequestErrorsRequest request) {
        return new ResponseIterable((Supplier)new Supplier<ListWorkRequestErrorsRequest.Builder>(){

            @Override
            public ListWorkRequestErrorsRequest.Builder get() {
                return ListWorkRequestErrorsRequest.builder().copy(request);
            }
        }, (Function)new Function<ListWorkRequestErrorsResponse, String>(){

            @Override
            public String apply(ListWorkRequestErrorsResponse response) {
                return response.getOpcNextPage();
            }
        }, (Function)new Function<RequestBuilderAndToken<ListWorkRequestErrorsRequest.Builder>, ListWorkRequestErrorsRequest>(){

            @Override
            public ListWorkRequestErrorsRequest apply(RequestBuilderAndToken<ListWorkRequestErrorsRequest.Builder> input) {
                if (input.getNextPageToken() == null) {
                    return ((ListWorkRequestErrorsRequest.Builder)input.getRequestBuilder()).build();
                }
                return ((ListWorkRequestErrorsRequest.Builder)input.getRequestBuilder()).page(input.getNextPageToken().orElse(null)).build();
            }
        }, (Function)new Function<ListWorkRequestErrorsRequest, ListWorkRequestErrorsResponse>(){

            @Override
            public ListWorkRequestErrorsResponse apply(ListWorkRequestErrorsRequest request) {
                return SchedulePaginators.this.client.listWorkRequestErrors(request);
            }
        });
    }

    public Iterable<WorkRequestError> listWorkRequestErrorsRecordIterator(final ListWorkRequestErrorsRequest request) {
        return new ResponseRecordIterable((Supplier)new Supplier<ListWorkRequestErrorsRequest.Builder>(){

            @Override
            public ListWorkRequestErrorsRequest.Builder get() {
                return ListWorkRequestErrorsRequest.builder().copy(request);
            }
        }, (Function)new Function<ListWorkRequestErrorsResponse, String>(){

            @Override
            public String apply(ListWorkRequestErrorsResponse response) {
                return response.getOpcNextPage();
            }
        }, (Function)new Function<RequestBuilderAndToken<ListWorkRequestErrorsRequest.Builder>, ListWorkRequestErrorsRequest>(){

            @Override
            public ListWorkRequestErrorsRequest apply(RequestBuilderAndToken<ListWorkRequestErrorsRequest.Builder> input) {
                if (input.getNextPageToken() == null) {
                    return ((ListWorkRequestErrorsRequest.Builder)input.getRequestBuilder()).build();
                }
                return ((ListWorkRequestErrorsRequest.Builder)input.getRequestBuilder()).page(input.getNextPageToken().orElse(null)).build();
            }
        }, (Function)new Function<ListWorkRequestErrorsRequest, ListWorkRequestErrorsResponse>(){

            @Override
            public ListWorkRequestErrorsResponse apply(ListWorkRequestErrorsRequest request) {
                return SchedulePaginators.this.client.listWorkRequestErrors(request);
            }
        }, (Function)new Function<ListWorkRequestErrorsResponse, List<WorkRequestError>>(){

            @Override
            public List<WorkRequestError> apply(ListWorkRequestErrorsResponse response) {
                return response.getWorkRequestErrorCollection().getItems();
            }
        });
    }

    public Iterable<ListWorkRequestLogsResponse> listWorkRequestLogsResponseIterator(final ListWorkRequestLogsRequest request) {
        return new ResponseIterable((Supplier)new Supplier<ListWorkRequestLogsRequest.Builder>(){

            @Override
            public ListWorkRequestLogsRequest.Builder get() {
                return ListWorkRequestLogsRequest.builder().copy(request);
            }
        }, (Function)new Function<ListWorkRequestLogsResponse, String>(){

            @Override
            public String apply(ListWorkRequestLogsResponse response) {
                return response.getOpcNextPage();
            }
        }, (Function)new Function<RequestBuilderAndToken<ListWorkRequestLogsRequest.Builder>, ListWorkRequestLogsRequest>(){

            @Override
            public ListWorkRequestLogsRequest apply(RequestBuilderAndToken<ListWorkRequestLogsRequest.Builder> input) {
                if (input.getNextPageToken() == null) {
                    return ((ListWorkRequestLogsRequest.Builder)input.getRequestBuilder()).build();
                }
                return ((ListWorkRequestLogsRequest.Builder)input.getRequestBuilder()).page(input.getNextPageToken().orElse(null)).build();
            }
        }, (Function)new Function<ListWorkRequestLogsRequest, ListWorkRequestLogsResponse>(){

            @Override
            public ListWorkRequestLogsResponse apply(ListWorkRequestLogsRequest request) {
                return SchedulePaginators.this.client.listWorkRequestLogs(request);
            }
        });
    }

    public Iterable<WorkRequestLogEntry> listWorkRequestLogsRecordIterator(final ListWorkRequestLogsRequest request) {
        return new ResponseRecordIterable((Supplier)new Supplier<ListWorkRequestLogsRequest.Builder>(){

            @Override
            public ListWorkRequestLogsRequest.Builder get() {
                return ListWorkRequestLogsRequest.builder().copy(request);
            }
        }, (Function)new Function<ListWorkRequestLogsResponse, String>(){

            @Override
            public String apply(ListWorkRequestLogsResponse response) {
                return response.getOpcNextPage();
            }
        }, (Function)new Function<RequestBuilderAndToken<ListWorkRequestLogsRequest.Builder>, ListWorkRequestLogsRequest>(){

            @Override
            public ListWorkRequestLogsRequest apply(RequestBuilderAndToken<ListWorkRequestLogsRequest.Builder> input) {
                if (input.getNextPageToken() == null) {
                    return ((ListWorkRequestLogsRequest.Builder)input.getRequestBuilder()).build();
                }
                return ((ListWorkRequestLogsRequest.Builder)input.getRequestBuilder()).page(input.getNextPageToken().orElse(null)).build();
            }
        }, (Function)new Function<ListWorkRequestLogsRequest, ListWorkRequestLogsResponse>(){

            @Override
            public ListWorkRequestLogsResponse apply(ListWorkRequestLogsRequest request) {
                return SchedulePaginators.this.client.listWorkRequestLogs(request);
            }
        }, (Function)new Function<ListWorkRequestLogsResponse, List<WorkRequestLogEntry>>(){

            @Override
            public List<WorkRequestLogEntry> apply(ListWorkRequestLogsResponse response) {
                return response.getWorkRequestLogEntryCollection().getItems();
            }
        });
    }

    public Iterable<ListWorkRequestsResponse> listWorkRequestsResponseIterator(final ListWorkRequestsRequest request) {
        return new ResponseIterable((Supplier)new Supplier<ListWorkRequestsRequest.Builder>(){

            @Override
            public ListWorkRequestsRequest.Builder get() {
                return ListWorkRequestsRequest.builder().copy(request);
            }
        }, (Function)new Function<ListWorkRequestsResponse, String>(){

            @Override
            public String apply(ListWorkRequestsResponse response) {
                return response.getOpcNextPage();
            }
        }, (Function)new Function<RequestBuilderAndToken<ListWorkRequestsRequest.Builder>, ListWorkRequestsRequest>(){

            @Override
            public ListWorkRequestsRequest apply(RequestBuilderAndToken<ListWorkRequestsRequest.Builder> input) {
                if (input.getNextPageToken() == null) {
                    return ((ListWorkRequestsRequest.Builder)input.getRequestBuilder()).build();
                }
                return ((ListWorkRequestsRequest.Builder)input.getRequestBuilder()).page(input.getNextPageToken().orElse(null)).build();
            }
        }, (Function)new Function<ListWorkRequestsRequest, ListWorkRequestsResponse>(){

            @Override
            public ListWorkRequestsResponse apply(ListWorkRequestsRequest request) {
                return SchedulePaginators.this.client.listWorkRequests(request);
            }
        });
    }

    public Iterable<WorkRequestSummary> listWorkRequestsRecordIterator(final ListWorkRequestsRequest request) {
        return new ResponseRecordIterable((Supplier)new Supplier<ListWorkRequestsRequest.Builder>(){

            @Override
            public ListWorkRequestsRequest.Builder get() {
                return ListWorkRequestsRequest.builder().copy(request);
            }
        }, (Function)new Function<ListWorkRequestsResponse, String>(){

            @Override
            public String apply(ListWorkRequestsResponse response) {
                return response.getOpcNextPage();
            }
        }, (Function)new Function<RequestBuilderAndToken<ListWorkRequestsRequest.Builder>, ListWorkRequestsRequest>(){

            @Override
            public ListWorkRequestsRequest apply(RequestBuilderAndToken<ListWorkRequestsRequest.Builder> input) {
                if (input.getNextPageToken() == null) {
                    return ((ListWorkRequestsRequest.Builder)input.getRequestBuilder()).build();
                }
                return ((ListWorkRequestsRequest.Builder)input.getRequestBuilder()).page(input.getNextPageToken().orElse(null)).build();
            }
        }, (Function)new Function<ListWorkRequestsRequest, ListWorkRequestsResponse>(){

            @Override
            public ListWorkRequestsResponse apply(ListWorkRequestsRequest request) {
                return SchedulePaginators.this.client.listWorkRequests(request);
            }
        }, (Function)new Function<ListWorkRequestsResponse, List<WorkRequestSummary>>(){

            @Override
            public List<WorkRequestSummary> apply(ListWorkRequestsResponse response) {
                return response.getWorkRequestSummaryCollection().getItems();
            }
        });
    }
}

