/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.resourcescheduler.model;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonFilter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonValue;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonPOJOBuilder;
import com.oracle.bmc.http.client.internal.ExplicitlySetBmcModel;
import com.oracle.bmc.http.internal.BmcEnum;
import com.oracle.bmc.resourcescheduler.model.Resource;
import com.oracle.bmc.resourcescheduler.model.ResourceFilter;
import java.beans.ConstructorProperties;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;

@JsonDeserialize(builder=Builder.class)
@JsonFilter(value="explicitlySetFilter")
public final class UpdateScheduleDetails
extends ExplicitlySetBmcModel {
    @JsonProperty(value="displayName")
    private final String displayName;
    @JsonProperty(value="description")
    private final String description;
    @JsonProperty(value="action")
    private final Action action;
    @JsonProperty(value="recurrenceDetails")
    private final String recurrenceDetails;
    @JsonProperty(value="recurrenceType")
    private final RecurrenceType recurrenceType;
    @JsonProperty(value="resourceFilters")
    private final List<ResourceFilter> resourceFilters;
    @JsonProperty(value="resources")
    private final List<Resource> resources;
    @JsonProperty(value="timeStarts")
    private final Date timeStarts;
    @JsonProperty(value="timeEnds")
    private final Date timeEnds;
    @JsonProperty(value="freeformTags")
    private final Map<String, String> freeformTags;
    @JsonProperty(value="definedTags")
    private final Map<String, Map<String, Object>> definedTags;

    @Deprecated
    @ConstructorProperties(value={"displayName", "description", "action", "recurrenceDetails", "recurrenceType", "resourceFilters", "resources", "timeStarts", "timeEnds", "freeformTags", "definedTags"})
    public UpdateScheduleDetails(String displayName, String description, Action action, String recurrenceDetails, RecurrenceType recurrenceType, List<ResourceFilter> resourceFilters, List<Resource> resources, Date timeStarts, Date timeEnds, Map<String, String> freeformTags, Map<String, Map<String, Object>> definedTags) {
        this.displayName = displayName;
        this.description = description;
        this.action = action;
        this.recurrenceDetails = recurrenceDetails;
        this.recurrenceType = recurrenceType;
        this.resourceFilters = resourceFilters;
        this.resources = resources;
        this.timeStarts = timeStarts;
        this.timeEnds = timeEnds;
        this.freeformTags = freeformTags;
        this.definedTags = definedTags;
    }

    public static Builder builder() {
        return new Builder();
    }

    public Builder toBuilder() {
        return new Builder().copy(this);
    }

    public String getDisplayName() {
        return this.displayName;
    }

    public String getDescription() {
        return this.description;
    }

    public Action getAction() {
        return this.action;
    }

    public String getRecurrenceDetails() {
        return this.recurrenceDetails;
    }

    public RecurrenceType getRecurrenceType() {
        return this.recurrenceType;
    }

    public List<ResourceFilter> getResourceFilters() {
        return this.resourceFilters;
    }

    public List<Resource> getResources() {
        return this.resources;
    }

    public Date getTimeStarts() {
        return this.timeStarts;
    }

    public Date getTimeEnds() {
        return this.timeEnds;
    }

    public Map<String, String> getFreeformTags() {
        return this.freeformTags;
    }

    public Map<String, Map<String, Object>> getDefinedTags() {
        return this.definedTags;
    }

    public String toString() {
        return this.toString(true);
    }

    public String toString(boolean includeByteArrayContents) {
        StringBuilder sb = new StringBuilder();
        sb.append("UpdateScheduleDetails(");
        sb.append("super=").append(super.toString());
        sb.append("displayName=").append(String.valueOf(this.displayName));
        sb.append(", description=").append(String.valueOf(this.description));
        sb.append(", action=").append(String.valueOf((Object)this.action));
        sb.append(", recurrenceDetails=").append(String.valueOf(this.recurrenceDetails));
        sb.append(", recurrenceType=").append(String.valueOf((Object)this.recurrenceType));
        sb.append(", resourceFilters=").append(String.valueOf(this.resourceFilters));
        sb.append(", resources=").append(String.valueOf(this.resources));
        sb.append(", timeStarts=").append(String.valueOf(this.timeStarts));
        sb.append(", timeEnds=").append(String.valueOf(this.timeEnds));
        sb.append(", freeformTags=").append(String.valueOf(this.freeformTags));
        sb.append(", definedTags=").append(String.valueOf(this.definedTags));
        sb.append(")");
        return sb.toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof UpdateScheduleDetails)) {
            return false;
        }
        UpdateScheduleDetails other = (UpdateScheduleDetails)((Object)o);
        return Objects.equals(this.displayName, other.displayName) && Objects.equals(this.description, other.description) && Objects.equals((Object)this.action, (Object)other.action) && Objects.equals(this.recurrenceDetails, other.recurrenceDetails) && Objects.equals((Object)this.recurrenceType, (Object)other.recurrenceType) && Objects.equals(this.resourceFilters, other.resourceFilters) && Objects.equals(this.resources, other.resources) && Objects.equals(this.timeStarts, other.timeStarts) && Objects.equals(this.timeEnds, other.timeEnds) && Objects.equals(this.freeformTags, other.freeformTags) && Objects.equals(this.definedTags, other.definedTags) && super.equals((Object)other);
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + (this.displayName == null ? 43 : this.displayName.hashCode());
        result = result * 59 + (this.description == null ? 43 : this.description.hashCode());
        result = result * 59 + (this.action == null ? 43 : this.action.hashCode());
        result = result * 59 + (this.recurrenceDetails == null ? 43 : this.recurrenceDetails.hashCode());
        result = result * 59 + (this.recurrenceType == null ? 43 : this.recurrenceType.hashCode());
        result = result * 59 + (this.resourceFilters == null ? 43 : this.resourceFilters.hashCode());
        result = result * 59 + (this.resources == null ? 43 : this.resources.hashCode());
        result = result * 59 + (this.timeStarts == null ? 43 : this.timeStarts.hashCode());
        result = result * 59 + (this.timeEnds == null ? 43 : this.timeEnds.hashCode());
        result = result * 59 + (this.freeformTags == null ? 43 : this.freeformTags.hashCode());
        result = result * 59 + (this.definedTags == null ? 43 : this.definedTags.hashCode());
        result = result * 59 + super.hashCode();
        return result;
    }

    public static enum RecurrenceType implements BmcEnum
    {
        Cron("CRON"),
        Ical("ICAL");

        private final String value;
        private static Map<String, RecurrenceType> map;

        private RecurrenceType(String value) {
            this.value = value;
        }

        @JsonValue
        public String getValue() {
            return this.value;
        }

        @JsonCreator
        public static RecurrenceType create(String key) {
            if (map.containsKey(key)) {
                return map.get(key);
            }
            throw new IllegalArgumentException("Invalid RecurrenceType: " + key);
        }

        static {
            map = new HashMap<String, RecurrenceType>();
            for (RecurrenceType v : RecurrenceType.values()) {
                map.put(v.getValue(), v);
            }
        }
    }

    public static enum Action implements BmcEnum
    {
        StartResource("START_RESOURCE"),
        StopResource("STOP_RESOURCE");

        private final String value;
        private static Map<String, Action> map;

        private Action(String value) {
            this.value = value;
        }

        @JsonValue
        public String getValue() {
            return this.value;
        }

        @JsonCreator
        public static Action create(String key) {
            if (map.containsKey(key)) {
                return map.get(key);
            }
            throw new IllegalArgumentException("Invalid Action: " + key);
        }

        static {
            map = new HashMap<String, Action>();
            for (Action v : Action.values()) {
                map.put(v.getValue(), v);
            }
        }
    }

    @JsonPOJOBuilder(withPrefix="")
    public static class Builder {
        @JsonProperty(value="displayName")
        private String displayName;
        @JsonProperty(value="description")
        private String description;
        @JsonProperty(value="action")
        private Action action;
        @JsonProperty(value="recurrenceDetails")
        private String recurrenceDetails;
        @JsonProperty(value="recurrenceType")
        private RecurrenceType recurrenceType;
        @JsonProperty(value="resourceFilters")
        private List<ResourceFilter> resourceFilters;
        @JsonProperty(value="resources")
        private List<Resource> resources;
        @JsonProperty(value="timeStarts")
        private Date timeStarts;
        @JsonProperty(value="timeEnds")
        private Date timeEnds;
        @JsonProperty(value="freeformTags")
        private Map<String, String> freeformTags;
        @JsonProperty(value="definedTags")
        private Map<String, Map<String, Object>> definedTags;
        @JsonIgnore
        private final Set<String> __explicitlySet__ = new HashSet<String>();

        public Builder displayName(String displayName) {
            this.displayName = displayName;
            this.__explicitlySet__.add("displayName");
            return this;
        }

        public Builder description(String description) {
            this.description = description;
            this.__explicitlySet__.add("description");
            return this;
        }

        public Builder action(Action action) {
            this.action = action;
            this.__explicitlySet__.add("action");
            return this;
        }

        public Builder recurrenceDetails(String recurrenceDetails) {
            this.recurrenceDetails = recurrenceDetails;
            this.__explicitlySet__.add("recurrenceDetails");
            return this;
        }

        public Builder recurrenceType(RecurrenceType recurrenceType) {
            this.recurrenceType = recurrenceType;
            this.__explicitlySet__.add("recurrenceType");
            return this;
        }

        public Builder resourceFilters(List<ResourceFilter> resourceFilters) {
            this.resourceFilters = resourceFilters;
            this.__explicitlySet__.add("resourceFilters");
            return this;
        }

        public Builder resources(List<Resource> resources) {
            this.resources = resources;
            this.__explicitlySet__.add("resources");
            return this;
        }

        public Builder timeStarts(Date timeStarts) {
            this.timeStarts = timeStarts;
            this.__explicitlySet__.add("timeStarts");
            return this;
        }

        public Builder timeEnds(Date timeEnds) {
            this.timeEnds = timeEnds;
            this.__explicitlySet__.add("timeEnds");
            return this;
        }

        public Builder freeformTags(Map<String, String> freeformTags) {
            this.freeformTags = freeformTags;
            this.__explicitlySet__.add("freeformTags");
            return this;
        }

        public Builder definedTags(Map<String, Map<String, Object>> definedTags) {
            this.definedTags = definedTags;
            this.__explicitlySet__.add("definedTags");
            return this;
        }

        public UpdateScheduleDetails build() {
            UpdateScheduleDetails model = new UpdateScheduleDetails(this.displayName, this.description, this.action, this.recurrenceDetails, this.recurrenceType, this.resourceFilters, this.resources, this.timeStarts, this.timeEnds, this.freeformTags, this.definedTags);
            for (String explicitlySetProperty : this.__explicitlySet__) {
                model.markPropertyAsExplicitlySet(explicitlySetProperty);
            }
            return model;
        }

        @JsonIgnore
        public Builder copy(UpdateScheduleDetails model) {
            if (model.wasPropertyExplicitlySet("displayName")) {
                this.displayName(model.getDisplayName());
            }
            if (model.wasPropertyExplicitlySet("description")) {
                this.description(model.getDescription());
            }
            if (model.wasPropertyExplicitlySet("action")) {
                this.action(model.getAction());
            }
            if (model.wasPropertyExplicitlySet("recurrenceDetails")) {
                this.recurrenceDetails(model.getRecurrenceDetails());
            }
            if (model.wasPropertyExplicitlySet("recurrenceType")) {
                this.recurrenceType(model.getRecurrenceType());
            }
            if (model.wasPropertyExplicitlySet("resourceFilters")) {
                this.resourceFilters(model.getResourceFilters());
            }
            if (model.wasPropertyExplicitlySet("resources")) {
                this.resources(model.getResources());
            }
            if (model.wasPropertyExplicitlySet("timeStarts")) {
                this.timeStarts(model.getTimeStarts());
            }
            if (model.wasPropertyExplicitlySet("timeEnds")) {
                this.timeEnds(model.getTimeEnds());
            }
            if (model.wasPropertyExplicitlySet("freeformTags")) {
                this.freeformTags(model.getFreeformTags());
            }
            if (model.wasPropertyExplicitlySet("definedTags")) {
                this.definedTags(model.getDefinedTags());
            }
            return this;
        }
    }
}

