/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.resourcescheduler.requests;

import com.oracle.bmc.InternalSdk;
import com.oracle.bmc.http.client.RequestInterceptor;
import com.oracle.bmc.requests.BmcRequest;
import com.oracle.bmc.resourcescheduler.model.CreateScheduleDetails;
import com.oracle.bmc.retrier.RetryConfiguration;
import java.util.Objects;

public class CreateScheduleRequest
extends BmcRequest<CreateScheduleDetails> {
    private CreateScheduleDetails createScheduleDetails;
    private String opcRetryToken;
    private String opcRequestId;

    public CreateScheduleDetails getCreateScheduleDetails() {
        return this.createScheduleDetails;
    }

    public String getOpcRetryToken() {
        return this.opcRetryToken;
    }

    public String getOpcRequestId() {
        return this.opcRequestId;
    }

    @InternalSdk
    public CreateScheduleDetails getBody$() {
        return this.createScheduleDetails;
    }

    public Builder toBuilder() {
        return new Builder().createScheduleDetails(this.createScheduleDetails).opcRetryToken(this.opcRetryToken).opcRequestId(this.opcRequestId);
    }

    public static Builder builder() {
        return new Builder();
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("(");
        sb.append("super=").append(super.toString());
        sb.append(",createScheduleDetails=").append(String.valueOf((Object)this.createScheduleDetails));
        sb.append(",opcRetryToken=").append(String.valueOf(this.opcRetryToken));
        sb.append(",opcRequestId=").append(String.valueOf(this.opcRequestId));
        sb.append(")");
        return sb.toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof CreateScheduleRequest)) {
            return false;
        }
        CreateScheduleRequest other = (CreateScheduleRequest)((Object)o);
        return super.equals(o) && Objects.equals((Object)this.createScheduleDetails, (Object)other.createScheduleDetails) && Objects.equals(this.opcRetryToken, other.opcRetryToken) && Objects.equals(this.opcRequestId, other.opcRequestId);
    }

    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        result = result * 59 + (this.createScheduleDetails == null ? 43 : this.createScheduleDetails.hashCode());
        result = result * 59 + (this.opcRetryToken == null ? 43 : this.opcRetryToken.hashCode());
        result = result * 59 + (this.opcRequestId == null ? 43 : this.opcRequestId.hashCode());
        return result;
    }

    public static class Builder
    implements BmcRequest.Builder<CreateScheduleRequest, CreateScheduleDetails> {
        private RequestInterceptor invocationCallback = null;
        private RetryConfiguration retryConfiguration = null;
        private CreateScheduleDetails createScheduleDetails = null;
        private String opcRetryToken = null;
        private String opcRequestId = null;

        public Builder createScheduleDetails(CreateScheduleDetails createScheduleDetails) {
            this.createScheduleDetails = createScheduleDetails;
            return this;
        }

        public Builder opcRetryToken(String opcRetryToken) {
            this.opcRetryToken = opcRetryToken;
            return this;
        }

        public Builder opcRequestId(String opcRequestId) {
            this.opcRequestId = opcRequestId;
            return this;
        }

        public Builder invocationCallback(RequestInterceptor invocationCallback) {
            this.invocationCallback = invocationCallback;
            return this;
        }

        public Builder retryConfiguration(RetryConfiguration retryConfiguration) {
            this.retryConfiguration = retryConfiguration;
            return this;
        }

        public Builder copy(CreateScheduleRequest o) {
            this.createScheduleDetails(o.getCreateScheduleDetails());
            this.opcRetryToken(o.getOpcRetryToken());
            this.opcRequestId(o.getOpcRequestId());
            this.invocationCallback(o.getInvocationCallback());
            this.retryConfiguration(o.getRetryConfiguration());
            return this;
        }

        public CreateScheduleRequest build() {
            CreateScheduleRequest request = this.buildWithoutInvocationCallback();
            request.setInvocationCallback(this.invocationCallback);
            request.setRetryConfiguration(this.retryConfiguration);
            return request;
        }

        @InternalSdk
        public Builder body$(CreateScheduleDetails body) {
            this.createScheduleDetails(body);
            return this;
        }

        public CreateScheduleRequest buildWithoutInvocationCallback() {
            CreateScheduleRequest request = new CreateScheduleRequest();
            request.createScheduleDetails = this.createScheduleDetails;
            request.opcRetryToken = this.opcRetryToken;
            request.opcRequestId = this.opcRequestId;
            return request;
        }
    }
}

