/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.resourcescheduler.requests;

import com.oracle.bmc.InternalSdk;
import com.oracle.bmc.http.client.RequestInterceptor;
import com.oracle.bmc.requests.BmcRequest;
import com.oracle.bmc.resourcescheduler.model.UpdateScheduleDetails;
import com.oracle.bmc.retrier.RetryConfiguration;
import java.util.Objects;

public class UpdateScheduleRequest
extends BmcRequest<UpdateScheduleDetails> {
    private String scheduleId;
    private UpdateScheduleDetails updateScheduleDetails;
    private String ifMatch;
    private String opcRequestId;

    public String getScheduleId() {
        return this.scheduleId;
    }

    public UpdateScheduleDetails getUpdateScheduleDetails() {
        return this.updateScheduleDetails;
    }

    public String getIfMatch() {
        return this.ifMatch;
    }

    public String getOpcRequestId() {
        return this.opcRequestId;
    }

    @InternalSdk
    public UpdateScheduleDetails getBody$() {
        return this.updateScheduleDetails;
    }

    public Builder toBuilder() {
        return new Builder().scheduleId(this.scheduleId).updateScheduleDetails(this.updateScheduleDetails).ifMatch(this.ifMatch).opcRequestId(this.opcRequestId);
    }

    public static Builder builder() {
        return new Builder();
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("(");
        sb.append("super=").append(super.toString());
        sb.append(",scheduleId=").append(String.valueOf(this.scheduleId));
        sb.append(",updateScheduleDetails=").append(String.valueOf((Object)this.updateScheduleDetails));
        sb.append(",ifMatch=").append(String.valueOf(this.ifMatch));
        sb.append(",opcRequestId=").append(String.valueOf(this.opcRequestId));
        sb.append(")");
        return sb.toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof UpdateScheduleRequest)) {
            return false;
        }
        UpdateScheduleRequest other = (UpdateScheduleRequest)((Object)o);
        return super.equals(o) && Objects.equals(this.scheduleId, other.scheduleId) && Objects.equals((Object)this.updateScheduleDetails, (Object)other.updateScheduleDetails) && Objects.equals(this.ifMatch, other.ifMatch) && Objects.equals(this.opcRequestId, other.opcRequestId);
    }

    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        result = result * 59 + (this.scheduleId == null ? 43 : this.scheduleId.hashCode());
        result = result * 59 + (this.updateScheduleDetails == null ? 43 : this.updateScheduleDetails.hashCode());
        result = result * 59 + (this.ifMatch == null ? 43 : this.ifMatch.hashCode());
        result = result * 59 + (this.opcRequestId == null ? 43 : this.opcRequestId.hashCode());
        return result;
    }

    public static class Builder
    implements BmcRequest.Builder<UpdateScheduleRequest, UpdateScheduleDetails> {
        private RequestInterceptor invocationCallback = null;
        private RetryConfiguration retryConfiguration = null;
        private String scheduleId = null;
        private UpdateScheduleDetails updateScheduleDetails = null;
        private String ifMatch = null;
        private String opcRequestId = null;

        public Builder scheduleId(String scheduleId) {
            this.scheduleId = scheduleId;
            return this;
        }

        public Builder updateScheduleDetails(UpdateScheduleDetails updateScheduleDetails) {
            this.updateScheduleDetails = updateScheduleDetails;
            return this;
        }

        public Builder ifMatch(String ifMatch) {
            this.ifMatch = ifMatch;
            return this;
        }

        public Builder opcRequestId(String opcRequestId) {
            this.opcRequestId = opcRequestId;
            return this;
        }

        public Builder invocationCallback(RequestInterceptor invocationCallback) {
            this.invocationCallback = invocationCallback;
            return this;
        }

        public Builder retryConfiguration(RetryConfiguration retryConfiguration) {
            this.retryConfiguration = retryConfiguration;
            return this;
        }

        public Builder copy(UpdateScheduleRequest o) {
            this.scheduleId(o.getScheduleId());
            this.updateScheduleDetails(o.getUpdateScheduleDetails());
            this.ifMatch(o.getIfMatch());
            this.opcRequestId(o.getOpcRequestId());
            this.invocationCallback(o.getInvocationCallback());
            this.retryConfiguration(o.getRetryConfiguration());
            return this;
        }

        public UpdateScheduleRequest build() {
            UpdateScheduleRequest request = this.buildWithoutInvocationCallback();
            request.setInvocationCallback(this.invocationCallback);
            request.setRetryConfiguration(this.retryConfiguration);
            return request;
        }

        @InternalSdk
        public Builder body$(UpdateScheduleDetails body) {
            this.updateScheduleDetails(body);
            return this;
        }

        public UpdateScheduleRequest buildWithoutInvocationCallback() {
            UpdateScheduleRequest request = new UpdateScheduleRequest();
            request.scheduleId = this.scheduleId;
            request.updateScheduleDetails = this.updateScheduleDetails;
            request.ifMatch = this.ifMatch;
            request.opcRequestId = this.opcRequestId;
            return request;
        }
    }
}

