/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.resourcesearch;

import com.google.common.base.Function;
import com.google.common.base.Optional;
import com.google.common.base.Supplier;
import com.oracle.bmc.ClientConfiguration;
import com.oracle.bmc.Region;
import com.oracle.bmc.Service;
import com.oracle.bmc.Services;
import com.oracle.bmc.auth.AbstractAuthenticationDetailsProvider;
import com.oracle.bmc.auth.BasicAuthenticationDetailsProvider;
import com.oracle.bmc.auth.RefreshableOnNotAuthenticatedProvider;
import com.oracle.bmc.auth.RegionProvider;
import com.oracle.bmc.common.RegionalClientBuilder;
import com.oracle.bmc.http.ClientConfigurator;
import com.oracle.bmc.http.internal.ErrorConsumer;
import com.oracle.bmc.http.internal.RestClient;
import com.oracle.bmc.http.internal.RestClientFactory;
import com.oracle.bmc.http.internal.RestClientFactoryBuilder;
import com.oracle.bmc.http.internal.SuccessConsumer;
import com.oracle.bmc.http.internal.WrappedInvocationBuilder;
import com.oracle.bmc.http.signing.RequestSigner;
import com.oracle.bmc.http.signing.RequestSignerFactory;
import com.oracle.bmc.http.signing.SigningStrategy;
import com.oracle.bmc.http.signing.internal.DefaultRequestSignerFactory;
import com.oracle.bmc.requests.BmcRequest;
import com.oracle.bmc.resourcesearch.ResourceSearchAsync;
import com.oracle.bmc.resourcesearch.internal.http.GetResourceTypeConverter;
import com.oracle.bmc.resourcesearch.internal.http.ListResourceTypesConverter;
import com.oracle.bmc.resourcesearch.internal.http.SearchResourcesConverter;
import com.oracle.bmc.resourcesearch.requests.GetResourceTypeRequest;
import com.oracle.bmc.resourcesearch.requests.ListResourceTypesRequest;
import com.oracle.bmc.resourcesearch.requests.SearchResourcesRequest;
import com.oracle.bmc.resourcesearch.responses.GetResourceTypeResponse;
import com.oracle.bmc.resourcesearch.responses.ListResourceTypesResponse;
import com.oracle.bmc.resourcesearch.responses.SearchResourcesResponse;
import com.oracle.bmc.responses.AsyncHandler;
import com.oracle.bmc.util.internal.Consumer;
import com.oracle.bmc.util.internal.RefreshAuthTokenTransformingFuture;
import com.oracle.bmc.util.internal.RefreshAuthTokenWrappingAsyncHandler;
import com.oracle.bmc.util.internal.TransformingFuture;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.concurrent.Future;
import javax.ws.rs.core.Response;
import lombok.NonNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ResourceSearchAsyncClient
implements ResourceSearchAsync {
    private static final Logger LOG = LoggerFactory.getLogger(ResourceSearchAsyncClient.class);
    public static final Service SERVICE = Services.serviceBuilder().serviceName("RESOURCESEARCH").serviceEndpointPrefix("query").serviceEndpointTemplate("https://query.{region}.{secondLevelDomain}").build();
    private final RestClient client;
    private final AbstractAuthenticationDetailsProvider authenticationDetailsProvider;

    public ResourceSearchAsyncClient(BasicAuthenticationDetailsProvider authenticationDetailsProvider) {
        this(authenticationDetailsProvider, null);
    }

    public ResourceSearchAsyncClient(BasicAuthenticationDetailsProvider authenticationDetailsProvider, ClientConfiguration configuration) {
        this(authenticationDetailsProvider, configuration, null);
    }

    public ResourceSearchAsyncClient(BasicAuthenticationDetailsProvider authenticationDetailsProvider, ClientConfiguration configuration, ClientConfigurator clientConfigurator) {
        this((AbstractAuthenticationDetailsProvider)authenticationDetailsProvider, configuration, clientConfigurator, (RequestSignerFactory)new DefaultRequestSignerFactory(SigningStrategy.STANDARD));
    }

    public ResourceSearchAsyncClient(AbstractAuthenticationDetailsProvider authenticationDetailsProvider, ClientConfiguration configuration, ClientConfigurator clientConfigurator, RequestSignerFactory defaultRequestSignerFactory) {
        this(authenticationDetailsProvider, configuration, clientConfigurator, defaultRequestSignerFactory, new ArrayList<ClientConfigurator>());
    }

    public ResourceSearchAsyncClient(AbstractAuthenticationDetailsProvider authenticationDetailsProvider, ClientConfiguration configuration, ClientConfigurator clientConfigurator, RequestSignerFactory defaultRequestSignerFactory, List<ClientConfigurator> additionalClientConfigurators) {
        this(authenticationDetailsProvider, configuration, clientConfigurator, defaultRequestSignerFactory, additionalClientConfigurators, null);
    }

    public ResourceSearchAsyncClient(AbstractAuthenticationDetailsProvider authenticationDetailsProvider, ClientConfiguration configuration, ClientConfigurator clientConfigurator, RequestSignerFactory defaultRequestSignerFactory, List<ClientConfigurator> additionalClientConfigurators, String endpoint) {
        this(authenticationDetailsProvider, configuration, clientConfigurator, defaultRequestSignerFactory, DefaultRequestSignerFactory.createDefaultRequestSignerFactories(), additionalClientConfigurators, endpoint);
    }

    public ResourceSearchAsyncClient(AbstractAuthenticationDetailsProvider authenticationDetailsProvider, ClientConfiguration configuration, ClientConfigurator clientConfigurator, RequestSignerFactory defaultRequestSignerFactory, Map<SigningStrategy, RequestSignerFactory> signingStrategyRequestSignerFactories, List<ClientConfigurator> additionalClientConfigurators, String endpoint) {
        RegionProvider provider;
        this.authenticationDetailsProvider = authenticationDetailsProvider;
        RestClientFactory restClientFactory = RestClientFactoryBuilder.builder().clientConfigurator(clientConfigurator).additionalClientConfigurators(additionalClientConfigurators).build();
        RequestSigner defaultRequestSigner = defaultRequestSignerFactory.createRequestSigner(SERVICE, this.authenticationDetailsProvider);
        HashMap<SigningStrategy, RequestSigner> requestSigners = new HashMap<SigningStrategy, RequestSigner>();
        if (this.authenticationDetailsProvider instanceof BasicAuthenticationDetailsProvider) {
            for (SigningStrategy s : SigningStrategy.values()) {
                requestSigners.put(s, signingStrategyRequestSignerFactories.get(s).createRequestSigner(SERVICE, authenticationDetailsProvider));
            }
        }
        this.client = restClientFactory.create(defaultRequestSigner, requestSigners, configuration);
        if (this.authenticationDetailsProvider instanceof RegionProvider && (provider = (RegionProvider)this.authenticationDetailsProvider).getRegion() != null) {
            this.setRegion(provider.getRegion());
            if (endpoint != null) {
                LOG.info("Authentication details provider configured for region '{}', but endpoint specifically set to '{}'. Using endpoint setting instead of region.", (Object)provider.getRegion(), (Object)endpoint);
            }
        }
        if (endpoint != null) {
            this.setEndpoint(endpoint);
        }
    }

    public static Builder builder() {
        return new Builder(SERVICE);
    }

    @Override
    public void setEndpoint(String endpoint) {
        LOG.info("Setting endpoint to {}", (Object)endpoint);
        this.client.setEndpoint(endpoint);
    }

    @Override
    public void setRegion(Region region) {
        Optional endpoint = region.getEndpoint(SERVICE);
        if (!endpoint.isPresent()) {
            throw new IllegalArgumentException("Endpoint for " + SERVICE + " is not known in region " + region);
        }
        this.setEndpoint((String)endpoint.get());
    }

    @Override
    public void setRegion(String regionId) {
        regionId = regionId.toLowerCase(Locale.ENGLISH);
        try {
            Region region = Region.fromRegionId((String)regionId);
            this.setRegion(region);
        }
        catch (IllegalArgumentException e) {
            LOG.info("Unknown regionId '{}', falling back to default endpoint format", (Object)regionId);
            String endpoint = Region.formatDefaultRegionEndpoint((Service)SERVICE, (String)regionId);
            this.setEndpoint(endpoint);
        }
    }

    @Override
    public void close() {
        this.client.close();
    }

    @Override
    public Future<GetResourceTypeResponse> getResourceType(GetResourceTypeRequest request, AsyncHandler<GetResourceTypeRequest, GetResourceTypeResponse> handler) {
        LOG.trace("Called async getResourceType");
        final GetResourceTypeRequest interceptedRequest = GetResourceTypeConverter.interceptRequest(request);
        final WrappedInvocationBuilder ib = GetResourceTypeConverter.fromRequest(this.client, interceptedRequest);
        final Function<Response, GetResourceTypeResponse> transformer = GetResourceTypeConverter.fromResponse();
        Object handlerToUse = handler;
        if (handler != null && this.authenticationDetailsProvider instanceof RefreshableOnNotAuthenticatedProvider) {
            handlerToUse = new RefreshAuthTokenWrappingAsyncHandler<GetResourceTypeRequest, GetResourceTypeResponse>((RefreshableOnNotAuthenticatedProvider)this.authenticationDetailsProvider, handler){

                public void retryCall() {
                    SuccessConsumer onSuccess = new SuccessConsumer((AsyncHandler)this, transformer, (Object)interceptedRequest);
                    ErrorConsumer onError = new ErrorConsumer((AsyncHandler)this, (Object)interceptedRequest);
                    ResourceSearchAsyncClient.this.client.get(ib, (BmcRequest)interceptedRequest, (Consumer)onSuccess, (Consumer)onError);
                }
            };
        }
        SuccessConsumer onSuccess = handler == null ? null : new SuccessConsumer(handlerToUse, transformer, (Object)interceptedRequest);
        ErrorConsumer onError = handler == null ? null : new ErrorConsumer(handlerToUse, (Object)interceptedRequest);
        Future responseFuture = this.client.get(ib, (BmcRequest)interceptedRequest, (Consumer)onSuccess, (Consumer)onError);
        if (this.authenticationDetailsProvider instanceof RefreshableOnNotAuthenticatedProvider) {
            return new RefreshAuthTokenTransformingFuture(responseFuture, transformer, (RefreshableOnNotAuthenticatedProvider)this.authenticationDetailsProvider, (Supplier)new Supplier<Future<Response>>((Consumer)onSuccess, (Consumer)onError){
                final /* synthetic */ Consumer val$onSuccess;
                final /* synthetic */ Consumer val$onError;
                {
                    this.val$onSuccess = consumer;
                    this.val$onError = consumer2;
                }

                public Future<Response> get() {
                    return ResourceSearchAsyncClient.this.client.get(ib, (BmcRequest)interceptedRequest, this.val$onSuccess, this.val$onError);
                }
            });
        }
        return new TransformingFuture(responseFuture, transformer);
    }

    @Override
    public Future<ListResourceTypesResponse> listResourceTypes(ListResourceTypesRequest request, AsyncHandler<ListResourceTypesRequest, ListResourceTypesResponse> handler) {
        LOG.trace("Called async listResourceTypes");
        final ListResourceTypesRequest interceptedRequest = ListResourceTypesConverter.interceptRequest(request);
        final WrappedInvocationBuilder ib = ListResourceTypesConverter.fromRequest(this.client, interceptedRequest);
        final Function<Response, ListResourceTypesResponse> transformer = ListResourceTypesConverter.fromResponse();
        Object handlerToUse = handler;
        if (handler != null && this.authenticationDetailsProvider instanceof RefreshableOnNotAuthenticatedProvider) {
            handlerToUse = new RefreshAuthTokenWrappingAsyncHandler<ListResourceTypesRequest, ListResourceTypesResponse>((RefreshableOnNotAuthenticatedProvider)this.authenticationDetailsProvider, handler){

                public void retryCall() {
                    SuccessConsumer onSuccess = new SuccessConsumer((AsyncHandler)this, transformer, (Object)interceptedRequest);
                    ErrorConsumer onError = new ErrorConsumer((AsyncHandler)this, (Object)interceptedRequest);
                    ResourceSearchAsyncClient.this.client.get(ib, (BmcRequest)interceptedRequest, (Consumer)onSuccess, (Consumer)onError);
                }
            };
        }
        SuccessConsumer onSuccess = handler == null ? null : new SuccessConsumer(handlerToUse, transformer, (Object)interceptedRequest);
        ErrorConsumer onError = handler == null ? null : new ErrorConsumer(handlerToUse, (Object)interceptedRequest);
        Future responseFuture = this.client.get(ib, (BmcRequest)interceptedRequest, (Consumer)onSuccess, (Consumer)onError);
        if (this.authenticationDetailsProvider instanceof RefreshableOnNotAuthenticatedProvider) {
            return new RefreshAuthTokenTransformingFuture(responseFuture, transformer, (RefreshableOnNotAuthenticatedProvider)this.authenticationDetailsProvider, (Supplier)new Supplier<Future<Response>>((Consumer)onSuccess, (Consumer)onError){
                final /* synthetic */ Consumer val$onSuccess;
                final /* synthetic */ Consumer val$onError;
                {
                    this.val$onSuccess = consumer;
                    this.val$onError = consumer2;
                }

                public Future<Response> get() {
                    return ResourceSearchAsyncClient.this.client.get(ib, (BmcRequest)interceptedRequest, this.val$onSuccess, this.val$onError);
                }
            });
        }
        return new TransformingFuture(responseFuture, transformer);
    }

    @Override
    public Future<SearchResourcesResponse> searchResources(SearchResourcesRequest request, AsyncHandler<SearchResourcesRequest, SearchResourcesResponse> handler) {
        LOG.trace("Called async searchResources");
        final SearchResourcesRequest interceptedRequest = SearchResourcesConverter.interceptRequest(request);
        final WrappedInvocationBuilder ib = SearchResourcesConverter.fromRequest(this.client, interceptedRequest);
        final Function<Response, SearchResourcesResponse> transformer = SearchResourcesConverter.fromResponse();
        Object handlerToUse = handler;
        if (handler != null && this.authenticationDetailsProvider instanceof RefreshableOnNotAuthenticatedProvider) {
            handlerToUse = new RefreshAuthTokenWrappingAsyncHandler<SearchResourcesRequest, SearchResourcesResponse>((RefreshableOnNotAuthenticatedProvider)this.authenticationDetailsProvider, handler){

                public void retryCall() {
                    SuccessConsumer onSuccess = new SuccessConsumer((AsyncHandler)this, transformer, (Object)interceptedRequest);
                    ErrorConsumer onError = new ErrorConsumer((AsyncHandler)this, (Object)interceptedRequest);
                    ResourceSearchAsyncClient.this.client.post(ib, (Object)interceptedRequest.getSearchDetails(), (BmcRequest)interceptedRequest, (Consumer)onSuccess, (Consumer)onError);
                }
            };
        }
        SuccessConsumer onSuccess = handler == null ? null : new SuccessConsumer(handlerToUse, transformer, (Object)interceptedRequest);
        ErrorConsumer onError = handler == null ? null : new ErrorConsumer(handlerToUse, (Object)interceptedRequest);
        Future responseFuture = this.client.post(ib, (Object)interceptedRequest.getSearchDetails(), (BmcRequest)interceptedRequest, (Consumer)onSuccess, (Consumer)onError);
        if (this.authenticationDetailsProvider instanceof RefreshableOnNotAuthenticatedProvider) {
            return new RefreshAuthTokenTransformingFuture(responseFuture, transformer, (RefreshableOnNotAuthenticatedProvider)this.authenticationDetailsProvider, (Supplier)new Supplier<Future<Response>>((Consumer)onSuccess, (Consumer)onError){
                final /* synthetic */ Consumer val$onSuccess;
                final /* synthetic */ Consumer val$onError;
                {
                    this.val$onSuccess = consumer;
                    this.val$onError = consumer2;
                }

                public Future<Response> get() {
                    return ResourceSearchAsyncClient.this.client.post(ib, (Object)interceptedRequest.getSearchDetails(), (BmcRequest)interceptedRequest, this.val$onSuccess, this.val$onError);
                }
            });
        }
        return new TransformingFuture(responseFuture, transformer);
    }

    RestClient getClient() {
        return this.client;
    }

    public static class Builder
    extends RegionalClientBuilder<Builder, ResourceSearchAsyncClient> {
        private Builder(Service service) {
            super(service);
            this.requestSignerFactory = new DefaultRequestSignerFactory(SigningStrategy.STANDARD);
        }

        public ResourceSearchAsyncClient build(@NonNull AbstractAuthenticationDetailsProvider authenticationDetailsProvider) {
            if (authenticationDetailsProvider == null) {
                throw new NullPointerException("authenticationDetailsProvider is marked @NonNull but is null");
            }
            return new ResourceSearchAsyncClient(authenticationDetailsProvider, this.configuration, this.clientConfigurator, this.requestSignerFactory, this.additionalClientConfigurators, this.endpoint);
        }
    }
}

