/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.resourcesearch.requests;

import com.oracle.bmc.requests.BmcRequest;
import com.oracle.bmc.retrier.RetryConfiguration;
import com.oracle.bmc.util.internal.Consumer;
import java.beans.ConstructorProperties;
import javax.ws.rs.client.Invocation;

public class GetResourceTypeRequest
extends BmcRequest {
    private String name;
    private String opcRequestId;

    @ConstructorProperties(value={"name", "opcRequestId"})
    GetResourceTypeRequest(String name, String opcRequestId) {
        this.name = name;
        this.opcRequestId = opcRequestId;
    }

    public static Builder builder() {
        return new Builder();
    }

    public String getName() {
        return this.name;
    }

    public String getOpcRequestId() {
        return this.opcRequestId;
    }

    public static class Builder {
        private String name;
        private String opcRequestId;
        private Consumer<Invocation.Builder> invocationCallback = null;
        private RetryConfiguration retryConfiguration = null;

        public Builder invocationCallback(Consumer<Invocation.Builder> invocationCallback) {
            this.invocationCallback = invocationCallback;
            return this;
        }

        public Builder retryConfiguration(RetryConfiguration retryConfiguration) {
            this.retryConfiguration = retryConfiguration;
            return this;
        }

        public Builder copy(GetResourceTypeRequest o) {
            this.name(o.getName());
            this.opcRequestId(o.getOpcRequestId());
            this.invocationCallback((Consumer<Invocation.Builder>)o.getInvocationCallback());
            this.retryConfiguration(o.getRetryConfiguration());
            return this;
        }

        public GetResourceTypeRequest build() {
            GetResourceTypeRequest request = this.buildWithoutInvocationCallback();
            request.setInvocationCallback(this.invocationCallback);
            request.setRetryConfiguration(this.retryConfiguration);
            return request;
        }

        Builder() {
        }

        public Builder name(String name) {
            this.name = name;
            return this;
        }

        public Builder opcRequestId(String opcRequestId) {
            this.opcRequestId = opcRequestId;
            return this;
        }

        public GetResourceTypeRequest buildWithoutInvocationCallback() {
            return new GetResourceTypeRequest(this.name, this.opcRequestId);
        }

        public String toString() {
            return "GetResourceTypeRequest.Builder(name=" + this.name + ", opcRequestId=" + this.opcRequestId + ")";
        }
    }
}

