/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.resourcesearch.requests;

import com.oracle.bmc.requests.BmcRequest;
import com.oracle.bmc.resourcesearch.model.SearchDetails;
import com.oracle.bmc.retrier.RetryConfiguration;
import com.oracle.bmc.util.internal.Consumer;
import java.beans.ConstructorProperties;
import javax.ws.rs.client.Invocation;

public class SearchResourcesRequest
extends BmcRequest {
    private SearchDetails searchDetails;
    private Integer limit;
    private String page;
    private String opcRequestId;

    @ConstructorProperties(value={"searchDetails", "limit", "page", "opcRequestId"})
    SearchResourcesRequest(SearchDetails searchDetails, Integer limit, String page, String opcRequestId) {
        this.searchDetails = searchDetails;
        this.limit = limit;
        this.page = page;
        this.opcRequestId = opcRequestId;
    }

    public static Builder builder() {
        return new Builder();
    }

    public SearchDetails getSearchDetails() {
        return this.searchDetails;
    }

    public Integer getLimit() {
        return this.limit;
    }

    public String getPage() {
        return this.page;
    }

    public String getOpcRequestId() {
        return this.opcRequestId;
    }

    public static class Builder {
        private SearchDetails searchDetails;
        private Integer limit;
        private String page;
        private String opcRequestId;
        private Consumer<Invocation.Builder> invocationCallback = null;
        private RetryConfiguration retryConfiguration = null;

        public Builder invocationCallback(Consumer<Invocation.Builder> invocationCallback) {
            this.invocationCallback = invocationCallback;
            return this;
        }

        public Builder retryConfiguration(RetryConfiguration retryConfiguration) {
            this.retryConfiguration = retryConfiguration;
            return this;
        }

        public Builder copy(SearchResourcesRequest o) {
            this.searchDetails(o.getSearchDetails());
            this.limit(o.getLimit());
            this.page(o.getPage());
            this.opcRequestId(o.getOpcRequestId());
            this.invocationCallback((Consumer<Invocation.Builder>)o.getInvocationCallback());
            this.retryConfiguration(o.getRetryConfiguration());
            return this;
        }

        public SearchResourcesRequest build() {
            SearchResourcesRequest request = this.buildWithoutInvocationCallback();
            request.setInvocationCallback(this.invocationCallback);
            request.setRetryConfiguration(this.retryConfiguration);
            return request;
        }

        Builder() {
        }

        public Builder searchDetails(SearchDetails searchDetails) {
            this.searchDetails = searchDetails;
            return this;
        }

        public Builder limit(Integer limit) {
            this.limit = limit;
            return this;
        }

        public Builder page(String page) {
            this.page = page;
            return this;
        }

        public Builder opcRequestId(String opcRequestId) {
            this.opcRequestId = opcRequestId;
            return this;
        }

        public SearchResourcesRequest buildWithoutInvocationCallback() {
            return new SearchResourcesRequest(this.searchDetails, this.limit, this.page, this.opcRequestId);
        }

        public String toString() {
            return "SearchResourcesRequest.Builder(searchDetails=" + this.searchDetails + ", limit=" + this.limit + ", page=" + this.page + ", opcRequestId=" + this.opcRequestId + ")";
        }
    }
}

