/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.resourcesearch.responses;

import com.oracle.bmc.resourcesearch.model.ResourceType;
import java.beans.ConstructorProperties;
import java.util.List;

public class ListResourceTypesResponse {
    private String opcNextPage;
    private String opcRequestId;
    private List<ResourceType> items;

    @ConstructorProperties(value={"opcNextPage", "opcRequestId", "items"})
    ListResourceTypesResponse(String opcNextPage, String opcRequestId, List<ResourceType> items) {
        this.opcNextPage = opcNextPage;
        this.opcRequestId = opcRequestId;
        this.items = items;
    }

    public static Builder builder() {
        return new Builder();
    }

    public String getOpcNextPage() {
        return this.opcNextPage;
    }

    public String getOpcRequestId() {
        return this.opcRequestId;
    }

    public List<ResourceType> getItems() {
        return this.items;
    }

    public static class Builder {
        private String opcNextPage;
        private String opcRequestId;
        private List<ResourceType> items;

        public Builder copy(ListResourceTypesResponse o) {
            this.opcNextPage(o.getOpcNextPage());
            this.opcRequestId(o.getOpcRequestId());
            this.items(o.getItems());
            return this;
        }

        Builder() {
        }

        public Builder opcNextPage(String opcNextPage) {
            this.opcNextPage = opcNextPage;
            return this;
        }

        public Builder opcRequestId(String opcRequestId) {
            this.opcRequestId = opcRequestId;
            return this;
        }

        public Builder items(List<ResourceType> items) {
            this.items = items;
            return this;
        }

        public ListResourceTypesResponse build() {
            return new ListResourceTypesResponse(this.opcNextPage, this.opcRequestId, this.items);
        }

        public String toString() {
            return "ListResourceTypesResponse.Builder(opcNextPage=" + this.opcNextPage + ", opcRequestId=" + this.opcRequestId + ", items=" + this.items + ")";
        }
    }
}

