/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.resourcesearch.responses;

import com.oracle.bmc.resourcesearch.model.ResourceSummaryCollection;
import java.beans.ConstructorProperties;

public class SearchResourcesResponse {
    private String opcNextPage;
    private String opcRequestId;
    private ResourceSummaryCollection resourceSummaryCollection;

    @ConstructorProperties(value={"opcNextPage", "opcRequestId", "resourceSummaryCollection"})
    SearchResourcesResponse(String opcNextPage, String opcRequestId, ResourceSummaryCollection resourceSummaryCollection) {
        this.opcNextPage = opcNextPage;
        this.opcRequestId = opcRequestId;
        this.resourceSummaryCollection = resourceSummaryCollection;
    }

    public static Builder builder() {
        return new Builder();
    }

    public String getOpcNextPage() {
        return this.opcNextPage;
    }

    public String getOpcRequestId() {
        return this.opcRequestId;
    }

    public ResourceSummaryCollection getResourceSummaryCollection() {
        return this.resourceSummaryCollection;
    }

    public static class Builder {
        private String opcNextPage;
        private String opcRequestId;
        private ResourceSummaryCollection resourceSummaryCollection;

        public Builder copy(SearchResourcesResponse o) {
            this.opcNextPage(o.getOpcNextPage());
            this.opcRequestId(o.getOpcRequestId());
            this.resourceSummaryCollection(o.getResourceSummaryCollection());
            return this;
        }

        Builder() {
        }

        public Builder opcNextPage(String opcNextPage) {
            this.opcNextPage = opcNextPage;
            return this;
        }

        public Builder opcRequestId(String opcRequestId) {
            this.opcRequestId = opcRequestId;
            return this;
        }

        public Builder resourceSummaryCollection(ResourceSummaryCollection resourceSummaryCollection) {
            this.resourceSummaryCollection = resourceSummaryCollection;
            return this;
        }

        public SearchResourcesResponse build() {
            return new SearchResourcesResponse(this.opcNextPage, this.opcRequestId, this.resourceSummaryCollection);
        }

        public String toString() {
            return "SearchResourcesResponse.Builder(opcNextPage=" + this.opcNextPage + ", opcRequestId=" + this.opcRequestId + ", resourceSummaryCollection=" + this.resourceSummaryCollection + ")";
        }
    }
}

