/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.resourcesearch.requests;

import com.oracle.bmc.InternalSdk;
import com.oracle.bmc.requests.BmcRequest;
import com.oracle.bmc.resourcesearch.model.SearchDetails;
import com.oracle.bmc.retrier.RetryConfiguration;
import com.oracle.bmc.util.internal.Consumer;
import java.beans.ConstructorProperties;
import javax.ws.rs.client.Invocation;

public class SearchResourcesRequest
extends BmcRequest<SearchDetails> {
    private SearchDetails searchDetails;
    private Integer limit;
    private String page;
    private String tenantId;
    private String opcRequestId;

    @InternalSdk
    public SearchDetails getBody$() {
        return this.searchDetails;
    }

    @ConstructorProperties(value={"searchDetails", "limit", "page", "tenantId", "opcRequestId"})
    SearchResourcesRequest(SearchDetails searchDetails, Integer limit, String page, String tenantId, String opcRequestId) {
        this.searchDetails = searchDetails;
        this.limit = limit;
        this.page = page;
        this.tenantId = tenantId;
        this.opcRequestId = opcRequestId;
    }

    public static Builder builder() {
        return new Builder();
    }

    public SearchDetails getSearchDetails() {
        return this.searchDetails;
    }

    public Integer getLimit() {
        return this.limit;
    }

    public String getPage() {
        return this.page;
    }

    public String getTenantId() {
        return this.tenantId;
    }

    public String getOpcRequestId() {
        return this.opcRequestId;
    }

    public static class Builder
    implements BmcRequest.Builder<SearchResourcesRequest, SearchDetails> {
        private SearchDetails searchDetails;
        private Integer limit;
        private String page;
        private String tenantId;
        private String opcRequestId;
        private Consumer<Invocation.Builder> invocationCallback = null;
        private RetryConfiguration retryConfiguration = null;

        public Builder invocationCallback(Consumer<Invocation.Builder> invocationCallback) {
            this.invocationCallback = invocationCallback;
            return this;
        }

        public Builder retryConfiguration(RetryConfiguration retryConfiguration) {
            this.retryConfiguration = retryConfiguration;
            return this;
        }

        public Builder copy(SearchResourcesRequest o) {
            this.searchDetails(o.getSearchDetails());
            this.limit(o.getLimit());
            this.page(o.getPage());
            this.tenantId(o.getTenantId());
            this.opcRequestId(o.getOpcRequestId());
            this.invocationCallback((Consumer<Invocation.Builder>)o.getInvocationCallback());
            this.retryConfiguration(o.getRetryConfiguration());
            return this;
        }

        public SearchResourcesRequest build() {
            SearchResourcesRequest request = this.buildWithoutInvocationCallback();
            request.setInvocationCallback(this.invocationCallback);
            request.setRetryConfiguration(this.retryConfiguration);
            return request;
        }

        @InternalSdk
        public Builder body$(SearchDetails body) {
            this.searchDetails(body);
            return this;
        }

        Builder() {
        }

        public Builder searchDetails(SearchDetails searchDetails) {
            this.searchDetails = searchDetails;
            return this;
        }

        public Builder limit(Integer limit) {
            this.limit = limit;
            return this;
        }

        public Builder page(String page) {
            this.page = page;
            return this;
        }

        public Builder tenantId(String tenantId) {
            this.tenantId = tenantId;
            return this;
        }

        public Builder opcRequestId(String opcRequestId) {
            this.opcRequestId = opcRequestId;
            return this;
        }

        public SearchResourcesRequest buildWithoutInvocationCallback() {
            return new SearchResourcesRequest(this.searchDetails, this.limit, this.page, this.tenantId, this.opcRequestId);
        }

        public String toString() {
            return "SearchResourcesRequest.Builder(searchDetails=" + this.searchDetails + ", limit=" + this.limit + ", page=" + this.page + ", tenantId=" + this.tenantId + ", opcRequestId=" + this.opcRequestId + ")";
        }
    }
}

