/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.rover;

import com.google.common.base.Function;
import com.google.common.base.Supplier;
import com.oracle.bmc.paginator.internal.RequestBuilderAndToken;
import com.oracle.bmc.paginator.internal.ResponseIterable;
import com.oracle.bmc.paginator.internal.ResponseRecordIterable;
import com.oracle.bmc.rover.RoverCluster;
import com.oracle.bmc.rover.model.RoverClusterSummary;
import com.oracle.bmc.rover.requests.ListRoverClustersRequest;
import com.oracle.bmc.rover.responses.ListRoverClustersResponse;
import java.beans.ConstructorProperties;
import java.util.List;

public class RoverClusterPaginators {
    private final RoverCluster client;

    public Iterable<ListRoverClustersResponse> listRoverClustersResponseIterator(final ListRoverClustersRequest request) {
        return new ResponseIterable((Supplier)new Supplier<ListRoverClustersRequest.Builder>(){

            public ListRoverClustersRequest.Builder get() {
                return ListRoverClustersRequest.builder().copy(request);
            }
        }, (Function)new Function<ListRoverClustersResponse, String>(){

            public String apply(ListRoverClustersResponse response) {
                return response.getOpcNextPage();
            }
        }, (Function)new Function<RequestBuilderAndToken<ListRoverClustersRequest.Builder>, ListRoverClustersRequest>(){

            public ListRoverClustersRequest apply(RequestBuilderAndToken<ListRoverClustersRequest.Builder> input) {
                if (input.getToken() == null) {
                    return ((ListRoverClustersRequest.Builder)input.getRequestBuilder()).build();
                }
                return ((ListRoverClustersRequest.Builder)input.getRequestBuilder()).page((String)input.getToken().orNull()).build();
            }
        }, (Function)new Function<ListRoverClustersRequest, ListRoverClustersResponse>(){

            public ListRoverClustersResponse apply(ListRoverClustersRequest request) {
                return RoverClusterPaginators.this.client.listRoverClusters(request);
            }
        });
    }

    public Iterable<RoverClusterSummary> listRoverClustersRecordIterator(final ListRoverClustersRequest request) {
        return new ResponseRecordIterable((Supplier)new Supplier<ListRoverClustersRequest.Builder>(){

            public ListRoverClustersRequest.Builder get() {
                return ListRoverClustersRequest.builder().copy(request);
            }
        }, (Function)new Function<ListRoverClustersResponse, String>(){

            public String apply(ListRoverClustersResponse response) {
                return response.getOpcNextPage();
            }
        }, (Function)new Function<RequestBuilderAndToken<ListRoverClustersRequest.Builder>, ListRoverClustersRequest>(){

            public ListRoverClustersRequest apply(RequestBuilderAndToken<ListRoverClustersRequest.Builder> input) {
                if (input.getToken() == null) {
                    return ((ListRoverClustersRequest.Builder)input.getRequestBuilder()).build();
                }
                return ((ListRoverClustersRequest.Builder)input.getRequestBuilder()).page((String)input.getToken().orNull()).build();
            }
        }, (Function)new Function<ListRoverClustersRequest, ListRoverClustersResponse>(){

            public ListRoverClustersResponse apply(ListRoverClustersRequest request) {
                return RoverClusterPaginators.this.client.listRoverClusters(request);
            }
        }, (Function)new Function<ListRoverClustersResponse, List<RoverClusterSummary>>(){

            public List<RoverClusterSummary> apply(ListRoverClustersResponse response) {
                return response.getRoverClusterCollection().getItems();
            }
        });
    }

    @ConstructorProperties(value={"client"})
    public RoverClusterPaginators(RoverCluster client) {
        this.client = client;
    }
}

