/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.rover;

import com.google.common.base.Function;
import com.google.common.base.Optional;
import com.google.common.util.concurrent.ThreadFactoryBuilder;
import com.oracle.bmc.ClientConfiguration;
import com.oracle.bmc.Region;
import com.oracle.bmc.Service;
import com.oracle.bmc.Services;
import com.oracle.bmc.auth.AbstractAuthenticationDetailsProvider;
import com.oracle.bmc.auth.BasicAuthenticationDetailsProvider;
import com.oracle.bmc.auth.ProvidesClientConfigurators;
import com.oracle.bmc.auth.RegionProvider;
import com.oracle.bmc.common.RegionalClientBuilder;
import com.oracle.bmc.http.ClientConfigurator;
import com.oracle.bmc.http.internal.RestClient;
import com.oracle.bmc.http.internal.RestClientFactory;
import com.oracle.bmc.http.internal.RestClientFactoryBuilder;
import com.oracle.bmc.http.internal.RetryTokenUtils;
import com.oracle.bmc.http.internal.WrappedInvocationBuilder;
import com.oracle.bmc.http.signing.RequestSigner;
import com.oracle.bmc.http.signing.RequestSignerFactory;
import com.oracle.bmc.http.signing.SigningStrategy;
import com.oracle.bmc.http.signing.internal.DefaultRequestSignerFactory;
import com.oracle.bmc.requests.BmcRequest;
import com.oracle.bmc.retrier.BmcGenericRetrier;
import com.oracle.bmc.retrier.Retriers;
import com.oracle.bmc.retrier.RetryConfiguration;
import com.oracle.bmc.retrier.TokenRefreshRetrier;
import com.oracle.bmc.rover.RoverEntitlement;
import com.oracle.bmc.rover.RoverEntitlementPaginators;
import com.oracle.bmc.rover.RoverEntitlementWaiters;
import com.oracle.bmc.rover.internal.http.ChangeRoverEntitlementCompartmentConverter;
import com.oracle.bmc.rover.internal.http.CreateRoverEntitlementConverter;
import com.oracle.bmc.rover.internal.http.DeleteRoverEntitlementConverter;
import com.oracle.bmc.rover.internal.http.GetRoverEntitlementConverter;
import com.oracle.bmc.rover.internal.http.ListRoverEntitlementsConverter;
import com.oracle.bmc.rover.internal.http.UpdateRoverEntitlementConverter;
import com.oracle.bmc.rover.requests.ChangeRoverEntitlementCompartmentRequest;
import com.oracle.bmc.rover.requests.CreateRoverEntitlementRequest;
import com.oracle.bmc.rover.requests.DeleteRoverEntitlementRequest;
import com.oracle.bmc.rover.requests.GetRoverEntitlementRequest;
import com.oracle.bmc.rover.requests.ListRoverEntitlementsRequest;
import com.oracle.bmc.rover.requests.UpdateRoverEntitlementRequest;
import com.oracle.bmc.rover.responses.ChangeRoverEntitlementCompartmentResponse;
import com.oracle.bmc.rover.responses.CreateRoverEntitlementResponse;
import com.oracle.bmc.rover.responses.DeleteRoverEntitlementResponse;
import com.oracle.bmc.rover.responses.GetRoverEntitlementResponse;
import com.oracle.bmc.rover.responses.ListRoverEntitlementsResponse;
import com.oracle.bmc.rover.responses.UpdateRoverEntitlementResponse;
import java.net.URI;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import javax.ws.rs.core.Response;
import lombok.NonNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RoverEntitlementClient
implements RoverEntitlement {
    private static final Logger LOG = LoggerFactory.getLogger(RoverEntitlementClient.class);
    public static final Service SERVICE = Services.serviceBuilder().serviceName("ROVERENTITLEMENT").serviceEndpointPrefix("").serviceEndpointTemplate("https://rover.{region}.oci.{secondLevelDomain}").build();
    private static final int MAX_IMMEDIATE_RETRIES_IF_USING_INSTANCE_PRINCIPALS = 2;
    private final RoverEntitlementWaiters waiters;
    private final RoverEntitlementPaginators paginators;
    private final RestClient client;
    private final AbstractAuthenticationDetailsProvider authenticationDetailsProvider;
    private final RetryConfiguration retryConfiguration;

    public RoverEntitlementClient(BasicAuthenticationDetailsProvider authenticationDetailsProvider) {
        this(authenticationDetailsProvider, null);
    }

    public RoverEntitlementClient(BasicAuthenticationDetailsProvider authenticationDetailsProvider, ClientConfiguration configuration) {
        this(authenticationDetailsProvider, configuration, null);
    }

    public RoverEntitlementClient(BasicAuthenticationDetailsProvider authenticationDetailsProvider, ClientConfiguration configuration, ClientConfigurator clientConfigurator) {
        this((AbstractAuthenticationDetailsProvider)authenticationDetailsProvider, configuration, clientConfigurator, (RequestSignerFactory)new DefaultRequestSignerFactory(SigningStrategy.STANDARD));
    }

    public RoverEntitlementClient(AbstractAuthenticationDetailsProvider authenticationDetailsProvider, ClientConfiguration configuration, ClientConfigurator clientConfigurator, RequestSignerFactory defaultRequestSignerFactory) {
        this(authenticationDetailsProvider, configuration, clientConfigurator, defaultRequestSignerFactory, new ArrayList<ClientConfigurator>());
    }

    public RoverEntitlementClient(AbstractAuthenticationDetailsProvider authenticationDetailsProvider, ClientConfiguration configuration, ClientConfigurator clientConfigurator, RequestSignerFactory defaultRequestSignerFactory, List<ClientConfigurator> additionalClientConfigurators) {
        this(authenticationDetailsProvider, configuration, clientConfigurator, defaultRequestSignerFactory, additionalClientConfigurators, null);
    }

    public RoverEntitlementClient(AbstractAuthenticationDetailsProvider authenticationDetailsProvider, ClientConfiguration configuration, ClientConfigurator clientConfigurator, RequestSignerFactory defaultRequestSignerFactory, List<ClientConfigurator> additionalClientConfigurators, String endpoint) {
        this(authenticationDetailsProvider, configuration, clientConfigurator, defaultRequestSignerFactory, DefaultRequestSignerFactory.createDefaultRequestSignerFactories(), additionalClientConfigurators, endpoint);
    }

    public RoverEntitlementClient(AbstractAuthenticationDetailsProvider authenticationDetailsProvider, ClientConfiguration configuration, ClientConfigurator clientConfigurator, RequestSignerFactory defaultRequestSignerFactory, Map<SigningStrategy, RequestSignerFactory> signingStrategyRequestSignerFactories, List<ClientConfigurator> additionalClientConfigurators, String endpoint) {
        this(authenticationDetailsProvider, configuration, clientConfigurator, defaultRequestSignerFactory, signingStrategyRequestSignerFactories, additionalClientConfigurators, endpoint, null);
    }

    public RoverEntitlementClient(AbstractAuthenticationDetailsProvider authenticationDetailsProvider, ClientConfiguration configuration, ClientConfigurator clientConfigurator, RequestSignerFactory defaultRequestSignerFactory, Map<SigningStrategy, RequestSignerFactory> signingStrategyRequestSignerFactories, List<ClientConfigurator> additionalClientConfigurators, String endpoint, ExecutorService executorService) {
        this(authenticationDetailsProvider, configuration, clientConfigurator, defaultRequestSignerFactory, signingStrategyRequestSignerFactories, additionalClientConfigurators, endpoint, executorService, RestClientFactoryBuilder.builder());
    }

    protected RoverEntitlementClient(AbstractAuthenticationDetailsProvider authenticationDetailsProvider, ClientConfiguration configuration, ClientConfigurator clientConfigurator, RequestSignerFactory defaultRequestSignerFactory, Map<SigningStrategy, RequestSignerFactory> signingStrategyRequestSignerFactories, List<ClientConfigurator> additionalClientConfigurators, String endpoint, ExecutorService executorService, RestClientFactoryBuilder restClientFactoryBuilder) {
        RegionProvider provider;
        this.authenticationDetailsProvider = authenticationDetailsProvider;
        ArrayList authenticationDetailsConfigurators = new ArrayList();
        if (this.authenticationDetailsProvider instanceof ProvidesClientConfigurators) {
            authenticationDetailsConfigurators.addAll(((ProvidesClientConfigurators)this.authenticationDetailsProvider).getClientConfigurators());
        }
        ArrayList<ClientConfigurator> allConfigurators = new ArrayList<ClientConfigurator>(additionalClientConfigurators);
        allConfigurators.addAll(authenticationDetailsConfigurators);
        RestClientFactory restClientFactory = restClientFactoryBuilder.clientConfigurator(clientConfigurator).additionalClientConfigurators(allConfigurators).build();
        RequestSigner defaultRequestSigner = defaultRequestSignerFactory.createRequestSigner(SERVICE, this.authenticationDetailsProvider);
        HashMap<SigningStrategy, RequestSigner> requestSigners = new HashMap<SigningStrategy, RequestSigner>();
        if (this.authenticationDetailsProvider instanceof BasicAuthenticationDetailsProvider) {
            for (SigningStrategy s : SigningStrategy.values()) {
                requestSigners.put(s, signingStrategyRequestSignerFactories.get(s).createRequestSigner(SERVICE, authenticationDetailsProvider));
            }
        }
        ClientConfiguration clientConfigurationToUse = configuration != null ? configuration : ClientConfiguration.builder().build();
        this.retryConfiguration = clientConfigurationToUse.getRetryConfiguration();
        this.client = restClientFactory.create(defaultRequestSigner, requestSigners, clientConfigurationToUse);
        if (executorService == null) {
            ThreadPoolExecutor threadPoolExecutor = new ThreadPoolExecutor(50, 50, 60L, TimeUnit.SECONDS, new LinkedBlockingQueue<Runnable>(), new ThreadFactoryBuilder().setDaemon(true).setNameFormat("RoverEntitlement-waiters-%d").build());
            threadPoolExecutor.allowCoreThreadTimeOut(true);
            executorService = threadPoolExecutor;
        }
        this.waiters = new RoverEntitlementWaiters(executorService, this);
        this.paginators = new RoverEntitlementPaginators(this);
        if (this.authenticationDetailsProvider instanceof RegionProvider && (provider = (RegionProvider)this.authenticationDetailsProvider).getRegion() != null) {
            this.setRegion(provider.getRegion());
            if (endpoint != null) {
                LOG.info("Authentication details provider configured for region '{}', but endpoint specifically set to '{}'. Using endpoint setting instead of region.", (Object)provider.getRegion(), (Object)endpoint);
            }
        }
        if (endpoint != null) {
            this.setEndpoint(endpoint);
        }
    }

    public static Builder builder() {
        return new Builder(SERVICE);
    }

    @Override
    public void setEndpoint(String endpoint) {
        LOG.info("Setting endpoint to {}", (Object)endpoint);
        this.client.setEndpoint(endpoint);
    }

    @Override
    public String getEndpoint() {
        String endpoint = null;
        URI uri = this.client.getBaseTarget().getUri();
        if (uri != null) {
            endpoint = uri.toString();
        }
        return endpoint;
    }

    @Override
    public void setRegion(Region region) {
        Optional endpoint = region.getEndpoint(SERVICE);
        if (!endpoint.isPresent()) {
            throw new IllegalArgumentException("Endpoint for " + SERVICE + " is not known in region " + region);
        }
        this.setEndpoint((String)endpoint.get());
    }

    @Override
    public void setRegion(String regionId) {
        regionId = regionId.toLowerCase(Locale.ENGLISH);
        try {
            Region region = Region.fromRegionId((String)regionId);
            this.setRegion(region);
        }
        catch (IllegalArgumentException e) {
            LOG.info("Unknown regionId '{}', falling back to default endpoint format", (Object)regionId);
            String endpoint = Region.formatDefaultRegionEndpoint((Service)SERVICE, (String)regionId);
            this.setEndpoint(endpoint);
        }
    }

    @Override
    public void close() {
        this.client.close();
    }

    @Override
    public ChangeRoverEntitlementCompartmentResponse changeRoverEntitlementCompartment(ChangeRoverEntitlementCompartmentRequest request) {
        LOG.trace("Called changeRoverEntitlementCompartment");
        ChangeRoverEntitlementCompartmentRequest interceptedRequest = ChangeRoverEntitlementCompartmentConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = ChangeRoverEntitlementCompartmentConverter.fromRequest(this.client, interceptedRequest);
        Function<Response, ChangeRoverEntitlementCompartmentResponse> transformer = ChangeRoverEntitlementCompartmentConverter.fromResponse();
        BmcGenericRetrier retrier = Retriers.createPreferredRetrier((RetryConfiguration)interceptedRequest.getRetryConfiguration(), (RetryConfiguration)this.retryConfiguration);
        RetryTokenUtils.addRetryToken((WrappedInvocationBuilder)ib);
        return (ChangeRoverEntitlementCompartmentResponse)retrier.execute((Object)interceptedRequest, retryRequest -> {
            TokenRefreshRetrier tokenRefreshRetrier = new TokenRefreshRetrier(this.authenticationDetailsProvider);
            return (ChangeRoverEntitlementCompartmentResponse)tokenRefreshRetrier.execute((Object)retryRequest, retriedRequest -> {
                Response response = this.client.post(ib, (Object)retriedRequest.getChangeRoverEntitlementCompartmentDetails(), (BmcRequest)retriedRequest);
                return (ChangeRoverEntitlementCompartmentResponse)transformer.apply((Object)response);
            });
        });
    }

    @Override
    public CreateRoverEntitlementResponse createRoverEntitlement(CreateRoverEntitlementRequest request) {
        LOG.trace("Called createRoverEntitlement");
        CreateRoverEntitlementRequest interceptedRequest = CreateRoverEntitlementConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = CreateRoverEntitlementConverter.fromRequest(this.client, interceptedRequest);
        Function<Response, CreateRoverEntitlementResponse> transformer = CreateRoverEntitlementConverter.fromResponse();
        BmcGenericRetrier retrier = Retriers.createPreferredRetrier((RetryConfiguration)interceptedRequest.getRetryConfiguration(), (RetryConfiguration)this.retryConfiguration);
        RetryTokenUtils.addRetryToken((WrappedInvocationBuilder)ib);
        return (CreateRoverEntitlementResponse)retrier.execute((Object)interceptedRequest, retryRequest -> {
            TokenRefreshRetrier tokenRefreshRetrier = new TokenRefreshRetrier(this.authenticationDetailsProvider);
            return (CreateRoverEntitlementResponse)tokenRefreshRetrier.execute((Object)retryRequest, retriedRequest -> {
                Response response = this.client.post(ib, (Object)retriedRequest.getCreateRoverEntitlementDetails(), (BmcRequest)retriedRequest);
                return (CreateRoverEntitlementResponse)transformer.apply((Object)response);
            });
        });
    }

    @Override
    public DeleteRoverEntitlementResponse deleteRoverEntitlement(DeleteRoverEntitlementRequest request) {
        LOG.trace("Called deleteRoverEntitlement");
        DeleteRoverEntitlementRequest interceptedRequest = DeleteRoverEntitlementConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = DeleteRoverEntitlementConverter.fromRequest(this.client, interceptedRequest);
        Function<Response, DeleteRoverEntitlementResponse> transformer = DeleteRoverEntitlementConverter.fromResponse();
        BmcGenericRetrier retrier = Retriers.createPreferredRetrier((RetryConfiguration)interceptedRequest.getRetryConfiguration(), (RetryConfiguration)this.retryConfiguration);
        RetryTokenUtils.addRetryToken((WrappedInvocationBuilder)ib);
        return (DeleteRoverEntitlementResponse)retrier.execute((Object)interceptedRequest, retryRequest -> {
            TokenRefreshRetrier tokenRefreshRetrier = new TokenRefreshRetrier(this.authenticationDetailsProvider);
            return (DeleteRoverEntitlementResponse)tokenRefreshRetrier.execute((Object)retryRequest, retriedRequest -> {
                Response response = this.client.delete(ib, (BmcRequest)retriedRequest);
                return (DeleteRoverEntitlementResponse)transformer.apply((Object)response);
            });
        });
    }

    @Override
    public GetRoverEntitlementResponse getRoverEntitlement(GetRoverEntitlementRequest request) {
        LOG.trace("Called getRoverEntitlement");
        GetRoverEntitlementRequest interceptedRequest = GetRoverEntitlementConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = GetRoverEntitlementConverter.fromRequest(this.client, interceptedRequest);
        Function<Response, GetRoverEntitlementResponse> transformer = GetRoverEntitlementConverter.fromResponse();
        BmcGenericRetrier retrier = Retriers.createPreferredRetrier((RetryConfiguration)interceptedRequest.getRetryConfiguration(), (RetryConfiguration)this.retryConfiguration);
        RetryTokenUtils.addRetryToken((WrappedInvocationBuilder)ib);
        return (GetRoverEntitlementResponse)retrier.execute((Object)interceptedRequest, retryRequest -> {
            TokenRefreshRetrier tokenRefreshRetrier = new TokenRefreshRetrier(this.authenticationDetailsProvider);
            return (GetRoverEntitlementResponse)tokenRefreshRetrier.execute((Object)retryRequest, retriedRequest -> {
                Response response = this.client.get(ib, (BmcRequest)retriedRequest);
                return (GetRoverEntitlementResponse)transformer.apply((Object)response);
            });
        });
    }

    @Override
    public ListRoverEntitlementsResponse listRoverEntitlements(ListRoverEntitlementsRequest request) {
        LOG.trace("Called listRoverEntitlements");
        ListRoverEntitlementsRequest interceptedRequest = ListRoverEntitlementsConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = ListRoverEntitlementsConverter.fromRequest(this.client, interceptedRequest);
        Function<Response, ListRoverEntitlementsResponse> transformer = ListRoverEntitlementsConverter.fromResponse();
        BmcGenericRetrier retrier = Retriers.createPreferredRetrier((RetryConfiguration)interceptedRequest.getRetryConfiguration(), (RetryConfiguration)this.retryConfiguration);
        return (ListRoverEntitlementsResponse)retrier.execute((Object)interceptedRequest, retryRequest -> {
            TokenRefreshRetrier tokenRefreshRetrier = new TokenRefreshRetrier(this.authenticationDetailsProvider);
            return (ListRoverEntitlementsResponse)tokenRefreshRetrier.execute((Object)retryRequest, retriedRequest -> {
                Response response = this.client.get(ib, (BmcRequest)retriedRequest);
                return (ListRoverEntitlementsResponse)transformer.apply((Object)response);
            });
        });
    }

    @Override
    public UpdateRoverEntitlementResponse updateRoverEntitlement(UpdateRoverEntitlementRequest request) {
        LOG.trace("Called updateRoverEntitlement");
        UpdateRoverEntitlementRequest interceptedRequest = UpdateRoverEntitlementConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = UpdateRoverEntitlementConverter.fromRequest(this.client, interceptedRequest);
        Function<Response, UpdateRoverEntitlementResponse> transformer = UpdateRoverEntitlementConverter.fromResponse();
        BmcGenericRetrier retrier = Retriers.createPreferredRetrier((RetryConfiguration)interceptedRequest.getRetryConfiguration(), (RetryConfiguration)this.retryConfiguration);
        return (UpdateRoverEntitlementResponse)retrier.execute((Object)interceptedRequest, retryRequest -> {
            TokenRefreshRetrier tokenRefreshRetrier = new TokenRefreshRetrier(this.authenticationDetailsProvider);
            return (UpdateRoverEntitlementResponse)tokenRefreshRetrier.execute((Object)retryRequest, retriedRequest -> {
                Response response = this.client.put(ib, (Object)retriedRequest.getUpdateRoverEntitlementDetails(), (BmcRequest)retriedRequest);
                return (UpdateRoverEntitlementResponse)transformer.apply((Object)response);
            });
        });
    }

    @Override
    public RoverEntitlementWaiters getWaiters() {
        return this.waiters;
    }

    @Override
    public RoverEntitlementPaginators getPaginators() {
        return this.paginators;
    }

    RestClient getClient() {
        return this.client;
    }

    public static class Builder
    extends RegionalClientBuilder<Builder, RoverEntitlementClient> {
        private ExecutorService executorService;

        private Builder(Service service) {
            super(service);
            this.requestSignerFactory = new DefaultRequestSignerFactory(SigningStrategy.STANDARD);
        }

        public Builder executorService(ExecutorService executorService) {
            this.executorService = executorService;
            return this;
        }

        public RoverEntitlementClient build(@NonNull AbstractAuthenticationDetailsProvider authenticationDetailsProvider) {
            if (authenticationDetailsProvider == null) {
                throw new NullPointerException("authenticationDetailsProvider is marked non-null but is null");
            }
            return new RoverEntitlementClient(authenticationDetailsProvider, this.configuration, this.clientConfigurator, this.requestSignerFactory, this.signingStrategyRequestSignerFactories, this.additionalClientConfigurators, this.endpoint, this.executorService);
        }
    }
}

