/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.rover.internal.http;

import com.google.common.base.Function;
import com.google.common.base.Optional;
import com.oracle.bmc.http.internal.HeaderUtils;
import com.oracle.bmc.http.internal.ResponseConversionFunctionFactory;
import com.oracle.bmc.http.internal.ResponseHelper;
import com.oracle.bmc.http.internal.RestClient;
import com.oracle.bmc.http.internal.WithHeaders;
import com.oracle.bmc.http.internal.WrappedInvocationBuilder;
import com.oracle.bmc.http.internal.WrappedWebTarget;
import com.oracle.bmc.rover.model.RoverNodeSetKey;
import com.oracle.bmc.rover.requests.RoverNodeActionSetKeyRequest;
import com.oracle.bmc.rover.responses.RoverNodeActionSetKeyResponse;
import com.oracle.bmc.util.internal.HttpUtils;
import java.util.List;
import javax.ws.rs.core.MultivaluedMap;
import javax.ws.rs.core.Response;
import org.apache.commons.lang3.Validate;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RoverNodeActionSetKeyConverter {
    private static final Logger LOG = LoggerFactory.getLogger(RoverNodeActionSetKeyConverter.class);
    private static final ResponseConversionFunctionFactory RESPONSE_CONVERSION_FACTORY = new ResponseConversionFunctionFactory();

    public static RoverNodeActionSetKeyRequest interceptRequest(RoverNodeActionSetKeyRequest request) {
        return request;
    }

    public static WrappedInvocationBuilder fromRequest(RestClient client, RoverNodeActionSetKeyRequest request) {
        Validate.notNull((Object)((Object)request), (String)"request instance is required", (Object[])new Object[0]);
        Validate.notBlank((CharSequence)request.getRoverNodeId(), (String)"roverNodeId must not be blank", (Object[])new Object[0]);
        Validate.notNull((Object)request.getJwt(), (String)"jwt is required", (Object[])new Object[0]);
        Validate.notNull((Object)request.getRoverNodeActionSetKeyDetails(), (String)"roverNodeActionSetKeyDetails is required", (Object[])new Object[0]);
        WrappedWebTarget target = client.getBaseTarget().path("/20201210").path("roverNodes").path(HttpUtils.encodePathSegment((String)request.getRoverNodeId())).path("actions").path("setKey");
        WrappedInvocationBuilder ib = target.request();
        ib.accept(new String[]{"application/json"});
        ib.header("jwt", (Object)request.getJwt());
        if (request.getIfMatch() != null) {
            ib.header("if-match", (Object)request.getIfMatch());
        }
        if (request.getOpcRequestId() != null) {
            ib.header("opc-request-id", (Object)request.getOpcRequestId());
        }
        if (request.getOpcRetryToken() != null) {
            ib.header("opc-retry-token", (Object)request.getOpcRetryToken());
        }
        return ib;
    }

    public static Function<Response, RoverNodeActionSetKeyResponse> fromResponse() {
        Function<Response, RoverNodeActionSetKeyResponse> transformer = new Function<Response, RoverNodeActionSetKeyResponse>(){

            public RoverNodeActionSetKeyResponse apply(Response rawResponse) {
                Optional opcRequestIdHeader;
                LOG.trace("Transform function invoked for com.oracle.bmc.rover.responses.RoverNodeActionSetKeyResponse");
                Function responseFn = RESPONSE_CONVERSION_FACTORY.create(RoverNodeSetKey.class);
                WithHeaders response = (WithHeaders)responseFn.apply((Object)rawResponse);
                MultivaluedMap headers = response.getHeaders();
                RoverNodeActionSetKeyResponse.Builder builder = RoverNodeActionSetKeyResponse.builder().__httpStatusCode__(rawResponse.getStatus());
                builder.roverNodeSetKey((RoverNodeSetKey)response.getItem());
                Optional etagHeader = HeaderUtils.get((MultivaluedMap)headers, (String)"etag");
                if (etagHeader.isPresent()) {
                    builder.etag((String)HeaderUtils.toValue((String)"etag", (String)((String)((List)etagHeader.get()).get(0)), String.class));
                }
                if ((opcRequestIdHeader = HeaderUtils.get((MultivaluedMap)headers, (String)"opc-request-id")).isPresent()) {
                    builder.opcRequestId((String)HeaderUtils.toValue((String)"opc-request-id", (String)((String)((List)opcRequestIdHeader.get()).get(0)), String.class));
                }
                RoverNodeActionSetKeyResponse responseWrapper = builder.build();
                ResponseHelper.closeResponseSilentlyIfNotBuffered((Response)rawResponse);
                return responseWrapper;
            }
        };
        return transformer;
    }
}

