/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.rover.model;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonFilter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonValue;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonPOJOBuilder;
import com.oracle.bmc.rover.model.EnclosureType;
import com.oracle.bmc.rover.model.LifecycleState;
import com.oracle.bmc.rover.model.NodeType;
import com.oracle.bmc.rover.model.RoverWorkload;
import com.oracle.bmc.rover.model.ShippingAddress;
import java.beans.ConstructorProperties;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@JsonDeserialize(builder=Builder.class)
@JsonFilter(value="explicitlySetFilter")
public final class RoverNode {
    @JsonProperty(value="id")
    private final String id;
    @JsonProperty(value="clusterId")
    private final String clusterId;
    @JsonProperty(value="compartmentId")
    private final String compartmentId;
    @JsonProperty(value="nodeType")
    private final NodeType nodeType;
    @JsonProperty(value="enclosureType")
    private final EnclosureType enclosureType;
    @JsonProperty(value="serialNumber")
    private final String serialNumber;
    @JsonProperty(value="displayName")
    private final String displayName;
    @JsonProperty(value="timeCreated")
    private final Date timeCreated;
    @JsonProperty(value="lifecycleState")
    private final LifecycleState lifecycleState;
    @JsonProperty(value="lifecycleStateDetails")
    private final String lifecycleStateDetails;
    @JsonProperty(value="customerShippingAddress")
    private final ShippingAddress customerShippingAddress;
    @JsonProperty(value="nodeWorkloads")
    private final List<RoverWorkload> nodeWorkloads;
    @JsonProperty(value="timeCustomerReceieved")
    private final Date timeCustomerReceieved;
    @JsonProperty(value="timeCustomerReturned")
    private final Date timeCustomerReturned;
    @JsonProperty(value="deliveryTrackingInfo")
    private final String deliveryTrackingInfo;
    @JsonProperty(value="superUserPassword")
    private final String superUserPassword;
    @JsonProperty(value="unlockPassphrase")
    private final String unlockPassphrase;
    @JsonProperty(value="pointOfContact")
    private final String pointOfContact;
    @JsonProperty(value="pointOfContactPhoneNumber")
    private final String pointOfContactPhoneNumber;
    @JsonProperty(value="shippingPreference")
    private final ShippingPreference shippingPreference;
    @JsonProperty(value="shippingVendor")
    private final String shippingVendor;
    @JsonProperty(value="timePickupExpected")
    private final Date timePickupExpected;
    @JsonProperty(value="timeReturnWindowStarts")
    private final Date timeReturnWindowStarts;
    @JsonProperty(value="oracleShippingTrackingUrl")
    private final String oracleShippingTrackingUrl;
    @JsonProperty(value="timeReturnWindowEnds")
    private final Date timeReturnWindowEnds;
    @JsonProperty(value="returnShippingLabelUri")
    private final String returnShippingLabelUri;
    @JsonProperty(value="publicKey")
    private final String publicKey;
    @JsonProperty(value="imageExportPar")
    private final String imageExportPar;
    @JsonProperty(value="freeformTags")
    private final Map<String, String> freeformTags;
    @JsonProperty(value="definedTags")
    private final Map<String, Map<String, Object>> definedTags;
    @JsonProperty(value="systemTags")
    private final Map<String, Map<String, Object>> systemTags;
    @JsonIgnore
    private final Set<String> __explicitlySet__ = new HashSet<String>();

    public static Builder builder() {
        return new Builder();
    }

    public Builder toBuilder() {
        return new Builder().id(this.id).clusterId(this.clusterId).compartmentId(this.compartmentId).nodeType(this.nodeType).enclosureType(this.enclosureType).serialNumber(this.serialNumber).displayName(this.displayName).timeCreated(this.timeCreated).lifecycleState(this.lifecycleState).lifecycleStateDetails(this.lifecycleStateDetails).customerShippingAddress(this.customerShippingAddress).nodeWorkloads(this.nodeWorkloads).timeCustomerReceieved(this.timeCustomerReceieved).timeCustomerReturned(this.timeCustomerReturned).deliveryTrackingInfo(this.deliveryTrackingInfo).superUserPassword(this.superUserPassword).unlockPassphrase(this.unlockPassphrase).pointOfContact(this.pointOfContact).pointOfContactPhoneNumber(this.pointOfContactPhoneNumber).shippingPreference(this.shippingPreference).shippingVendor(this.shippingVendor).timePickupExpected(this.timePickupExpected).timeReturnWindowStarts(this.timeReturnWindowStarts).oracleShippingTrackingUrl(this.oracleShippingTrackingUrl).timeReturnWindowEnds(this.timeReturnWindowEnds).returnShippingLabelUri(this.returnShippingLabelUri).publicKey(this.publicKey).imageExportPar(this.imageExportPar).freeformTags(this.freeformTags).definedTags(this.definedTags).systemTags(this.systemTags);
    }

    public String getId() {
        return this.id;
    }

    public String getClusterId() {
        return this.clusterId;
    }

    public String getCompartmentId() {
        return this.compartmentId;
    }

    public NodeType getNodeType() {
        return this.nodeType;
    }

    public EnclosureType getEnclosureType() {
        return this.enclosureType;
    }

    public String getSerialNumber() {
        return this.serialNumber;
    }

    public String getDisplayName() {
        return this.displayName;
    }

    public Date getTimeCreated() {
        return this.timeCreated;
    }

    public LifecycleState getLifecycleState() {
        return this.lifecycleState;
    }

    public String getLifecycleStateDetails() {
        return this.lifecycleStateDetails;
    }

    public ShippingAddress getCustomerShippingAddress() {
        return this.customerShippingAddress;
    }

    public List<RoverWorkload> getNodeWorkloads() {
        return this.nodeWorkloads;
    }

    public Date getTimeCustomerReceieved() {
        return this.timeCustomerReceieved;
    }

    public Date getTimeCustomerReturned() {
        return this.timeCustomerReturned;
    }

    public String getDeliveryTrackingInfo() {
        return this.deliveryTrackingInfo;
    }

    public String getSuperUserPassword() {
        return this.superUserPassword;
    }

    public String getUnlockPassphrase() {
        return this.unlockPassphrase;
    }

    public String getPointOfContact() {
        return this.pointOfContact;
    }

    public String getPointOfContactPhoneNumber() {
        return this.pointOfContactPhoneNumber;
    }

    public ShippingPreference getShippingPreference() {
        return this.shippingPreference;
    }

    public String getShippingVendor() {
        return this.shippingVendor;
    }

    public Date getTimePickupExpected() {
        return this.timePickupExpected;
    }

    public Date getTimeReturnWindowStarts() {
        return this.timeReturnWindowStarts;
    }

    public String getOracleShippingTrackingUrl() {
        return this.oracleShippingTrackingUrl;
    }

    public Date getTimeReturnWindowEnds() {
        return this.timeReturnWindowEnds;
    }

    public String getReturnShippingLabelUri() {
        return this.returnShippingLabelUri;
    }

    public String getPublicKey() {
        return this.publicKey;
    }

    public String getImageExportPar() {
        return this.imageExportPar;
    }

    public Map<String, String> getFreeformTags() {
        return this.freeformTags;
    }

    public Map<String, Map<String, Object>> getDefinedTags() {
        return this.definedTags;
    }

    public Map<String, Map<String, Object>> getSystemTags() {
        return this.systemTags;
    }

    public Set<String> get__explicitlySet__() {
        return this.__explicitlySet__;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof RoverNode)) {
            return false;
        }
        RoverNode other = (RoverNode)o;
        String this$id = this.getId();
        String other$id = other.getId();
        if (this$id == null ? other$id != null : !this$id.equals(other$id)) {
            return false;
        }
        String this$clusterId = this.getClusterId();
        String other$clusterId = other.getClusterId();
        if (this$clusterId == null ? other$clusterId != null : !this$clusterId.equals(other$clusterId)) {
            return false;
        }
        String this$compartmentId = this.getCompartmentId();
        String other$compartmentId = other.getCompartmentId();
        if (this$compartmentId == null ? other$compartmentId != null : !this$compartmentId.equals(other$compartmentId)) {
            return false;
        }
        NodeType this$nodeType = this.getNodeType();
        NodeType other$nodeType = other.getNodeType();
        if (this$nodeType == null ? other$nodeType != null : !((Object)((Object)this$nodeType)).equals((Object)other$nodeType)) {
            return false;
        }
        EnclosureType this$enclosureType = this.getEnclosureType();
        EnclosureType other$enclosureType = other.getEnclosureType();
        if (this$enclosureType == null ? other$enclosureType != null : !((Object)((Object)this$enclosureType)).equals((Object)other$enclosureType)) {
            return false;
        }
        String this$serialNumber = this.getSerialNumber();
        String other$serialNumber = other.getSerialNumber();
        if (this$serialNumber == null ? other$serialNumber != null : !this$serialNumber.equals(other$serialNumber)) {
            return false;
        }
        String this$displayName = this.getDisplayName();
        String other$displayName = other.getDisplayName();
        if (this$displayName == null ? other$displayName != null : !this$displayName.equals(other$displayName)) {
            return false;
        }
        Date this$timeCreated = this.getTimeCreated();
        Date other$timeCreated = other.getTimeCreated();
        if (this$timeCreated == null ? other$timeCreated != null : !((Object)this$timeCreated).equals(other$timeCreated)) {
            return false;
        }
        LifecycleState this$lifecycleState = this.getLifecycleState();
        LifecycleState other$lifecycleState = other.getLifecycleState();
        if (this$lifecycleState == null ? other$lifecycleState != null : !((Object)((Object)this$lifecycleState)).equals((Object)other$lifecycleState)) {
            return false;
        }
        String this$lifecycleStateDetails = this.getLifecycleStateDetails();
        String other$lifecycleStateDetails = other.getLifecycleStateDetails();
        if (this$lifecycleStateDetails == null ? other$lifecycleStateDetails != null : !this$lifecycleStateDetails.equals(other$lifecycleStateDetails)) {
            return false;
        }
        ShippingAddress this$customerShippingAddress = this.getCustomerShippingAddress();
        ShippingAddress other$customerShippingAddress = other.getCustomerShippingAddress();
        if (this$customerShippingAddress == null ? other$customerShippingAddress != null : !((Object)this$customerShippingAddress).equals(other$customerShippingAddress)) {
            return false;
        }
        List<RoverWorkload> this$nodeWorkloads = this.getNodeWorkloads();
        List<RoverWorkload> other$nodeWorkloads = other.getNodeWorkloads();
        if (this$nodeWorkloads == null ? other$nodeWorkloads != null : !((Object)this$nodeWorkloads).equals(other$nodeWorkloads)) {
            return false;
        }
        Date this$timeCustomerReceieved = this.getTimeCustomerReceieved();
        Date other$timeCustomerReceieved = other.getTimeCustomerReceieved();
        if (this$timeCustomerReceieved == null ? other$timeCustomerReceieved != null : !((Object)this$timeCustomerReceieved).equals(other$timeCustomerReceieved)) {
            return false;
        }
        Date this$timeCustomerReturned = this.getTimeCustomerReturned();
        Date other$timeCustomerReturned = other.getTimeCustomerReturned();
        if (this$timeCustomerReturned == null ? other$timeCustomerReturned != null : !((Object)this$timeCustomerReturned).equals(other$timeCustomerReturned)) {
            return false;
        }
        String this$deliveryTrackingInfo = this.getDeliveryTrackingInfo();
        String other$deliveryTrackingInfo = other.getDeliveryTrackingInfo();
        if (this$deliveryTrackingInfo == null ? other$deliveryTrackingInfo != null : !this$deliveryTrackingInfo.equals(other$deliveryTrackingInfo)) {
            return false;
        }
        String this$superUserPassword = this.getSuperUserPassword();
        String other$superUserPassword = other.getSuperUserPassword();
        if (this$superUserPassword == null ? other$superUserPassword != null : !this$superUserPassword.equals(other$superUserPassword)) {
            return false;
        }
        String this$unlockPassphrase = this.getUnlockPassphrase();
        String other$unlockPassphrase = other.getUnlockPassphrase();
        if (this$unlockPassphrase == null ? other$unlockPassphrase != null : !this$unlockPassphrase.equals(other$unlockPassphrase)) {
            return false;
        }
        String this$pointOfContact = this.getPointOfContact();
        String other$pointOfContact = other.getPointOfContact();
        if (this$pointOfContact == null ? other$pointOfContact != null : !this$pointOfContact.equals(other$pointOfContact)) {
            return false;
        }
        String this$pointOfContactPhoneNumber = this.getPointOfContactPhoneNumber();
        String other$pointOfContactPhoneNumber = other.getPointOfContactPhoneNumber();
        if (this$pointOfContactPhoneNumber == null ? other$pointOfContactPhoneNumber != null : !this$pointOfContactPhoneNumber.equals(other$pointOfContactPhoneNumber)) {
            return false;
        }
        ShippingPreference this$shippingPreference = this.getShippingPreference();
        ShippingPreference other$shippingPreference = other.getShippingPreference();
        if (this$shippingPreference == null ? other$shippingPreference != null : !((Object)((Object)this$shippingPreference)).equals((Object)other$shippingPreference)) {
            return false;
        }
        String this$shippingVendor = this.getShippingVendor();
        String other$shippingVendor = other.getShippingVendor();
        if (this$shippingVendor == null ? other$shippingVendor != null : !this$shippingVendor.equals(other$shippingVendor)) {
            return false;
        }
        Date this$timePickupExpected = this.getTimePickupExpected();
        Date other$timePickupExpected = other.getTimePickupExpected();
        if (this$timePickupExpected == null ? other$timePickupExpected != null : !((Object)this$timePickupExpected).equals(other$timePickupExpected)) {
            return false;
        }
        Date this$timeReturnWindowStarts = this.getTimeReturnWindowStarts();
        Date other$timeReturnWindowStarts = other.getTimeReturnWindowStarts();
        if (this$timeReturnWindowStarts == null ? other$timeReturnWindowStarts != null : !((Object)this$timeReturnWindowStarts).equals(other$timeReturnWindowStarts)) {
            return false;
        }
        String this$oracleShippingTrackingUrl = this.getOracleShippingTrackingUrl();
        String other$oracleShippingTrackingUrl = other.getOracleShippingTrackingUrl();
        if (this$oracleShippingTrackingUrl == null ? other$oracleShippingTrackingUrl != null : !this$oracleShippingTrackingUrl.equals(other$oracleShippingTrackingUrl)) {
            return false;
        }
        Date this$timeReturnWindowEnds = this.getTimeReturnWindowEnds();
        Date other$timeReturnWindowEnds = other.getTimeReturnWindowEnds();
        if (this$timeReturnWindowEnds == null ? other$timeReturnWindowEnds != null : !((Object)this$timeReturnWindowEnds).equals(other$timeReturnWindowEnds)) {
            return false;
        }
        String this$returnShippingLabelUri = this.getReturnShippingLabelUri();
        String other$returnShippingLabelUri = other.getReturnShippingLabelUri();
        if (this$returnShippingLabelUri == null ? other$returnShippingLabelUri != null : !this$returnShippingLabelUri.equals(other$returnShippingLabelUri)) {
            return false;
        }
        String this$publicKey = this.getPublicKey();
        String other$publicKey = other.getPublicKey();
        if (this$publicKey == null ? other$publicKey != null : !this$publicKey.equals(other$publicKey)) {
            return false;
        }
        String this$imageExportPar = this.getImageExportPar();
        String other$imageExportPar = other.getImageExportPar();
        if (this$imageExportPar == null ? other$imageExportPar != null : !this$imageExportPar.equals(other$imageExportPar)) {
            return false;
        }
        Map<String, String> this$freeformTags = this.getFreeformTags();
        Map<String, String> other$freeformTags = other.getFreeformTags();
        if (this$freeformTags == null ? other$freeformTags != null : !((Object)this$freeformTags).equals(other$freeformTags)) {
            return false;
        }
        Map<String, Map<String, Object>> this$definedTags = this.getDefinedTags();
        Map<String, Map<String, Object>> other$definedTags = other.getDefinedTags();
        if (this$definedTags == null ? other$definedTags != null : !((Object)this$definedTags).equals(other$definedTags)) {
            return false;
        }
        Map<String, Map<String, Object>> this$systemTags = this.getSystemTags();
        Map<String, Map<String, Object>> other$systemTags = other.getSystemTags();
        if (this$systemTags == null ? other$systemTags != null : !((Object)this$systemTags).equals(other$systemTags)) {
            return false;
        }
        Set<String> this$__explicitlySet__ = this.get__explicitlySet__();
        Set<String> other$__explicitlySet__ = other.get__explicitlySet__();
        return !(this$__explicitlySet__ == null ? other$__explicitlySet__ != null : !((Object)this$__explicitlySet__).equals(other$__explicitlySet__));
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        String $id = this.getId();
        result = result * 59 + ($id == null ? 43 : $id.hashCode());
        String $clusterId = this.getClusterId();
        result = result * 59 + ($clusterId == null ? 43 : $clusterId.hashCode());
        String $compartmentId = this.getCompartmentId();
        result = result * 59 + ($compartmentId == null ? 43 : $compartmentId.hashCode());
        NodeType $nodeType = this.getNodeType();
        result = result * 59 + ($nodeType == null ? 43 : ((Object)((Object)$nodeType)).hashCode());
        EnclosureType $enclosureType = this.getEnclosureType();
        result = result * 59 + ($enclosureType == null ? 43 : ((Object)((Object)$enclosureType)).hashCode());
        String $serialNumber = this.getSerialNumber();
        result = result * 59 + ($serialNumber == null ? 43 : $serialNumber.hashCode());
        String $displayName = this.getDisplayName();
        result = result * 59 + ($displayName == null ? 43 : $displayName.hashCode());
        Date $timeCreated = this.getTimeCreated();
        result = result * 59 + ($timeCreated == null ? 43 : ((Object)$timeCreated).hashCode());
        LifecycleState $lifecycleState = this.getLifecycleState();
        result = result * 59 + ($lifecycleState == null ? 43 : ((Object)((Object)$lifecycleState)).hashCode());
        String $lifecycleStateDetails = this.getLifecycleStateDetails();
        result = result * 59 + ($lifecycleStateDetails == null ? 43 : $lifecycleStateDetails.hashCode());
        ShippingAddress $customerShippingAddress = this.getCustomerShippingAddress();
        result = result * 59 + ($customerShippingAddress == null ? 43 : ((Object)$customerShippingAddress).hashCode());
        List<RoverWorkload> $nodeWorkloads = this.getNodeWorkloads();
        result = result * 59 + ($nodeWorkloads == null ? 43 : ((Object)$nodeWorkloads).hashCode());
        Date $timeCustomerReceieved = this.getTimeCustomerReceieved();
        result = result * 59 + ($timeCustomerReceieved == null ? 43 : ((Object)$timeCustomerReceieved).hashCode());
        Date $timeCustomerReturned = this.getTimeCustomerReturned();
        result = result * 59 + ($timeCustomerReturned == null ? 43 : ((Object)$timeCustomerReturned).hashCode());
        String $deliveryTrackingInfo = this.getDeliveryTrackingInfo();
        result = result * 59 + ($deliveryTrackingInfo == null ? 43 : $deliveryTrackingInfo.hashCode());
        String $superUserPassword = this.getSuperUserPassword();
        result = result * 59 + ($superUserPassword == null ? 43 : $superUserPassword.hashCode());
        String $unlockPassphrase = this.getUnlockPassphrase();
        result = result * 59 + ($unlockPassphrase == null ? 43 : $unlockPassphrase.hashCode());
        String $pointOfContact = this.getPointOfContact();
        result = result * 59 + ($pointOfContact == null ? 43 : $pointOfContact.hashCode());
        String $pointOfContactPhoneNumber = this.getPointOfContactPhoneNumber();
        result = result * 59 + ($pointOfContactPhoneNumber == null ? 43 : $pointOfContactPhoneNumber.hashCode());
        ShippingPreference $shippingPreference = this.getShippingPreference();
        result = result * 59 + ($shippingPreference == null ? 43 : ((Object)((Object)$shippingPreference)).hashCode());
        String $shippingVendor = this.getShippingVendor();
        result = result * 59 + ($shippingVendor == null ? 43 : $shippingVendor.hashCode());
        Date $timePickupExpected = this.getTimePickupExpected();
        result = result * 59 + ($timePickupExpected == null ? 43 : ((Object)$timePickupExpected).hashCode());
        Date $timeReturnWindowStarts = this.getTimeReturnWindowStarts();
        result = result * 59 + ($timeReturnWindowStarts == null ? 43 : ((Object)$timeReturnWindowStarts).hashCode());
        String $oracleShippingTrackingUrl = this.getOracleShippingTrackingUrl();
        result = result * 59 + ($oracleShippingTrackingUrl == null ? 43 : $oracleShippingTrackingUrl.hashCode());
        Date $timeReturnWindowEnds = this.getTimeReturnWindowEnds();
        result = result * 59 + ($timeReturnWindowEnds == null ? 43 : ((Object)$timeReturnWindowEnds).hashCode());
        String $returnShippingLabelUri = this.getReturnShippingLabelUri();
        result = result * 59 + ($returnShippingLabelUri == null ? 43 : $returnShippingLabelUri.hashCode());
        String $publicKey = this.getPublicKey();
        result = result * 59 + ($publicKey == null ? 43 : $publicKey.hashCode());
        String $imageExportPar = this.getImageExportPar();
        result = result * 59 + ($imageExportPar == null ? 43 : $imageExportPar.hashCode());
        Map<String, String> $freeformTags = this.getFreeformTags();
        result = result * 59 + ($freeformTags == null ? 43 : ((Object)$freeformTags).hashCode());
        Map<String, Map<String, Object>> $definedTags = this.getDefinedTags();
        result = result * 59 + ($definedTags == null ? 43 : ((Object)$definedTags).hashCode());
        Map<String, Map<String, Object>> $systemTags = this.getSystemTags();
        result = result * 59 + ($systemTags == null ? 43 : ((Object)$systemTags).hashCode());
        Set<String> $__explicitlySet__ = this.get__explicitlySet__();
        result = result * 59 + ($__explicitlySet__ == null ? 43 : ((Object)$__explicitlySet__).hashCode());
        return result;
    }

    public String toString() {
        return "RoverNode(id=" + this.getId() + ", clusterId=" + this.getClusterId() + ", compartmentId=" + this.getCompartmentId() + ", nodeType=" + (Object)((Object)this.getNodeType()) + ", enclosureType=" + (Object)((Object)this.getEnclosureType()) + ", serialNumber=" + this.getSerialNumber() + ", displayName=" + this.getDisplayName() + ", timeCreated=" + this.getTimeCreated() + ", lifecycleState=" + (Object)((Object)this.getLifecycleState()) + ", lifecycleStateDetails=" + this.getLifecycleStateDetails() + ", customerShippingAddress=" + this.getCustomerShippingAddress() + ", nodeWorkloads=" + this.getNodeWorkloads() + ", timeCustomerReceieved=" + this.getTimeCustomerReceieved() + ", timeCustomerReturned=" + this.getTimeCustomerReturned() + ", deliveryTrackingInfo=" + this.getDeliveryTrackingInfo() + ", superUserPassword=" + this.getSuperUserPassword() + ", unlockPassphrase=" + this.getUnlockPassphrase() + ", pointOfContact=" + this.getPointOfContact() + ", pointOfContactPhoneNumber=" + this.getPointOfContactPhoneNumber() + ", shippingPreference=" + (Object)((Object)this.getShippingPreference()) + ", shippingVendor=" + this.getShippingVendor() + ", timePickupExpected=" + this.getTimePickupExpected() + ", timeReturnWindowStarts=" + this.getTimeReturnWindowStarts() + ", oracleShippingTrackingUrl=" + this.getOracleShippingTrackingUrl() + ", timeReturnWindowEnds=" + this.getTimeReturnWindowEnds() + ", returnShippingLabelUri=" + this.getReturnShippingLabelUri() + ", publicKey=" + this.getPublicKey() + ", imageExportPar=" + this.getImageExportPar() + ", freeformTags=" + this.getFreeformTags() + ", definedTags=" + this.getDefinedTags() + ", systemTags=" + this.getSystemTags() + ", __explicitlySet__=" + this.get__explicitlySet__() + ")";
    }

    @ConstructorProperties(value={"id", "clusterId", "compartmentId", "nodeType", "enclosureType", "serialNumber", "displayName", "timeCreated", "lifecycleState", "lifecycleStateDetails", "customerShippingAddress", "nodeWorkloads", "timeCustomerReceieved", "timeCustomerReturned", "deliveryTrackingInfo", "superUserPassword", "unlockPassphrase", "pointOfContact", "pointOfContactPhoneNumber", "shippingPreference", "shippingVendor", "timePickupExpected", "timeReturnWindowStarts", "oracleShippingTrackingUrl", "timeReturnWindowEnds", "returnShippingLabelUri", "publicKey", "imageExportPar", "freeformTags", "definedTags", "systemTags"})
    @Deprecated
    public RoverNode(String id, String clusterId, String compartmentId, NodeType nodeType, EnclosureType enclosureType, String serialNumber, String displayName, Date timeCreated, LifecycleState lifecycleState, String lifecycleStateDetails, ShippingAddress customerShippingAddress, List<RoverWorkload> nodeWorkloads, Date timeCustomerReceieved, Date timeCustomerReturned, String deliveryTrackingInfo, String superUserPassword, String unlockPassphrase, String pointOfContact, String pointOfContactPhoneNumber, ShippingPreference shippingPreference, String shippingVendor, Date timePickupExpected, Date timeReturnWindowStarts, String oracleShippingTrackingUrl, Date timeReturnWindowEnds, String returnShippingLabelUri, String publicKey, String imageExportPar, Map<String, String> freeformTags, Map<String, Map<String, Object>> definedTags, Map<String, Map<String, Object>> systemTags) {
        this.id = id;
        this.clusterId = clusterId;
        this.compartmentId = compartmentId;
        this.nodeType = nodeType;
        this.enclosureType = enclosureType;
        this.serialNumber = serialNumber;
        this.displayName = displayName;
        this.timeCreated = timeCreated;
        this.lifecycleState = lifecycleState;
        this.lifecycleStateDetails = lifecycleStateDetails;
        this.customerShippingAddress = customerShippingAddress;
        this.nodeWorkloads = nodeWorkloads;
        this.timeCustomerReceieved = timeCustomerReceieved;
        this.timeCustomerReturned = timeCustomerReturned;
        this.deliveryTrackingInfo = deliveryTrackingInfo;
        this.superUserPassword = superUserPassword;
        this.unlockPassphrase = unlockPassphrase;
        this.pointOfContact = pointOfContact;
        this.pointOfContactPhoneNumber = pointOfContactPhoneNumber;
        this.shippingPreference = shippingPreference;
        this.shippingVendor = shippingVendor;
        this.timePickupExpected = timePickupExpected;
        this.timeReturnWindowStarts = timeReturnWindowStarts;
        this.oracleShippingTrackingUrl = oracleShippingTrackingUrl;
        this.timeReturnWindowEnds = timeReturnWindowEnds;
        this.returnShippingLabelUri = returnShippingLabelUri;
        this.publicKey = publicKey;
        this.imageExportPar = imageExportPar;
        this.freeformTags = freeformTags;
        this.definedTags = definedTags;
        this.systemTags = systemTags;
    }

    public static enum ShippingPreference {
        OracleShipped("ORACLE_SHIPPED"),
        CustomerPickup("CUSTOMER_PICKUP"),
        UnknownEnumValue(null);

        private static final Logger LOG;
        private final String value;
        private static Map<String, ShippingPreference> map;

        private ShippingPreference(String value) {
            this.value = value;
        }

        @JsonValue
        public String getValue() {
            return this.value;
        }

        @JsonCreator
        public static ShippingPreference create(String key) {
            if (map.containsKey(key)) {
                return map.get(key);
            }
            LOG.warn("Received unknown value '{}' for enum 'ShippingPreference', returning UnknownEnumValue", (Object)key);
            return UnknownEnumValue;
        }

        static {
            LOG = LoggerFactory.getLogger(ShippingPreference.class);
            map = new HashMap<String, ShippingPreference>();
            for (ShippingPreference v : ShippingPreference.values()) {
                if (v == UnknownEnumValue) continue;
                map.put(v.getValue(), v);
            }
        }
    }

    @JsonPOJOBuilder(withPrefix="")
    public static class Builder {
        @JsonProperty(value="id")
        private String id;
        @JsonProperty(value="clusterId")
        private String clusterId;
        @JsonProperty(value="compartmentId")
        private String compartmentId;
        @JsonProperty(value="nodeType")
        private NodeType nodeType;
        @JsonProperty(value="enclosureType")
        private EnclosureType enclosureType;
        @JsonProperty(value="serialNumber")
        private String serialNumber;
        @JsonProperty(value="displayName")
        private String displayName;
        @JsonProperty(value="timeCreated")
        private Date timeCreated;
        @JsonProperty(value="lifecycleState")
        private LifecycleState lifecycleState;
        @JsonProperty(value="lifecycleStateDetails")
        private String lifecycleStateDetails;
        @JsonProperty(value="customerShippingAddress")
        private ShippingAddress customerShippingAddress;
        @JsonProperty(value="nodeWorkloads")
        private List<RoverWorkload> nodeWorkloads;
        @JsonProperty(value="timeCustomerReceieved")
        private Date timeCustomerReceieved;
        @JsonProperty(value="timeCustomerReturned")
        private Date timeCustomerReturned;
        @JsonProperty(value="deliveryTrackingInfo")
        private String deliveryTrackingInfo;
        @JsonProperty(value="superUserPassword")
        private String superUserPassword;
        @JsonProperty(value="unlockPassphrase")
        private String unlockPassphrase;
        @JsonProperty(value="pointOfContact")
        private String pointOfContact;
        @JsonProperty(value="pointOfContactPhoneNumber")
        private String pointOfContactPhoneNumber;
        @JsonProperty(value="shippingPreference")
        private ShippingPreference shippingPreference;
        @JsonProperty(value="shippingVendor")
        private String shippingVendor;
        @JsonProperty(value="timePickupExpected")
        private Date timePickupExpected;
        @JsonProperty(value="timeReturnWindowStarts")
        private Date timeReturnWindowStarts;
        @JsonProperty(value="oracleShippingTrackingUrl")
        private String oracleShippingTrackingUrl;
        @JsonProperty(value="timeReturnWindowEnds")
        private Date timeReturnWindowEnds;
        @JsonProperty(value="returnShippingLabelUri")
        private String returnShippingLabelUri;
        @JsonProperty(value="publicKey")
        private String publicKey;
        @JsonProperty(value="imageExportPar")
        private String imageExportPar;
        @JsonProperty(value="freeformTags")
        private Map<String, String> freeformTags;
        @JsonProperty(value="definedTags")
        private Map<String, Map<String, Object>> definedTags;
        @JsonProperty(value="systemTags")
        private Map<String, Map<String, Object>> systemTags;
        @JsonIgnore
        private final Set<String> __explicitlySet__ = new HashSet<String>();

        public Builder id(String id) {
            this.id = id;
            this.__explicitlySet__.add("id");
            return this;
        }

        public Builder clusterId(String clusterId) {
            this.clusterId = clusterId;
            this.__explicitlySet__.add("clusterId");
            return this;
        }

        public Builder compartmentId(String compartmentId) {
            this.compartmentId = compartmentId;
            this.__explicitlySet__.add("compartmentId");
            return this;
        }

        public Builder nodeType(NodeType nodeType) {
            this.nodeType = nodeType;
            this.__explicitlySet__.add("nodeType");
            return this;
        }

        public Builder enclosureType(EnclosureType enclosureType) {
            this.enclosureType = enclosureType;
            this.__explicitlySet__.add("enclosureType");
            return this;
        }

        public Builder serialNumber(String serialNumber) {
            this.serialNumber = serialNumber;
            this.__explicitlySet__.add("serialNumber");
            return this;
        }

        public Builder displayName(String displayName) {
            this.displayName = displayName;
            this.__explicitlySet__.add("displayName");
            return this;
        }

        public Builder timeCreated(Date timeCreated) {
            this.timeCreated = timeCreated;
            this.__explicitlySet__.add("timeCreated");
            return this;
        }

        public Builder lifecycleState(LifecycleState lifecycleState) {
            this.lifecycleState = lifecycleState;
            this.__explicitlySet__.add("lifecycleState");
            return this;
        }

        public Builder lifecycleStateDetails(String lifecycleStateDetails) {
            this.lifecycleStateDetails = lifecycleStateDetails;
            this.__explicitlySet__.add("lifecycleStateDetails");
            return this;
        }

        public Builder customerShippingAddress(ShippingAddress customerShippingAddress) {
            this.customerShippingAddress = customerShippingAddress;
            this.__explicitlySet__.add("customerShippingAddress");
            return this;
        }

        public Builder nodeWorkloads(List<RoverWorkload> nodeWorkloads) {
            this.nodeWorkloads = nodeWorkloads;
            this.__explicitlySet__.add("nodeWorkloads");
            return this;
        }

        public Builder timeCustomerReceieved(Date timeCustomerReceieved) {
            this.timeCustomerReceieved = timeCustomerReceieved;
            this.__explicitlySet__.add("timeCustomerReceieved");
            return this;
        }

        public Builder timeCustomerReturned(Date timeCustomerReturned) {
            this.timeCustomerReturned = timeCustomerReturned;
            this.__explicitlySet__.add("timeCustomerReturned");
            return this;
        }

        public Builder deliveryTrackingInfo(String deliveryTrackingInfo) {
            this.deliveryTrackingInfo = deliveryTrackingInfo;
            this.__explicitlySet__.add("deliveryTrackingInfo");
            return this;
        }

        public Builder superUserPassword(String superUserPassword) {
            this.superUserPassword = superUserPassword;
            this.__explicitlySet__.add("superUserPassword");
            return this;
        }

        public Builder unlockPassphrase(String unlockPassphrase) {
            this.unlockPassphrase = unlockPassphrase;
            this.__explicitlySet__.add("unlockPassphrase");
            return this;
        }

        public Builder pointOfContact(String pointOfContact) {
            this.pointOfContact = pointOfContact;
            this.__explicitlySet__.add("pointOfContact");
            return this;
        }

        public Builder pointOfContactPhoneNumber(String pointOfContactPhoneNumber) {
            this.pointOfContactPhoneNumber = pointOfContactPhoneNumber;
            this.__explicitlySet__.add("pointOfContactPhoneNumber");
            return this;
        }

        public Builder shippingPreference(ShippingPreference shippingPreference) {
            this.shippingPreference = shippingPreference;
            this.__explicitlySet__.add("shippingPreference");
            return this;
        }

        public Builder shippingVendor(String shippingVendor) {
            this.shippingVendor = shippingVendor;
            this.__explicitlySet__.add("shippingVendor");
            return this;
        }

        public Builder timePickupExpected(Date timePickupExpected) {
            this.timePickupExpected = timePickupExpected;
            this.__explicitlySet__.add("timePickupExpected");
            return this;
        }

        public Builder timeReturnWindowStarts(Date timeReturnWindowStarts) {
            this.timeReturnWindowStarts = timeReturnWindowStarts;
            this.__explicitlySet__.add("timeReturnWindowStarts");
            return this;
        }

        public Builder oracleShippingTrackingUrl(String oracleShippingTrackingUrl) {
            this.oracleShippingTrackingUrl = oracleShippingTrackingUrl;
            this.__explicitlySet__.add("oracleShippingTrackingUrl");
            return this;
        }

        public Builder timeReturnWindowEnds(Date timeReturnWindowEnds) {
            this.timeReturnWindowEnds = timeReturnWindowEnds;
            this.__explicitlySet__.add("timeReturnWindowEnds");
            return this;
        }

        public Builder returnShippingLabelUri(String returnShippingLabelUri) {
            this.returnShippingLabelUri = returnShippingLabelUri;
            this.__explicitlySet__.add("returnShippingLabelUri");
            return this;
        }

        public Builder publicKey(String publicKey) {
            this.publicKey = publicKey;
            this.__explicitlySet__.add("publicKey");
            return this;
        }

        public Builder imageExportPar(String imageExportPar) {
            this.imageExportPar = imageExportPar;
            this.__explicitlySet__.add("imageExportPar");
            return this;
        }

        public Builder freeformTags(Map<String, String> freeformTags) {
            this.freeformTags = freeformTags;
            this.__explicitlySet__.add("freeformTags");
            return this;
        }

        public Builder definedTags(Map<String, Map<String, Object>> definedTags) {
            this.definedTags = definedTags;
            this.__explicitlySet__.add("definedTags");
            return this;
        }

        public Builder systemTags(Map<String, Map<String, Object>> systemTags) {
            this.systemTags = systemTags;
            this.__explicitlySet__.add("systemTags");
            return this;
        }

        public RoverNode build() {
            RoverNode __instance__ = new RoverNode(this.id, this.clusterId, this.compartmentId, this.nodeType, this.enclosureType, this.serialNumber, this.displayName, this.timeCreated, this.lifecycleState, this.lifecycleStateDetails, this.customerShippingAddress, this.nodeWorkloads, this.timeCustomerReceieved, this.timeCustomerReturned, this.deliveryTrackingInfo, this.superUserPassword, this.unlockPassphrase, this.pointOfContact, this.pointOfContactPhoneNumber, this.shippingPreference, this.shippingVendor, this.timePickupExpected, this.timeReturnWindowStarts, this.oracleShippingTrackingUrl, this.timeReturnWindowEnds, this.returnShippingLabelUri, this.publicKey, this.imageExportPar, this.freeformTags, this.definedTags, this.systemTags);
            __instance__.__explicitlySet__.addAll(this.__explicitlySet__);
            return __instance__;
        }

        @JsonIgnore
        public Builder copy(RoverNode o) {
            Builder copiedBuilder = this.id(o.getId()).clusterId(o.getClusterId()).compartmentId(o.getCompartmentId()).nodeType(o.getNodeType()).enclosureType(o.getEnclosureType()).serialNumber(o.getSerialNumber()).displayName(o.getDisplayName()).timeCreated(o.getTimeCreated()).lifecycleState(o.getLifecycleState()).lifecycleStateDetails(o.getLifecycleStateDetails()).customerShippingAddress(o.getCustomerShippingAddress()).nodeWorkloads(o.getNodeWorkloads()).timeCustomerReceieved(o.getTimeCustomerReceieved()).timeCustomerReturned(o.getTimeCustomerReturned()).deliveryTrackingInfo(o.getDeliveryTrackingInfo()).superUserPassword(o.getSuperUserPassword()).unlockPassphrase(o.getUnlockPassphrase()).pointOfContact(o.getPointOfContact()).pointOfContactPhoneNumber(o.getPointOfContactPhoneNumber()).shippingPreference(o.getShippingPreference()).shippingVendor(o.getShippingVendor()).timePickupExpected(o.getTimePickupExpected()).timeReturnWindowStarts(o.getTimeReturnWindowStarts()).oracleShippingTrackingUrl(o.getOracleShippingTrackingUrl()).timeReturnWindowEnds(o.getTimeReturnWindowEnds()).returnShippingLabelUri(o.getReturnShippingLabelUri()).publicKey(o.getPublicKey()).imageExportPar(o.getImageExportPar()).freeformTags(o.getFreeformTags()).definedTags(o.getDefinedTags()).systemTags(o.getSystemTags());
            copiedBuilder.__explicitlySet__.retainAll(o.__explicitlySet__);
            return copiedBuilder;
        }

        Builder() {
        }

        public String toString() {
            return "RoverNode.Builder(id=" + this.id + ", clusterId=" + this.clusterId + ", compartmentId=" + this.compartmentId + ", nodeType=" + (Object)((Object)this.nodeType) + ", enclosureType=" + (Object)((Object)this.enclosureType) + ", serialNumber=" + this.serialNumber + ", displayName=" + this.displayName + ", timeCreated=" + this.timeCreated + ", lifecycleState=" + (Object)((Object)this.lifecycleState) + ", lifecycleStateDetails=" + this.lifecycleStateDetails + ", customerShippingAddress=" + this.customerShippingAddress + ", nodeWorkloads=" + this.nodeWorkloads + ", timeCustomerReceieved=" + this.timeCustomerReceieved + ", timeCustomerReturned=" + this.timeCustomerReturned + ", deliveryTrackingInfo=" + this.deliveryTrackingInfo + ", superUserPassword=" + this.superUserPassword + ", unlockPassphrase=" + this.unlockPassphrase + ", pointOfContact=" + this.pointOfContact + ", pointOfContactPhoneNumber=" + this.pointOfContactPhoneNumber + ", shippingPreference=" + (Object)((Object)this.shippingPreference) + ", shippingVendor=" + this.shippingVendor + ", timePickupExpected=" + this.timePickupExpected + ", timeReturnWindowStarts=" + this.timeReturnWindowStarts + ", oracleShippingTrackingUrl=" + this.oracleShippingTrackingUrl + ", timeReturnWindowEnds=" + this.timeReturnWindowEnds + ", returnShippingLabelUri=" + this.returnShippingLabelUri + ", publicKey=" + this.publicKey + ", imageExportPar=" + this.imageExportPar + ", freeformTags=" + this.freeformTags + ", definedTags=" + this.definedTags + ", systemTags=" + this.systemTags + ")";
        }
    }
}

