/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.rover.requests;

import com.oracle.bmc.requests.BmcRequest;
import com.oracle.bmc.retrier.RetryConfiguration;
import com.oracle.bmc.util.internal.Consumer;
import java.beans.ConstructorProperties;
import javax.ws.rs.client.Invocation;

public class GetRoverClusterRequest
extends BmcRequest<Void> {
    private String roverClusterId;
    private String opcRequestId;

    @ConstructorProperties(value={"roverClusterId", "opcRequestId"})
    GetRoverClusterRequest(String roverClusterId, String opcRequestId) {
        this.roverClusterId = roverClusterId;
        this.opcRequestId = opcRequestId;
    }

    public static Builder builder() {
        return new Builder();
    }

    public String getRoverClusterId() {
        return this.roverClusterId;
    }

    public String getOpcRequestId() {
        return this.opcRequestId;
    }

    public static class Builder
    implements BmcRequest.Builder<GetRoverClusterRequest, Void> {
        private String roverClusterId;
        private String opcRequestId;
        private Consumer<Invocation.Builder> invocationCallback = null;
        private RetryConfiguration retryConfiguration = null;

        public Builder invocationCallback(Consumer<Invocation.Builder> invocationCallback) {
            this.invocationCallback = invocationCallback;
            return this;
        }

        public Builder retryConfiguration(RetryConfiguration retryConfiguration) {
            this.retryConfiguration = retryConfiguration;
            return this;
        }

        public Builder copy(GetRoverClusterRequest o) {
            this.roverClusterId(o.getRoverClusterId());
            this.opcRequestId(o.getOpcRequestId());
            this.invocationCallback((Consumer<Invocation.Builder>)o.getInvocationCallback());
            this.retryConfiguration(o.getRetryConfiguration());
            return this;
        }

        public GetRoverClusterRequest build() {
            GetRoverClusterRequest request = this.buildWithoutInvocationCallback();
            request.setInvocationCallback(this.invocationCallback);
            request.setRetryConfiguration(this.retryConfiguration);
            return request;
        }

        Builder() {
        }

        public Builder roverClusterId(String roverClusterId) {
            this.roverClusterId = roverClusterId;
            return this;
        }

        public Builder opcRequestId(String opcRequestId) {
            this.opcRequestId = opcRequestId;
            return this;
        }

        public GetRoverClusterRequest buildWithoutInvocationCallback() {
            return new GetRoverClusterRequest(this.roverClusterId, this.opcRequestId);
        }

        public String toString() {
            return "GetRoverClusterRequest.Builder(roverClusterId=" + this.roverClusterId + ", opcRequestId=" + this.opcRequestId + ")";
        }
    }
}

