/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.rover;

import com.oracle.bmc.ClientConfiguration;
import com.oracle.bmc.Region;
import com.oracle.bmc.Service;
import com.oracle.bmc.Services;
import com.oracle.bmc.auth.AbstractAuthenticationDetailsProvider;
import com.oracle.bmc.auth.BasicAuthenticationDetailsProvider;
import com.oracle.bmc.common.ClientBuilderBase;
import com.oracle.bmc.common.RegionalClientBuilder;
import com.oracle.bmc.http.ClientConfigurator;
import com.oracle.bmc.http.client.Method;
import com.oracle.bmc.http.internal.BaseSyncClient;
import com.oracle.bmc.http.internal.BmcEnum;
import com.oracle.bmc.http.signing.RequestSignerFactory;
import com.oracle.bmc.http.signing.SigningStrategy;
import com.oracle.bmc.http.signing.internal.DefaultRequestSignerFactory;
import com.oracle.bmc.internal.ClientThreadFactory;
import com.oracle.bmc.rover.RoverCluster;
import com.oracle.bmc.rover.RoverClusterPaginators;
import com.oracle.bmc.rover.RoverClusterWaiters;
import com.oracle.bmc.rover.model.RoverClusterCertificate;
import com.oracle.bmc.rover.model.RoverClusterCollection;
import com.oracle.bmc.rover.requests.ChangeRoverClusterCompartmentRequest;
import com.oracle.bmc.rover.requests.CreateRoverClusterRequest;
import com.oracle.bmc.rover.requests.DeleteRoverClusterRequest;
import com.oracle.bmc.rover.requests.GetRoverClusterCertificateRequest;
import com.oracle.bmc.rover.requests.GetRoverClusterRequest;
import com.oracle.bmc.rover.requests.ListRoverClustersRequest;
import com.oracle.bmc.rover.requests.UpdateRoverClusterRequest;
import com.oracle.bmc.rover.responses.ChangeRoverClusterCompartmentResponse;
import com.oracle.bmc.rover.responses.CreateRoverClusterResponse;
import com.oracle.bmc.rover.responses.DeleteRoverClusterResponse;
import com.oracle.bmc.rover.responses.GetRoverClusterCertificateResponse;
import com.oracle.bmc.rover.responses.GetRoverClusterResponse;
import com.oracle.bmc.rover.responses.ListRoverClustersResponse;
import com.oracle.bmc.rover.responses.UpdateRoverClusterResponse;
import com.oracle.bmc.util.CircuitBreakerUtils;
import com.oracle.bmc.util.internal.Validate;
import jakarta.annotation.Nonnull;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RoverClusterClient
extends BaseSyncClient
implements RoverCluster {
    public static final Service SERVICE = Services.serviceBuilder().serviceName("ROVERCLUSTER").serviceEndpointPrefix("").serviceEndpointTemplate("https://rover.{region}.oci.{secondLevelDomain}").build();
    private static final Logger LOG = LoggerFactory.getLogger(RoverClusterClient.class);
    private final RoverClusterWaiters waiters;
    private final RoverClusterPaginators paginators;

    RoverClusterClient(ClientBuilderBase<?, ?> builder, AbstractAuthenticationDetailsProvider authenticationDetailsProvider, ExecutorService executorService) {
        super(builder, authenticationDetailsProvider, CircuitBreakerUtils.DEFAULT_CIRCUIT_BREAKER_CONFIGURATION);
        if (executorService == null) {
            ThreadPoolExecutor threadPoolExecutor = new ThreadPoolExecutor(50, 50, 60L, TimeUnit.SECONDS, new LinkedBlockingQueue<Runnable>(), (ThreadFactory)ClientThreadFactory.builder().isDaemon(true).nameFormat("RoverCluster-waiters-%d").build());
            threadPoolExecutor.allowCoreThreadTimeOut(true);
            executorService = threadPoolExecutor;
        }
        this.waiters = new RoverClusterWaiters(executorService, this);
        this.paginators = new RoverClusterPaginators(this);
    }

    public static Builder builder() {
        return new Builder(SERVICE);
    }

    @Override
    public void setRegion(Region region) {
        super.setRegion(region);
    }

    @Override
    public void setRegion(String regionId) {
        super.setRegion(regionId);
    }

    @Override
    public ChangeRoverClusterCompartmentResponse changeRoverClusterCompartment(ChangeRoverClusterCompartmentRequest request) {
        Validate.notBlank((String)request.getRoverClusterId(), (String)"roverClusterId must not be blank", (Object[])new Object[0]);
        Objects.requireNonNull(request.getChangeRoverClusterCompartmentDetails(), "changeRoverClusterCompartmentDetails is required");
        return (ChangeRoverClusterCompartmentResponse)this.clientCall(request, ChangeRoverClusterCompartmentResponse::builder).logger(LOG, "changeRoverClusterCompartment").serviceDetails("RoverCluster", "ChangeRoverClusterCompartment", "https://docs.oracle.com/iaas/api/#/en/rover/20201210/RoverCluster/ChangeRoverClusterCompartment").method(Method.POST).requestBuilder(ChangeRoverClusterCompartmentRequest::builder).basePath("/20201210").appendPathParam("roverClusters").appendPathParam(request.getRoverClusterId()).appendPathParam("actions").appendPathParam("changeCompartment").accept(new String[]{"application/json"}).appendHeader("if-match", request.getIfMatch()).appendHeader("opc-request-id", request.getOpcRequestId()).appendHeader("opc-retry-token", request.getOpcRetryToken()).hasBody().handleResponseHeaderString("opc-request-id", ChangeRoverClusterCompartmentResponse.Builder::opcRequestId).operationUsesDefaultRetries().callSync();
    }

    @Override
    public CreateRoverClusterResponse createRoverCluster(CreateRoverClusterRequest request) {
        Objects.requireNonNull(request.getCreateRoverClusterDetails(), "createRoverClusterDetails is required");
        return (CreateRoverClusterResponse)this.clientCall(request, CreateRoverClusterResponse::builder).logger(LOG, "createRoverCluster").serviceDetails("RoverCluster", "CreateRoverCluster", "https://docs.oracle.com/iaas/api/#/en/rover/20201210/RoverCluster/CreateRoverCluster").method(Method.POST).requestBuilder(CreateRoverClusterRequest::builder).basePath("/20201210").appendPathParam("roverClusters").accept(new String[]{"application/json"}).appendHeader("opc-retry-token", request.getOpcRetryToken()).appendHeader("opc-request-id", request.getOpcRequestId()).hasBody().handleBody(com.oracle.bmc.rover.model.RoverCluster.class, CreateRoverClusterResponse.Builder::roverCluster).handleResponseHeaderString("etag", CreateRoverClusterResponse.Builder::etag).handleResponseHeaderString("opc-request-id", CreateRoverClusterResponse.Builder::opcRequestId).operationUsesDefaultRetries().callSync();
    }

    @Override
    public DeleteRoverClusterResponse deleteRoverCluster(DeleteRoverClusterRequest request) {
        Validate.notBlank((String)request.getRoverClusterId(), (String)"roverClusterId must not be blank", (Object[])new Object[0]);
        return (DeleteRoverClusterResponse)this.clientCall(request, DeleteRoverClusterResponse::builder).logger(LOG, "deleteRoverCluster").serviceDetails("RoverCluster", "DeleteRoverCluster", "https://docs.oracle.com/iaas/api/#/en/rover/20201210/RoverCluster/DeleteRoverCluster").method(Method.DELETE).requestBuilder(DeleteRoverClusterRequest::builder).basePath("/20201210").appendPathParam("roverClusters").appendPathParam(request.getRoverClusterId()).accept(new String[]{"application/json"}).appendHeader("if-match", request.getIfMatch()).appendHeader("opc-request-id", request.getOpcRequestId()).appendHeader("opc-retry-token", request.getOpcRetryToken()).handleResponseHeaderString("opc-request-id", DeleteRoverClusterResponse.Builder::opcRequestId).operationUsesDefaultRetries().callSync();
    }

    @Override
    public GetRoverClusterResponse getRoverCluster(GetRoverClusterRequest request) {
        Validate.notBlank((String)request.getRoverClusterId(), (String)"roverClusterId must not be blank", (Object[])new Object[0]);
        return (GetRoverClusterResponse)this.clientCall(request, GetRoverClusterResponse::builder).logger(LOG, "getRoverCluster").serviceDetails("RoverCluster", "GetRoverCluster", "https://docs.oracle.com/iaas/api/#/en/rover/20201210/RoverCluster/GetRoverCluster").method(Method.GET).requestBuilder(GetRoverClusterRequest::builder).basePath("/20201210").appendPathParam("roverClusters").appendPathParam(request.getRoverClusterId()).accept(new String[]{"application/json"}).appendHeader("opc-request-id", request.getOpcRequestId()).handleBody(com.oracle.bmc.rover.model.RoverCluster.class, GetRoverClusterResponse.Builder::roverCluster).handleResponseHeaderString("etag", GetRoverClusterResponse.Builder::etag).handleResponseHeaderString("opc-request-id", GetRoverClusterResponse.Builder::opcRequestId).operationUsesDefaultRetries().callSync();
    }

    @Override
    public GetRoverClusterCertificateResponse getRoverClusterCertificate(GetRoverClusterCertificateRequest request) {
        Validate.notBlank((String)request.getRoverClusterId(), (String)"roverClusterId must not be blank", (Object[])new Object[0]);
        return (GetRoverClusterCertificateResponse)this.clientCall(request, GetRoverClusterCertificateResponse::builder).logger(LOG, "getRoverClusterCertificate").serviceDetails("RoverCluster", "GetRoverClusterCertificate", "https://docs.oracle.com/iaas/api/#/en/rover/20201210/RoverClusterCertificate/GetRoverClusterCertificate").method(Method.GET).requestBuilder(GetRoverClusterCertificateRequest::builder).basePath("/20201210").appendPathParam("roverClusters").appendPathParam(request.getRoverClusterId()).appendPathParam("certificate").accept(new String[]{"application/json"}).appendHeader("opc-request-id", request.getOpcRequestId()).handleBody(RoverClusterCertificate.class, GetRoverClusterCertificateResponse.Builder::roverClusterCertificate).handleResponseHeaderString("etag", GetRoverClusterCertificateResponse.Builder::etag).handleResponseHeaderString("opc-request-id", GetRoverClusterCertificateResponse.Builder::opcRequestId).operationUsesDefaultRetries().callSync();
    }

    @Override
    public ListRoverClustersResponse listRoverClusters(ListRoverClustersRequest request) {
        Objects.requireNonNull(request.getCompartmentId(), "compartmentId is required");
        return (ListRoverClustersResponse)this.clientCall(request, ListRoverClustersResponse::builder).logger(LOG, "listRoverClusters").serviceDetails("RoverCluster", "ListRoverClusters", "https://docs.oracle.com/iaas/api/#/en/rover/20201210/RoverCluster/ListRoverClusters").method(Method.GET).requestBuilder(ListRoverClustersRequest::builder).basePath("/20201210").appendPathParam("roverClusters").appendQueryParam("compartmentId", (Object)request.getCompartmentId()).appendQueryParam("displayName", (Object)request.getDisplayName()).appendEnumQueryParam("clusterType", (BmcEnum)request.getClusterType()).appendQueryParam("limit", (Object)request.getLimit()).appendQueryParam("page", (Object)request.getPage()).appendEnumQueryParam("lifecycleState", (BmcEnum)request.getLifecycleState()).appendEnumQueryParam("sortOrder", (BmcEnum)request.getSortOrder()).appendEnumQueryParam("sortBy", (BmcEnum)request.getSortBy()).accept(new String[]{"application/json"}).appendHeader("opc-request-id", request.getOpcRequestId()).handleBody(RoverClusterCollection.class, ListRoverClustersResponse.Builder::roverClusterCollection).handleResponseHeaderString("opc-request-id", ListRoverClustersResponse.Builder::opcRequestId).handleResponseHeaderString("opc-next-page", ListRoverClustersResponse.Builder::opcNextPage).handleResponseHeaderString("opc-prev-page", ListRoverClustersResponse.Builder::opcPrevPage).operationUsesDefaultRetries().callSync();
    }

    @Override
    public UpdateRoverClusterResponse updateRoverCluster(UpdateRoverClusterRequest request) {
        Validate.notBlank((String)request.getRoverClusterId(), (String)"roverClusterId must not be blank", (Object[])new Object[0]);
        Objects.requireNonNull(request.getUpdateRoverClusterDetails(), "updateRoverClusterDetails is required");
        return (UpdateRoverClusterResponse)this.clientCall(request, UpdateRoverClusterResponse::builder).logger(LOG, "updateRoverCluster").serviceDetails("RoverCluster", "UpdateRoverCluster", "https://docs.oracle.com/iaas/api/#/en/rover/20201210/RoverCluster/UpdateRoverCluster").method(Method.PUT).requestBuilder(UpdateRoverClusterRequest::builder).basePath("/20201210").appendPathParam("roverClusters").appendPathParam(request.getRoverClusterId()).accept(new String[]{"application/json"}).appendHeader("if-match", request.getIfMatch()).appendHeader("opc-request-id", request.getOpcRequestId()).hasBody().handleBody(com.oracle.bmc.rover.model.RoverCluster.class, UpdateRoverClusterResponse.Builder::roverCluster).handleResponseHeaderString("etag", UpdateRoverClusterResponse.Builder::etag).handleResponseHeaderString("opc-request-id", UpdateRoverClusterResponse.Builder::opcRequestId).operationUsesDefaultRetries().callSync();
    }

    @Override
    public RoverClusterWaiters getWaiters() {
        return this.waiters;
    }

    @Override
    public RoverClusterPaginators getPaginators() {
        return this.paginators;
    }

    @Deprecated
    public RoverClusterClient(BasicAuthenticationDetailsProvider authenticationDetailsProvider) {
        this((ClientBuilderBase<?, ?>)RoverClusterClient.builder(), (AbstractAuthenticationDetailsProvider)authenticationDetailsProvider, null);
    }

    @Deprecated
    public RoverClusterClient(BasicAuthenticationDetailsProvider authenticationDetailsProvider, ClientConfiguration configuration) {
        this(RoverClusterClient.builder().configuration(configuration), (AbstractAuthenticationDetailsProvider)authenticationDetailsProvider, null);
    }

    @Deprecated
    public RoverClusterClient(BasicAuthenticationDetailsProvider authenticationDetailsProvider, ClientConfiguration configuration, ClientConfigurator clientConfigurator) {
        this(((Builder)RoverClusterClient.builder().configuration(configuration)).clientConfigurator(clientConfigurator), (AbstractAuthenticationDetailsProvider)authenticationDetailsProvider, null);
    }

    @Deprecated
    public RoverClusterClient(AbstractAuthenticationDetailsProvider authenticationDetailsProvider, ClientConfiguration configuration, ClientConfigurator clientConfigurator, RequestSignerFactory defaultRequestSignerFactory) {
        this(((Builder)((Builder)RoverClusterClient.builder().configuration(configuration)).clientConfigurator(clientConfigurator)).requestSignerFactory(defaultRequestSignerFactory), authenticationDetailsProvider, null);
    }

    @Deprecated
    public RoverClusterClient(AbstractAuthenticationDetailsProvider authenticationDetailsProvider, ClientConfiguration configuration, ClientConfigurator clientConfigurator, RequestSignerFactory defaultRequestSignerFactory, List<ClientConfigurator> additionalClientConfigurators) {
        this(((Builder)((Builder)((Builder)RoverClusterClient.builder().configuration(configuration)).clientConfigurator(clientConfigurator)).requestSignerFactory(defaultRequestSignerFactory)).additionalClientConfigurators(additionalClientConfigurators), authenticationDetailsProvider, null);
    }

    @Deprecated
    public RoverClusterClient(AbstractAuthenticationDetailsProvider authenticationDetailsProvider, ClientConfiguration configuration, ClientConfigurator clientConfigurator, RequestSignerFactory defaultRequestSignerFactory, List<ClientConfigurator> additionalClientConfigurators, String endpoint) {
        this(((Builder)((Builder)((Builder)((Builder)RoverClusterClient.builder().configuration(configuration)).clientConfigurator(clientConfigurator)).requestSignerFactory(defaultRequestSignerFactory)).additionalClientConfigurators(additionalClientConfigurators)).endpoint(endpoint), authenticationDetailsProvider, null);
    }

    @Deprecated
    public RoverClusterClient(AbstractAuthenticationDetailsProvider authenticationDetailsProvider, ClientConfiguration configuration, ClientConfigurator clientConfigurator, RequestSignerFactory defaultRequestSignerFactory, Map<SigningStrategy, RequestSignerFactory> signingStrategyRequestSignerFactories, List<ClientConfigurator> additionalClientConfigurators, String endpoint) {
        this(((Builder)((Builder)((Builder)((Builder)((Builder)RoverClusterClient.builder().configuration(configuration)).clientConfigurator(clientConfigurator)).requestSignerFactory(defaultRequestSignerFactory)).additionalClientConfigurators(additionalClientConfigurators)).endpoint(endpoint)).signingStrategyRequestSignerFactories(signingStrategyRequestSignerFactories), authenticationDetailsProvider, null);
    }

    @Deprecated
    public RoverClusterClient(AbstractAuthenticationDetailsProvider authenticationDetailsProvider, ClientConfiguration configuration, ClientConfigurator clientConfigurator, RequestSignerFactory defaultRequestSignerFactory, Map<SigningStrategy, RequestSignerFactory> signingStrategyRequestSignerFactories, List<ClientConfigurator> additionalClientConfigurators, String endpoint, ExecutorService executorService) {
        this(((Builder)((Builder)((Builder)((Builder)((Builder)RoverClusterClient.builder().configuration(configuration)).clientConfigurator(clientConfigurator)).requestSignerFactory(defaultRequestSignerFactory)).additionalClientConfigurators(additionalClientConfigurators)).endpoint(endpoint)).signingStrategyRequestSignerFactories(signingStrategyRequestSignerFactories), authenticationDetailsProvider, executorService);
    }

    public static class Builder
    extends RegionalClientBuilder<Builder, RoverClusterClient> {
        private ExecutorService executorService;

        private Builder(Service service) {
            super(service);
            this.requestSignerFactory = new DefaultRequestSignerFactory(SigningStrategy.STANDARD);
        }

        public Builder executorService(ExecutorService executorService) {
            this.executorService = executorService;
            return this;
        }

        public RoverClusterClient build(@Nonnull AbstractAuthenticationDetailsProvider authenticationDetailsProvider) {
            return new RoverClusterClient((ClientBuilderBase<?, ?>)this, authenticationDetailsProvider, this.executorService);
        }
    }
}

