/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.rover;

import com.oracle.bmc.ClientConfiguration;
import com.oracle.bmc.Region;
import com.oracle.bmc.Service;
import com.oracle.bmc.Services;
import com.oracle.bmc.auth.AbstractAuthenticationDetailsProvider;
import com.oracle.bmc.auth.BasicAuthenticationDetailsProvider;
import com.oracle.bmc.common.ClientBuilderBase;
import com.oracle.bmc.common.RegionalClientBuilder;
import com.oracle.bmc.http.ClientConfigurator;
import com.oracle.bmc.http.client.Method;
import com.oracle.bmc.http.internal.BaseSyncClient;
import com.oracle.bmc.http.internal.BmcEnum;
import com.oracle.bmc.http.signing.RequestSignerFactory;
import com.oracle.bmc.http.signing.SigningStrategy;
import com.oracle.bmc.http.signing.internal.DefaultRequestSignerFactory;
import com.oracle.bmc.internal.ClientThreadFactory;
import com.oracle.bmc.rover.RoverNode;
import com.oracle.bmc.rover.RoverNodePaginators;
import com.oracle.bmc.rover.RoverNodeWaiters;
import com.oracle.bmc.rover.model.RoverNodeCertificate;
import com.oracle.bmc.rover.model.RoverNodeCollection;
import com.oracle.bmc.rover.model.RoverNodeEncryptionKey;
import com.oracle.bmc.rover.model.RoverNodeGetRpt;
import com.oracle.bmc.rover.model.RoverNodeSetKey;
import com.oracle.bmc.rover.requests.ChangeRoverNodeCompartmentRequest;
import com.oracle.bmc.rover.requests.CreateRoverNodeRequest;
import com.oracle.bmc.rover.requests.DeleteRoverNodeRequest;
import com.oracle.bmc.rover.requests.GetRoverNodeCertificateRequest;
import com.oracle.bmc.rover.requests.GetRoverNodeEncryptionKeyRequest;
import com.oracle.bmc.rover.requests.GetRoverNodeGetRptRequest;
import com.oracle.bmc.rover.requests.GetRoverNodeRequest;
import com.oracle.bmc.rover.requests.ListRoverNodesRequest;
import com.oracle.bmc.rover.requests.RoverNodeActionSetKeyRequest;
import com.oracle.bmc.rover.requests.UpdateRoverNodeRequest;
import com.oracle.bmc.rover.responses.ChangeRoverNodeCompartmentResponse;
import com.oracle.bmc.rover.responses.CreateRoverNodeResponse;
import com.oracle.bmc.rover.responses.DeleteRoverNodeResponse;
import com.oracle.bmc.rover.responses.GetRoverNodeCertificateResponse;
import com.oracle.bmc.rover.responses.GetRoverNodeEncryptionKeyResponse;
import com.oracle.bmc.rover.responses.GetRoverNodeGetRptResponse;
import com.oracle.bmc.rover.responses.GetRoverNodeResponse;
import com.oracle.bmc.rover.responses.ListRoverNodesResponse;
import com.oracle.bmc.rover.responses.RoverNodeActionSetKeyResponse;
import com.oracle.bmc.rover.responses.UpdateRoverNodeResponse;
import com.oracle.bmc.util.CircuitBreakerUtils;
import com.oracle.bmc.util.internal.Validate;
import jakarta.annotation.Nonnull;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RoverNodeClient
extends BaseSyncClient
implements RoverNode {
    public static final Service SERVICE = Services.serviceBuilder().serviceName("ROVERNODE").serviceEndpointPrefix("").serviceEndpointTemplate("https://rover.{region}.oci.{secondLevelDomain}").build();
    private static final Logger LOG = LoggerFactory.getLogger(RoverNodeClient.class);
    private final RoverNodeWaiters waiters;
    private final RoverNodePaginators paginators;

    RoverNodeClient(ClientBuilderBase<?, ?> builder, AbstractAuthenticationDetailsProvider authenticationDetailsProvider, ExecutorService executorService) {
        super(builder, authenticationDetailsProvider, CircuitBreakerUtils.DEFAULT_CIRCUIT_BREAKER_CONFIGURATION);
        if (executorService == null) {
            ThreadPoolExecutor threadPoolExecutor = new ThreadPoolExecutor(50, 50, 60L, TimeUnit.SECONDS, new LinkedBlockingQueue<Runnable>(), (ThreadFactory)ClientThreadFactory.builder().isDaemon(true).nameFormat("RoverNode-waiters-%d").build());
            threadPoolExecutor.allowCoreThreadTimeOut(true);
            executorService = threadPoolExecutor;
        }
        this.waiters = new RoverNodeWaiters(executorService, this);
        this.paginators = new RoverNodePaginators(this);
    }

    public static Builder builder() {
        return new Builder(SERVICE);
    }

    @Override
    public void setRegion(Region region) {
        super.setRegion(region);
    }

    @Override
    public void setRegion(String regionId) {
        super.setRegion(regionId);
    }

    @Override
    public ChangeRoverNodeCompartmentResponse changeRoverNodeCompartment(ChangeRoverNodeCompartmentRequest request) {
        Validate.notBlank((String)request.getRoverNodeId(), (String)"roverNodeId must not be blank", (Object[])new Object[0]);
        Objects.requireNonNull(request.getChangeRoverNodeCompartmentDetails(), "changeRoverNodeCompartmentDetails is required");
        return (ChangeRoverNodeCompartmentResponse)this.clientCall(request, ChangeRoverNodeCompartmentResponse::builder).logger(LOG, "changeRoverNodeCompartment").serviceDetails("RoverNode", "ChangeRoverNodeCompartment", "https://docs.oracle.com/iaas/api/#/en/rover/20201210/RoverNode/ChangeRoverNodeCompartment").method(Method.POST).requestBuilder(ChangeRoverNodeCompartmentRequest::builder).basePath("/20201210").appendPathParam("roverNodes").appendPathParam(request.getRoverNodeId()).appendPathParam("actions").appendPathParam("changeCompartment").accept(new String[]{"application/json"}).appendHeader("if-match", request.getIfMatch()).appendHeader("opc-request-id", request.getOpcRequestId()).appendHeader("opc-retry-token", request.getOpcRetryToken()).hasBody().handleResponseHeaderString("opc-request-id", ChangeRoverNodeCompartmentResponse.Builder::opcRequestId).operationUsesDefaultRetries().callSync();
    }

    @Override
    public CreateRoverNodeResponse createRoverNode(CreateRoverNodeRequest request) {
        Objects.requireNonNull(request.getCreateRoverNodeDetails(), "createRoverNodeDetails is required");
        return (CreateRoverNodeResponse)this.clientCall(request, CreateRoverNodeResponse::builder).logger(LOG, "createRoverNode").serviceDetails("RoverNode", "CreateRoverNode", "https://docs.oracle.com/iaas/api/#/en/rover/20201210/RoverNode/CreateRoverNode").method(Method.POST).requestBuilder(CreateRoverNodeRequest::builder).basePath("/20201210").appendPathParam("roverNodes").accept(new String[]{"application/json"}).appendHeader("opc-retry-token", request.getOpcRetryToken()).appendHeader("opc-request-id", request.getOpcRequestId()).hasBody().handleBody(com.oracle.bmc.rover.model.RoverNode.class, CreateRoverNodeResponse.Builder::roverNode).handleResponseHeaderString("etag", CreateRoverNodeResponse.Builder::etag).handleResponseHeaderString("opc-request-id", CreateRoverNodeResponse.Builder::opcRequestId).operationUsesDefaultRetries().callSync();
    }

    @Override
    public DeleteRoverNodeResponse deleteRoverNode(DeleteRoverNodeRequest request) {
        Validate.notBlank((String)request.getRoverNodeId(), (String)"roverNodeId must not be blank", (Object[])new Object[0]);
        return (DeleteRoverNodeResponse)this.clientCall(request, DeleteRoverNodeResponse::builder).logger(LOG, "deleteRoverNode").serviceDetails("RoverNode", "DeleteRoverNode", "https://docs.oracle.com/iaas/api/#/en/rover/20201210/RoverNode/DeleteRoverNode").method(Method.DELETE).requestBuilder(DeleteRoverNodeRequest::builder).basePath("/20201210").appendPathParam("roverNodes").appendPathParam(request.getRoverNodeId()).accept(new String[]{"application/json"}).appendHeader("if-match", request.getIfMatch()).appendHeader("opc-request-id", request.getOpcRequestId()).appendHeader("opc-retry-token", request.getOpcRetryToken()).handleResponseHeaderString("opc-request-id", DeleteRoverNodeResponse.Builder::opcRequestId).operationUsesDefaultRetries().callSync();
    }

    @Override
    public GetRoverNodeResponse getRoverNode(GetRoverNodeRequest request) {
        Validate.notBlank((String)request.getRoverNodeId(), (String)"roverNodeId must not be blank", (Object[])new Object[0]);
        return (GetRoverNodeResponse)this.clientCall(request, GetRoverNodeResponse::builder).logger(LOG, "getRoverNode").serviceDetails("RoverNode", "GetRoverNode", "https://docs.oracle.com/iaas/api/#/en/rover/20201210/RoverNode/GetRoverNode").method(Method.GET).requestBuilder(GetRoverNodeRequest::builder).basePath("/20201210").appendPathParam("roverNodes").appendPathParam(request.getRoverNodeId()).accept(new String[]{"application/json"}).appendHeader("opc-request-id", request.getOpcRequestId()).handleBody(com.oracle.bmc.rover.model.RoverNode.class, GetRoverNodeResponse.Builder::roverNode).handleResponseHeaderString("etag", GetRoverNodeResponse.Builder::etag).handleResponseHeaderString("opc-request-id", GetRoverNodeResponse.Builder::opcRequestId).operationUsesDefaultRetries().callSync();
    }

    @Override
    public GetRoverNodeCertificateResponse getRoverNodeCertificate(GetRoverNodeCertificateRequest request) {
        Validate.notBlank((String)request.getRoverNodeId(), (String)"roverNodeId must not be blank", (Object[])new Object[0]);
        return (GetRoverNodeCertificateResponse)this.clientCall(request, GetRoverNodeCertificateResponse::builder).logger(LOG, "getRoverNodeCertificate").serviceDetails("RoverNode", "GetRoverNodeCertificate", "https://docs.oracle.com/iaas/api/#/en/rover/20201210/RoverNodeCertificate/GetRoverNodeCertificate").method(Method.GET).requestBuilder(GetRoverNodeCertificateRequest::builder).basePath("/20201210").appendPathParam("roverNodes").appendPathParam(request.getRoverNodeId()).appendPathParam("certificate").accept(new String[]{"application/json"}).appendHeader("opc-request-id", request.getOpcRequestId()).handleBody(RoverNodeCertificate.class, GetRoverNodeCertificateResponse.Builder::roverNodeCertificate).handleResponseHeaderString("etag", GetRoverNodeCertificateResponse.Builder::etag).handleResponseHeaderString("opc-request-id", GetRoverNodeCertificateResponse.Builder::opcRequestId).operationUsesDefaultRetries().callSync();
    }

    @Override
    public GetRoverNodeEncryptionKeyResponse getRoverNodeEncryptionKey(GetRoverNodeEncryptionKeyRequest request) {
        Validate.notBlank((String)request.getRoverNodeId(), (String)"roverNodeId must not be blank", (Object[])new Object[0]);
        return (GetRoverNodeEncryptionKeyResponse)this.clientCall(request, GetRoverNodeEncryptionKeyResponse::builder).logger(LOG, "getRoverNodeEncryptionKey").serviceDetails("RoverNode", "GetRoverNodeEncryptionKey", "https://docs.oracle.com/iaas/api/#/en/rover/20201210/RoverNodeEncryptionKey/GetRoverNodeEncryptionKey").method(Method.GET).requestBuilder(GetRoverNodeEncryptionKeyRequest::builder).basePath("/20201210").appendPathParam("roverNodes").appendPathParam(request.getRoverNodeId()).appendPathParam("encryptionKey").accept(new String[]{"application/json"}).appendHeader("opc-request-id", request.getOpcRequestId()).handleBody(RoverNodeEncryptionKey.class, GetRoverNodeEncryptionKeyResponse.Builder::roverNodeEncryptionKey).handleResponseHeaderString("etag", GetRoverNodeEncryptionKeyResponse.Builder::etag).handleResponseHeaderString("opc-request-id", GetRoverNodeEncryptionKeyResponse.Builder::opcRequestId).operationUsesDefaultRetries().callSync();
    }

    @Override
    public GetRoverNodeGetRptResponse getRoverNodeGetRpt(GetRoverNodeGetRptRequest request) {
        Validate.notBlank((String)request.getRoverNodeId(), (String)"roverNodeId must not be blank", (Object[])new Object[0]);
        Objects.requireNonNull(request.getJwt(), "jwt is required");
        return (GetRoverNodeGetRptResponse)this.clientCall(request, GetRoverNodeGetRptResponse::builder).logger(LOG, "getRoverNodeGetRpt").serviceDetails("RoverNode", "GetRoverNodeGetRpt", "https://docs.oracle.com/iaas/api/#/en/rover/20201210/RoverNodeGetRpt/GetRoverNodeGetRpt").method(Method.GET).requestBuilder(GetRoverNodeGetRptRequest::builder).basePath("/20201210").appendPathParam("roverNodes").appendPathParam(request.getRoverNodeId()).appendPathParam("getRpt").accept(new String[]{"application/json"}).appendHeader("jwt", request.getJwt()).appendHeader("opc-request-id", request.getOpcRequestId()).handleBody(RoverNodeGetRpt.class, GetRoverNodeGetRptResponse.Builder::roverNodeGetRpt).handleResponseHeaderString("etag", GetRoverNodeGetRptResponse.Builder::etag).handleResponseHeaderString("opc-request-id", GetRoverNodeGetRptResponse.Builder::opcRequestId).operationUsesDefaultRetries().callSync();
    }

    @Override
    public ListRoverNodesResponse listRoverNodes(ListRoverNodesRequest request) {
        Objects.requireNonNull(request.getCompartmentId(), "compartmentId is required");
        return (ListRoverNodesResponse)this.clientCall(request, ListRoverNodesResponse::builder).logger(LOG, "listRoverNodes").serviceDetails("RoverNode", "ListRoverNodes", "https://docs.oracle.com/iaas/api/#/en/rover/20201210/RoverNode/ListRoverNodes").method(Method.GET).requestBuilder(ListRoverNodesRequest::builder).basePath("/20201210").appendPathParam("roverNodes").appendQueryParam("compartmentId", (Object)request.getCompartmentId()).appendQueryParam("displayName", (Object)request.getDisplayName()).appendEnumQueryParam("nodeType", (BmcEnum)request.getNodeType()).appendQueryParam("shape", (Object)request.getShape()).appendQueryParam("limit", (Object)request.getLimit()).appendQueryParam("page", (Object)request.getPage()).appendEnumQueryParam("lifecycleState", (BmcEnum)request.getLifecycleState()).appendEnumQueryParam("sortOrder", (BmcEnum)request.getSortOrder()).appendEnumQueryParam("sortBy", (BmcEnum)request.getSortBy()).accept(new String[]{"application/json"}).appendHeader("opc-request-id", request.getOpcRequestId()).handleBody(RoverNodeCollection.class, ListRoverNodesResponse.Builder::roverNodeCollection).handleResponseHeaderString("opc-request-id", ListRoverNodesResponse.Builder::opcRequestId).handleResponseHeaderString("opc-next-page", ListRoverNodesResponse.Builder::opcNextPage).handleResponseHeaderString("opc-prev-page", ListRoverNodesResponse.Builder::opcPrevPage).operationUsesDefaultRetries().callSync();
    }

    @Override
    public RoverNodeActionSetKeyResponse roverNodeActionSetKey(RoverNodeActionSetKeyRequest request) {
        Validate.notBlank((String)request.getRoverNodeId(), (String)"roverNodeId must not be blank", (Object[])new Object[0]);
        Objects.requireNonNull(request.getJwt(), "jwt is required");
        Objects.requireNonNull(request.getRoverNodeActionSetKeyDetails(), "roverNodeActionSetKeyDetails is required");
        return (RoverNodeActionSetKeyResponse)this.clientCall(request, RoverNodeActionSetKeyResponse::builder).logger(LOG, "roverNodeActionSetKey").serviceDetails("RoverNode", "RoverNodeActionSetKey", "https://docs.oracle.com/iaas/api/#/en/rover/20201210/RoverNodeSetKey/RoverNodeActionSetKey").method(Method.POST).requestBuilder(RoverNodeActionSetKeyRequest::builder).basePath("/20201210").appendPathParam("roverNodes").appendPathParam(request.getRoverNodeId()).appendPathParam("actions").appendPathParam("setKey").accept(new String[]{"application/json"}).appendHeader("jwt", request.getJwt()).appendHeader("if-match", request.getIfMatch()).appendHeader("opc-request-id", request.getOpcRequestId()).appendHeader("opc-retry-token", request.getOpcRetryToken()).hasBody().handleBody(RoverNodeSetKey.class, RoverNodeActionSetKeyResponse.Builder::roverNodeSetKey).handleResponseHeaderString("etag", RoverNodeActionSetKeyResponse.Builder::etag).handleResponseHeaderString("opc-request-id", RoverNodeActionSetKeyResponse.Builder::opcRequestId).operationUsesDefaultRetries().callSync();
    }

    @Override
    public UpdateRoverNodeResponse updateRoverNode(UpdateRoverNodeRequest request) {
        Validate.notBlank((String)request.getRoverNodeId(), (String)"roverNodeId must not be blank", (Object[])new Object[0]);
        Objects.requireNonNull(request.getUpdateRoverNodeDetails(), "updateRoverNodeDetails is required");
        return (UpdateRoverNodeResponse)this.clientCall(request, UpdateRoverNodeResponse::builder).logger(LOG, "updateRoverNode").serviceDetails("RoverNode", "UpdateRoverNode", "https://docs.oracle.com/iaas/api/#/en/rover/20201210/RoverNode/UpdateRoverNode").method(Method.PUT).requestBuilder(UpdateRoverNodeRequest::builder).basePath("/20201210").appendPathParam("roverNodes").appendPathParam(request.getRoverNodeId()).accept(new String[]{"application/json"}).appendHeader("if-match", request.getIfMatch()).appendHeader("opc-request-id", request.getOpcRequestId()).hasBody().handleBody(com.oracle.bmc.rover.model.RoverNode.class, UpdateRoverNodeResponse.Builder::roverNode).handleResponseHeaderString("etag", UpdateRoverNodeResponse.Builder::etag).handleResponseHeaderString("opc-request-id", UpdateRoverNodeResponse.Builder::opcRequestId).operationUsesDefaultRetries().callSync();
    }

    @Override
    public RoverNodeWaiters getWaiters() {
        return this.waiters;
    }

    @Override
    public RoverNodePaginators getPaginators() {
        return this.paginators;
    }

    @Deprecated
    public RoverNodeClient(BasicAuthenticationDetailsProvider authenticationDetailsProvider) {
        this((ClientBuilderBase<?, ?>)RoverNodeClient.builder(), (AbstractAuthenticationDetailsProvider)authenticationDetailsProvider, null);
    }

    @Deprecated
    public RoverNodeClient(BasicAuthenticationDetailsProvider authenticationDetailsProvider, ClientConfiguration configuration) {
        this(RoverNodeClient.builder().configuration(configuration), (AbstractAuthenticationDetailsProvider)authenticationDetailsProvider, null);
    }

    @Deprecated
    public RoverNodeClient(BasicAuthenticationDetailsProvider authenticationDetailsProvider, ClientConfiguration configuration, ClientConfigurator clientConfigurator) {
        this(((Builder)RoverNodeClient.builder().configuration(configuration)).clientConfigurator(clientConfigurator), (AbstractAuthenticationDetailsProvider)authenticationDetailsProvider, null);
    }

    @Deprecated
    public RoverNodeClient(AbstractAuthenticationDetailsProvider authenticationDetailsProvider, ClientConfiguration configuration, ClientConfigurator clientConfigurator, RequestSignerFactory defaultRequestSignerFactory) {
        this(((Builder)((Builder)RoverNodeClient.builder().configuration(configuration)).clientConfigurator(clientConfigurator)).requestSignerFactory(defaultRequestSignerFactory), authenticationDetailsProvider, null);
    }

    @Deprecated
    public RoverNodeClient(AbstractAuthenticationDetailsProvider authenticationDetailsProvider, ClientConfiguration configuration, ClientConfigurator clientConfigurator, RequestSignerFactory defaultRequestSignerFactory, List<ClientConfigurator> additionalClientConfigurators) {
        this(((Builder)((Builder)((Builder)RoverNodeClient.builder().configuration(configuration)).clientConfigurator(clientConfigurator)).requestSignerFactory(defaultRequestSignerFactory)).additionalClientConfigurators(additionalClientConfigurators), authenticationDetailsProvider, null);
    }

    @Deprecated
    public RoverNodeClient(AbstractAuthenticationDetailsProvider authenticationDetailsProvider, ClientConfiguration configuration, ClientConfigurator clientConfigurator, RequestSignerFactory defaultRequestSignerFactory, List<ClientConfigurator> additionalClientConfigurators, String endpoint) {
        this(((Builder)((Builder)((Builder)((Builder)RoverNodeClient.builder().configuration(configuration)).clientConfigurator(clientConfigurator)).requestSignerFactory(defaultRequestSignerFactory)).additionalClientConfigurators(additionalClientConfigurators)).endpoint(endpoint), authenticationDetailsProvider, null);
    }

    @Deprecated
    public RoverNodeClient(AbstractAuthenticationDetailsProvider authenticationDetailsProvider, ClientConfiguration configuration, ClientConfigurator clientConfigurator, RequestSignerFactory defaultRequestSignerFactory, Map<SigningStrategy, RequestSignerFactory> signingStrategyRequestSignerFactories, List<ClientConfigurator> additionalClientConfigurators, String endpoint) {
        this(((Builder)((Builder)((Builder)((Builder)((Builder)RoverNodeClient.builder().configuration(configuration)).clientConfigurator(clientConfigurator)).requestSignerFactory(defaultRequestSignerFactory)).additionalClientConfigurators(additionalClientConfigurators)).endpoint(endpoint)).signingStrategyRequestSignerFactories(signingStrategyRequestSignerFactories), authenticationDetailsProvider, null);
    }

    @Deprecated
    public RoverNodeClient(AbstractAuthenticationDetailsProvider authenticationDetailsProvider, ClientConfiguration configuration, ClientConfigurator clientConfigurator, RequestSignerFactory defaultRequestSignerFactory, Map<SigningStrategy, RequestSignerFactory> signingStrategyRequestSignerFactories, List<ClientConfigurator> additionalClientConfigurators, String endpoint, ExecutorService executorService) {
        this(((Builder)((Builder)((Builder)((Builder)((Builder)RoverNodeClient.builder().configuration(configuration)).clientConfigurator(clientConfigurator)).requestSignerFactory(defaultRequestSignerFactory)).additionalClientConfigurators(additionalClientConfigurators)).endpoint(endpoint)).signingStrategyRequestSignerFactories(signingStrategyRequestSignerFactories), authenticationDetailsProvider, executorService);
    }

    public static class Builder
    extends RegionalClientBuilder<Builder, RoverNodeClient> {
        private ExecutorService executorService;

        private Builder(Service service) {
            super(service);
            this.requestSignerFactory = new DefaultRequestSignerFactory(SigningStrategy.STANDARD);
        }

        public Builder executorService(ExecutorService executorService) {
            this.executorService = executorService;
            return this;
        }

        public RoverNodeClient build(@Nonnull AbstractAuthenticationDetailsProvider authenticationDetailsProvider) {
            return new RoverNodeClient((ClientBuilderBase<?, ?>)this, authenticationDetailsProvider, this.executorService);
        }
    }
}

