/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.rover;

import com.oracle.bmc.ClientConfiguration;
import com.oracle.bmc.Region;
import com.oracle.bmc.Service;
import com.oracle.bmc.Services;
import com.oracle.bmc.auth.AbstractAuthenticationDetailsProvider;
import com.oracle.bmc.auth.BasicAuthenticationDetailsProvider;
import com.oracle.bmc.common.ClientBuilderBase;
import com.oracle.bmc.common.RegionalClientBuilder;
import com.oracle.bmc.http.ClientConfigurator;
import com.oracle.bmc.http.client.Method;
import com.oracle.bmc.http.internal.BaseAsyncClient;
import com.oracle.bmc.http.internal.BmcEnum;
import com.oracle.bmc.http.signing.RequestSignerFactory;
import com.oracle.bmc.http.signing.SigningStrategy;
import com.oracle.bmc.http.signing.internal.DefaultRequestSignerFactory;
import com.oracle.bmc.internal.Alloy;
import com.oracle.bmc.responses.AsyncHandler;
import com.oracle.bmc.rover.RoverBundleAsync;
import com.oracle.bmc.rover.model.RoverBundleRequestCollection;
import com.oracle.bmc.rover.model.RoverBundleStatus;
import com.oracle.bmc.rover.model.RoverBundleVersion;
import com.oracle.bmc.rover.requests.ListRoverClusterRoverBundleRequestsRequest;
import com.oracle.bmc.rover.requests.ListRoverNodeRoverBundleRequestsRequest;
import com.oracle.bmc.rover.requests.RequestBundleRoverClusterRequest;
import com.oracle.bmc.rover.requests.RequestBundleRoverNodeRequest;
import com.oracle.bmc.rover.requests.RetrieveAvailableBundleVersionsRoverClusterRequest;
import com.oracle.bmc.rover.requests.RetrieveAvailableBundleVersionsRoverNodeRequest;
import com.oracle.bmc.rover.requests.RetrieveBundleStatusRoverClusterRequest;
import com.oracle.bmc.rover.requests.RetrieveBundleStatusRoverNodeRequest;
import com.oracle.bmc.rover.responses.ListRoverClusterRoverBundleRequestsResponse;
import com.oracle.bmc.rover.responses.ListRoverNodeRoverBundleRequestsResponse;
import com.oracle.bmc.rover.responses.RequestBundleRoverClusterResponse;
import com.oracle.bmc.rover.responses.RequestBundleRoverNodeResponse;
import com.oracle.bmc.rover.responses.RetrieveAvailableBundleVersionsRoverClusterResponse;
import com.oracle.bmc.rover.responses.RetrieveAvailableBundleVersionsRoverNodeResponse;
import com.oracle.bmc.rover.responses.RetrieveBundleStatusRoverClusterResponse;
import com.oracle.bmc.rover.responses.RetrieveBundleStatusRoverNodeResponse;
import com.oracle.bmc.util.internal.Validate;
import jakarta.annotation.Nonnull;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.Future;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RoverBundleAsyncClient
extends BaseAsyncClient
implements RoverBundleAsync {
    public static final Service SERVICE = Services.serviceBuilder().serviceName("ROVERBUNDLE").serviceEndpointPrefix("").serviceEndpointTemplate("https://rover.{region}.oci.{secondLevelDomain}").build();
    private static final Logger LOG = LoggerFactory.getLogger(RoverBundleAsyncClient.class);

    RoverBundleAsyncClient(ClientBuilderBase<?, ?> builder, AbstractAuthenticationDetailsProvider authenticationDetailsProvider) {
        super(builder, authenticationDetailsProvider);
    }

    public static Builder builder() {
        return new Builder(SERVICE);
    }

    @Override
    public void setRegion(Region region) {
        super.setRegion(region);
    }

    @Override
    public void setRegion(String regionId) {
        super.setRegion(regionId);
    }

    @Override
    public Future<ListRoverClusterRoverBundleRequestsResponse> listRoverClusterRoverBundleRequests(ListRoverClusterRoverBundleRequestsRequest request, AsyncHandler<ListRoverClusterRoverBundleRequestsRequest, ListRoverClusterRoverBundleRequestsResponse> handler) {
        Validate.notBlank((String)request.getRoverClusterId(), (String)"roverClusterId must not be blank", (Object[])new Object[0]);
        return this.clientCall(request, ListRoverClusterRoverBundleRequestsResponse::builder).logger(LOG, "listRoverClusterRoverBundleRequests").serviceDetails("RoverBundle", "ListRoverClusterRoverBundleRequests", "https://docs.oracle.com/iaas/api/#/en/rover/20201210/RoverCluster/ListRoverClusterRoverBundleRequests").method(Method.GET).requestBuilder(ListRoverClusterRoverBundleRequestsRequest::builder).basePath("/20201210").appendPathParam("roverClusters").appendPathParam(request.getRoverClusterId()).appendPathParam("roverBundleRequests").appendQueryParam("limit", (Object)request.getLimit()).appendQueryParam("page", (Object)request.getPage()).appendEnumQueryParam("sortOrder", (BmcEnum)request.getSortOrder()).appendEnumQueryParam("sortBy", (BmcEnum)request.getSortBy()).accept(new String[]{"application/json"}).appendHeader("opc-request-id", request.getOpcRequestId()).handleBody(RoverBundleRequestCollection.class, ListRoverClusterRoverBundleRequestsResponse.Builder::roverBundleRequestCollection).handleResponseHeaderString("opc-request-id", ListRoverClusterRoverBundleRequestsResponse.Builder::opcRequestId).handleResponseHeaderString("opc-next-page", ListRoverClusterRoverBundleRequestsResponse.Builder::opcNextPage).callAsync(handler);
    }

    @Override
    public Future<ListRoverNodeRoverBundleRequestsResponse> listRoverNodeRoverBundleRequests(ListRoverNodeRoverBundleRequestsRequest request, AsyncHandler<ListRoverNodeRoverBundleRequestsRequest, ListRoverNodeRoverBundleRequestsResponse> handler) {
        Validate.notBlank((String)request.getRoverNodeId(), (String)"roverNodeId must not be blank", (Object[])new Object[0]);
        return this.clientCall(request, ListRoverNodeRoverBundleRequestsResponse::builder).logger(LOG, "listRoverNodeRoverBundleRequests").serviceDetails("RoverBundle", "ListRoverNodeRoverBundleRequests", "https://docs.oracle.com/iaas/api/#/en/rover/20201210/RoverNode/ListRoverNodeRoverBundleRequests").method(Method.GET).requestBuilder(ListRoverNodeRoverBundleRequestsRequest::builder).basePath("/20201210").appendPathParam("roverNodes").appendPathParam(request.getRoverNodeId()).appendPathParam("roverBundleRequests").appendQueryParam("limit", (Object)request.getLimit()).appendQueryParam("page", (Object)request.getPage()).appendEnumQueryParam("sortOrder", (BmcEnum)request.getSortOrder()).appendEnumQueryParam("sortBy", (BmcEnum)request.getSortBy()).accept(new String[]{"application/json"}).appendHeader("opc-request-id", request.getOpcRequestId()).handleBody(RoverBundleRequestCollection.class, ListRoverNodeRoverBundleRequestsResponse.Builder::roverBundleRequestCollection).handleResponseHeaderString("opc-request-id", ListRoverNodeRoverBundleRequestsResponse.Builder::opcRequestId).handleResponseHeaderString("opc-next-page", ListRoverNodeRoverBundleRequestsResponse.Builder::opcNextPage).callAsync(handler);
    }

    @Override
    public Future<RequestBundleRoverClusterResponse> requestBundleRoverCluster(RequestBundleRoverClusterRequest request, AsyncHandler<RequestBundleRoverClusterRequest, RequestBundleRoverClusterResponse> handler) {
        Objects.requireNonNull(request.getRequestRoverBundleDetails(), "requestRoverBundleDetails is required");
        Validate.notBlank((String)request.getRoverClusterId(), (String)"roverClusterId must not be blank", (Object[])new Object[0]);
        return this.clientCall(request, RequestBundleRoverClusterResponse::builder).logger(LOG, "requestBundleRoverCluster").serviceDetails("RoverBundle", "RequestBundleRoverCluster", "https://docs.oracle.com/iaas/api/#/en/rover/20201210/RoverCluster/RequestBundleRoverCluster").method(Method.POST).requestBuilder(RequestBundleRoverClusterRequest::builder).basePath("/20201210").appendPathParam("roverClusters").appendPathParam(request.getRoverClusterId()).appendPathParam("actions").appendPathParam("requestRoverBundle").accept(new String[]{"application/json"}).appendHeader("opc-request-id", request.getOpcRequestId()).hasBody().handleResponseHeaderString("opc-request-id", RequestBundleRoverClusterResponse.Builder::opcRequestId).handleResponseHeaderString("opc-work-request-id", RequestBundleRoverClusterResponse.Builder::opcWorkRequestId).callAsync(handler);
    }

    @Override
    public Future<RequestBundleRoverNodeResponse> requestBundleRoverNode(RequestBundleRoverNodeRequest request, AsyncHandler<RequestBundleRoverNodeRequest, RequestBundleRoverNodeResponse> handler) {
        Objects.requireNonNull(request.getRequestRoverBundleDetails(), "requestRoverBundleDetails is required");
        Validate.notBlank((String)request.getRoverNodeId(), (String)"roverNodeId must not be blank", (Object[])new Object[0]);
        return this.clientCall(request, RequestBundleRoverNodeResponse::builder).logger(LOG, "requestBundleRoverNode").serviceDetails("RoverBundle", "RequestBundleRoverNode", "https://docs.oracle.com/iaas/api/#/en/rover/20201210/RoverNode/RequestBundleRoverNode").method(Method.POST).requestBuilder(RequestBundleRoverNodeRequest::builder).basePath("/20201210").appendPathParam("roverNodes").appendPathParam(request.getRoverNodeId()).appendPathParam("actions").appendPathParam("requestRoverBundle").accept(new String[]{"application/json"}).appendHeader("opc-request-id", request.getOpcRequestId()).hasBody().handleResponseHeaderString("opc-request-id", RequestBundleRoverNodeResponse.Builder::opcRequestId).handleResponseHeaderString("opc-work-request-id", RequestBundleRoverNodeResponse.Builder::opcWorkRequestId).callAsync(handler);
    }

    @Override
    public Future<RetrieveAvailableBundleVersionsRoverClusterResponse> retrieveAvailableBundleVersionsRoverCluster(RetrieveAvailableBundleVersionsRoverClusterRequest request, AsyncHandler<RetrieveAvailableBundleVersionsRoverClusterRequest, RetrieveAvailableBundleVersionsRoverClusterResponse> handler) {
        Objects.requireNonNull(request.getCurrentRoverBundleDetails(), "currentRoverBundleDetails is required");
        Validate.notBlank((String)request.getRoverClusterId(), (String)"roverClusterId must not be blank", (Object[])new Object[0]);
        return this.clientCall(request, RetrieveAvailableBundleVersionsRoverClusterResponse::builder).logger(LOG, "retrieveAvailableBundleVersionsRoverCluster").serviceDetails("RoverBundle", "RetrieveAvailableBundleVersionsRoverCluster", "https://docs.oracle.com/iaas/api/#/en/rover/20201210/RoverCluster/RetrieveAvailableBundleVersionsRoverCluster").method(Method.POST).requestBuilder(RetrieveAvailableBundleVersionsRoverClusterRequest::builder).basePath("/20201210").appendPathParam("roverClusters").appendPathParam(request.getRoverClusterId()).appendPathParam("actions").appendPathParam("retrieveAvailableRoverBundleVersion").accept(new String[]{"application/json"}).appendHeader("opc-request-id", request.getOpcRequestId()).hasBody().handleBody(RoverBundleVersion.class, RetrieveAvailableBundleVersionsRoverClusterResponse.Builder::roverBundleVersion).handleResponseHeaderString("etag", RetrieveAvailableBundleVersionsRoverClusterResponse.Builder::etag).handleResponseHeaderString("opc-request-id", RetrieveAvailableBundleVersionsRoverClusterResponse.Builder::opcRequestId).callAsync(handler);
    }

    @Override
    public Future<RetrieveAvailableBundleVersionsRoverNodeResponse> retrieveAvailableBundleVersionsRoverNode(RetrieveAvailableBundleVersionsRoverNodeRequest request, AsyncHandler<RetrieveAvailableBundleVersionsRoverNodeRequest, RetrieveAvailableBundleVersionsRoverNodeResponse> handler) {
        Objects.requireNonNull(request.getCurrentRoverBundleDetails(), "currentRoverBundleDetails is required");
        Validate.notBlank((String)request.getRoverNodeId(), (String)"roverNodeId must not be blank", (Object[])new Object[0]);
        return this.clientCall(request, RetrieveAvailableBundleVersionsRoverNodeResponse::builder).logger(LOG, "retrieveAvailableBundleVersionsRoverNode").serviceDetails("RoverBundle", "RetrieveAvailableBundleVersionsRoverNode", "https://docs.oracle.com/iaas/api/#/en/rover/20201210/RoverNode/RetrieveAvailableBundleVersionsRoverNode").method(Method.POST).requestBuilder(RetrieveAvailableBundleVersionsRoverNodeRequest::builder).basePath("/20201210").appendPathParam("roverNodes").appendPathParam(request.getRoverNodeId()).appendPathParam("actions").appendPathParam("retrieveAvailableRoverBundleVersion").accept(new String[]{"application/json"}).appendHeader("opc-request-id", request.getOpcRequestId()).hasBody().handleBody(RoverBundleVersion.class, RetrieveAvailableBundleVersionsRoverNodeResponse.Builder::roverBundleVersion).handleResponseHeaderString("etag", RetrieveAvailableBundleVersionsRoverNodeResponse.Builder::etag).handleResponseHeaderString("opc-request-id", RetrieveAvailableBundleVersionsRoverNodeResponse.Builder::opcRequestId).callAsync(handler);
    }

    @Override
    public Future<RetrieveBundleStatusRoverClusterResponse> retrieveBundleStatusRoverCluster(RetrieveBundleStatusRoverClusterRequest request, AsyncHandler<RetrieveBundleStatusRoverClusterRequest, RetrieveBundleStatusRoverClusterResponse> handler) {
        Objects.requireNonNull(request.getRoverBundleStatusDetails(), "roverBundleStatusDetails is required");
        Validate.notBlank((String)request.getRoverClusterId(), (String)"roverClusterId must not be blank", (Object[])new Object[0]);
        return this.clientCall(request, RetrieveBundleStatusRoverClusterResponse::builder).logger(LOG, "retrieveBundleStatusRoverCluster").serviceDetails("RoverBundle", "RetrieveBundleStatusRoverCluster", "https://docs.oracle.com/iaas/api/#/en/rover/20201210/RoverCluster/RetrieveBundleStatusRoverCluster").method(Method.POST).requestBuilder(RetrieveBundleStatusRoverClusterRequest::builder).basePath("/20201210").appendPathParam("roverClusters").appendPathParam(request.getRoverClusterId()).appendPathParam("actions").appendPathParam("retrieveRoverBundleStatus").accept(new String[]{"application/json"}).appendHeader("opc-request-id", request.getOpcRequestId()).hasBody().handleBody(RoverBundleStatus.class, RetrieveBundleStatusRoverClusterResponse.Builder::roverBundleStatus).handleResponseHeaderString("etag", RetrieveBundleStatusRoverClusterResponse.Builder::etag).handleResponseHeaderString("opc-request-id", RetrieveBundleStatusRoverClusterResponse.Builder::opcRequestId).callAsync(handler);
    }

    @Override
    public Future<RetrieveBundleStatusRoverNodeResponse> retrieveBundleStatusRoverNode(RetrieveBundleStatusRoverNodeRequest request, AsyncHandler<RetrieveBundleStatusRoverNodeRequest, RetrieveBundleStatusRoverNodeResponse> handler) {
        Objects.requireNonNull(request.getRoverBundleStatusDetails(), "roverBundleStatusDetails is required");
        Validate.notBlank((String)request.getRoverNodeId(), (String)"roverNodeId must not be blank", (Object[])new Object[0]);
        return this.clientCall(request, RetrieveBundleStatusRoverNodeResponse::builder).logger(LOG, "retrieveBundleStatusRoverNode").serviceDetails("RoverBundle", "RetrieveBundleStatusRoverNode", "https://docs.oracle.com/iaas/api/#/en/rover/20201210/RoverNode/RetrieveBundleStatusRoverNode").method(Method.POST).requestBuilder(RetrieveBundleStatusRoverNodeRequest::builder).basePath("/20201210").appendPathParam("roverNodes").appendPathParam(request.getRoverNodeId()).appendPathParam("actions").appendPathParam("retrieveRoverBundleStatus").accept(new String[]{"application/json"}).appendHeader("opc-request-id", request.getOpcRequestId()).hasBody().handleBody(RoverBundleStatus.class, RetrieveBundleStatusRoverNodeResponse.Builder::roverBundleStatus).handleResponseHeaderString("etag", RetrieveBundleStatusRoverNodeResponse.Builder::etag).handleResponseHeaderString("opc-request-id", RetrieveBundleStatusRoverNodeResponse.Builder::opcRequestId).callAsync(handler);
    }

    @Deprecated
    public RoverBundleAsyncClient(BasicAuthenticationDetailsProvider authenticationDetailsProvider) {
        this((ClientBuilderBase<?, ?>)RoverBundleAsyncClient.builder(), (AbstractAuthenticationDetailsProvider)authenticationDetailsProvider);
    }

    @Deprecated
    public RoverBundleAsyncClient(BasicAuthenticationDetailsProvider authenticationDetailsProvider, ClientConfiguration configuration) {
        this(RoverBundleAsyncClient.builder().configuration(configuration), (AbstractAuthenticationDetailsProvider)authenticationDetailsProvider);
    }

    @Deprecated
    public RoverBundleAsyncClient(BasicAuthenticationDetailsProvider authenticationDetailsProvider, ClientConfiguration configuration, ClientConfigurator clientConfigurator) {
        this(((Builder)RoverBundleAsyncClient.builder().configuration(configuration)).clientConfigurator(clientConfigurator), (AbstractAuthenticationDetailsProvider)authenticationDetailsProvider);
    }

    @Deprecated
    public RoverBundleAsyncClient(AbstractAuthenticationDetailsProvider authenticationDetailsProvider, ClientConfiguration configuration, ClientConfigurator clientConfigurator, RequestSignerFactory defaultRequestSignerFactory) {
        this(((Builder)((Builder)RoverBundleAsyncClient.builder().configuration(configuration)).clientConfigurator(clientConfigurator)).requestSignerFactory(defaultRequestSignerFactory), authenticationDetailsProvider);
    }

    @Deprecated
    public RoverBundleAsyncClient(AbstractAuthenticationDetailsProvider authenticationDetailsProvider, ClientConfiguration configuration, ClientConfigurator clientConfigurator, RequestSignerFactory defaultRequestSignerFactory, List<ClientConfigurator> additionalClientConfigurators) {
        this(((Builder)((Builder)((Builder)RoverBundleAsyncClient.builder().configuration(configuration)).clientConfigurator(clientConfigurator)).requestSignerFactory(defaultRequestSignerFactory)).additionalClientConfigurators(additionalClientConfigurators), authenticationDetailsProvider);
    }

    @Deprecated
    public RoverBundleAsyncClient(AbstractAuthenticationDetailsProvider authenticationDetailsProvider, ClientConfiguration configuration, ClientConfigurator clientConfigurator, RequestSignerFactory defaultRequestSignerFactory, List<ClientConfigurator> additionalClientConfigurators, String endpoint) {
        this(((Builder)((Builder)((Builder)((Builder)RoverBundleAsyncClient.builder().configuration(configuration)).clientConfigurator(clientConfigurator)).requestSignerFactory(defaultRequestSignerFactory)).additionalClientConfigurators(additionalClientConfigurators)).endpoint(endpoint), authenticationDetailsProvider);
    }

    @Deprecated
    public RoverBundleAsyncClient(AbstractAuthenticationDetailsProvider authenticationDetailsProvider, ClientConfiguration configuration, ClientConfigurator clientConfigurator, RequestSignerFactory defaultRequestSignerFactory, Map<SigningStrategy, RequestSignerFactory> signingStrategyRequestSignerFactories, List<ClientConfigurator> additionalClientConfigurators, String endpoint) {
        this(((Builder)((Builder)((Builder)((Builder)((Builder)RoverBundleAsyncClient.builder().configuration(configuration)).clientConfigurator(clientConfigurator)).requestSignerFactory(defaultRequestSignerFactory)).additionalClientConfigurators(additionalClientConfigurators)).endpoint(endpoint)).signingStrategyRequestSignerFactories(signingStrategyRequestSignerFactories), authenticationDetailsProvider);
    }

    public static class Builder
    extends RegionalClientBuilder<Builder, RoverBundleAsyncClient> {
        private Builder(Service service) {
            super(service);
            String packageName = "rover";
            Alloy.throwDisabledServiceExceptionIfAppropriate((String)"rover");
            this.requestSignerFactory = new DefaultRequestSignerFactory(SigningStrategy.STANDARD);
        }

        public RoverBundleAsyncClient build(@Nonnull AbstractAuthenticationDetailsProvider authenticationDetailsProvider) {
            return new RoverBundleAsyncClient((ClientBuilderBase<?, ?>)this, authenticationDetailsProvider);
        }
    }
}

