/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.rover;

import com.oracle.bmc.ClientConfiguration;
import com.oracle.bmc.Region;
import com.oracle.bmc.Service;
import com.oracle.bmc.Services;
import com.oracle.bmc.auth.AbstractAuthenticationDetailsProvider;
import com.oracle.bmc.auth.BasicAuthenticationDetailsProvider;
import com.oracle.bmc.common.ClientBuilderBase;
import com.oracle.bmc.common.RegionalClientBuilder;
import com.oracle.bmc.http.ClientConfigurator;
import com.oracle.bmc.http.client.Method;
import com.oracle.bmc.http.internal.BaseAsyncClient;
import com.oracle.bmc.http.internal.BmcEnum;
import com.oracle.bmc.http.signing.RequestSignerFactory;
import com.oracle.bmc.http.signing.SigningStrategy;
import com.oracle.bmc.http.signing.internal.DefaultRequestSignerFactory;
import com.oracle.bmc.internal.Alloy;
import com.oracle.bmc.responses.AsyncHandler;
import com.oracle.bmc.rover.RoverEntitlementAsync;
import com.oracle.bmc.rover.model.RoverEntitlement;
import com.oracle.bmc.rover.model.RoverEntitlementCollection;
import com.oracle.bmc.rover.requests.ChangeRoverEntitlementCompartmentRequest;
import com.oracle.bmc.rover.requests.CreateRoverEntitlementRequest;
import com.oracle.bmc.rover.requests.DeleteRoverEntitlementRequest;
import com.oracle.bmc.rover.requests.GetRoverEntitlementRequest;
import com.oracle.bmc.rover.requests.ListRoverEntitlementsRequest;
import com.oracle.bmc.rover.requests.UpdateRoverEntitlementRequest;
import com.oracle.bmc.rover.responses.ChangeRoverEntitlementCompartmentResponse;
import com.oracle.bmc.rover.responses.CreateRoverEntitlementResponse;
import com.oracle.bmc.rover.responses.DeleteRoverEntitlementResponse;
import com.oracle.bmc.rover.responses.GetRoverEntitlementResponse;
import com.oracle.bmc.rover.responses.ListRoverEntitlementsResponse;
import com.oracle.bmc.rover.responses.UpdateRoverEntitlementResponse;
import com.oracle.bmc.util.internal.Validate;
import jakarta.annotation.Nonnull;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.Future;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RoverEntitlementAsyncClient
extends BaseAsyncClient
implements RoverEntitlementAsync {
    public static final Service SERVICE = Services.serviceBuilder().serviceName("ROVERENTITLEMENT").serviceEndpointPrefix("").serviceEndpointTemplate("https://rover.{region}.oci.{secondLevelDomain}").build();
    private static final Logger LOG = LoggerFactory.getLogger(RoverEntitlementAsyncClient.class);

    RoverEntitlementAsyncClient(ClientBuilderBase<?, ?> builder, AbstractAuthenticationDetailsProvider authenticationDetailsProvider) {
        super(builder, authenticationDetailsProvider);
    }

    public static Builder builder() {
        return new Builder(SERVICE);
    }

    @Override
    public void setRegion(Region region) {
        super.setRegion(region);
    }

    @Override
    public void setRegion(String regionId) {
        super.setRegion(regionId);
    }

    @Override
    public Future<ChangeRoverEntitlementCompartmentResponse> changeRoverEntitlementCompartment(ChangeRoverEntitlementCompartmentRequest request, AsyncHandler<ChangeRoverEntitlementCompartmentRequest, ChangeRoverEntitlementCompartmentResponse> handler) {
        Validate.notBlank((String)request.getRoverEntitlementId(), (String)"roverEntitlementId must not be blank", (Object[])new Object[0]);
        Objects.requireNonNull(request.getChangeRoverEntitlementCompartmentDetails(), "changeRoverEntitlementCompartmentDetails is required");
        return this.clientCall(request, ChangeRoverEntitlementCompartmentResponse::builder).logger(LOG, "changeRoverEntitlementCompartment").serviceDetails("RoverEntitlement", "ChangeRoverEntitlementCompartment", "https://docs.oracle.com/iaas/api/#/en/rover/20201210/RoverEntitlement/ChangeRoverEntitlementCompartment").method(Method.POST).requestBuilder(ChangeRoverEntitlementCompartmentRequest::builder).basePath("/20201210").appendPathParam("roverEntitlements").appendPathParam(request.getRoverEntitlementId()).appendPathParam("actions").appendPathParam("changeCompartment").accept(new String[]{"application/json"}).appendHeader("if-match", request.getIfMatch()).appendHeader("opc-request-id", request.getOpcRequestId()).appendHeader("opc-retry-token", request.getOpcRetryToken()).hasBody().handleResponseHeaderString("opc-request-id", ChangeRoverEntitlementCompartmentResponse.Builder::opcRequestId).callAsync(handler);
    }

    @Override
    public Future<CreateRoverEntitlementResponse> createRoverEntitlement(CreateRoverEntitlementRequest request, AsyncHandler<CreateRoverEntitlementRequest, CreateRoverEntitlementResponse> handler) {
        Objects.requireNonNull(request.getCreateRoverEntitlementDetails(), "createRoverEntitlementDetails is required");
        return this.clientCall(request, CreateRoverEntitlementResponse::builder).logger(LOG, "createRoverEntitlement").serviceDetails("RoverEntitlement", "CreateRoverEntitlement", "https://docs.oracle.com/iaas/api/#/en/rover/20201210/RoverEntitlement/CreateRoverEntitlement").method(Method.POST).requestBuilder(CreateRoverEntitlementRequest::builder).basePath("/20201210").appendPathParam("roverEntitlements").accept(new String[]{"application/json"}).appendHeader("opc-retry-token", request.getOpcRetryToken()).appendHeader("opc-request-id", request.getOpcRequestId()).hasBody().handleBody(RoverEntitlement.class, CreateRoverEntitlementResponse.Builder::roverEntitlement).handleResponseHeaderString("opc-request-id", CreateRoverEntitlementResponse.Builder::opcRequestId).handleResponseHeaderString("etag", CreateRoverEntitlementResponse.Builder::etag).callAsync(handler);
    }

    @Override
    public Future<DeleteRoverEntitlementResponse> deleteRoverEntitlement(DeleteRoverEntitlementRequest request, AsyncHandler<DeleteRoverEntitlementRequest, DeleteRoverEntitlementResponse> handler) {
        Validate.notBlank((String)request.getRoverEntitlementId(), (String)"roverEntitlementId must not be blank", (Object[])new Object[0]);
        return this.clientCall(request, DeleteRoverEntitlementResponse::builder).logger(LOG, "deleteRoverEntitlement").serviceDetails("RoverEntitlement", "DeleteRoverEntitlement", "https://docs.oracle.com/iaas/api/#/en/rover/20201210/RoverEntitlement/DeleteRoverEntitlement").method(Method.DELETE).requestBuilder(DeleteRoverEntitlementRequest::builder).basePath("/20201210").appendPathParam("roverEntitlements").appendPathParam(request.getRoverEntitlementId()).accept(new String[]{"application/json"}).appendHeader("opc-retry-token", request.getOpcRetryToken()).appendHeader("opc-request-id", request.getOpcRequestId()).appendHeader("if-match", request.getIfMatch()).handleResponseHeaderString("opc-request-id", DeleteRoverEntitlementResponse.Builder::opcRequestId).callAsync(handler);
    }

    @Override
    public Future<GetRoverEntitlementResponse> getRoverEntitlement(GetRoverEntitlementRequest request, AsyncHandler<GetRoverEntitlementRequest, GetRoverEntitlementResponse> handler) {
        Validate.notBlank((String)request.getRoverEntitlementId(), (String)"roverEntitlementId must not be blank", (Object[])new Object[0]);
        Objects.requireNonNull(request.getCompartmentId(), "compartmentId is required");
        return this.clientCall(request, GetRoverEntitlementResponse::builder).logger(LOG, "getRoverEntitlement").serviceDetails("RoverEntitlement", "GetRoverEntitlement", "https://docs.oracle.com/iaas/api/#/en/rover/20201210/RoverEntitlement/GetRoverEntitlement").method(Method.GET).requestBuilder(GetRoverEntitlementRequest::builder).basePath("/20201210").appendPathParam("roverEntitlements").appendPathParam(request.getRoverEntitlementId()).appendQueryParam("compartmentId", (Object)request.getCompartmentId()).accept(new String[]{"application/json"}).appendHeader("opc-retry-token", request.getOpcRetryToken()).appendHeader("opc-request-id", request.getOpcRequestId()).handleBody(RoverEntitlement.class, GetRoverEntitlementResponse.Builder::roverEntitlement).handleResponseHeaderString("opc-request-id", GetRoverEntitlementResponse.Builder::opcRequestId).handleResponseHeaderString("etag", GetRoverEntitlementResponse.Builder::etag).callAsync(handler);
    }

    @Override
    public Future<ListRoverEntitlementsResponse> listRoverEntitlements(ListRoverEntitlementsRequest request, AsyncHandler<ListRoverEntitlementsRequest, ListRoverEntitlementsResponse> handler) {
        Objects.requireNonNull(request.getCompartmentId(), "compartmentId is required");
        return this.clientCall(request, ListRoverEntitlementsResponse::builder).logger(LOG, "listRoverEntitlements").serviceDetails("RoverEntitlement", "ListRoverEntitlements", "https://docs.oracle.com/iaas/api/#/en/rover/20201210/RoverEntitlement/ListRoverEntitlements").method(Method.GET).requestBuilder(ListRoverEntitlementsRequest::builder).basePath("/20201210").appendPathParam("roverEntitlements").appendQueryParam("id", (Object)request.getId()).appendQueryParam("compartmentId", (Object)request.getCompartmentId()).appendQueryParam("displayName", (Object)request.getDisplayName()).appendEnumQueryParam("lifecycleState", (BmcEnum)request.getLifecycleState()).appendQueryParam("limit", (Object)request.getLimit()).appendQueryParam("page", (Object)request.getPage()).appendEnumQueryParam("sortOrder", (BmcEnum)request.getSortOrder()).appendEnumQueryParam("sortBy", (BmcEnum)request.getSortBy()).accept(new String[]{"application/json"}).appendHeader("opc-request-id", request.getOpcRequestId()).handleBody(RoverEntitlementCollection.class, ListRoverEntitlementsResponse.Builder::roverEntitlementCollection).handleResponseHeaderString("opc-request-id", ListRoverEntitlementsResponse.Builder::opcRequestId).handleResponseHeaderString("opc-next-page", ListRoverEntitlementsResponse.Builder::opcNextPage).handleResponseHeaderString("opc-prev-page", ListRoverEntitlementsResponse.Builder::opcPrevPage).callAsync(handler);
    }

    @Override
    public Future<UpdateRoverEntitlementResponse> updateRoverEntitlement(UpdateRoverEntitlementRequest request, AsyncHandler<UpdateRoverEntitlementRequest, UpdateRoverEntitlementResponse> handler) {
        Validate.notBlank((String)request.getRoverEntitlementId(), (String)"roverEntitlementId must not be blank", (Object[])new Object[0]);
        Objects.requireNonNull(request.getUpdateRoverEntitlementDetails(), "updateRoverEntitlementDetails is required");
        return this.clientCall(request, UpdateRoverEntitlementResponse::builder).logger(LOG, "updateRoverEntitlement").serviceDetails("RoverEntitlement", "UpdateRoverEntitlement", "https://docs.oracle.com/iaas/api/#/en/rover/20201210/RoverEntitlement/UpdateRoverEntitlement").method(Method.PUT).requestBuilder(UpdateRoverEntitlementRequest::builder).basePath("/20201210").appendPathParam("roverEntitlements").appendPathParam(request.getRoverEntitlementId()).accept(new String[]{"application/json"}).appendHeader("if-match", request.getIfMatch()).appendHeader("opc-request-id", request.getOpcRequestId()).hasBody().handleBody(RoverEntitlement.class, UpdateRoverEntitlementResponse.Builder::roverEntitlement).handleResponseHeaderString("etag", UpdateRoverEntitlementResponse.Builder::etag).handleResponseHeaderString("opc-request-id", UpdateRoverEntitlementResponse.Builder::opcRequestId).callAsync(handler);
    }

    @Deprecated
    public RoverEntitlementAsyncClient(BasicAuthenticationDetailsProvider authenticationDetailsProvider) {
        this((ClientBuilderBase<?, ?>)RoverEntitlementAsyncClient.builder(), (AbstractAuthenticationDetailsProvider)authenticationDetailsProvider);
    }

    @Deprecated
    public RoverEntitlementAsyncClient(BasicAuthenticationDetailsProvider authenticationDetailsProvider, ClientConfiguration configuration) {
        this(RoverEntitlementAsyncClient.builder().configuration(configuration), (AbstractAuthenticationDetailsProvider)authenticationDetailsProvider);
    }

    @Deprecated
    public RoverEntitlementAsyncClient(BasicAuthenticationDetailsProvider authenticationDetailsProvider, ClientConfiguration configuration, ClientConfigurator clientConfigurator) {
        this(((Builder)RoverEntitlementAsyncClient.builder().configuration(configuration)).clientConfigurator(clientConfigurator), (AbstractAuthenticationDetailsProvider)authenticationDetailsProvider);
    }

    @Deprecated
    public RoverEntitlementAsyncClient(AbstractAuthenticationDetailsProvider authenticationDetailsProvider, ClientConfiguration configuration, ClientConfigurator clientConfigurator, RequestSignerFactory defaultRequestSignerFactory) {
        this(((Builder)((Builder)RoverEntitlementAsyncClient.builder().configuration(configuration)).clientConfigurator(clientConfigurator)).requestSignerFactory(defaultRequestSignerFactory), authenticationDetailsProvider);
    }

    @Deprecated
    public RoverEntitlementAsyncClient(AbstractAuthenticationDetailsProvider authenticationDetailsProvider, ClientConfiguration configuration, ClientConfigurator clientConfigurator, RequestSignerFactory defaultRequestSignerFactory, List<ClientConfigurator> additionalClientConfigurators) {
        this(((Builder)((Builder)((Builder)RoverEntitlementAsyncClient.builder().configuration(configuration)).clientConfigurator(clientConfigurator)).requestSignerFactory(defaultRequestSignerFactory)).additionalClientConfigurators(additionalClientConfigurators), authenticationDetailsProvider);
    }

    @Deprecated
    public RoverEntitlementAsyncClient(AbstractAuthenticationDetailsProvider authenticationDetailsProvider, ClientConfiguration configuration, ClientConfigurator clientConfigurator, RequestSignerFactory defaultRequestSignerFactory, List<ClientConfigurator> additionalClientConfigurators, String endpoint) {
        this(((Builder)((Builder)((Builder)((Builder)RoverEntitlementAsyncClient.builder().configuration(configuration)).clientConfigurator(clientConfigurator)).requestSignerFactory(defaultRequestSignerFactory)).additionalClientConfigurators(additionalClientConfigurators)).endpoint(endpoint), authenticationDetailsProvider);
    }

    @Deprecated
    public RoverEntitlementAsyncClient(AbstractAuthenticationDetailsProvider authenticationDetailsProvider, ClientConfiguration configuration, ClientConfigurator clientConfigurator, RequestSignerFactory defaultRequestSignerFactory, Map<SigningStrategy, RequestSignerFactory> signingStrategyRequestSignerFactories, List<ClientConfigurator> additionalClientConfigurators, String endpoint) {
        this(((Builder)((Builder)((Builder)((Builder)((Builder)RoverEntitlementAsyncClient.builder().configuration(configuration)).clientConfigurator(clientConfigurator)).requestSignerFactory(defaultRequestSignerFactory)).additionalClientConfigurators(additionalClientConfigurators)).endpoint(endpoint)).signingStrategyRequestSignerFactories(signingStrategyRequestSignerFactories), authenticationDetailsProvider);
    }

    public static class Builder
    extends RegionalClientBuilder<Builder, RoverEntitlementAsyncClient> {
        private Builder(Service service) {
            super(service);
            String packageName = "rover";
            Alloy.throwDisabledServiceExceptionIfAppropriate((String)"rover");
            this.requestSignerFactory = new DefaultRequestSignerFactory(SigningStrategy.STANDARD);
        }

        public RoverEntitlementAsyncClient build(@Nonnull AbstractAuthenticationDetailsProvider authenticationDetailsProvider) {
            return new RoverEntitlementAsyncClient((ClientBuilderBase<?, ?>)this, authenticationDetailsProvider);
        }
    }
}

