/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.rover.model;

import com.fasterxml.jackson.annotation.JsonFilter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonPOJOBuilder;
import com.oracle.bmc.http.client.internal.ExplicitlySetBmcModel;
import java.beans.ConstructorProperties;
import java.util.Date;
import java.util.HashSet;
import java.util.Objects;
import java.util.Set;

@JsonDeserialize(builder=Builder.class)
@JsonFilter(value="explicitlySetFilter")
public final class RoverBundleRequestSummary
extends ExplicitlySetBmcModel {
    @JsonProperty(value="id")
    private final String id;
    @JsonProperty(value="destinationCompartmentId")
    private final String destinationCompartmentId;
    @JsonProperty(value="destinationBucketName")
    private final String destinationBucketName;
    @JsonProperty(value="bundleVersion")
    private final String bundleVersion;
    @JsonProperty(value="workRequestId")
    private final String workRequestId;
    @JsonProperty(value="timeTaskCreated")
    private final Date timeTaskCreated;

    @Deprecated
    @ConstructorProperties(value={"id", "destinationCompartmentId", "destinationBucketName", "bundleVersion", "workRequestId", "timeTaskCreated"})
    public RoverBundleRequestSummary(String id, String destinationCompartmentId, String destinationBucketName, String bundleVersion, String workRequestId, Date timeTaskCreated) {
        this.id = id;
        this.destinationCompartmentId = destinationCompartmentId;
        this.destinationBucketName = destinationBucketName;
        this.bundleVersion = bundleVersion;
        this.workRequestId = workRequestId;
        this.timeTaskCreated = timeTaskCreated;
    }

    public static Builder builder() {
        return new Builder();
    }

    public Builder toBuilder() {
        return new Builder().copy(this);
    }

    public String getId() {
        return this.id;
    }

    public String getDestinationCompartmentId() {
        return this.destinationCompartmentId;
    }

    public String getDestinationBucketName() {
        return this.destinationBucketName;
    }

    public String getBundleVersion() {
        return this.bundleVersion;
    }

    public String getWorkRequestId() {
        return this.workRequestId;
    }

    public Date getTimeTaskCreated() {
        return this.timeTaskCreated;
    }

    public String toString() {
        return this.toString(true);
    }

    public String toString(boolean includeByteArrayContents) {
        StringBuilder sb = new StringBuilder();
        sb.append("RoverBundleRequestSummary(");
        sb.append("super=").append(super.toString());
        sb.append("id=").append(String.valueOf(this.id));
        sb.append(", destinationCompartmentId=").append(String.valueOf(this.destinationCompartmentId));
        sb.append(", destinationBucketName=").append(String.valueOf(this.destinationBucketName));
        sb.append(", bundleVersion=").append(String.valueOf(this.bundleVersion));
        sb.append(", workRequestId=").append(String.valueOf(this.workRequestId));
        sb.append(", timeTaskCreated=").append(String.valueOf(this.timeTaskCreated));
        sb.append(")");
        return sb.toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof RoverBundleRequestSummary)) {
            return false;
        }
        RoverBundleRequestSummary other = (RoverBundleRequestSummary)((Object)o);
        return Objects.equals(this.id, other.id) && Objects.equals(this.destinationCompartmentId, other.destinationCompartmentId) && Objects.equals(this.destinationBucketName, other.destinationBucketName) && Objects.equals(this.bundleVersion, other.bundleVersion) && Objects.equals(this.workRequestId, other.workRequestId) && Objects.equals(this.timeTaskCreated, other.timeTaskCreated) && super.equals((Object)other);
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + (this.id == null ? 43 : this.id.hashCode());
        result = result * 59 + (this.destinationCompartmentId == null ? 43 : this.destinationCompartmentId.hashCode());
        result = result * 59 + (this.destinationBucketName == null ? 43 : this.destinationBucketName.hashCode());
        result = result * 59 + (this.bundleVersion == null ? 43 : this.bundleVersion.hashCode());
        result = result * 59 + (this.workRequestId == null ? 43 : this.workRequestId.hashCode());
        result = result * 59 + (this.timeTaskCreated == null ? 43 : this.timeTaskCreated.hashCode());
        result = result * 59 + super.hashCode();
        return result;
    }

    @JsonPOJOBuilder(withPrefix="")
    public static class Builder {
        @JsonProperty(value="id")
        private String id;
        @JsonProperty(value="destinationCompartmentId")
        private String destinationCompartmentId;
        @JsonProperty(value="destinationBucketName")
        private String destinationBucketName;
        @JsonProperty(value="bundleVersion")
        private String bundleVersion;
        @JsonProperty(value="workRequestId")
        private String workRequestId;
        @JsonProperty(value="timeTaskCreated")
        private Date timeTaskCreated;
        @JsonIgnore
        private final Set<String> __explicitlySet__ = new HashSet<String>();

        public Builder id(String id) {
            this.id = id;
            this.__explicitlySet__.add("id");
            return this;
        }

        public Builder destinationCompartmentId(String destinationCompartmentId) {
            this.destinationCompartmentId = destinationCompartmentId;
            this.__explicitlySet__.add("destinationCompartmentId");
            return this;
        }

        public Builder destinationBucketName(String destinationBucketName) {
            this.destinationBucketName = destinationBucketName;
            this.__explicitlySet__.add("destinationBucketName");
            return this;
        }

        public Builder bundleVersion(String bundleVersion) {
            this.bundleVersion = bundleVersion;
            this.__explicitlySet__.add("bundleVersion");
            return this;
        }

        public Builder workRequestId(String workRequestId) {
            this.workRequestId = workRequestId;
            this.__explicitlySet__.add("workRequestId");
            return this;
        }

        public Builder timeTaskCreated(Date timeTaskCreated) {
            this.timeTaskCreated = timeTaskCreated;
            this.__explicitlySet__.add("timeTaskCreated");
            return this;
        }

        public RoverBundleRequestSummary build() {
            RoverBundleRequestSummary model = new RoverBundleRequestSummary(this.id, this.destinationCompartmentId, this.destinationBucketName, this.bundleVersion, this.workRequestId, this.timeTaskCreated);
            for (String explicitlySetProperty : this.__explicitlySet__) {
                model.markPropertyAsExplicitlySet(explicitlySetProperty);
            }
            return model;
        }

        @JsonIgnore
        public Builder copy(RoverBundleRequestSummary model) {
            if (model.wasPropertyExplicitlySet("id")) {
                this.id(model.getId());
            }
            if (model.wasPropertyExplicitlySet("destinationCompartmentId")) {
                this.destinationCompartmentId(model.getDestinationCompartmentId());
            }
            if (model.wasPropertyExplicitlySet("destinationBucketName")) {
                this.destinationBucketName(model.getDestinationBucketName());
            }
            if (model.wasPropertyExplicitlySet("bundleVersion")) {
                this.bundleVersion(model.getBundleVersion());
            }
            if (model.wasPropertyExplicitlySet("workRequestId")) {
                this.workRequestId(model.getWorkRequestId());
            }
            if (model.wasPropertyExplicitlySet("timeTaskCreated")) {
                this.timeTaskCreated(model.getTimeTaskCreated());
            }
            return this;
        }
    }
}

