/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.rover.model;

import com.fasterxml.jackson.annotation.JsonFilter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonPOJOBuilder;
import com.oracle.bmc.http.client.internal.ExplicitlySetBmcModel;
import java.beans.ConstructorProperties;
import java.util.HashSet;
import java.util.Objects;
import java.util.Set;

@JsonDeserialize(builder=Builder.class)
@JsonFilter(value="explicitlySetFilter")
public final class RoverBundleVersion
extends ExplicitlySetBmcModel {
    @JsonProperty(value="bundleVersion")
    private final String bundleVersion;
    @JsonProperty(value="compartmentId")
    private final String compartmentId;
    @JsonProperty(value="bundleName")
    private final String bundleName;

    @Deprecated
    @ConstructorProperties(value={"bundleVersion", "compartmentId", "bundleName"})
    public RoverBundleVersion(String bundleVersion, String compartmentId, String bundleName) {
        this.bundleVersion = bundleVersion;
        this.compartmentId = compartmentId;
        this.bundleName = bundleName;
    }

    public static Builder builder() {
        return new Builder();
    }

    public Builder toBuilder() {
        return new Builder().copy(this);
    }

    public String getBundleVersion() {
        return this.bundleVersion;
    }

    public String getCompartmentId() {
        return this.compartmentId;
    }

    public String getBundleName() {
        return this.bundleName;
    }

    public String toString() {
        return this.toString(true);
    }

    public String toString(boolean includeByteArrayContents) {
        StringBuilder sb = new StringBuilder();
        sb.append("RoverBundleVersion(");
        sb.append("super=").append(super.toString());
        sb.append("bundleVersion=").append(String.valueOf(this.bundleVersion));
        sb.append(", compartmentId=").append(String.valueOf(this.compartmentId));
        sb.append(", bundleName=").append(String.valueOf(this.bundleName));
        sb.append(")");
        return sb.toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof RoverBundleVersion)) {
            return false;
        }
        RoverBundleVersion other = (RoverBundleVersion)((Object)o);
        return Objects.equals(this.bundleVersion, other.bundleVersion) && Objects.equals(this.compartmentId, other.compartmentId) && Objects.equals(this.bundleName, other.bundleName) && super.equals((Object)other);
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + (this.bundleVersion == null ? 43 : this.bundleVersion.hashCode());
        result = result * 59 + (this.compartmentId == null ? 43 : this.compartmentId.hashCode());
        result = result * 59 + (this.bundleName == null ? 43 : this.bundleName.hashCode());
        result = result * 59 + super.hashCode();
        return result;
    }

    @JsonPOJOBuilder(withPrefix="")
    public static class Builder {
        @JsonProperty(value="bundleVersion")
        private String bundleVersion;
        @JsonProperty(value="compartmentId")
        private String compartmentId;
        @JsonProperty(value="bundleName")
        private String bundleName;
        @JsonIgnore
        private final Set<String> __explicitlySet__ = new HashSet<String>();

        public Builder bundleVersion(String bundleVersion) {
            this.bundleVersion = bundleVersion;
            this.__explicitlySet__.add("bundleVersion");
            return this;
        }

        public Builder compartmentId(String compartmentId) {
            this.compartmentId = compartmentId;
            this.__explicitlySet__.add("compartmentId");
            return this;
        }

        public Builder bundleName(String bundleName) {
            this.bundleName = bundleName;
            this.__explicitlySet__.add("bundleName");
            return this;
        }

        public RoverBundleVersion build() {
            RoverBundleVersion model = new RoverBundleVersion(this.bundleVersion, this.compartmentId, this.bundleName);
            for (String explicitlySetProperty : this.__explicitlySet__) {
                model.markPropertyAsExplicitlySet(explicitlySetProperty);
            }
            return model;
        }

        @JsonIgnore
        public Builder copy(RoverBundleVersion model) {
            if (model.wasPropertyExplicitlySet("bundleVersion")) {
                this.bundleVersion(model.getBundleVersion());
            }
            if (model.wasPropertyExplicitlySet("compartmentId")) {
                this.compartmentId(model.getCompartmentId());
            }
            if (model.wasPropertyExplicitlySet("bundleName")) {
                this.bundleName(model.getBundleName());
            }
            return this;
        }
    }
}

