/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.rover;

import com.oracle.bmc.rover.RoverNode;
import com.oracle.bmc.rover.model.LifecycleState;
import com.oracle.bmc.rover.requests.GetRoverNodeRequest;
import com.oracle.bmc.rover.responses.GetRoverNodeResponse;
import com.oracle.bmc.util.internal.Validate;
import com.oracle.bmc.waiter.BmcGenericWaiter;
import com.oracle.bmc.waiter.DelayStrategy;
import com.oracle.bmc.waiter.TerminationStrategy;
import com.oracle.bmc.waiter.Waiter;
import com.oracle.bmc.waiter.Waiters;
import com.oracle.bmc.waiter.internal.SimpleWaiterImpl;
import java.util.Arrays;
import java.util.HashSet;
import java.util.concurrent.ExecutorService;
import java.util.function.Function;
import java.util.function.Predicate;

public class RoverNodeWaiters {
    private final ExecutorService executorService;
    private final RoverNode client;

    public RoverNodeWaiters(ExecutorService executorService, RoverNode client) {
        this.executorService = executorService;
        this.client = client;
    }

    public Waiter<GetRoverNodeRequest, GetRoverNodeResponse> forRoverNode(GetRoverNodeRequest request, LifecycleState ... targetStates) {
        Validate.notEmpty((Object[])targetStates, (String)"At least one targetState must be provided", (Object[])new Object[0]);
        Validate.noNullElements((Object[])targetStates, (String)"Null targetState values are not permitted", (Object[])new Object[0]);
        return this.forRoverNode(Waiters.DEFAULT_POLLING_WAITER, request, targetStates);
    }

    public Waiter<GetRoverNodeRequest, GetRoverNodeResponse> forRoverNode(GetRoverNodeRequest request, LifecycleState targetState, TerminationStrategy terminationStrategy, DelayStrategy delayStrategy) {
        Validate.notNull((Object)((Object)targetState), (String)"The targetState cannot be null", (Object[])new Object[0]);
        return this.forRoverNode(Waiters.newWaiter((TerminationStrategy)terminationStrategy, (DelayStrategy)delayStrategy), request, targetState);
    }

    public Waiter<GetRoverNodeRequest, GetRoverNodeResponse> forRoverNode(GetRoverNodeRequest request, TerminationStrategy terminationStrategy, DelayStrategy delayStrategy, LifecycleState ... targetStates) {
        Validate.notEmpty((Object[])targetStates, (String)"At least one targetState must be provided", (Object[])new Object[0]);
        Validate.noNullElements((Object[])targetStates, (String)"Null targetState values are not permitted", (Object[])new Object[0]);
        return this.forRoverNode(Waiters.newWaiter((TerminationStrategy)terminationStrategy, (DelayStrategy)delayStrategy), request, targetStates);
    }

    private Waiter<GetRoverNodeRequest, GetRoverNodeResponse> forRoverNode(BmcGenericWaiter waiter, GetRoverNodeRequest request, LifecycleState ... targetStates) {
        final HashSet<LifecycleState> targetStatesSet = new HashSet<LifecycleState>(Arrays.asList(targetStates));
        return new SimpleWaiterImpl(this.executorService, waiter.toCallable(() -> request, (Function)new Function<GetRoverNodeRequest, GetRoverNodeResponse>(){

            @Override
            public GetRoverNodeResponse apply(GetRoverNodeRequest request) {
                return RoverNodeWaiters.this.client.getRoverNode(request);
            }
        }, (Predicate)new Predicate<GetRoverNodeResponse>(){

            @Override
            public boolean test(GetRoverNodeResponse response) {
                return targetStatesSet.contains((Object)response.getRoverNode().getLifecycleState());
            }
        }, targetStatesSet.contains((Object)LifecycleState.Deleted)), (Object)request);
    }
}

