/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.rover.model;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonFilter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonValue;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonPOJOBuilder;
import com.oracle.bmc.http.client.internal.ExplicitlySetBmcModel;
import com.oracle.bmc.http.internal.BmcEnum;
import com.oracle.bmc.rover.model.CertKeyAlgorithm;
import com.oracle.bmc.rover.model.CertSignatureAlgorithm;
import com.oracle.bmc.rover.model.EnclosureType;
import com.oracle.bmc.rover.model.LifecycleState;
import com.oracle.bmc.rover.model.NodeType;
import com.oracle.bmc.rover.model.RoverWorkload;
import com.oracle.bmc.rover.model.ShippingAddress;
import java.beans.ConstructorProperties;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@JsonDeserialize(builder=Builder.class)
@JsonFilter(value="explicitlySetFilter")
public final class RoverNode
extends ExplicitlySetBmcModel {
    @JsonProperty(value="id")
    private final String id;
    @JsonProperty(value="clusterId")
    private final String clusterId;
    @JsonProperty(value="compartmentId")
    private final String compartmentId;
    @JsonProperty(value="nodeType")
    private final NodeType nodeType;
    @JsonProperty(value="shape")
    private final String shape;
    @JsonProperty(value="enclosureType")
    private final EnclosureType enclosureType;
    @JsonProperty(value="serialNumber")
    private final String serialNumber;
    @JsonProperty(value="displayName")
    private final String displayName;
    @JsonProperty(value="timeCreated")
    private final Date timeCreated;
    @JsonProperty(value="lifecycleState")
    private final LifecycleState lifecycleState;
    @JsonProperty(value="lifecycleStateDetails")
    private final String lifecycleStateDetails;
    @JsonProperty(value="customerShippingAddress")
    private final ShippingAddress customerShippingAddress;
    @JsonProperty(value="nodeWorkloads")
    private final List<RoverWorkload> nodeWorkloads;
    @JsonProperty(value="timeCustomerReceieved")
    private final Date timeCustomerReceieved;
    @JsonProperty(value="timeCustomerReturned")
    private final Date timeCustomerReturned;
    @JsonProperty(value="deliveryTrackingInfo")
    private final String deliveryTrackingInfo;
    @JsonProperty(value="superUserPassword")
    private final String superUserPassword;
    @JsonProperty(value="unlockPassphrase")
    private final String unlockPassphrase;
    @JsonProperty(value="pointOfContact")
    private final String pointOfContact;
    @JsonProperty(value="pointOfContactPhoneNumber")
    private final String pointOfContactPhoneNumber;
    @JsonProperty(value="shippingPreference")
    private final ShippingPreference shippingPreference;
    @JsonProperty(value="shippingVendor")
    private final String shippingVendor;
    @JsonProperty(value="timePickupExpected")
    private final Date timePickupExpected;
    @JsonProperty(value="timeReturnWindowStarts")
    private final Date timeReturnWindowStarts;
    @JsonProperty(value="oracleShippingTrackingUrl")
    private final String oracleShippingTrackingUrl;
    @JsonProperty(value="timeReturnWindowEnds")
    private final Date timeReturnWindowEnds;
    @JsonProperty(value="returnShippingLabelUri")
    private final String returnShippingLabelUri;
    @JsonProperty(value="isImportRequested")
    private final Boolean isImportRequested;
    @JsonProperty(value="importCompartmentId")
    private final String importCompartmentId;
    @JsonProperty(value="importFileBucket")
    private final String importFileBucket;
    @JsonProperty(value="dataValidationCode")
    private final String dataValidationCode;
    @JsonProperty(value="publicKey")
    private final String publicKey;
    @JsonProperty(value="imageExportPar")
    private final String imageExportPar;
    @JsonProperty(value="masterKeyId")
    private final String masterKeyId;
    @JsonProperty(value="certificateAuthorityId")
    private final String certificateAuthorityId;
    @JsonProperty(value="timeCertValidityEnd")
    private final Date timeCertValidityEnd;
    @JsonProperty(value="commonName")
    private final String commonName;
    @JsonProperty(value="certCompartmentId")
    private final String certCompartmentId;
    @JsonProperty(value="certificateVersionNumber")
    private final String certificateVersionNumber;
    @JsonProperty(value="certificateId")
    private final String certificateId;
    @JsonProperty(value="certKeyAlgorithm")
    private final CertKeyAlgorithm certKeyAlgorithm;
    @JsonProperty(value="certSignatureAlgorithm")
    private final CertSignatureAlgorithm certSignatureAlgorithm;
    @JsonProperty(value="tags")
    private final String tags;
    @JsonProperty(value="freeformTags")
    private final Map<String, String> freeformTags;
    @JsonProperty(value="definedTags")
    private final Map<String, Map<String, Object>> definedTags;
    @JsonProperty(value="systemTags")
    private final Map<String, Map<String, Object>> systemTags;

    @Deprecated
    @ConstructorProperties(value={"id", "clusterId", "compartmentId", "nodeType", "shape", "enclosureType", "serialNumber", "displayName", "timeCreated", "lifecycleState", "lifecycleStateDetails", "customerShippingAddress", "nodeWorkloads", "timeCustomerReceieved", "timeCustomerReturned", "deliveryTrackingInfo", "superUserPassword", "unlockPassphrase", "pointOfContact", "pointOfContactPhoneNumber", "shippingPreference", "shippingVendor", "timePickupExpected", "timeReturnWindowStarts", "oracleShippingTrackingUrl", "timeReturnWindowEnds", "returnShippingLabelUri", "isImportRequested", "importCompartmentId", "importFileBucket", "dataValidationCode", "publicKey", "imageExportPar", "masterKeyId", "certificateAuthorityId", "timeCertValidityEnd", "commonName", "certCompartmentId", "certificateVersionNumber", "certificateId", "certKeyAlgorithm", "certSignatureAlgorithm", "tags", "freeformTags", "definedTags", "systemTags"})
    public RoverNode(String id, String clusterId, String compartmentId, NodeType nodeType, String shape, EnclosureType enclosureType, String serialNumber, String displayName, Date timeCreated, LifecycleState lifecycleState, String lifecycleStateDetails, ShippingAddress customerShippingAddress, List<RoverWorkload> nodeWorkloads, Date timeCustomerReceieved, Date timeCustomerReturned, String deliveryTrackingInfo, String superUserPassword, String unlockPassphrase, String pointOfContact, String pointOfContactPhoneNumber, ShippingPreference shippingPreference, String shippingVendor, Date timePickupExpected, Date timeReturnWindowStarts, String oracleShippingTrackingUrl, Date timeReturnWindowEnds, String returnShippingLabelUri, Boolean isImportRequested, String importCompartmentId, String importFileBucket, String dataValidationCode, String publicKey, String imageExportPar, String masterKeyId, String certificateAuthorityId, Date timeCertValidityEnd, String commonName, String certCompartmentId, String certificateVersionNumber, String certificateId, CertKeyAlgorithm certKeyAlgorithm, CertSignatureAlgorithm certSignatureAlgorithm, String tags, Map<String, String> freeformTags, Map<String, Map<String, Object>> definedTags, Map<String, Map<String, Object>> systemTags) {
        this.id = id;
        this.clusterId = clusterId;
        this.compartmentId = compartmentId;
        this.nodeType = nodeType;
        this.shape = shape;
        this.enclosureType = enclosureType;
        this.serialNumber = serialNumber;
        this.displayName = displayName;
        this.timeCreated = timeCreated;
        this.lifecycleState = lifecycleState;
        this.lifecycleStateDetails = lifecycleStateDetails;
        this.customerShippingAddress = customerShippingAddress;
        this.nodeWorkloads = nodeWorkloads;
        this.timeCustomerReceieved = timeCustomerReceieved;
        this.timeCustomerReturned = timeCustomerReturned;
        this.deliveryTrackingInfo = deliveryTrackingInfo;
        this.superUserPassword = superUserPassword;
        this.unlockPassphrase = unlockPassphrase;
        this.pointOfContact = pointOfContact;
        this.pointOfContactPhoneNumber = pointOfContactPhoneNumber;
        this.shippingPreference = shippingPreference;
        this.shippingVendor = shippingVendor;
        this.timePickupExpected = timePickupExpected;
        this.timeReturnWindowStarts = timeReturnWindowStarts;
        this.oracleShippingTrackingUrl = oracleShippingTrackingUrl;
        this.timeReturnWindowEnds = timeReturnWindowEnds;
        this.returnShippingLabelUri = returnShippingLabelUri;
        this.isImportRequested = isImportRequested;
        this.importCompartmentId = importCompartmentId;
        this.importFileBucket = importFileBucket;
        this.dataValidationCode = dataValidationCode;
        this.publicKey = publicKey;
        this.imageExportPar = imageExportPar;
        this.masterKeyId = masterKeyId;
        this.certificateAuthorityId = certificateAuthorityId;
        this.timeCertValidityEnd = timeCertValidityEnd;
        this.commonName = commonName;
        this.certCompartmentId = certCompartmentId;
        this.certificateVersionNumber = certificateVersionNumber;
        this.certificateId = certificateId;
        this.certKeyAlgorithm = certKeyAlgorithm;
        this.certSignatureAlgorithm = certSignatureAlgorithm;
        this.tags = tags;
        this.freeformTags = freeformTags;
        this.definedTags = definedTags;
        this.systemTags = systemTags;
    }

    public static Builder builder() {
        return new Builder();
    }

    public Builder toBuilder() {
        return new Builder().copy(this);
    }

    public String getId() {
        return this.id;
    }

    public String getClusterId() {
        return this.clusterId;
    }

    public String getCompartmentId() {
        return this.compartmentId;
    }

    public NodeType getNodeType() {
        return this.nodeType;
    }

    public String getShape() {
        return this.shape;
    }

    public EnclosureType getEnclosureType() {
        return this.enclosureType;
    }

    public String getSerialNumber() {
        return this.serialNumber;
    }

    public String getDisplayName() {
        return this.displayName;
    }

    public Date getTimeCreated() {
        return this.timeCreated;
    }

    public LifecycleState getLifecycleState() {
        return this.lifecycleState;
    }

    public String getLifecycleStateDetails() {
        return this.lifecycleStateDetails;
    }

    public ShippingAddress getCustomerShippingAddress() {
        return this.customerShippingAddress;
    }

    public List<RoverWorkload> getNodeWorkloads() {
        return this.nodeWorkloads;
    }

    public Date getTimeCustomerReceieved() {
        return this.timeCustomerReceieved;
    }

    public Date getTimeCustomerReturned() {
        return this.timeCustomerReturned;
    }

    public String getDeliveryTrackingInfo() {
        return this.deliveryTrackingInfo;
    }

    public String getSuperUserPassword() {
        return this.superUserPassword;
    }

    public String getUnlockPassphrase() {
        return this.unlockPassphrase;
    }

    public String getPointOfContact() {
        return this.pointOfContact;
    }

    public String getPointOfContactPhoneNumber() {
        return this.pointOfContactPhoneNumber;
    }

    public ShippingPreference getShippingPreference() {
        return this.shippingPreference;
    }

    public String getShippingVendor() {
        return this.shippingVendor;
    }

    public Date getTimePickupExpected() {
        return this.timePickupExpected;
    }

    public Date getTimeReturnWindowStarts() {
        return this.timeReturnWindowStarts;
    }

    public String getOracleShippingTrackingUrl() {
        return this.oracleShippingTrackingUrl;
    }

    public Date getTimeReturnWindowEnds() {
        return this.timeReturnWindowEnds;
    }

    public String getReturnShippingLabelUri() {
        return this.returnShippingLabelUri;
    }

    public Boolean getIsImportRequested() {
        return this.isImportRequested;
    }

    public String getImportCompartmentId() {
        return this.importCompartmentId;
    }

    public String getImportFileBucket() {
        return this.importFileBucket;
    }

    public String getDataValidationCode() {
        return this.dataValidationCode;
    }

    public String getPublicKey() {
        return this.publicKey;
    }

    public String getImageExportPar() {
        return this.imageExportPar;
    }

    public String getMasterKeyId() {
        return this.masterKeyId;
    }

    public String getCertificateAuthorityId() {
        return this.certificateAuthorityId;
    }

    public Date getTimeCertValidityEnd() {
        return this.timeCertValidityEnd;
    }

    public String getCommonName() {
        return this.commonName;
    }

    public String getCertCompartmentId() {
        return this.certCompartmentId;
    }

    public String getCertificateVersionNumber() {
        return this.certificateVersionNumber;
    }

    public String getCertificateId() {
        return this.certificateId;
    }

    public CertKeyAlgorithm getCertKeyAlgorithm() {
        return this.certKeyAlgorithm;
    }

    public CertSignatureAlgorithm getCertSignatureAlgorithm() {
        return this.certSignatureAlgorithm;
    }

    public String getTags() {
        return this.tags;
    }

    public Map<String, String> getFreeformTags() {
        return this.freeformTags;
    }

    public Map<String, Map<String, Object>> getDefinedTags() {
        return this.definedTags;
    }

    public Map<String, Map<String, Object>> getSystemTags() {
        return this.systemTags;
    }

    public String toString() {
        return this.toString(true);
    }

    public String toString(boolean includeByteArrayContents) {
        StringBuilder sb = new StringBuilder();
        sb.append("RoverNode(");
        sb.append("super=").append(super.toString());
        sb.append("id=").append(String.valueOf(this.id));
        sb.append(", clusterId=").append(String.valueOf(this.clusterId));
        sb.append(", compartmentId=").append(String.valueOf(this.compartmentId));
        sb.append(", nodeType=").append(String.valueOf((Object)this.nodeType));
        sb.append(", shape=").append(String.valueOf(this.shape));
        sb.append(", enclosureType=").append(String.valueOf((Object)this.enclosureType));
        sb.append(", serialNumber=").append(String.valueOf(this.serialNumber));
        sb.append(", displayName=").append(String.valueOf(this.displayName));
        sb.append(", timeCreated=").append(String.valueOf(this.timeCreated));
        sb.append(", lifecycleState=").append(String.valueOf((Object)this.lifecycleState));
        sb.append(", lifecycleStateDetails=").append(String.valueOf(this.lifecycleStateDetails));
        sb.append(", customerShippingAddress=").append(String.valueOf((Object)this.customerShippingAddress));
        sb.append(", nodeWorkloads=").append(String.valueOf(this.nodeWorkloads));
        sb.append(", timeCustomerReceieved=").append(String.valueOf(this.timeCustomerReceieved));
        sb.append(", timeCustomerReturned=").append(String.valueOf(this.timeCustomerReturned));
        sb.append(", deliveryTrackingInfo=").append(String.valueOf(this.deliveryTrackingInfo));
        sb.append(", superUserPassword=").append(String.valueOf(this.superUserPassword));
        sb.append(", unlockPassphrase=").append(String.valueOf(this.unlockPassphrase));
        sb.append(", pointOfContact=").append(String.valueOf(this.pointOfContact));
        sb.append(", pointOfContactPhoneNumber=").append(String.valueOf(this.pointOfContactPhoneNumber));
        sb.append(", shippingPreference=").append(String.valueOf((Object)this.shippingPreference));
        sb.append(", shippingVendor=").append(String.valueOf(this.shippingVendor));
        sb.append(", timePickupExpected=").append(String.valueOf(this.timePickupExpected));
        sb.append(", timeReturnWindowStarts=").append(String.valueOf(this.timeReturnWindowStarts));
        sb.append(", oracleShippingTrackingUrl=").append(String.valueOf(this.oracleShippingTrackingUrl));
        sb.append(", timeReturnWindowEnds=").append(String.valueOf(this.timeReturnWindowEnds));
        sb.append(", returnShippingLabelUri=").append(String.valueOf(this.returnShippingLabelUri));
        sb.append(", isImportRequested=").append(String.valueOf(this.isImportRequested));
        sb.append(", importCompartmentId=").append(String.valueOf(this.importCompartmentId));
        sb.append(", importFileBucket=").append(String.valueOf(this.importFileBucket));
        sb.append(", dataValidationCode=").append(String.valueOf(this.dataValidationCode));
        sb.append(", publicKey=").append(String.valueOf(this.publicKey));
        sb.append(", imageExportPar=").append(String.valueOf(this.imageExportPar));
        sb.append(", masterKeyId=").append(String.valueOf(this.masterKeyId));
        sb.append(", certificateAuthorityId=").append(String.valueOf(this.certificateAuthorityId));
        sb.append(", timeCertValidityEnd=").append(String.valueOf(this.timeCertValidityEnd));
        sb.append(", commonName=").append(String.valueOf(this.commonName));
        sb.append(", certCompartmentId=").append(String.valueOf(this.certCompartmentId));
        sb.append(", certificateVersionNumber=").append(String.valueOf(this.certificateVersionNumber));
        sb.append(", certificateId=").append(String.valueOf(this.certificateId));
        sb.append(", certKeyAlgorithm=").append(String.valueOf((Object)this.certKeyAlgorithm));
        sb.append(", certSignatureAlgorithm=").append(String.valueOf((Object)this.certSignatureAlgorithm));
        sb.append(", tags=").append(String.valueOf(this.tags));
        sb.append(", freeformTags=").append(String.valueOf(this.freeformTags));
        sb.append(", definedTags=").append(String.valueOf(this.definedTags));
        sb.append(", systemTags=").append(String.valueOf(this.systemTags));
        sb.append(")");
        return sb.toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof RoverNode)) {
            return false;
        }
        RoverNode other = (RoverNode)((Object)o);
        return Objects.equals(this.id, other.id) && Objects.equals(this.clusterId, other.clusterId) && Objects.equals(this.compartmentId, other.compartmentId) && Objects.equals((Object)this.nodeType, (Object)other.nodeType) && Objects.equals(this.shape, other.shape) && Objects.equals((Object)this.enclosureType, (Object)other.enclosureType) && Objects.equals(this.serialNumber, other.serialNumber) && Objects.equals(this.displayName, other.displayName) && Objects.equals(this.timeCreated, other.timeCreated) && Objects.equals((Object)this.lifecycleState, (Object)other.lifecycleState) && Objects.equals(this.lifecycleStateDetails, other.lifecycleStateDetails) && Objects.equals((Object)this.customerShippingAddress, (Object)other.customerShippingAddress) && Objects.equals(this.nodeWorkloads, other.nodeWorkloads) && Objects.equals(this.timeCustomerReceieved, other.timeCustomerReceieved) && Objects.equals(this.timeCustomerReturned, other.timeCustomerReturned) && Objects.equals(this.deliveryTrackingInfo, other.deliveryTrackingInfo) && Objects.equals(this.superUserPassword, other.superUserPassword) && Objects.equals(this.unlockPassphrase, other.unlockPassphrase) && Objects.equals(this.pointOfContact, other.pointOfContact) && Objects.equals(this.pointOfContactPhoneNumber, other.pointOfContactPhoneNumber) && Objects.equals((Object)this.shippingPreference, (Object)other.shippingPreference) && Objects.equals(this.shippingVendor, other.shippingVendor) && Objects.equals(this.timePickupExpected, other.timePickupExpected) && Objects.equals(this.timeReturnWindowStarts, other.timeReturnWindowStarts) && Objects.equals(this.oracleShippingTrackingUrl, other.oracleShippingTrackingUrl) && Objects.equals(this.timeReturnWindowEnds, other.timeReturnWindowEnds) && Objects.equals(this.returnShippingLabelUri, other.returnShippingLabelUri) && Objects.equals(this.isImportRequested, other.isImportRequested) && Objects.equals(this.importCompartmentId, other.importCompartmentId) && Objects.equals(this.importFileBucket, other.importFileBucket) && Objects.equals(this.dataValidationCode, other.dataValidationCode) && Objects.equals(this.publicKey, other.publicKey) && Objects.equals(this.imageExportPar, other.imageExportPar) && Objects.equals(this.masterKeyId, other.masterKeyId) && Objects.equals(this.certificateAuthorityId, other.certificateAuthorityId) && Objects.equals(this.timeCertValidityEnd, other.timeCertValidityEnd) && Objects.equals(this.commonName, other.commonName) && Objects.equals(this.certCompartmentId, other.certCompartmentId) && Objects.equals(this.certificateVersionNumber, other.certificateVersionNumber) && Objects.equals(this.certificateId, other.certificateId) && Objects.equals((Object)this.certKeyAlgorithm, (Object)other.certKeyAlgorithm) && Objects.equals((Object)this.certSignatureAlgorithm, (Object)other.certSignatureAlgorithm) && Objects.equals(this.tags, other.tags) && Objects.equals(this.freeformTags, other.freeformTags) && Objects.equals(this.definedTags, other.definedTags) && Objects.equals(this.systemTags, other.systemTags) && super.equals((Object)other);
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + (this.id == null ? 43 : this.id.hashCode());
        result = result * 59 + (this.clusterId == null ? 43 : this.clusterId.hashCode());
        result = result * 59 + (this.compartmentId == null ? 43 : this.compartmentId.hashCode());
        result = result * 59 + (this.nodeType == null ? 43 : this.nodeType.hashCode());
        result = result * 59 + (this.shape == null ? 43 : this.shape.hashCode());
        result = result * 59 + (this.enclosureType == null ? 43 : this.enclosureType.hashCode());
        result = result * 59 + (this.serialNumber == null ? 43 : this.serialNumber.hashCode());
        result = result * 59 + (this.displayName == null ? 43 : this.displayName.hashCode());
        result = result * 59 + (this.timeCreated == null ? 43 : this.timeCreated.hashCode());
        result = result * 59 + (this.lifecycleState == null ? 43 : this.lifecycleState.hashCode());
        result = result * 59 + (this.lifecycleStateDetails == null ? 43 : this.lifecycleStateDetails.hashCode());
        result = result * 59 + (this.customerShippingAddress == null ? 43 : this.customerShippingAddress.hashCode());
        result = result * 59 + (this.nodeWorkloads == null ? 43 : this.nodeWorkloads.hashCode());
        result = result * 59 + (this.timeCustomerReceieved == null ? 43 : this.timeCustomerReceieved.hashCode());
        result = result * 59 + (this.timeCustomerReturned == null ? 43 : this.timeCustomerReturned.hashCode());
        result = result * 59 + (this.deliveryTrackingInfo == null ? 43 : this.deliveryTrackingInfo.hashCode());
        result = result * 59 + (this.superUserPassword == null ? 43 : this.superUserPassword.hashCode());
        result = result * 59 + (this.unlockPassphrase == null ? 43 : this.unlockPassphrase.hashCode());
        result = result * 59 + (this.pointOfContact == null ? 43 : this.pointOfContact.hashCode());
        result = result * 59 + (this.pointOfContactPhoneNumber == null ? 43 : this.pointOfContactPhoneNumber.hashCode());
        result = result * 59 + (this.shippingPreference == null ? 43 : this.shippingPreference.hashCode());
        result = result * 59 + (this.shippingVendor == null ? 43 : this.shippingVendor.hashCode());
        result = result * 59 + (this.timePickupExpected == null ? 43 : this.timePickupExpected.hashCode());
        result = result * 59 + (this.timeReturnWindowStarts == null ? 43 : this.timeReturnWindowStarts.hashCode());
        result = result * 59 + (this.oracleShippingTrackingUrl == null ? 43 : this.oracleShippingTrackingUrl.hashCode());
        result = result * 59 + (this.timeReturnWindowEnds == null ? 43 : this.timeReturnWindowEnds.hashCode());
        result = result * 59 + (this.returnShippingLabelUri == null ? 43 : this.returnShippingLabelUri.hashCode());
        result = result * 59 + (this.isImportRequested == null ? 43 : this.isImportRequested.hashCode());
        result = result * 59 + (this.importCompartmentId == null ? 43 : this.importCompartmentId.hashCode());
        result = result * 59 + (this.importFileBucket == null ? 43 : this.importFileBucket.hashCode());
        result = result * 59 + (this.dataValidationCode == null ? 43 : this.dataValidationCode.hashCode());
        result = result * 59 + (this.publicKey == null ? 43 : this.publicKey.hashCode());
        result = result * 59 + (this.imageExportPar == null ? 43 : this.imageExportPar.hashCode());
        result = result * 59 + (this.masterKeyId == null ? 43 : this.masterKeyId.hashCode());
        result = result * 59 + (this.certificateAuthorityId == null ? 43 : this.certificateAuthorityId.hashCode());
        result = result * 59 + (this.timeCertValidityEnd == null ? 43 : this.timeCertValidityEnd.hashCode());
        result = result * 59 + (this.commonName == null ? 43 : this.commonName.hashCode());
        result = result * 59 + (this.certCompartmentId == null ? 43 : this.certCompartmentId.hashCode());
        result = result * 59 + (this.certificateVersionNumber == null ? 43 : this.certificateVersionNumber.hashCode());
        result = result * 59 + (this.certificateId == null ? 43 : this.certificateId.hashCode());
        result = result * 59 + (this.certKeyAlgorithm == null ? 43 : this.certKeyAlgorithm.hashCode());
        result = result * 59 + (this.certSignatureAlgorithm == null ? 43 : this.certSignatureAlgorithm.hashCode());
        result = result * 59 + (this.tags == null ? 43 : this.tags.hashCode());
        result = result * 59 + (this.freeformTags == null ? 43 : this.freeformTags.hashCode());
        result = result * 59 + (this.definedTags == null ? 43 : this.definedTags.hashCode());
        result = result * 59 + (this.systemTags == null ? 43 : this.systemTags.hashCode());
        result = result * 59 + super.hashCode();
        return result;
    }

    public static enum ShippingPreference implements BmcEnum
    {
        OracleShipped("ORACLE_SHIPPED"),
        CustomerPickup("CUSTOMER_PICKUP"),
        UnknownEnumValue(null);

        private static final Logger LOG;
        private final String value;
        private static Map<String, ShippingPreference> map;

        private ShippingPreference(String value) {
            this.value = value;
        }

        @JsonValue
        public String getValue() {
            return this.value;
        }

        @JsonCreator
        public static ShippingPreference create(String key) {
            if (map.containsKey(key)) {
                return map.get(key);
            }
            LOG.warn("Received unknown value '{}' for enum 'ShippingPreference', returning UnknownEnumValue", (Object)key);
            return UnknownEnumValue;
        }

        static {
            LOG = LoggerFactory.getLogger(ShippingPreference.class);
            map = new HashMap<String, ShippingPreference>();
            for (ShippingPreference v : ShippingPreference.values()) {
                if (v == UnknownEnumValue) continue;
                map.put(v.getValue(), v);
            }
        }
    }

    @JsonPOJOBuilder(withPrefix="")
    public static class Builder {
        @JsonProperty(value="id")
        private String id;
        @JsonProperty(value="clusterId")
        private String clusterId;
        @JsonProperty(value="compartmentId")
        private String compartmentId;
        @JsonProperty(value="nodeType")
        private NodeType nodeType;
        @JsonProperty(value="shape")
        private String shape;
        @JsonProperty(value="enclosureType")
        private EnclosureType enclosureType;
        @JsonProperty(value="serialNumber")
        private String serialNumber;
        @JsonProperty(value="displayName")
        private String displayName;
        @JsonProperty(value="timeCreated")
        private Date timeCreated;
        @JsonProperty(value="lifecycleState")
        private LifecycleState lifecycleState;
        @JsonProperty(value="lifecycleStateDetails")
        private String lifecycleStateDetails;
        @JsonProperty(value="customerShippingAddress")
        private ShippingAddress customerShippingAddress;
        @JsonProperty(value="nodeWorkloads")
        private List<RoverWorkload> nodeWorkloads;
        @JsonProperty(value="timeCustomerReceieved")
        private Date timeCustomerReceieved;
        @JsonProperty(value="timeCustomerReturned")
        private Date timeCustomerReturned;
        @JsonProperty(value="deliveryTrackingInfo")
        private String deliveryTrackingInfo;
        @JsonProperty(value="superUserPassword")
        private String superUserPassword;
        @JsonProperty(value="unlockPassphrase")
        private String unlockPassphrase;
        @JsonProperty(value="pointOfContact")
        private String pointOfContact;
        @JsonProperty(value="pointOfContactPhoneNumber")
        private String pointOfContactPhoneNumber;
        @JsonProperty(value="shippingPreference")
        private ShippingPreference shippingPreference;
        @JsonProperty(value="shippingVendor")
        private String shippingVendor;
        @JsonProperty(value="timePickupExpected")
        private Date timePickupExpected;
        @JsonProperty(value="timeReturnWindowStarts")
        private Date timeReturnWindowStarts;
        @JsonProperty(value="oracleShippingTrackingUrl")
        private String oracleShippingTrackingUrl;
        @JsonProperty(value="timeReturnWindowEnds")
        private Date timeReturnWindowEnds;
        @JsonProperty(value="returnShippingLabelUri")
        private String returnShippingLabelUri;
        @JsonProperty(value="isImportRequested")
        private Boolean isImportRequested;
        @JsonProperty(value="importCompartmentId")
        private String importCompartmentId;
        @JsonProperty(value="importFileBucket")
        private String importFileBucket;
        @JsonProperty(value="dataValidationCode")
        private String dataValidationCode;
        @JsonProperty(value="publicKey")
        private String publicKey;
        @JsonProperty(value="imageExportPar")
        private String imageExportPar;
        @JsonProperty(value="masterKeyId")
        private String masterKeyId;
        @JsonProperty(value="certificateAuthorityId")
        private String certificateAuthorityId;
        @JsonProperty(value="timeCertValidityEnd")
        private Date timeCertValidityEnd;
        @JsonProperty(value="commonName")
        private String commonName;
        @JsonProperty(value="certCompartmentId")
        private String certCompartmentId;
        @JsonProperty(value="certificateVersionNumber")
        private String certificateVersionNumber;
        @JsonProperty(value="certificateId")
        private String certificateId;
        @JsonProperty(value="certKeyAlgorithm")
        private CertKeyAlgorithm certKeyAlgorithm;
        @JsonProperty(value="certSignatureAlgorithm")
        private CertSignatureAlgorithm certSignatureAlgorithm;
        @JsonProperty(value="tags")
        private String tags;
        @JsonProperty(value="freeformTags")
        private Map<String, String> freeformTags;
        @JsonProperty(value="definedTags")
        private Map<String, Map<String, Object>> definedTags;
        @JsonProperty(value="systemTags")
        private Map<String, Map<String, Object>> systemTags;
        @JsonIgnore
        private final Set<String> __explicitlySet__ = new HashSet<String>();

        public Builder id(String id) {
            this.id = id;
            this.__explicitlySet__.add("id");
            return this;
        }

        public Builder clusterId(String clusterId) {
            this.clusterId = clusterId;
            this.__explicitlySet__.add("clusterId");
            return this;
        }

        public Builder compartmentId(String compartmentId) {
            this.compartmentId = compartmentId;
            this.__explicitlySet__.add("compartmentId");
            return this;
        }

        public Builder nodeType(NodeType nodeType) {
            this.nodeType = nodeType;
            this.__explicitlySet__.add("nodeType");
            return this;
        }

        public Builder shape(String shape) {
            this.shape = shape;
            this.__explicitlySet__.add("shape");
            return this;
        }

        public Builder enclosureType(EnclosureType enclosureType) {
            this.enclosureType = enclosureType;
            this.__explicitlySet__.add("enclosureType");
            return this;
        }

        public Builder serialNumber(String serialNumber) {
            this.serialNumber = serialNumber;
            this.__explicitlySet__.add("serialNumber");
            return this;
        }

        public Builder displayName(String displayName) {
            this.displayName = displayName;
            this.__explicitlySet__.add("displayName");
            return this;
        }

        public Builder timeCreated(Date timeCreated) {
            this.timeCreated = timeCreated;
            this.__explicitlySet__.add("timeCreated");
            return this;
        }

        public Builder lifecycleState(LifecycleState lifecycleState) {
            this.lifecycleState = lifecycleState;
            this.__explicitlySet__.add("lifecycleState");
            return this;
        }

        public Builder lifecycleStateDetails(String lifecycleStateDetails) {
            this.lifecycleStateDetails = lifecycleStateDetails;
            this.__explicitlySet__.add("lifecycleStateDetails");
            return this;
        }

        public Builder customerShippingAddress(ShippingAddress customerShippingAddress) {
            this.customerShippingAddress = customerShippingAddress;
            this.__explicitlySet__.add("customerShippingAddress");
            return this;
        }

        public Builder nodeWorkloads(List<RoverWorkload> nodeWorkloads) {
            this.nodeWorkloads = nodeWorkloads;
            this.__explicitlySet__.add("nodeWorkloads");
            return this;
        }

        public Builder timeCustomerReceieved(Date timeCustomerReceieved) {
            this.timeCustomerReceieved = timeCustomerReceieved;
            this.__explicitlySet__.add("timeCustomerReceieved");
            return this;
        }

        public Builder timeCustomerReturned(Date timeCustomerReturned) {
            this.timeCustomerReturned = timeCustomerReturned;
            this.__explicitlySet__.add("timeCustomerReturned");
            return this;
        }

        public Builder deliveryTrackingInfo(String deliveryTrackingInfo) {
            this.deliveryTrackingInfo = deliveryTrackingInfo;
            this.__explicitlySet__.add("deliveryTrackingInfo");
            return this;
        }

        public Builder superUserPassword(String superUserPassword) {
            this.superUserPassword = superUserPassword;
            this.__explicitlySet__.add("superUserPassword");
            return this;
        }

        public Builder unlockPassphrase(String unlockPassphrase) {
            this.unlockPassphrase = unlockPassphrase;
            this.__explicitlySet__.add("unlockPassphrase");
            return this;
        }

        public Builder pointOfContact(String pointOfContact) {
            this.pointOfContact = pointOfContact;
            this.__explicitlySet__.add("pointOfContact");
            return this;
        }

        public Builder pointOfContactPhoneNumber(String pointOfContactPhoneNumber) {
            this.pointOfContactPhoneNumber = pointOfContactPhoneNumber;
            this.__explicitlySet__.add("pointOfContactPhoneNumber");
            return this;
        }

        public Builder shippingPreference(ShippingPreference shippingPreference) {
            this.shippingPreference = shippingPreference;
            this.__explicitlySet__.add("shippingPreference");
            return this;
        }

        public Builder shippingVendor(String shippingVendor) {
            this.shippingVendor = shippingVendor;
            this.__explicitlySet__.add("shippingVendor");
            return this;
        }

        public Builder timePickupExpected(Date timePickupExpected) {
            this.timePickupExpected = timePickupExpected;
            this.__explicitlySet__.add("timePickupExpected");
            return this;
        }

        public Builder timeReturnWindowStarts(Date timeReturnWindowStarts) {
            this.timeReturnWindowStarts = timeReturnWindowStarts;
            this.__explicitlySet__.add("timeReturnWindowStarts");
            return this;
        }

        public Builder oracleShippingTrackingUrl(String oracleShippingTrackingUrl) {
            this.oracleShippingTrackingUrl = oracleShippingTrackingUrl;
            this.__explicitlySet__.add("oracleShippingTrackingUrl");
            return this;
        }

        public Builder timeReturnWindowEnds(Date timeReturnWindowEnds) {
            this.timeReturnWindowEnds = timeReturnWindowEnds;
            this.__explicitlySet__.add("timeReturnWindowEnds");
            return this;
        }

        public Builder returnShippingLabelUri(String returnShippingLabelUri) {
            this.returnShippingLabelUri = returnShippingLabelUri;
            this.__explicitlySet__.add("returnShippingLabelUri");
            return this;
        }

        public Builder isImportRequested(Boolean isImportRequested) {
            this.isImportRequested = isImportRequested;
            this.__explicitlySet__.add("isImportRequested");
            return this;
        }

        public Builder importCompartmentId(String importCompartmentId) {
            this.importCompartmentId = importCompartmentId;
            this.__explicitlySet__.add("importCompartmentId");
            return this;
        }

        public Builder importFileBucket(String importFileBucket) {
            this.importFileBucket = importFileBucket;
            this.__explicitlySet__.add("importFileBucket");
            return this;
        }

        public Builder dataValidationCode(String dataValidationCode) {
            this.dataValidationCode = dataValidationCode;
            this.__explicitlySet__.add("dataValidationCode");
            return this;
        }

        public Builder publicKey(String publicKey) {
            this.publicKey = publicKey;
            this.__explicitlySet__.add("publicKey");
            return this;
        }

        public Builder imageExportPar(String imageExportPar) {
            this.imageExportPar = imageExportPar;
            this.__explicitlySet__.add("imageExportPar");
            return this;
        }

        public Builder masterKeyId(String masterKeyId) {
            this.masterKeyId = masterKeyId;
            this.__explicitlySet__.add("masterKeyId");
            return this;
        }

        public Builder certificateAuthorityId(String certificateAuthorityId) {
            this.certificateAuthorityId = certificateAuthorityId;
            this.__explicitlySet__.add("certificateAuthorityId");
            return this;
        }

        public Builder timeCertValidityEnd(Date timeCertValidityEnd) {
            this.timeCertValidityEnd = timeCertValidityEnd;
            this.__explicitlySet__.add("timeCertValidityEnd");
            return this;
        }

        public Builder commonName(String commonName) {
            this.commonName = commonName;
            this.__explicitlySet__.add("commonName");
            return this;
        }

        public Builder certCompartmentId(String certCompartmentId) {
            this.certCompartmentId = certCompartmentId;
            this.__explicitlySet__.add("certCompartmentId");
            return this;
        }

        public Builder certificateVersionNumber(String certificateVersionNumber) {
            this.certificateVersionNumber = certificateVersionNumber;
            this.__explicitlySet__.add("certificateVersionNumber");
            return this;
        }

        public Builder certificateId(String certificateId) {
            this.certificateId = certificateId;
            this.__explicitlySet__.add("certificateId");
            return this;
        }

        public Builder certKeyAlgorithm(CertKeyAlgorithm certKeyAlgorithm) {
            this.certKeyAlgorithm = certKeyAlgorithm;
            this.__explicitlySet__.add("certKeyAlgorithm");
            return this;
        }

        public Builder certSignatureAlgorithm(CertSignatureAlgorithm certSignatureAlgorithm) {
            this.certSignatureAlgorithm = certSignatureAlgorithm;
            this.__explicitlySet__.add("certSignatureAlgorithm");
            return this;
        }

        public Builder tags(String tags) {
            this.tags = tags;
            this.__explicitlySet__.add("tags");
            return this;
        }

        public Builder freeformTags(Map<String, String> freeformTags) {
            this.freeformTags = freeformTags;
            this.__explicitlySet__.add("freeformTags");
            return this;
        }

        public Builder definedTags(Map<String, Map<String, Object>> definedTags) {
            this.definedTags = definedTags;
            this.__explicitlySet__.add("definedTags");
            return this;
        }

        public Builder systemTags(Map<String, Map<String, Object>> systemTags) {
            this.systemTags = systemTags;
            this.__explicitlySet__.add("systemTags");
            return this;
        }

        public RoverNode build() {
            RoverNode model = new RoverNode(this.id, this.clusterId, this.compartmentId, this.nodeType, this.shape, this.enclosureType, this.serialNumber, this.displayName, this.timeCreated, this.lifecycleState, this.lifecycleStateDetails, this.customerShippingAddress, this.nodeWorkloads, this.timeCustomerReceieved, this.timeCustomerReturned, this.deliveryTrackingInfo, this.superUserPassword, this.unlockPassphrase, this.pointOfContact, this.pointOfContactPhoneNumber, this.shippingPreference, this.shippingVendor, this.timePickupExpected, this.timeReturnWindowStarts, this.oracleShippingTrackingUrl, this.timeReturnWindowEnds, this.returnShippingLabelUri, this.isImportRequested, this.importCompartmentId, this.importFileBucket, this.dataValidationCode, this.publicKey, this.imageExportPar, this.masterKeyId, this.certificateAuthorityId, this.timeCertValidityEnd, this.commonName, this.certCompartmentId, this.certificateVersionNumber, this.certificateId, this.certKeyAlgorithm, this.certSignatureAlgorithm, this.tags, this.freeformTags, this.definedTags, this.systemTags);
            for (String explicitlySetProperty : this.__explicitlySet__) {
                model.markPropertyAsExplicitlySet(explicitlySetProperty);
            }
            return model;
        }

        @JsonIgnore
        public Builder copy(RoverNode model) {
            if (model.wasPropertyExplicitlySet("id")) {
                this.id(model.getId());
            }
            if (model.wasPropertyExplicitlySet("clusterId")) {
                this.clusterId(model.getClusterId());
            }
            if (model.wasPropertyExplicitlySet("compartmentId")) {
                this.compartmentId(model.getCompartmentId());
            }
            if (model.wasPropertyExplicitlySet("nodeType")) {
                this.nodeType(model.getNodeType());
            }
            if (model.wasPropertyExplicitlySet("shape")) {
                this.shape(model.getShape());
            }
            if (model.wasPropertyExplicitlySet("enclosureType")) {
                this.enclosureType(model.getEnclosureType());
            }
            if (model.wasPropertyExplicitlySet("serialNumber")) {
                this.serialNumber(model.getSerialNumber());
            }
            if (model.wasPropertyExplicitlySet("displayName")) {
                this.displayName(model.getDisplayName());
            }
            if (model.wasPropertyExplicitlySet("timeCreated")) {
                this.timeCreated(model.getTimeCreated());
            }
            if (model.wasPropertyExplicitlySet("lifecycleState")) {
                this.lifecycleState(model.getLifecycleState());
            }
            if (model.wasPropertyExplicitlySet("lifecycleStateDetails")) {
                this.lifecycleStateDetails(model.getLifecycleStateDetails());
            }
            if (model.wasPropertyExplicitlySet("customerShippingAddress")) {
                this.customerShippingAddress(model.getCustomerShippingAddress());
            }
            if (model.wasPropertyExplicitlySet("nodeWorkloads")) {
                this.nodeWorkloads(model.getNodeWorkloads());
            }
            if (model.wasPropertyExplicitlySet("timeCustomerReceieved")) {
                this.timeCustomerReceieved(model.getTimeCustomerReceieved());
            }
            if (model.wasPropertyExplicitlySet("timeCustomerReturned")) {
                this.timeCustomerReturned(model.getTimeCustomerReturned());
            }
            if (model.wasPropertyExplicitlySet("deliveryTrackingInfo")) {
                this.deliveryTrackingInfo(model.getDeliveryTrackingInfo());
            }
            if (model.wasPropertyExplicitlySet("superUserPassword")) {
                this.superUserPassword(model.getSuperUserPassword());
            }
            if (model.wasPropertyExplicitlySet("unlockPassphrase")) {
                this.unlockPassphrase(model.getUnlockPassphrase());
            }
            if (model.wasPropertyExplicitlySet("pointOfContact")) {
                this.pointOfContact(model.getPointOfContact());
            }
            if (model.wasPropertyExplicitlySet("pointOfContactPhoneNumber")) {
                this.pointOfContactPhoneNumber(model.getPointOfContactPhoneNumber());
            }
            if (model.wasPropertyExplicitlySet("shippingPreference")) {
                this.shippingPreference(model.getShippingPreference());
            }
            if (model.wasPropertyExplicitlySet("shippingVendor")) {
                this.shippingVendor(model.getShippingVendor());
            }
            if (model.wasPropertyExplicitlySet("timePickupExpected")) {
                this.timePickupExpected(model.getTimePickupExpected());
            }
            if (model.wasPropertyExplicitlySet("timeReturnWindowStarts")) {
                this.timeReturnWindowStarts(model.getTimeReturnWindowStarts());
            }
            if (model.wasPropertyExplicitlySet("oracleShippingTrackingUrl")) {
                this.oracleShippingTrackingUrl(model.getOracleShippingTrackingUrl());
            }
            if (model.wasPropertyExplicitlySet("timeReturnWindowEnds")) {
                this.timeReturnWindowEnds(model.getTimeReturnWindowEnds());
            }
            if (model.wasPropertyExplicitlySet("returnShippingLabelUri")) {
                this.returnShippingLabelUri(model.getReturnShippingLabelUri());
            }
            if (model.wasPropertyExplicitlySet("isImportRequested")) {
                this.isImportRequested(model.getIsImportRequested());
            }
            if (model.wasPropertyExplicitlySet("importCompartmentId")) {
                this.importCompartmentId(model.getImportCompartmentId());
            }
            if (model.wasPropertyExplicitlySet("importFileBucket")) {
                this.importFileBucket(model.getImportFileBucket());
            }
            if (model.wasPropertyExplicitlySet("dataValidationCode")) {
                this.dataValidationCode(model.getDataValidationCode());
            }
            if (model.wasPropertyExplicitlySet("publicKey")) {
                this.publicKey(model.getPublicKey());
            }
            if (model.wasPropertyExplicitlySet("imageExportPar")) {
                this.imageExportPar(model.getImageExportPar());
            }
            if (model.wasPropertyExplicitlySet("masterKeyId")) {
                this.masterKeyId(model.getMasterKeyId());
            }
            if (model.wasPropertyExplicitlySet("certificateAuthorityId")) {
                this.certificateAuthorityId(model.getCertificateAuthorityId());
            }
            if (model.wasPropertyExplicitlySet("timeCertValidityEnd")) {
                this.timeCertValidityEnd(model.getTimeCertValidityEnd());
            }
            if (model.wasPropertyExplicitlySet("commonName")) {
                this.commonName(model.getCommonName());
            }
            if (model.wasPropertyExplicitlySet("certCompartmentId")) {
                this.certCompartmentId(model.getCertCompartmentId());
            }
            if (model.wasPropertyExplicitlySet("certificateVersionNumber")) {
                this.certificateVersionNumber(model.getCertificateVersionNumber());
            }
            if (model.wasPropertyExplicitlySet("certificateId")) {
                this.certificateId(model.getCertificateId());
            }
            if (model.wasPropertyExplicitlySet("certKeyAlgorithm")) {
                this.certKeyAlgorithm(model.getCertKeyAlgorithm());
            }
            if (model.wasPropertyExplicitlySet("certSignatureAlgorithm")) {
                this.certSignatureAlgorithm(model.getCertSignatureAlgorithm());
            }
            if (model.wasPropertyExplicitlySet("tags")) {
                this.tags(model.getTags());
            }
            if (model.wasPropertyExplicitlySet("freeformTags")) {
                this.freeformTags(model.getFreeformTags());
            }
            if (model.wasPropertyExplicitlySet("definedTags")) {
                this.definedTags(model.getDefinedTags());
            }
            if (model.wasPropertyExplicitlySet("systemTags")) {
                this.systemTags(model.getSystemTags());
            }
            return this;
        }
    }
}

