/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.rover.model;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonValue;
import com.oracle.bmc.http.internal.BmcEnum;
import java.util.HashMap;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public enum CertKeyAlgorithm implements BmcEnum
{
    Rsa2048("RSA2048"),
    Rsa4096("RSA4096"),
    EcdsaP256("ECDSA_P256"),
    EcdsaP384("ECDSA_P384"),
    UnknownEnumValue(null);

    private static final Logger LOG;
    private final String value;
    private static Map<String, CertKeyAlgorithm> map;

    private CertKeyAlgorithm(String value) {
        this.value = value;
    }

    @JsonValue
    public String getValue() {
        return this.value;
    }

    @JsonCreator
    public static CertKeyAlgorithm create(String key) {
        if (map.containsKey(key)) {
            return map.get(key);
        }
        LOG.warn("Received unknown value '{}' for enum 'CertKeyAlgorithm', returning UnknownEnumValue", (Object)key);
        return UnknownEnumValue;
    }

    static {
        LOG = LoggerFactory.getLogger(CertKeyAlgorithm.class);
        map = new HashMap<String, CertKeyAlgorithm>();
        for (CertKeyAlgorithm v : CertKeyAlgorithm.values()) {
            if (v == UnknownEnumValue) continue;
            map.put(v.getValue(), v);
        }
    }
}

