/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.sch;

import com.oracle.bmc.ClientConfiguration;
import com.oracle.bmc.Region;
import com.oracle.bmc.Service;
import com.oracle.bmc.Services;
import com.oracle.bmc.auth.AbstractAuthenticationDetailsProvider;
import com.oracle.bmc.auth.BasicAuthenticationDetailsProvider;
import com.oracle.bmc.common.ClientBuilderBase;
import com.oracle.bmc.common.RegionalClientBuilder;
import com.oracle.bmc.http.ClientConfigurator;
import com.oracle.bmc.http.client.Method;
import com.oracle.bmc.http.internal.BaseAsyncClient;
import com.oracle.bmc.http.internal.BmcEnum;
import com.oracle.bmc.http.signing.RequestSignerFactory;
import com.oracle.bmc.http.signing.SigningStrategy;
import com.oracle.bmc.http.signing.internal.DefaultRequestSignerFactory;
import com.oracle.bmc.responses.AsyncHandler;
import com.oracle.bmc.sch.ServiceConnectorAsync;
import com.oracle.bmc.sch.model.ServiceConnector;
import com.oracle.bmc.sch.model.ServiceConnectorCollection;
import com.oracle.bmc.sch.model.WorkRequest;
import com.oracle.bmc.sch.model.WorkRequestCollection;
import com.oracle.bmc.sch.model.WorkRequestErrorCollection;
import com.oracle.bmc.sch.model.WorkRequestLogEntryCollection;
import com.oracle.bmc.sch.requests.ActivateServiceConnectorRequest;
import com.oracle.bmc.sch.requests.ChangeServiceConnectorCompartmentRequest;
import com.oracle.bmc.sch.requests.CreateServiceConnectorRequest;
import com.oracle.bmc.sch.requests.DeactivateServiceConnectorRequest;
import com.oracle.bmc.sch.requests.DeleteServiceConnectorRequest;
import com.oracle.bmc.sch.requests.GetServiceConnectorRequest;
import com.oracle.bmc.sch.requests.GetWorkRequestRequest;
import com.oracle.bmc.sch.requests.ListServiceConnectorsRequest;
import com.oracle.bmc.sch.requests.ListWorkRequestErrorsRequest;
import com.oracle.bmc.sch.requests.ListWorkRequestLogsRequest;
import com.oracle.bmc.sch.requests.ListWorkRequestsRequest;
import com.oracle.bmc.sch.requests.UpdateServiceConnectorRequest;
import com.oracle.bmc.sch.responses.ActivateServiceConnectorResponse;
import com.oracle.bmc.sch.responses.ChangeServiceConnectorCompartmentResponse;
import com.oracle.bmc.sch.responses.CreateServiceConnectorResponse;
import com.oracle.bmc.sch.responses.DeactivateServiceConnectorResponse;
import com.oracle.bmc.sch.responses.DeleteServiceConnectorResponse;
import com.oracle.bmc.sch.responses.GetServiceConnectorResponse;
import com.oracle.bmc.sch.responses.GetWorkRequestResponse;
import com.oracle.bmc.sch.responses.ListServiceConnectorsResponse;
import com.oracle.bmc.sch.responses.ListWorkRequestErrorsResponse;
import com.oracle.bmc.sch.responses.ListWorkRequestLogsResponse;
import com.oracle.bmc.sch.responses.ListWorkRequestsResponse;
import com.oracle.bmc.sch.responses.UpdateServiceConnectorResponse;
import com.oracle.bmc.util.internal.Validate;
import jakarta.annotation.Nonnull;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.Future;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ServiceConnectorAsyncClient
extends BaseAsyncClient
implements ServiceConnectorAsync {
    public static final Service SERVICE = Services.serviceBuilder().serviceName("SERVICECONNECTOR").serviceEndpointPrefix("").serviceEndpointTemplate("https://service-connector-hub.{region}.oci.{secondLevelDomain}").build();
    private static final Logger LOG = LoggerFactory.getLogger(ServiceConnectorAsyncClient.class);

    ServiceConnectorAsyncClient(ClientBuilderBase<?, ?> builder, AbstractAuthenticationDetailsProvider authenticationDetailsProvider) {
        super(builder, authenticationDetailsProvider);
    }

    public static Builder builder() {
        return new Builder(SERVICE);
    }

    @Override
    public void setRegion(Region region) {
        super.setRegion(region);
    }

    @Override
    public void setRegion(String regionId) {
        super.setRegion(regionId);
    }

    @Override
    public Future<ActivateServiceConnectorResponse> activateServiceConnector(ActivateServiceConnectorRequest request, AsyncHandler<ActivateServiceConnectorRequest, ActivateServiceConnectorResponse> handler) {
        Validate.notBlank((String)request.getServiceConnectorId(), (String)"serviceConnectorId must not be blank", (Object[])new Object[0]);
        return this.clientCall(request, ActivateServiceConnectorResponse::builder).logger(LOG, "activateServiceConnector").serviceDetails("ServiceConnector", "ActivateServiceConnector", "https://docs.oracle.com/iaas/api/#/en/serviceconnectors/20200909/ServiceConnector/ActivateServiceConnector").method(Method.POST).requestBuilder(ActivateServiceConnectorRequest::builder).basePath("/20200909").appendPathParam("serviceConnectors").appendPathParam(request.getServiceConnectorId()).appendPathParam("actions").appendPathParam("activate").accept(new String[]{"application/json"}).appendHeader("opc-retry-token", request.getOpcRetryToken()).appendHeader("if-match", request.getIfMatch()).appendHeader("opc-request-id", request.getOpcRequestId()).handleResponseHeaderString("opc-work-request-id", ActivateServiceConnectorResponse.Builder::opcWorkRequestId).handleResponseHeaderString("opc-request-id", ActivateServiceConnectorResponse.Builder::opcRequestId).callAsync(handler);
    }

    @Override
    public Future<ChangeServiceConnectorCompartmentResponse> changeServiceConnectorCompartment(ChangeServiceConnectorCompartmentRequest request, AsyncHandler<ChangeServiceConnectorCompartmentRequest, ChangeServiceConnectorCompartmentResponse> handler) {
        Validate.notBlank((String)request.getServiceConnectorId(), (String)"serviceConnectorId must not be blank", (Object[])new Object[0]);
        Objects.requireNonNull(request.getChangeServiceConnectorCompartmentDetails(), "changeServiceConnectorCompartmentDetails is required");
        return this.clientCall(request, ChangeServiceConnectorCompartmentResponse::builder).logger(LOG, "changeServiceConnectorCompartment").serviceDetails("ServiceConnector", "ChangeServiceConnectorCompartment", "https://docs.oracle.com/iaas/api/#/en/serviceconnectors/20200909/ServiceConnector/ChangeServiceConnectorCompartment").method(Method.POST).requestBuilder(ChangeServiceConnectorCompartmentRequest::builder).basePath("/20200909").appendPathParam("serviceConnectors").appendPathParam(request.getServiceConnectorId()).appendPathParam("actions").appendPathParam("changeCompartment").accept(new String[]{"application/json"}).appendHeader("if-match", request.getIfMatch()).appendHeader("opc-request-id", request.getOpcRequestId()).hasBody().handleResponseHeaderString("opc-work-request-id", ChangeServiceConnectorCompartmentResponse.Builder::opcWorkRequestId).handleResponseHeaderString("opc-request-id", ChangeServiceConnectorCompartmentResponse.Builder::opcRequestId).callAsync(handler);
    }

    @Override
    public Future<CreateServiceConnectorResponse> createServiceConnector(CreateServiceConnectorRequest request, AsyncHandler<CreateServiceConnectorRequest, CreateServiceConnectorResponse> handler) {
        Objects.requireNonNull(request.getCreateServiceConnectorDetails(), "createServiceConnectorDetails is required");
        return this.clientCall(request, CreateServiceConnectorResponse::builder).logger(LOG, "createServiceConnector").serviceDetails("ServiceConnector", "CreateServiceConnector", "https://docs.oracle.com/iaas/api/#/en/serviceconnectors/20200909/ServiceConnector/CreateServiceConnector").method(Method.POST).requestBuilder(CreateServiceConnectorRequest::builder).basePath("/20200909").appendPathParam("serviceConnectors").accept(new String[]{"application/json"}).appendHeader("opc-retry-token", request.getOpcRetryToken()).appendHeader("opc-request-id", request.getOpcRequestId()).hasBody().handleResponseHeaderString("opc-work-request-id", CreateServiceConnectorResponse.Builder::opcWorkRequestId).handleResponseHeaderString("opc-request-id", CreateServiceConnectorResponse.Builder::opcRequestId).callAsync(handler);
    }

    @Override
    public Future<DeactivateServiceConnectorResponse> deactivateServiceConnector(DeactivateServiceConnectorRequest request, AsyncHandler<DeactivateServiceConnectorRequest, DeactivateServiceConnectorResponse> handler) {
        Validate.notBlank((String)request.getServiceConnectorId(), (String)"serviceConnectorId must not be blank", (Object[])new Object[0]);
        return this.clientCall(request, DeactivateServiceConnectorResponse::builder).logger(LOG, "deactivateServiceConnector").serviceDetails("ServiceConnector", "DeactivateServiceConnector", "https://docs.oracle.com/iaas/api/#/en/serviceconnectors/20200909/ServiceConnector/DeactivateServiceConnector").method(Method.POST).requestBuilder(DeactivateServiceConnectorRequest::builder).basePath("/20200909").appendPathParam("serviceConnectors").appendPathParam(request.getServiceConnectorId()).appendPathParam("actions").appendPathParam("deactivate").accept(new String[]{"application/json"}).appendHeader("opc-retry-token", request.getOpcRetryToken()).appendHeader("if-match", request.getIfMatch()).appendHeader("opc-request-id", request.getOpcRequestId()).handleResponseHeaderString("opc-work-request-id", DeactivateServiceConnectorResponse.Builder::opcWorkRequestId).handleResponseHeaderString("opc-request-id", DeactivateServiceConnectorResponse.Builder::opcRequestId).callAsync(handler);
    }

    @Override
    public Future<DeleteServiceConnectorResponse> deleteServiceConnector(DeleteServiceConnectorRequest request, AsyncHandler<DeleteServiceConnectorRequest, DeleteServiceConnectorResponse> handler) {
        Validate.notBlank((String)request.getServiceConnectorId(), (String)"serviceConnectorId must not be blank", (Object[])new Object[0]);
        return this.clientCall(request, DeleteServiceConnectorResponse::builder).logger(LOG, "deleteServiceConnector").serviceDetails("ServiceConnector", "DeleteServiceConnector", "https://docs.oracle.com/iaas/api/#/en/serviceconnectors/20200909/ServiceConnector/DeleteServiceConnector").method(Method.DELETE).requestBuilder(DeleteServiceConnectorRequest::builder).basePath("/20200909").appendPathParam("serviceConnectors").appendPathParam(request.getServiceConnectorId()).accept(new String[]{"application/json"}).appendHeader("if-match", request.getIfMatch()).appendHeader("opc-request-id", request.getOpcRequestId()).handleResponseHeaderString("opc-work-request-id", DeleteServiceConnectorResponse.Builder::opcWorkRequestId).handleResponseHeaderString("opc-request-id", DeleteServiceConnectorResponse.Builder::opcRequestId).callAsync(handler);
    }

    @Override
    public Future<GetServiceConnectorResponse> getServiceConnector(GetServiceConnectorRequest request, AsyncHandler<GetServiceConnectorRequest, GetServiceConnectorResponse> handler) {
        Validate.notBlank((String)request.getServiceConnectorId(), (String)"serviceConnectorId must not be blank", (Object[])new Object[0]);
        return this.clientCall(request, GetServiceConnectorResponse::builder).logger(LOG, "getServiceConnector").serviceDetails("ServiceConnector", "GetServiceConnector", "https://docs.oracle.com/iaas/api/#/en/serviceconnectors/20200909/ServiceConnector/GetServiceConnector").method(Method.GET).requestBuilder(GetServiceConnectorRequest::builder).basePath("/20200909").appendPathParam("serviceConnectors").appendPathParam(request.getServiceConnectorId()).accept(new String[]{"application/json"}).appendHeader("opc-request-id", request.getOpcRequestId()).handleBody(ServiceConnector.class, GetServiceConnectorResponse.Builder::serviceConnector).handleResponseHeaderString("etag", GetServiceConnectorResponse.Builder::etag).handleResponseHeaderString("opc-request-id", GetServiceConnectorResponse.Builder::opcRequestId).callAsync(handler);
    }

    @Override
    public Future<GetWorkRequestResponse> getWorkRequest(GetWorkRequestRequest request, AsyncHandler<GetWorkRequestRequest, GetWorkRequestResponse> handler) {
        Validate.notBlank((String)request.getWorkRequestId(), (String)"workRequestId must not be blank", (Object[])new Object[0]);
        return this.clientCall(request, GetWorkRequestResponse::builder).logger(LOG, "getWorkRequest").serviceDetails("ServiceConnector", "GetWorkRequest", "https://docs.oracle.com/iaas/api/#/en/serviceconnectors/20200909/WorkRequest/GetWorkRequest").method(Method.GET).requestBuilder(GetWorkRequestRequest::builder).basePath("/20200909").appendPathParam("workRequests").appendPathParam(request.getWorkRequestId()).accept(new String[]{"application/json"}).appendHeader("opc-request-id", request.getOpcRequestId()).handleBody(WorkRequest.class, GetWorkRequestResponse.Builder::workRequest).handleResponseHeaderString("opc-request-id", GetWorkRequestResponse.Builder::opcRequestId).handleResponseHeaderFloat("retry-after", GetWorkRequestResponse.Builder::retryAfter).callAsync(handler);
    }

    @Override
    public Future<ListServiceConnectorsResponse> listServiceConnectors(ListServiceConnectorsRequest request, AsyncHandler<ListServiceConnectorsRequest, ListServiceConnectorsResponse> handler) {
        Objects.requireNonNull(request.getCompartmentId(), "compartmentId is required");
        return this.clientCall(request, ListServiceConnectorsResponse::builder).logger(LOG, "listServiceConnectors").serviceDetails("ServiceConnector", "ListServiceConnectors", "https://docs.oracle.com/iaas/api/#/en/serviceconnectors/20200909/ServiceConnector/ListServiceConnectors").method(Method.GET).requestBuilder(ListServiceConnectorsRequest::builder).basePath("/20200909").appendPathParam("serviceConnectors").appendQueryParam("compartmentId", (Object)request.getCompartmentId()).appendEnumQueryParam("lifecycleState", (BmcEnum)request.getLifecycleState()).appendQueryParam("displayName", (Object)request.getDisplayName()).appendQueryParam("limit", (Object)request.getLimit()).appendQueryParam("page", (Object)request.getPage()).appendEnumQueryParam("sortOrder", (BmcEnum)request.getSortOrder()).appendEnumQueryParam("sortBy", (BmcEnum)request.getSortBy()).accept(new String[]{"application/json"}).appendHeader("opc-request-id", request.getOpcRequestId()).handleBody(ServiceConnectorCollection.class, ListServiceConnectorsResponse.Builder::serviceConnectorCollection).handleResponseHeaderString("opc-request-id", ListServiceConnectorsResponse.Builder::opcRequestId).handleResponseHeaderString("opc-next-page", ListServiceConnectorsResponse.Builder::opcNextPage).handleResponseHeaderString("opc-prev-page", ListServiceConnectorsResponse.Builder::opcPrevPage).callAsync(handler);
    }

    @Override
    public Future<ListWorkRequestErrorsResponse> listWorkRequestErrors(ListWorkRequestErrorsRequest request, AsyncHandler<ListWorkRequestErrorsRequest, ListWorkRequestErrorsResponse> handler) {
        Validate.notBlank((String)request.getWorkRequestId(), (String)"workRequestId must not be blank", (Object[])new Object[0]);
        return this.clientCall(request, ListWorkRequestErrorsResponse::builder).logger(LOG, "listWorkRequestErrors").serviceDetails("ServiceConnector", "ListWorkRequestErrors", "https://docs.oracle.com/iaas/api/#/en/serviceconnectors/20200909/WorkRequestError/ListWorkRequestErrors").method(Method.GET).requestBuilder(ListWorkRequestErrorsRequest::builder).basePath("/20200909").appendPathParam("workRequests").appendPathParam(request.getWorkRequestId()).appendPathParam("errors").appendQueryParam("page", (Object)request.getPage()).appendQueryParam("limit", (Object)request.getLimit()).accept(new String[]{"application/json"}).appendHeader("opc-request-id", request.getOpcRequestId()).handleBody(WorkRequestErrorCollection.class, ListWorkRequestErrorsResponse.Builder::workRequestErrorCollection).handleResponseHeaderString("opc-next-page", ListWorkRequestErrorsResponse.Builder::opcNextPage).handleResponseHeaderString("opc-request-id", ListWorkRequestErrorsResponse.Builder::opcRequestId).handleResponseHeaderString("opc-prev-page", ListWorkRequestErrorsResponse.Builder::opcPrevPage).callAsync(handler);
    }

    @Override
    public Future<ListWorkRequestLogsResponse> listWorkRequestLogs(ListWorkRequestLogsRequest request, AsyncHandler<ListWorkRequestLogsRequest, ListWorkRequestLogsResponse> handler) {
        Validate.notBlank((String)request.getWorkRequestId(), (String)"workRequestId must not be blank", (Object[])new Object[0]);
        return this.clientCall(request, ListWorkRequestLogsResponse::builder).logger(LOG, "listWorkRequestLogs").serviceDetails("ServiceConnector", "ListWorkRequestLogs", "https://docs.oracle.com/iaas/api/#/en/serviceconnectors/20200909/WorkRequestLogEntry/ListWorkRequestLogs").method(Method.GET).requestBuilder(ListWorkRequestLogsRequest::builder).basePath("/20200909").appendPathParam("workRequests").appendPathParam(request.getWorkRequestId()).appendPathParam("logs").appendQueryParam("page", (Object)request.getPage()).appendQueryParam("limit", (Object)request.getLimit()).accept(new String[]{"application/json"}).appendHeader("opc-request-id", request.getOpcRequestId()).handleBody(WorkRequestLogEntryCollection.class, ListWorkRequestLogsResponse.Builder::workRequestLogEntryCollection).handleResponseHeaderString("opc-next-page", ListWorkRequestLogsResponse.Builder::opcNextPage).handleResponseHeaderString("opc-request-id", ListWorkRequestLogsResponse.Builder::opcRequestId).handleResponseHeaderString("opc-prev-page", ListWorkRequestLogsResponse.Builder::opcPrevPage).callAsync(handler);
    }

    @Override
    public Future<ListWorkRequestsResponse> listWorkRequests(ListWorkRequestsRequest request, AsyncHandler<ListWorkRequestsRequest, ListWorkRequestsResponse> handler) {
        Objects.requireNonNull(request.getCompartmentId(), "compartmentId is required");
        return this.clientCall(request, ListWorkRequestsResponse::builder).logger(LOG, "listWorkRequests").serviceDetails("ServiceConnector", "ListWorkRequests", "https://docs.oracle.com/iaas/api/#/en/serviceconnectors/20200909/WorkRequest/ListWorkRequests").method(Method.GET).requestBuilder(ListWorkRequestsRequest::builder).basePath("/20200909").appendPathParam("workRequests").appendQueryParam("compartmentId", (Object)request.getCompartmentId()).appendQueryParam("page", (Object)request.getPage()).appendQueryParam("limit", (Object)request.getLimit()).accept(new String[]{"application/json"}).appendHeader("opc-request-id", request.getOpcRequestId()).handleBody(WorkRequestCollection.class, ListWorkRequestsResponse.Builder::workRequestCollection).handleResponseHeaderString("opc-request-id", ListWorkRequestsResponse.Builder::opcRequestId).handleResponseHeaderString("opc-next-page", ListWorkRequestsResponse.Builder::opcNextPage).handleResponseHeaderString("opc-prev-page", ListWorkRequestsResponse.Builder::opcPrevPage).callAsync(handler);
    }

    @Override
    public Future<UpdateServiceConnectorResponse> updateServiceConnector(UpdateServiceConnectorRequest request, AsyncHandler<UpdateServiceConnectorRequest, UpdateServiceConnectorResponse> handler) {
        Validate.notBlank((String)request.getServiceConnectorId(), (String)"serviceConnectorId must not be blank", (Object[])new Object[0]);
        Objects.requireNonNull(request.getUpdateServiceConnectorDetails(), "updateServiceConnectorDetails is required");
        return this.clientCall(request, UpdateServiceConnectorResponse::builder).logger(LOG, "updateServiceConnector").serviceDetails("ServiceConnector", "UpdateServiceConnector", "https://docs.oracle.com/iaas/api/#/en/serviceconnectors/20200909/ServiceConnector/UpdateServiceConnector").method(Method.PUT).requestBuilder(UpdateServiceConnectorRequest::builder).basePath("/20200909").appendPathParam("serviceConnectors").appendPathParam(request.getServiceConnectorId()).accept(new String[]{"application/json"}).appendHeader("if-match", request.getIfMatch()).appendHeader("opc-request-id", request.getOpcRequestId()).hasBody().handleResponseHeaderString("opc-work-request-id", UpdateServiceConnectorResponse.Builder::opcWorkRequestId).handleResponseHeaderString("opc-request-id", UpdateServiceConnectorResponse.Builder::opcRequestId).callAsync(handler);
    }

    @Deprecated
    public ServiceConnectorAsyncClient(BasicAuthenticationDetailsProvider authenticationDetailsProvider) {
        this((ClientBuilderBase<?, ?>)ServiceConnectorAsyncClient.builder(), (AbstractAuthenticationDetailsProvider)authenticationDetailsProvider);
    }

    @Deprecated
    public ServiceConnectorAsyncClient(BasicAuthenticationDetailsProvider authenticationDetailsProvider, ClientConfiguration configuration) {
        this(ServiceConnectorAsyncClient.builder().configuration(configuration), (AbstractAuthenticationDetailsProvider)authenticationDetailsProvider);
    }

    @Deprecated
    public ServiceConnectorAsyncClient(BasicAuthenticationDetailsProvider authenticationDetailsProvider, ClientConfiguration configuration, ClientConfigurator clientConfigurator) {
        this(((Builder)ServiceConnectorAsyncClient.builder().configuration(configuration)).clientConfigurator(clientConfigurator), (AbstractAuthenticationDetailsProvider)authenticationDetailsProvider);
    }

    @Deprecated
    public ServiceConnectorAsyncClient(AbstractAuthenticationDetailsProvider authenticationDetailsProvider, ClientConfiguration configuration, ClientConfigurator clientConfigurator, RequestSignerFactory defaultRequestSignerFactory) {
        this(((Builder)((Builder)ServiceConnectorAsyncClient.builder().configuration(configuration)).clientConfigurator(clientConfigurator)).requestSignerFactory(defaultRequestSignerFactory), authenticationDetailsProvider);
    }

    @Deprecated
    public ServiceConnectorAsyncClient(AbstractAuthenticationDetailsProvider authenticationDetailsProvider, ClientConfiguration configuration, ClientConfigurator clientConfigurator, RequestSignerFactory defaultRequestSignerFactory, List<ClientConfigurator> additionalClientConfigurators) {
        this(((Builder)((Builder)((Builder)ServiceConnectorAsyncClient.builder().configuration(configuration)).clientConfigurator(clientConfigurator)).requestSignerFactory(defaultRequestSignerFactory)).additionalClientConfigurators(additionalClientConfigurators), authenticationDetailsProvider);
    }

    @Deprecated
    public ServiceConnectorAsyncClient(AbstractAuthenticationDetailsProvider authenticationDetailsProvider, ClientConfiguration configuration, ClientConfigurator clientConfigurator, RequestSignerFactory defaultRequestSignerFactory, List<ClientConfigurator> additionalClientConfigurators, String endpoint) {
        this(((Builder)((Builder)((Builder)((Builder)ServiceConnectorAsyncClient.builder().configuration(configuration)).clientConfigurator(clientConfigurator)).requestSignerFactory(defaultRequestSignerFactory)).additionalClientConfigurators(additionalClientConfigurators)).endpoint(endpoint), authenticationDetailsProvider);
    }

    @Deprecated
    public ServiceConnectorAsyncClient(AbstractAuthenticationDetailsProvider authenticationDetailsProvider, ClientConfiguration configuration, ClientConfigurator clientConfigurator, RequestSignerFactory defaultRequestSignerFactory, Map<SigningStrategy, RequestSignerFactory> signingStrategyRequestSignerFactories, List<ClientConfigurator> additionalClientConfigurators, String endpoint) {
        this(((Builder)((Builder)((Builder)((Builder)((Builder)ServiceConnectorAsyncClient.builder().configuration(configuration)).clientConfigurator(clientConfigurator)).requestSignerFactory(defaultRequestSignerFactory)).additionalClientConfigurators(additionalClientConfigurators)).endpoint(endpoint)).signingStrategyRequestSignerFactories(signingStrategyRequestSignerFactories), authenticationDetailsProvider);
    }

    public static class Builder
    extends RegionalClientBuilder<Builder, ServiceConnectorAsyncClient> {
        private Builder(Service service) {
            super(service);
            this.requestSignerFactory = new DefaultRequestSignerFactory(SigningStrategy.STANDARD);
        }

        public ServiceConnectorAsyncClient build(@Nonnull AbstractAuthenticationDetailsProvider authenticationDetailsProvider) {
            return new ServiceConnectorAsyncClient((ClientBuilderBase<?, ?>)this, authenticationDetailsProvider);
        }
    }
}

