/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.sch;

import com.oracle.bmc.ClientConfiguration;
import com.oracle.bmc.Region;
import com.oracle.bmc.Service;
import com.oracle.bmc.Services;
import com.oracle.bmc.auth.AbstractAuthenticationDetailsProvider;
import com.oracle.bmc.auth.BasicAuthenticationDetailsProvider;
import com.oracle.bmc.common.ClientBuilderBase;
import com.oracle.bmc.common.RegionalClientBuilder;
import com.oracle.bmc.http.ClientConfigurator;
import com.oracle.bmc.http.client.Method;
import com.oracle.bmc.http.internal.BaseSyncClient;
import com.oracle.bmc.http.internal.BmcEnum;
import com.oracle.bmc.http.signing.RequestSignerFactory;
import com.oracle.bmc.http.signing.SigningStrategy;
import com.oracle.bmc.http.signing.internal.DefaultRequestSignerFactory;
import com.oracle.bmc.internal.ClientThreadFactory;
import com.oracle.bmc.sch.ServiceConnector;
import com.oracle.bmc.sch.ServiceConnectorPaginators;
import com.oracle.bmc.sch.ServiceConnectorWaiters;
import com.oracle.bmc.sch.model.ServiceConnectorCollection;
import com.oracle.bmc.sch.model.WorkRequest;
import com.oracle.bmc.sch.model.WorkRequestCollection;
import com.oracle.bmc.sch.model.WorkRequestErrorCollection;
import com.oracle.bmc.sch.model.WorkRequestLogEntryCollection;
import com.oracle.bmc.sch.requests.ActivateServiceConnectorRequest;
import com.oracle.bmc.sch.requests.ChangeServiceConnectorCompartmentRequest;
import com.oracle.bmc.sch.requests.CreateServiceConnectorRequest;
import com.oracle.bmc.sch.requests.DeactivateServiceConnectorRequest;
import com.oracle.bmc.sch.requests.DeleteServiceConnectorRequest;
import com.oracle.bmc.sch.requests.GetServiceConnectorRequest;
import com.oracle.bmc.sch.requests.GetWorkRequestRequest;
import com.oracle.bmc.sch.requests.ListServiceConnectorsRequest;
import com.oracle.bmc.sch.requests.ListWorkRequestErrorsRequest;
import com.oracle.bmc.sch.requests.ListWorkRequestLogsRequest;
import com.oracle.bmc.sch.requests.ListWorkRequestsRequest;
import com.oracle.bmc.sch.requests.UpdateServiceConnectorRequest;
import com.oracle.bmc.sch.responses.ActivateServiceConnectorResponse;
import com.oracle.bmc.sch.responses.ChangeServiceConnectorCompartmentResponse;
import com.oracle.bmc.sch.responses.CreateServiceConnectorResponse;
import com.oracle.bmc.sch.responses.DeactivateServiceConnectorResponse;
import com.oracle.bmc.sch.responses.DeleteServiceConnectorResponse;
import com.oracle.bmc.sch.responses.GetServiceConnectorResponse;
import com.oracle.bmc.sch.responses.GetWorkRequestResponse;
import com.oracle.bmc.sch.responses.ListServiceConnectorsResponse;
import com.oracle.bmc.sch.responses.ListWorkRequestErrorsResponse;
import com.oracle.bmc.sch.responses.ListWorkRequestLogsResponse;
import com.oracle.bmc.sch.responses.ListWorkRequestsResponse;
import com.oracle.bmc.sch.responses.UpdateServiceConnectorResponse;
import com.oracle.bmc.util.CircuitBreakerUtils;
import com.oracle.bmc.util.internal.Validate;
import jakarta.annotation.Nonnull;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ServiceConnectorClient
extends BaseSyncClient
implements ServiceConnector {
    public static final Service SERVICE = Services.serviceBuilder().serviceName("SERVICECONNECTOR").serviceEndpointPrefix("").serviceEndpointTemplate("https://service-connector-hub.{region}.oci.{secondLevelDomain}").build();
    private static final Logger LOG = LoggerFactory.getLogger(ServiceConnectorClient.class);
    private final ServiceConnectorWaiters waiters;
    private final ServiceConnectorPaginators paginators;

    ServiceConnectorClient(ClientBuilderBase<?, ?> builder, AbstractAuthenticationDetailsProvider authenticationDetailsProvider, ExecutorService executorService) {
        super(builder, authenticationDetailsProvider, CircuitBreakerUtils.DEFAULT_CIRCUIT_BREAKER_CONFIGURATION);
        if (executorService == null) {
            ThreadPoolExecutor threadPoolExecutor = new ThreadPoolExecutor(50, 50, 60L, TimeUnit.SECONDS, new LinkedBlockingQueue<Runnable>(), (ThreadFactory)ClientThreadFactory.builder().isDaemon(true).nameFormat("ServiceConnector-waiters-%d").build());
            threadPoolExecutor.allowCoreThreadTimeOut(true);
            executorService = threadPoolExecutor;
        }
        this.waiters = new ServiceConnectorWaiters(executorService, this);
        this.paginators = new ServiceConnectorPaginators(this);
    }

    public static Builder builder() {
        return new Builder(SERVICE);
    }

    @Override
    public void setRegion(Region region) {
        super.setRegion(region);
    }

    @Override
    public void setRegion(String regionId) {
        super.setRegion(regionId);
    }

    @Override
    public ActivateServiceConnectorResponse activateServiceConnector(ActivateServiceConnectorRequest request) {
        Validate.notBlank((String)request.getServiceConnectorId(), (String)"serviceConnectorId must not be blank", (Object[])new Object[0]);
        return (ActivateServiceConnectorResponse)this.clientCall(request, ActivateServiceConnectorResponse::builder).logger(LOG, "activateServiceConnector").serviceDetails("ServiceConnector", "ActivateServiceConnector", "https://docs.oracle.com/iaas/api/#/en/serviceconnectors/20200909/ServiceConnector/ActivateServiceConnector").method(Method.POST).requestBuilder(ActivateServiceConnectorRequest::builder).basePath("/20200909").appendPathParam("serviceConnectors").appendPathParam(request.getServiceConnectorId()).appendPathParam("actions").appendPathParam("activate").accept(new String[]{"application/json"}).appendHeader("opc-retry-token", request.getOpcRetryToken()).appendHeader("if-match", request.getIfMatch()).appendHeader("opc-request-id", request.getOpcRequestId()).handleResponseHeaderString("opc-work-request-id", ActivateServiceConnectorResponse.Builder::opcWorkRequestId).handleResponseHeaderString("opc-request-id", ActivateServiceConnectorResponse.Builder::opcRequestId).callSync();
    }

    @Override
    public ChangeServiceConnectorCompartmentResponse changeServiceConnectorCompartment(ChangeServiceConnectorCompartmentRequest request) {
        Validate.notBlank((String)request.getServiceConnectorId(), (String)"serviceConnectorId must not be blank", (Object[])new Object[0]);
        Objects.requireNonNull(request.getChangeServiceConnectorCompartmentDetails(), "changeServiceConnectorCompartmentDetails is required");
        return (ChangeServiceConnectorCompartmentResponse)this.clientCall(request, ChangeServiceConnectorCompartmentResponse::builder).logger(LOG, "changeServiceConnectorCompartment").serviceDetails("ServiceConnector", "ChangeServiceConnectorCompartment", "https://docs.oracle.com/iaas/api/#/en/serviceconnectors/20200909/ServiceConnector/ChangeServiceConnectorCompartment").method(Method.POST).requestBuilder(ChangeServiceConnectorCompartmentRequest::builder).basePath("/20200909").appendPathParam("serviceConnectors").appendPathParam(request.getServiceConnectorId()).appendPathParam("actions").appendPathParam("changeCompartment").accept(new String[]{"application/json"}).appendHeader("if-match", request.getIfMatch()).appendHeader("opc-request-id", request.getOpcRequestId()).hasBody().handleResponseHeaderString("opc-work-request-id", ChangeServiceConnectorCompartmentResponse.Builder::opcWorkRequestId).handleResponseHeaderString("opc-request-id", ChangeServiceConnectorCompartmentResponse.Builder::opcRequestId).callSync();
    }

    @Override
    public CreateServiceConnectorResponse createServiceConnector(CreateServiceConnectorRequest request) {
        Objects.requireNonNull(request.getCreateServiceConnectorDetails(), "createServiceConnectorDetails is required");
        return (CreateServiceConnectorResponse)this.clientCall(request, CreateServiceConnectorResponse::builder).logger(LOG, "createServiceConnector").serviceDetails("ServiceConnector", "CreateServiceConnector", "https://docs.oracle.com/iaas/api/#/en/serviceconnectors/20200909/ServiceConnector/CreateServiceConnector").method(Method.POST).requestBuilder(CreateServiceConnectorRequest::builder).basePath("/20200909").appendPathParam("serviceConnectors").accept(new String[]{"application/json"}).appendHeader("opc-retry-token", request.getOpcRetryToken()).appendHeader("opc-request-id", request.getOpcRequestId()).hasBody().handleResponseHeaderString("opc-work-request-id", CreateServiceConnectorResponse.Builder::opcWorkRequestId).handleResponseHeaderString("opc-request-id", CreateServiceConnectorResponse.Builder::opcRequestId).callSync();
    }

    @Override
    public DeactivateServiceConnectorResponse deactivateServiceConnector(DeactivateServiceConnectorRequest request) {
        Validate.notBlank((String)request.getServiceConnectorId(), (String)"serviceConnectorId must not be blank", (Object[])new Object[0]);
        return (DeactivateServiceConnectorResponse)this.clientCall(request, DeactivateServiceConnectorResponse::builder).logger(LOG, "deactivateServiceConnector").serviceDetails("ServiceConnector", "DeactivateServiceConnector", "https://docs.oracle.com/iaas/api/#/en/serviceconnectors/20200909/ServiceConnector/DeactivateServiceConnector").method(Method.POST).requestBuilder(DeactivateServiceConnectorRequest::builder).basePath("/20200909").appendPathParam("serviceConnectors").appendPathParam(request.getServiceConnectorId()).appendPathParam("actions").appendPathParam("deactivate").accept(new String[]{"application/json"}).appendHeader("opc-retry-token", request.getOpcRetryToken()).appendHeader("if-match", request.getIfMatch()).appendHeader("opc-request-id", request.getOpcRequestId()).handleResponseHeaderString("opc-work-request-id", DeactivateServiceConnectorResponse.Builder::opcWorkRequestId).handleResponseHeaderString("opc-request-id", DeactivateServiceConnectorResponse.Builder::opcRequestId).callSync();
    }

    @Override
    public DeleteServiceConnectorResponse deleteServiceConnector(DeleteServiceConnectorRequest request) {
        Validate.notBlank((String)request.getServiceConnectorId(), (String)"serviceConnectorId must not be blank", (Object[])new Object[0]);
        return (DeleteServiceConnectorResponse)this.clientCall(request, DeleteServiceConnectorResponse::builder).logger(LOG, "deleteServiceConnector").serviceDetails("ServiceConnector", "DeleteServiceConnector", "https://docs.oracle.com/iaas/api/#/en/serviceconnectors/20200909/ServiceConnector/DeleteServiceConnector").method(Method.DELETE).requestBuilder(DeleteServiceConnectorRequest::builder).basePath("/20200909").appendPathParam("serviceConnectors").appendPathParam(request.getServiceConnectorId()).accept(new String[]{"application/json"}).appendHeader("if-match", request.getIfMatch()).appendHeader("opc-request-id", request.getOpcRequestId()).handleResponseHeaderString("opc-work-request-id", DeleteServiceConnectorResponse.Builder::opcWorkRequestId).handleResponseHeaderString("opc-request-id", DeleteServiceConnectorResponse.Builder::opcRequestId).callSync();
    }

    @Override
    public GetServiceConnectorResponse getServiceConnector(GetServiceConnectorRequest request) {
        Validate.notBlank((String)request.getServiceConnectorId(), (String)"serviceConnectorId must not be blank", (Object[])new Object[0]);
        return (GetServiceConnectorResponse)this.clientCall(request, GetServiceConnectorResponse::builder).logger(LOG, "getServiceConnector").serviceDetails("ServiceConnector", "GetServiceConnector", "https://docs.oracle.com/iaas/api/#/en/serviceconnectors/20200909/ServiceConnector/GetServiceConnector").method(Method.GET).requestBuilder(GetServiceConnectorRequest::builder).basePath("/20200909").appendPathParam("serviceConnectors").appendPathParam(request.getServiceConnectorId()).accept(new String[]{"application/json"}).appendHeader("opc-request-id", request.getOpcRequestId()).handleBody(com.oracle.bmc.sch.model.ServiceConnector.class, GetServiceConnectorResponse.Builder::serviceConnector).handleResponseHeaderString("etag", GetServiceConnectorResponse.Builder::etag).handleResponseHeaderString("opc-request-id", GetServiceConnectorResponse.Builder::opcRequestId).callSync();
    }

    @Override
    public GetWorkRequestResponse getWorkRequest(GetWorkRequestRequest request) {
        Validate.notBlank((String)request.getWorkRequestId(), (String)"workRequestId must not be blank", (Object[])new Object[0]);
        return (GetWorkRequestResponse)this.clientCall(request, GetWorkRequestResponse::builder).logger(LOG, "getWorkRequest").serviceDetails("ServiceConnector", "GetWorkRequest", "https://docs.oracle.com/iaas/api/#/en/serviceconnectors/20200909/WorkRequest/GetWorkRequest").method(Method.GET).requestBuilder(GetWorkRequestRequest::builder).basePath("/20200909").appendPathParam("workRequests").appendPathParam(request.getWorkRequestId()).accept(new String[]{"application/json"}).appendHeader("opc-request-id", request.getOpcRequestId()).handleBody(WorkRequest.class, GetWorkRequestResponse.Builder::workRequest).handleResponseHeaderString("opc-request-id", GetWorkRequestResponse.Builder::opcRequestId).handleResponseHeaderFloat("retry-after", GetWorkRequestResponse.Builder::retryAfter).callSync();
    }

    @Override
    public ListServiceConnectorsResponse listServiceConnectors(ListServiceConnectorsRequest request) {
        Objects.requireNonNull(request.getCompartmentId(), "compartmentId is required");
        return (ListServiceConnectorsResponse)this.clientCall(request, ListServiceConnectorsResponse::builder).logger(LOG, "listServiceConnectors").serviceDetails("ServiceConnector", "ListServiceConnectors", "https://docs.oracle.com/iaas/api/#/en/serviceconnectors/20200909/ServiceConnector/ListServiceConnectors").method(Method.GET).requestBuilder(ListServiceConnectorsRequest::builder).basePath("/20200909").appendPathParam("serviceConnectors").appendQueryParam("compartmentId", (Object)request.getCompartmentId()).appendEnumQueryParam("lifecycleState", (BmcEnum)request.getLifecycleState()).appendQueryParam("displayName", (Object)request.getDisplayName()).appendQueryParam("limit", (Object)request.getLimit()).appendQueryParam("page", (Object)request.getPage()).appendEnumQueryParam("sortOrder", (BmcEnum)request.getSortOrder()).appendEnumQueryParam("sortBy", (BmcEnum)request.getSortBy()).accept(new String[]{"application/json"}).appendHeader("opc-request-id", request.getOpcRequestId()).handleBody(ServiceConnectorCollection.class, ListServiceConnectorsResponse.Builder::serviceConnectorCollection).handleResponseHeaderString("opc-request-id", ListServiceConnectorsResponse.Builder::opcRequestId).handleResponseHeaderString("opc-next-page", ListServiceConnectorsResponse.Builder::opcNextPage).handleResponseHeaderString("opc-prev-page", ListServiceConnectorsResponse.Builder::opcPrevPage).callSync();
    }

    @Override
    public ListWorkRequestErrorsResponse listWorkRequestErrors(ListWorkRequestErrorsRequest request) {
        Validate.notBlank((String)request.getWorkRequestId(), (String)"workRequestId must not be blank", (Object[])new Object[0]);
        return (ListWorkRequestErrorsResponse)this.clientCall(request, ListWorkRequestErrorsResponse::builder).logger(LOG, "listWorkRequestErrors").serviceDetails("ServiceConnector", "ListWorkRequestErrors", "https://docs.oracle.com/iaas/api/#/en/serviceconnectors/20200909/WorkRequestError/ListWorkRequestErrors").method(Method.GET).requestBuilder(ListWorkRequestErrorsRequest::builder).basePath("/20200909").appendPathParam("workRequests").appendPathParam(request.getWorkRequestId()).appendPathParam("errors").appendQueryParam("page", (Object)request.getPage()).appendQueryParam("limit", (Object)request.getLimit()).accept(new String[]{"application/json"}).appendHeader("opc-request-id", request.getOpcRequestId()).handleBody(WorkRequestErrorCollection.class, ListWorkRequestErrorsResponse.Builder::workRequestErrorCollection).handleResponseHeaderString("opc-next-page", ListWorkRequestErrorsResponse.Builder::opcNextPage).handleResponseHeaderString("opc-request-id", ListWorkRequestErrorsResponse.Builder::opcRequestId).handleResponseHeaderString("opc-prev-page", ListWorkRequestErrorsResponse.Builder::opcPrevPage).callSync();
    }

    @Override
    public ListWorkRequestLogsResponse listWorkRequestLogs(ListWorkRequestLogsRequest request) {
        Validate.notBlank((String)request.getWorkRequestId(), (String)"workRequestId must not be blank", (Object[])new Object[0]);
        return (ListWorkRequestLogsResponse)this.clientCall(request, ListWorkRequestLogsResponse::builder).logger(LOG, "listWorkRequestLogs").serviceDetails("ServiceConnector", "ListWorkRequestLogs", "https://docs.oracle.com/iaas/api/#/en/serviceconnectors/20200909/WorkRequestLogEntry/ListWorkRequestLogs").method(Method.GET).requestBuilder(ListWorkRequestLogsRequest::builder).basePath("/20200909").appendPathParam("workRequests").appendPathParam(request.getWorkRequestId()).appendPathParam("logs").appendQueryParam("page", (Object)request.getPage()).appendQueryParam("limit", (Object)request.getLimit()).accept(new String[]{"application/json"}).appendHeader("opc-request-id", request.getOpcRequestId()).handleBody(WorkRequestLogEntryCollection.class, ListWorkRequestLogsResponse.Builder::workRequestLogEntryCollection).handleResponseHeaderString("opc-next-page", ListWorkRequestLogsResponse.Builder::opcNextPage).handleResponseHeaderString("opc-request-id", ListWorkRequestLogsResponse.Builder::opcRequestId).handleResponseHeaderString("opc-prev-page", ListWorkRequestLogsResponse.Builder::opcPrevPage).callSync();
    }

    @Override
    public ListWorkRequestsResponse listWorkRequests(ListWorkRequestsRequest request) {
        Objects.requireNonNull(request.getCompartmentId(), "compartmentId is required");
        return (ListWorkRequestsResponse)this.clientCall(request, ListWorkRequestsResponse::builder).logger(LOG, "listWorkRequests").serviceDetails("ServiceConnector", "ListWorkRequests", "https://docs.oracle.com/iaas/api/#/en/serviceconnectors/20200909/WorkRequest/ListWorkRequests").method(Method.GET).requestBuilder(ListWorkRequestsRequest::builder).basePath("/20200909").appendPathParam("workRequests").appendQueryParam("compartmentId", (Object)request.getCompartmentId()).appendQueryParam("page", (Object)request.getPage()).appendQueryParam("limit", (Object)request.getLimit()).accept(new String[]{"application/json"}).appendHeader("opc-request-id", request.getOpcRequestId()).handleBody(WorkRequestCollection.class, ListWorkRequestsResponse.Builder::workRequestCollection).handleResponseHeaderString("opc-request-id", ListWorkRequestsResponse.Builder::opcRequestId).handleResponseHeaderString("opc-next-page", ListWorkRequestsResponse.Builder::opcNextPage).handleResponseHeaderString("opc-prev-page", ListWorkRequestsResponse.Builder::opcPrevPage).callSync();
    }

    @Override
    public UpdateServiceConnectorResponse updateServiceConnector(UpdateServiceConnectorRequest request) {
        Validate.notBlank((String)request.getServiceConnectorId(), (String)"serviceConnectorId must not be blank", (Object[])new Object[0]);
        Objects.requireNonNull(request.getUpdateServiceConnectorDetails(), "updateServiceConnectorDetails is required");
        return (UpdateServiceConnectorResponse)this.clientCall(request, UpdateServiceConnectorResponse::builder).logger(LOG, "updateServiceConnector").serviceDetails("ServiceConnector", "UpdateServiceConnector", "https://docs.oracle.com/iaas/api/#/en/serviceconnectors/20200909/ServiceConnector/UpdateServiceConnector").method(Method.PUT).requestBuilder(UpdateServiceConnectorRequest::builder).basePath("/20200909").appendPathParam("serviceConnectors").appendPathParam(request.getServiceConnectorId()).accept(new String[]{"application/json"}).appendHeader("if-match", request.getIfMatch()).appendHeader("opc-request-id", request.getOpcRequestId()).hasBody().handleResponseHeaderString("opc-work-request-id", UpdateServiceConnectorResponse.Builder::opcWorkRequestId).handleResponseHeaderString("opc-request-id", UpdateServiceConnectorResponse.Builder::opcRequestId).callSync();
    }

    @Override
    public ServiceConnectorWaiters getWaiters() {
        return this.waiters;
    }

    @Override
    public ServiceConnectorPaginators getPaginators() {
        return this.paginators;
    }

    @Deprecated
    public ServiceConnectorClient(BasicAuthenticationDetailsProvider authenticationDetailsProvider) {
        this((ClientBuilderBase<?, ?>)ServiceConnectorClient.builder(), (AbstractAuthenticationDetailsProvider)authenticationDetailsProvider, null);
    }

    @Deprecated
    public ServiceConnectorClient(BasicAuthenticationDetailsProvider authenticationDetailsProvider, ClientConfiguration configuration) {
        this(ServiceConnectorClient.builder().configuration(configuration), (AbstractAuthenticationDetailsProvider)authenticationDetailsProvider, null);
    }

    @Deprecated
    public ServiceConnectorClient(BasicAuthenticationDetailsProvider authenticationDetailsProvider, ClientConfiguration configuration, ClientConfigurator clientConfigurator) {
        this(((Builder)ServiceConnectorClient.builder().configuration(configuration)).clientConfigurator(clientConfigurator), (AbstractAuthenticationDetailsProvider)authenticationDetailsProvider, null);
    }

    @Deprecated
    public ServiceConnectorClient(AbstractAuthenticationDetailsProvider authenticationDetailsProvider, ClientConfiguration configuration, ClientConfigurator clientConfigurator, RequestSignerFactory defaultRequestSignerFactory) {
        this(((Builder)((Builder)ServiceConnectorClient.builder().configuration(configuration)).clientConfigurator(clientConfigurator)).requestSignerFactory(defaultRequestSignerFactory), authenticationDetailsProvider, null);
    }

    @Deprecated
    public ServiceConnectorClient(AbstractAuthenticationDetailsProvider authenticationDetailsProvider, ClientConfiguration configuration, ClientConfigurator clientConfigurator, RequestSignerFactory defaultRequestSignerFactory, List<ClientConfigurator> additionalClientConfigurators) {
        this(((Builder)((Builder)((Builder)ServiceConnectorClient.builder().configuration(configuration)).clientConfigurator(clientConfigurator)).requestSignerFactory(defaultRequestSignerFactory)).additionalClientConfigurators(additionalClientConfigurators), authenticationDetailsProvider, null);
    }

    @Deprecated
    public ServiceConnectorClient(AbstractAuthenticationDetailsProvider authenticationDetailsProvider, ClientConfiguration configuration, ClientConfigurator clientConfigurator, RequestSignerFactory defaultRequestSignerFactory, List<ClientConfigurator> additionalClientConfigurators, String endpoint) {
        this(((Builder)((Builder)((Builder)((Builder)ServiceConnectorClient.builder().configuration(configuration)).clientConfigurator(clientConfigurator)).requestSignerFactory(defaultRequestSignerFactory)).additionalClientConfigurators(additionalClientConfigurators)).endpoint(endpoint), authenticationDetailsProvider, null);
    }

    @Deprecated
    public ServiceConnectorClient(AbstractAuthenticationDetailsProvider authenticationDetailsProvider, ClientConfiguration configuration, ClientConfigurator clientConfigurator, RequestSignerFactory defaultRequestSignerFactory, Map<SigningStrategy, RequestSignerFactory> signingStrategyRequestSignerFactories, List<ClientConfigurator> additionalClientConfigurators, String endpoint) {
        this(((Builder)((Builder)((Builder)((Builder)((Builder)ServiceConnectorClient.builder().configuration(configuration)).clientConfigurator(clientConfigurator)).requestSignerFactory(defaultRequestSignerFactory)).additionalClientConfigurators(additionalClientConfigurators)).endpoint(endpoint)).signingStrategyRequestSignerFactories(signingStrategyRequestSignerFactories), authenticationDetailsProvider, null);
    }

    @Deprecated
    public ServiceConnectorClient(AbstractAuthenticationDetailsProvider authenticationDetailsProvider, ClientConfiguration configuration, ClientConfigurator clientConfigurator, RequestSignerFactory defaultRequestSignerFactory, Map<SigningStrategy, RequestSignerFactory> signingStrategyRequestSignerFactories, List<ClientConfigurator> additionalClientConfigurators, String endpoint, ExecutorService executorService) {
        this(((Builder)((Builder)((Builder)((Builder)((Builder)ServiceConnectorClient.builder().configuration(configuration)).clientConfigurator(clientConfigurator)).requestSignerFactory(defaultRequestSignerFactory)).additionalClientConfigurators(additionalClientConfigurators)).endpoint(endpoint)).signingStrategyRequestSignerFactories(signingStrategyRequestSignerFactories), authenticationDetailsProvider, executorService);
    }

    public static class Builder
    extends RegionalClientBuilder<Builder, ServiceConnectorClient> {
        private ExecutorService executorService;

        private Builder(Service service) {
            super(service);
            this.requestSignerFactory = new DefaultRequestSignerFactory(SigningStrategy.STANDARD);
        }

        public Builder executorService(ExecutorService executorService) {
            this.executorService = executorService;
            return this;
        }

        public ServiceConnectorClient build(@Nonnull AbstractAuthenticationDetailsProvider authenticationDetailsProvider) {
            return new ServiceConnectorClient((ClientBuilderBase<?, ?>)this, authenticationDetailsProvider, this.executorService);
        }
    }
}

