/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.sch;

import com.oracle.bmc.paginator.internal.RequestBuilderAndToken;
import com.oracle.bmc.paginator.internal.ResponseIterable;
import com.oracle.bmc.paginator.internal.ResponseRecordIterable;
import com.oracle.bmc.sch.ConnectorPlugins;
import com.oracle.bmc.sch.model.ConnectorPluginSummary;
import com.oracle.bmc.sch.requests.ListConnectorPluginsRequest;
import com.oracle.bmc.sch.responses.ListConnectorPluginsResponse;
import java.util.List;
import java.util.function.Function;
import java.util.function.Supplier;

public class ConnectorPluginsPaginators {
    private final ConnectorPlugins client;

    public ConnectorPluginsPaginators(ConnectorPlugins client) {
        this.client = client;
    }

    public Iterable<ListConnectorPluginsResponse> listConnectorPluginsResponseIterator(final ListConnectorPluginsRequest request) {
        return new ResponseIterable((Supplier)new Supplier<ListConnectorPluginsRequest.Builder>(){

            @Override
            public ListConnectorPluginsRequest.Builder get() {
                return ListConnectorPluginsRequest.builder().copy(request);
            }
        }, (Function)new Function<ListConnectorPluginsResponse, String>(){

            @Override
            public String apply(ListConnectorPluginsResponse response) {
                return response.getOpcNextPage();
            }
        }, (Function)new Function<RequestBuilderAndToken<ListConnectorPluginsRequest.Builder>, ListConnectorPluginsRequest>(){

            @Override
            public ListConnectorPluginsRequest apply(RequestBuilderAndToken<ListConnectorPluginsRequest.Builder> input) {
                if (input.getNextPageToken() == null) {
                    return ((ListConnectorPluginsRequest.Builder)input.getRequestBuilder()).build();
                }
                return ((ListConnectorPluginsRequest.Builder)input.getRequestBuilder()).page(input.getNextPageToken().orElse(null)).build();
            }
        }, (Function)new Function<ListConnectorPluginsRequest, ListConnectorPluginsResponse>(){

            @Override
            public ListConnectorPluginsResponse apply(ListConnectorPluginsRequest request) {
                return ConnectorPluginsPaginators.this.client.listConnectorPlugins(request);
            }
        });
    }

    public Iterable<ConnectorPluginSummary> listConnectorPluginsRecordIterator(final ListConnectorPluginsRequest request) {
        return new ResponseRecordIterable((Supplier)new Supplier<ListConnectorPluginsRequest.Builder>(){

            @Override
            public ListConnectorPluginsRequest.Builder get() {
                return ListConnectorPluginsRequest.builder().copy(request);
            }
        }, (Function)new Function<ListConnectorPluginsResponse, String>(){

            @Override
            public String apply(ListConnectorPluginsResponse response) {
                return response.getOpcNextPage();
            }
        }, (Function)new Function<RequestBuilderAndToken<ListConnectorPluginsRequest.Builder>, ListConnectorPluginsRequest>(){

            @Override
            public ListConnectorPluginsRequest apply(RequestBuilderAndToken<ListConnectorPluginsRequest.Builder> input) {
                if (input.getNextPageToken() == null) {
                    return ((ListConnectorPluginsRequest.Builder)input.getRequestBuilder()).build();
                }
                return ((ListConnectorPluginsRequest.Builder)input.getRequestBuilder()).page(input.getNextPageToken().orElse(null)).build();
            }
        }, (Function)new Function<ListConnectorPluginsRequest, ListConnectorPluginsResponse>(){

            @Override
            public ListConnectorPluginsResponse apply(ListConnectorPluginsRequest request) {
                return ConnectorPluginsPaginators.this.client.listConnectorPlugins(request);
            }
        }, (Function)new Function<ListConnectorPluginsResponse, List<ConnectorPluginSummary>>(){

            @Override
            public List<ConnectorPluginSummary> apply(ListConnectorPluginsResponse response) {
                return response.getConnectorPluginCollection().getItems();
            }
        });
    }
}

