/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.sch;

import com.oracle.bmc.sch.ConnectorPlugins;
import com.oracle.bmc.sch.model.ConnectorPluginLifecycleState;
import com.oracle.bmc.sch.requests.GetConnectorPluginRequest;
import com.oracle.bmc.sch.responses.GetConnectorPluginResponse;
import com.oracle.bmc.util.internal.Validate;
import com.oracle.bmc.waiter.BmcGenericWaiter;
import com.oracle.bmc.waiter.DelayStrategy;
import com.oracle.bmc.waiter.TerminationStrategy;
import com.oracle.bmc.waiter.Waiter;
import com.oracle.bmc.waiter.Waiters;
import com.oracle.bmc.waiter.internal.SimpleWaiterImpl;
import java.util.Arrays;
import java.util.HashSet;
import java.util.concurrent.ExecutorService;
import java.util.function.Function;
import java.util.function.Predicate;

public class ConnectorPluginsWaiters {
    private final ExecutorService executorService;
    private final ConnectorPlugins client;

    public ConnectorPluginsWaiters(ExecutorService executorService, ConnectorPlugins client) {
        this.executorService = executorService;
        this.client = client;
    }

    public Waiter<GetConnectorPluginRequest, GetConnectorPluginResponse> forConnectorPlugin(GetConnectorPluginRequest request, ConnectorPluginLifecycleState ... targetStates) {
        Validate.notEmpty((Object[])targetStates, (String)"At least one targetState must be provided", (Object[])new Object[0]);
        Validate.noNullElements((Object[])targetStates, (String)"Null targetState values are not permitted", (Object[])new Object[0]);
        return this.forConnectorPlugin(Waiters.DEFAULT_POLLING_WAITER, request, targetStates);
    }

    public Waiter<GetConnectorPluginRequest, GetConnectorPluginResponse> forConnectorPlugin(GetConnectorPluginRequest request, ConnectorPluginLifecycleState targetState, TerminationStrategy terminationStrategy, DelayStrategy delayStrategy) {
        Validate.notNull((Object)((Object)targetState), (String)"The targetState cannot be null", (Object[])new Object[0]);
        return this.forConnectorPlugin(Waiters.newWaiter((TerminationStrategy)terminationStrategy, (DelayStrategy)delayStrategy), request, targetState);
    }

    public Waiter<GetConnectorPluginRequest, GetConnectorPluginResponse> forConnectorPlugin(GetConnectorPluginRequest request, TerminationStrategy terminationStrategy, DelayStrategy delayStrategy, ConnectorPluginLifecycleState ... targetStates) {
        Validate.notEmpty((Object[])targetStates, (String)"At least one targetState must be provided", (Object[])new Object[0]);
        Validate.noNullElements((Object[])targetStates, (String)"Null targetState values are not permitted", (Object[])new Object[0]);
        return this.forConnectorPlugin(Waiters.newWaiter((TerminationStrategy)terminationStrategy, (DelayStrategy)delayStrategy), request, targetStates);
    }

    private Waiter<GetConnectorPluginRequest, GetConnectorPluginResponse> forConnectorPlugin(BmcGenericWaiter waiter, GetConnectorPluginRequest request, ConnectorPluginLifecycleState ... targetStates) {
        final HashSet<ConnectorPluginLifecycleState> targetStatesSet = new HashSet<ConnectorPluginLifecycleState>(Arrays.asList(targetStates));
        return new SimpleWaiterImpl(this.executorService, waiter.toCallable(() -> request, (Function)new Function<GetConnectorPluginRequest, GetConnectorPluginResponse>(){

            @Override
            public GetConnectorPluginResponse apply(GetConnectorPluginRequest request) {
                return ConnectorPluginsWaiters.this.client.getConnectorPlugin(request);
            }
        }, (Predicate)new Predicate<GetConnectorPluginResponse>(){

            @Override
            public boolean test(GetConnectorPluginResponse response) {
                return targetStatesSet.contains((Object)response.getConnectorPlugin().getLifecycleState());
            }
        }, targetStatesSet.contains((Object)ConnectorPluginLifecycleState.Deleted)), (Object)request);
    }
}

