/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.sch;

import com.oracle.bmc.ClientConfiguration;
import com.oracle.bmc.Region;
import com.oracle.bmc.Service;
import com.oracle.bmc.Services;
import com.oracle.bmc.auth.AbstractAuthenticationDetailsProvider;
import com.oracle.bmc.auth.BasicAuthenticationDetailsProvider;
import com.oracle.bmc.common.ClientBuilderBase;
import com.oracle.bmc.common.RegionalClientBuilder;
import com.oracle.bmc.http.ClientConfigurator;
import com.oracle.bmc.http.client.Method;
import com.oracle.bmc.http.internal.BaseSyncClient;
import com.oracle.bmc.http.internal.BmcEnum;
import com.oracle.bmc.http.signing.RequestSignerFactory;
import com.oracle.bmc.http.signing.SigningStrategy;
import com.oracle.bmc.http.signing.internal.DefaultRequestSignerFactory;
import com.oracle.bmc.internal.Alloy;
import com.oracle.bmc.internal.ClientThreadFactory;
import com.oracle.bmc.sch.ConnectorPlugins;
import com.oracle.bmc.sch.ConnectorPluginsPaginators;
import com.oracle.bmc.sch.ConnectorPluginsWaiters;
import com.oracle.bmc.sch.model.ConnectorPlugin;
import com.oracle.bmc.sch.model.ConnectorPluginCollection;
import com.oracle.bmc.sch.requests.GetConnectorPluginRequest;
import com.oracle.bmc.sch.requests.ListConnectorPluginsRequest;
import com.oracle.bmc.sch.responses.GetConnectorPluginResponse;
import com.oracle.bmc.sch.responses.ListConnectorPluginsResponse;
import com.oracle.bmc.util.CircuitBreakerUtils;
import com.oracle.bmc.util.internal.Validate;
import jakarta.annotation.Nonnull;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ConnectorPluginsClient
extends BaseSyncClient
implements ConnectorPlugins {
    public static final Service SERVICE = Services.serviceBuilder().serviceName("CONNECTORPLUGINS").serviceEndpointPrefix("").serviceEndpointTemplate("https://service-connector-hub.{region}.oci.{secondLevelDomain}").build();
    private static final Logger LOG = LoggerFactory.getLogger(ConnectorPluginsClient.class);
    private final ConnectorPluginsWaiters waiters;
    private final ConnectorPluginsPaginators paginators;

    ConnectorPluginsClient(ClientBuilderBase<?, ?> builder, AbstractAuthenticationDetailsProvider authenticationDetailsProvider, ExecutorService executorService) {
        super(builder, authenticationDetailsProvider, CircuitBreakerUtils.DEFAULT_CIRCUIT_BREAKER_CONFIGURATION);
        if (executorService == null) {
            ThreadPoolExecutor threadPoolExecutor = new ThreadPoolExecutor(50, 50, 60L, TimeUnit.SECONDS, new LinkedBlockingQueue<Runnable>(), (ThreadFactory)ClientThreadFactory.builder().isDaemon(true).nameFormat("ConnectorPlugins-waiters-%d").build());
            threadPoolExecutor.allowCoreThreadTimeOut(true);
            executorService = threadPoolExecutor;
        }
        this.waiters = new ConnectorPluginsWaiters(executorService, this);
        this.paginators = new ConnectorPluginsPaginators(this);
    }

    public static Builder builder() {
        return new Builder(SERVICE);
    }

    @Override
    public void setRegion(Region region) {
        super.setRegion(region);
    }

    @Override
    public void setRegion(String regionId) {
        super.setRegion(regionId);
    }

    @Override
    public GetConnectorPluginResponse getConnectorPlugin(GetConnectorPluginRequest request) {
        Validate.notBlank((String)request.getConnectorPluginName(), (String)"connectorPluginName must not be blank", (Object[])new Object[0]);
        return (GetConnectorPluginResponse)this.clientCall(request, GetConnectorPluginResponse::builder).logger(LOG, "getConnectorPlugin").serviceDetails("ConnectorPlugins", "GetConnectorPlugin", "https://docs.oracle.com/iaas/api/#/en/serviceconnectors/20200909/ConnectorPlugin/GetConnectorPlugin").method(Method.GET).requestBuilder(GetConnectorPluginRequest::builder).basePath("/20200909").appendPathParam("connectorPlugins").appendPathParam(request.getConnectorPluginName()).accept(new String[]{"application/json"}).appendHeader("opc-request-id", request.getOpcRequestId()).operationUsesDefaultRetries().handleBody(ConnectorPlugin.class, GetConnectorPluginResponse.Builder::connectorPlugin).handleResponseHeaderString("opc-request-id", GetConnectorPluginResponse.Builder::opcRequestId).callSync();
    }

    @Override
    public ListConnectorPluginsResponse listConnectorPlugins(ListConnectorPluginsRequest request) {
        return (ListConnectorPluginsResponse)this.clientCall(request, ListConnectorPluginsResponse::builder).logger(LOG, "listConnectorPlugins").serviceDetails("ConnectorPlugins", "ListConnectorPlugins", "https://docs.oracle.com/iaas/api/#/en/serviceconnectors/20200909/ConnectorPluginSummary/ListConnectorPlugins").method(Method.GET).requestBuilder(ListConnectorPluginsRequest::builder).basePath("/20200909").appendPathParam("connectorPlugins").appendEnumQueryParam("lifecycleState", (BmcEnum)request.getLifecycleState()).appendQueryParam("displayName", (Object)request.getDisplayName()).appendQueryParam("name", (Object)request.getName()).appendQueryParam("limit", (Object)request.getLimit()).appendQueryParam("page", (Object)request.getPage()).appendEnumQueryParam("sortOrder", (BmcEnum)request.getSortOrder()).appendEnumQueryParam("sortBy", (BmcEnum)request.getSortBy()).accept(new String[]{"application/json"}).appendHeader("opc-request-id", request.getOpcRequestId()).operationUsesDefaultRetries().handleBody(ConnectorPluginCollection.class, ListConnectorPluginsResponse.Builder::connectorPluginCollection).handleResponseHeaderString("opc-request-id", ListConnectorPluginsResponse.Builder::opcRequestId).handleResponseHeaderString("opc-next-page", ListConnectorPluginsResponse.Builder::opcNextPage).handleResponseHeaderString("opc-prev-page", ListConnectorPluginsResponse.Builder::opcPrevPage).callSync();
    }

    @Override
    public ConnectorPluginsWaiters getWaiters() {
        return this.waiters;
    }

    @Override
    public ConnectorPluginsPaginators getPaginators() {
        return this.paginators;
    }

    @Deprecated
    public ConnectorPluginsClient(BasicAuthenticationDetailsProvider authenticationDetailsProvider) {
        this((ClientBuilderBase<?, ?>)ConnectorPluginsClient.builder(), (AbstractAuthenticationDetailsProvider)authenticationDetailsProvider, null);
    }

    @Deprecated
    public ConnectorPluginsClient(BasicAuthenticationDetailsProvider authenticationDetailsProvider, ClientConfiguration configuration) {
        this(ConnectorPluginsClient.builder().configuration(configuration), (AbstractAuthenticationDetailsProvider)authenticationDetailsProvider, null);
    }

    @Deprecated
    public ConnectorPluginsClient(BasicAuthenticationDetailsProvider authenticationDetailsProvider, ClientConfiguration configuration, ClientConfigurator clientConfigurator) {
        this(((Builder)ConnectorPluginsClient.builder().configuration(configuration)).clientConfigurator(clientConfigurator), (AbstractAuthenticationDetailsProvider)authenticationDetailsProvider, null);
    }

    @Deprecated
    public ConnectorPluginsClient(AbstractAuthenticationDetailsProvider authenticationDetailsProvider, ClientConfiguration configuration, ClientConfigurator clientConfigurator, RequestSignerFactory defaultRequestSignerFactory) {
        this(((Builder)((Builder)ConnectorPluginsClient.builder().configuration(configuration)).clientConfigurator(clientConfigurator)).requestSignerFactory(defaultRequestSignerFactory), authenticationDetailsProvider, null);
    }

    @Deprecated
    public ConnectorPluginsClient(AbstractAuthenticationDetailsProvider authenticationDetailsProvider, ClientConfiguration configuration, ClientConfigurator clientConfigurator, RequestSignerFactory defaultRequestSignerFactory, List<ClientConfigurator> additionalClientConfigurators) {
        this(((Builder)((Builder)((Builder)ConnectorPluginsClient.builder().configuration(configuration)).clientConfigurator(clientConfigurator)).requestSignerFactory(defaultRequestSignerFactory)).additionalClientConfigurators(additionalClientConfigurators), authenticationDetailsProvider, null);
    }

    @Deprecated
    public ConnectorPluginsClient(AbstractAuthenticationDetailsProvider authenticationDetailsProvider, ClientConfiguration configuration, ClientConfigurator clientConfigurator, RequestSignerFactory defaultRequestSignerFactory, List<ClientConfigurator> additionalClientConfigurators, String endpoint) {
        this(((Builder)((Builder)((Builder)((Builder)ConnectorPluginsClient.builder().configuration(configuration)).clientConfigurator(clientConfigurator)).requestSignerFactory(defaultRequestSignerFactory)).additionalClientConfigurators(additionalClientConfigurators)).endpoint(endpoint), authenticationDetailsProvider, null);
    }

    @Deprecated
    public ConnectorPluginsClient(AbstractAuthenticationDetailsProvider authenticationDetailsProvider, ClientConfiguration configuration, ClientConfigurator clientConfigurator, RequestSignerFactory defaultRequestSignerFactory, Map<SigningStrategy, RequestSignerFactory> signingStrategyRequestSignerFactories, List<ClientConfigurator> additionalClientConfigurators, String endpoint) {
        this(((Builder)((Builder)((Builder)((Builder)((Builder)ConnectorPluginsClient.builder().configuration(configuration)).clientConfigurator(clientConfigurator)).requestSignerFactory(defaultRequestSignerFactory)).additionalClientConfigurators(additionalClientConfigurators)).endpoint(endpoint)).signingStrategyRequestSignerFactories(signingStrategyRequestSignerFactories), authenticationDetailsProvider, null);
    }

    @Deprecated
    public ConnectorPluginsClient(AbstractAuthenticationDetailsProvider authenticationDetailsProvider, ClientConfiguration configuration, ClientConfigurator clientConfigurator, RequestSignerFactory defaultRequestSignerFactory, Map<SigningStrategy, RequestSignerFactory> signingStrategyRequestSignerFactories, List<ClientConfigurator> additionalClientConfigurators, String endpoint, ExecutorService executorService) {
        this(((Builder)((Builder)((Builder)((Builder)((Builder)ConnectorPluginsClient.builder().configuration(configuration)).clientConfigurator(clientConfigurator)).requestSignerFactory(defaultRequestSignerFactory)).additionalClientConfigurators(additionalClientConfigurators)).endpoint(endpoint)).signingStrategyRequestSignerFactories(signingStrategyRequestSignerFactories), authenticationDetailsProvider, executorService);
    }

    public static class Builder
    extends RegionalClientBuilder<Builder, ConnectorPluginsClient> {
        private ExecutorService executorService;

        private Builder(Service service) {
            super(service);
            String packageName = "sch";
            Alloy.throwDisabledServiceExceptionIfAppropriate((String)"sch");
            this.requestSignerFactory = new DefaultRequestSignerFactory(SigningStrategy.STANDARD);
        }

        public Builder executorService(ExecutorService executorService) {
            this.executorService = executorService;
            return this;
        }

        public ConnectorPluginsClient build(@Nonnull AbstractAuthenticationDetailsProvider authenticationDetailsProvider) {
            return new ConnectorPluginsClient((ClientBuilderBase<?, ?>)this, authenticationDetailsProvider, this.executorService);
        }
    }
}

