/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.sch;

import com.oracle.bmc.ClientConfiguration;
import com.oracle.bmc.Region;
import com.oracle.bmc.Service;
import com.oracle.bmc.Services;
import com.oracle.bmc.auth.AbstractAuthenticationDetailsProvider;
import com.oracle.bmc.auth.BasicAuthenticationDetailsProvider;
import com.oracle.bmc.common.ClientBuilderBase;
import com.oracle.bmc.common.RegionalClientBuilder;
import com.oracle.bmc.http.ClientConfigurator;
import com.oracle.bmc.http.client.Method;
import com.oracle.bmc.http.internal.BaseAsyncClient;
import com.oracle.bmc.http.internal.BmcEnum;
import com.oracle.bmc.http.signing.RequestSignerFactory;
import com.oracle.bmc.http.signing.SigningStrategy;
import com.oracle.bmc.http.signing.internal.DefaultRequestSignerFactory;
import com.oracle.bmc.internal.Alloy;
import com.oracle.bmc.responses.AsyncHandler;
import com.oracle.bmc.sch.ConnectorPluginsAsync;
import com.oracle.bmc.sch.model.ConnectorPlugin;
import com.oracle.bmc.sch.model.ConnectorPluginCollection;
import com.oracle.bmc.sch.requests.GetConnectorPluginRequest;
import com.oracle.bmc.sch.requests.ListConnectorPluginsRequest;
import com.oracle.bmc.sch.responses.GetConnectorPluginResponse;
import com.oracle.bmc.sch.responses.ListConnectorPluginsResponse;
import com.oracle.bmc.util.internal.Validate;
import jakarta.annotation.Nonnull;
import java.util.List;
import java.util.Map;
import java.util.concurrent.Future;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ConnectorPluginsAsyncClient
extends BaseAsyncClient
implements ConnectorPluginsAsync {
    public static final Service SERVICE = Services.serviceBuilder().serviceName("CONNECTORPLUGINS").serviceEndpointPrefix("").serviceEndpointTemplate("https://service-connector-hub.{region}.oci.{secondLevelDomain}").build();
    private static final Logger LOG = LoggerFactory.getLogger(ConnectorPluginsAsyncClient.class);

    ConnectorPluginsAsyncClient(ClientBuilderBase<?, ?> builder, AbstractAuthenticationDetailsProvider authenticationDetailsProvider) {
        super(builder, authenticationDetailsProvider);
    }

    public static Builder builder() {
        return new Builder(SERVICE);
    }

    @Override
    public void setRegion(Region region) {
        super.setRegion(region);
    }

    @Override
    public void setRegion(String regionId) {
        super.setRegion(regionId);
    }

    @Override
    public Future<GetConnectorPluginResponse> getConnectorPlugin(GetConnectorPluginRequest request, AsyncHandler<GetConnectorPluginRequest, GetConnectorPluginResponse> handler) {
        Validate.notBlank((String)request.getConnectorPluginName(), (String)"connectorPluginName must not be blank", (Object[])new Object[0]);
        return this.clientCall(request, GetConnectorPluginResponse::builder).logger(LOG, "getConnectorPlugin").serviceDetails("ConnectorPlugins", "GetConnectorPlugin", "https://docs.oracle.com/iaas/api/#/en/serviceconnectors/20200909/ConnectorPlugin/GetConnectorPlugin").method(Method.GET).requestBuilder(GetConnectorPluginRequest::builder).basePath("/20200909").appendPathParam("connectorPlugins").appendPathParam(request.getConnectorPluginName()).accept(new String[]{"application/json"}).appendHeader("opc-request-id", request.getOpcRequestId()).handleBody(ConnectorPlugin.class, GetConnectorPluginResponse.Builder::connectorPlugin).handleResponseHeaderString("opc-request-id", GetConnectorPluginResponse.Builder::opcRequestId).callAsync(handler);
    }

    @Override
    public Future<ListConnectorPluginsResponse> listConnectorPlugins(ListConnectorPluginsRequest request, AsyncHandler<ListConnectorPluginsRequest, ListConnectorPluginsResponse> handler) {
        return this.clientCall(request, ListConnectorPluginsResponse::builder).logger(LOG, "listConnectorPlugins").serviceDetails("ConnectorPlugins", "ListConnectorPlugins", "https://docs.oracle.com/iaas/api/#/en/serviceconnectors/20200909/ConnectorPluginSummary/ListConnectorPlugins").method(Method.GET).requestBuilder(ListConnectorPluginsRequest::builder).basePath("/20200909").appendPathParam("connectorPlugins").appendEnumQueryParam("lifecycleState", (BmcEnum)request.getLifecycleState()).appendQueryParam("displayName", (Object)request.getDisplayName()).appendQueryParam("name", (Object)request.getName()).appendQueryParam("limit", (Object)request.getLimit()).appendQueryParam("page", (Object)request.getPage()).appendEnumQueryParam("sortOrder", (BmcEnum)request.getSortOrder()).appendEnumQueryParam("sortBy", (BmcEnum)request.getSortBy()).accept(new String[]{"application/json"}).appendHeader("opc-request-id", request.getOpcRequestId()).handleBody(ConnectorPluginCollection.class, ListConnectorPluginsResponse.Builder::connectorPluginCollection).handleResponseHeaderString("opc-request-id", ListConnectorPluginsResponse.Builder::opcRequestId).handleResponseHeaderString("opc-next-page", ListConnectorPluginsResponse.Builder::opcNextPage).handleResponseHeaderString("opc-prev-page", ListConnectorPluginsResponse.Builder::opcPrevPage).callAsync(handler);
    }

    @Deprecated
    public ConnectorPluginsAsyncClient(BasicAuthenticationDetailsProvider authenticationDetailsProvider) {
        this((ClientBuilderBase<?, ?>)ConnectorPluginsAsyncClient.builder(), (AbstractAuthenticationDetailsProvider)authenticationDetailsProvider);
    }

    @Deprecated
    public ConnectorPluginsAsyncClient(BasicAuthenticationDetailsProvider authenticationDetailsProvider, ClientConfiguration configuration) {
        this(ConnectorPluginsAsyncClient.builder().configuration(configuration), (AbstractAuthenticationDetailsProvider)authenticationDetailsProvider);
    }

    @Deprecated
    public ConnectorPluginsAsyncClient(BasicAuthenticationDetailsProvider authenticationDetailsProvider, ClientConfiguration configuration, ClientConfigurator clientConfigurator) {
        this(((Builder)ConnectorPluginsAsyncClient.builder().configuration(configuration)).clientConfigurator(clientConfigurator), (AbstractAuthenticationDetailsProvider)authenticationDetailsProvider);
    }

    @Deprecated
    public ConnectorPluginsAsyncClient(AbstractAuthenticationDetailsProvider authenticationDetailsProvider, ClientConfiguration configuration, ClientConfigurator clientConfigurator, RequestSignerFactory defaultRequestSignerFactory) {
        this(((Builder)((Builder)ConnectorPluginsAsyncClient.builder().configuration(configuration)).clientConfigurator(clientConfigurator)).requestSignerFactory(defaultRequestSignerFactory), authenticationDetailsProvider);
    }

    @Deprecated
    public ConnectorPluginsAsyncClient(AbstractAuthenticationDetailsProvider authenticationDetailsProvider, ClientConfiguration configuration, ClientConfigurator clientConfigurator, RequestSignerFactory defaultRequestSignerFactory, List<ClientConfigurator> additionalClientConfigurators) {
        this(((Builder)((Builder)((Builder)ConnectorPluginsAsyncClient.builder().configuration(configuration)).clientConfigurator(clientConfigurator)).requestSignerFactory(defaultRequestSignerFactory)).additionalClientConfigurators(additionalClientConfigurators), authenticationDetailsProvider);
    }

    @Deprecated
    public ConnectorPluginsAsyncClient(AbstractAuthenticationDetailsProvider authenticationDetailsProvider, ClientConfiguration configuration, ClientConfigurator clientConfigurator, RequestSignerFactory defaultRequestSignerFactory, List<ClientConfigurator> additionalClientConfigurators, String endpoint) {
        this(((Builder)((Builder)((Builder)((Builder)ConnectorPluginsAsyncClient.builder().configuration(configuration)).clientConfigurator(clientConfigurator)).requestSignerFactory(defaultRequestSignerFactory)).additionalClientConfigurators(additionalClientConfigurators)).endpoint(endpoint), authenticationDetailsProvider);
    }

    @Deprecated
    public ConnectorPluginsAsyncClient(AbstractAuthenticationDetailsProvider authenticationDetailsProvider, ClientConfiguration configuration, ClientConfigurator clientConfigurator, RequestSignerFactory defaultRequestSignerFactory, Map<SigningStrategy, RequestSignerFactory> signingStrategyRequestSignerFactories, List<ClientConfigurator> additionalClientConfigurators, String endpoint) {
        this(((Builder)((Builder)((Builder)((Builder)((Builder)ConnectorPluginsAsyncClient.builder().configuration(configuration)).clientConfigurator(clientConfigurator)).requestSignerFactory(defaultRequestSignerFactory)).additionalClientConfigurators(additionalClientConfigurators)).endpoint(endpoint)).signingStrategyRequestSignerFactories(signingStrategyRequestSignerFactories), authenticationDetailsProvider);
    }

    public static class Builder
    extends RegionalClientBuilder<Builder, ConnectorPluginsAsyncClient> {
        private Builder(Service service) {
            super(service);
            String packageName = "sch";
            Alloy.throwDisabledServiceExceptionIfAppropriate((String)"sch");
            this.requestSignerFactory = new DefaultRequestSignerFactory(SigningStrategy.STANDARD);
        }

        public ConnectorPluginsAsyncClient build(@Nonnull AbstractAuthenticationDetailsProvider authenticationDetailsProvider) {
            return new ConnectorPluginsAsyncClient((ClientBuilderBase<?, ?>)this, authenticationDetailsProvider);
        }
    }
}

