/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.sch.model;

import com.fasterxml.jackson.annotation.JsonFilter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonTypeInfo;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonPOJOBuilder;
import com.oracle.bmc.sch.model.ConnectorPluginLifecycleState;
import com.oracle.bmc.sch.model.ConnectorPluginSummary;
import com.oracle.bmc.sch.model.EstimatedThroughput;
import java.util.Date;
import java.util.HashSet;
import java.util.Objects;
import java.util.Set;

@JsonDeserialize(builder=Builder.class)
@JsonTypeInfo(use=JsonTypeInfo.Id.NAME, include=JsonTypeInfo.As.PROPERTY, property="kind")
@JsonFilter(value="explicitlySetFilter")
public final class SourceConnectorPluginSummary
extends ConnectorPluginSummary {
    @JsonProperty(value="maxRetention")
    private final String maxRetention;

    public static Builder builder() {
        return new Builder();
    }

    public Builder toBuilder() {
        return new Builder().copy(this);
    }

    @Deprecated
    public SourceConnectorPluginSummary(String name, Date timeCreated, EstimatedThroughput estimatedThroughput, ConnectorPluginLifecycleState lifecycleState, String displayName, String maxRetention) {
        super(name, timeCreated, estimatedThroughput, lifecycleState, displayName);
        this.maxRetention = maxRetention;
    }

    public String getMaxRetention() {
        return this.maxRetention;
    }

    @Override
    public String toString() {
        return this.toString(true);
    }

    @Override
    public String toString(boolean includeByteArrayContents) {
        StringBuilder sb = new StringBuilder();
        sb.append("SourceConnectorPluginSummary(");
        sb.append("super=").append(super.toString(includeByteArrayContents));
        sb.append(", maxRetention=").append(String.valueOf(this.maxRetention));
        sb.append(")");
        return sb.toString();
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof SourceConnectorPluginSummary)) {
            return false;
        }
        SourceConnectorPluginSummary other = (SourceConnectorPluginSummary)((Object)o);
        return Objects.equals(this.maxRetention, other.maxRetention) && super.equals((Object)other);
    }

    @Override
    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        result = result * 59 + (this.maxRetention == null ? 43 : this.maxRetention.hashCode());
        return result;
    }

    @JsonPOJOBuilder(withPrefix="")
    public static class Builder {
        @JsonProperty(value="name")
        private String name;
        @JsonProperty(value="timeCreated")
        private Date timeCreated;
        @JsonProperty(value="estimatedThroughput")
        private EstimatedThroughput estimatedThroughput;
        @JsonProperty(value="lifecycleState")
        private ConnectorPluginLifecycleState lifecycleState;
        @JsonProperty(value="displayName")
        private String displayName;
        @JsonProperty(value="maxRetention")
        private String maxRetention;
        @JsonIgnore
        private final Set<String> __explicitlySet__ = new HashSet<String>();

        public Builder name(String name) {
            this.name = name;
            this.__explicitlySet__.add("name");
            return this;
        }

        public Builder timeCreated(Date timeCreated) {
            this.timeCreated = timeCreated;
            this.__explicitlySet__.add("timeCreated");
            return this;
        }

        public Builder estimatedThroughput(EstimatedThroughput estimatedThroughput) {
            this.estimatedThroughput = estimatedThroughput;
            this.__explicitlySet__.add("estimatedThroughput");
            return this;
        }

        public Builder lifecycleState(ConnectorPluginLifecycleState lifecycleState) {
            this.lifecycleState = lifecycleState;
            this.__explicitlySet__.add("lifecycleState");
            return this;
        }

        public Builder displayName(String displayName) {
            this.displayName = displayName;
            this.__explicitlySet__.add("displayName");
            return this;
        }

        public Builder maxRetention(String maxRetention) {
            this.maxRetention = maxRetention;
            this.__explicitlySet__.add("maxRetention");
            return this;
        }

        public SourceConnectorPluginSummary build() {
            SourceConnectorPluginSummary model = new SourceConnectorPluginSummary(this.name, this.timeCreated, this.estimatedThroughput, this.lifecycleState, this.displayName, this.maxRetention);
            for (String explicitlySetProperty : this.__explicitlySet__) {
                model.markPropertyAsExplicitlySet(explicitlySetProperty);
            }
            return model;
        }

        @JsonIgnore
        public Builder copy(SourceConnectorPluginSummary model) {
            if (model.wasPropertyExplicitlySet("name")) {
                this.name(model.getName());
            }
            if (model.wasPropertyExplicitlySet("timeCreated")) {
                this.timeCreated(model.getTimeCreated());
            }
            if (model.wasPropertyExplicitlySet("estimatedThroughput")) {
                this.estimatedThroughput(model.getEstimatedThroughput());
            }
            if (model.wasPropertyExplicitlySet("lifecycleState")) {
                this.lifecycleState(model.getLifecycleState());
            }
            if (model.wasPropertyExplicitlySet("displayName")) {
                this.displayName(model.getDisplayName());
            }
            if (model.wasPropertyExplicitlySet("maxRetention")) {
                this.maxRetention(model.getMaxRetention());
            }
            return this;
        }
    }
}

